/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_prj_
#define _vdkb_prj_
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <vdk/vdk.h>
#include <vdk/dlist.h>
#include <vdkb2/vdkb_unit.h>
#include <vdkb2/vdkb_prjopt.h>
#include <vdkb2/vdkb_parser.h>
////////////////// VDKBProject class /////////////
typedef VDKList<VDKBUnit> UnitList;
typedef VDKListIterator<VDKBUnit> UnitListIterator;

class VDKBProject
{
 UnitList units;
 bool LoadUnits(char* name);
 VDKForm* owner;
 VDKBProjectOptions options;
 public:
 // properties
 int Status;
 VDKString PathName;
 VDKString Path;
 VDKString Name;
 bool Valid;
 int Type;
 // a brand new project
  VDKBProject(VDKForm *owner,char* name, int type, char* author, char* email, bool gpld, bool flag);
  // a file loaded project
  VDKBProject(VDKForm *owner,char* name);
  ~VDKBProject();
  //void Close() {} // to be implemented
  UnitList& Units() { return units; }
  // save as..
  bool Save(char* name);
  // save
  bool Save();

  bool CreateTemplatesFilesForVDK(int type);
  bool CreateTemplatesFilesForConsole();

  bool WriteMainCC(FILE* fp, int type);
  bool WriteMainH(FILE* fp, int type);
  bool WriteMainCCForConsole(FILE* fp);
#if USE_XDB
  void WriteXDBSetup(FILE* fp, char* name);
#endif
  bool WriteMainHForConsole(FILE* fp);
  bool WriteMakefile(FILE* fp);
  bool WriteDfmFile(FILE* fp, int type);
  bool WriteGUISetup(FILE* fp, int type);
  bool WriteSourcesForAutomake(FILE* fp);
  void WriteGUISetupParsingFrm(FILE* fp, char* fname);
  void WriteGuiHeaderParsingFrm(FILE* fp, char* fname);
  void WriteGUIBoxesSetup(VDKBParser& parser, FILE* fp);
  VDKBProjectOptions* Options() { return &options; }
 public:

};
#endif
