/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_text_h
#define _vdkb_text_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdk/vdk.h>
//#include <vdkb/vdkb_actstack.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <vdkb/vdkeditor.h>

class VDKBText: public VDKEditor
{ 
  VDKString filename;
  bool mapped,realized;
  //  VDKBActionStack action_stack;
  unsigned int lastGuessed;
  void ScrollTo(int pos);
  static void DeleteText(GtkWidget* wid, int start, int end,void* gp);
  static void InsertText(GtkWidget* wid, 
		     const char* buf,
		     int len, int pos, void* gp);
  time_t mtime;
 public:
  __rproperty(VDKBText,int) CurrentLine;
  bool Hilite;
  //
  VDKBText(VDKForm* owner, bool editable = true, char* filename = NULL);
  ~VDKBText();
  char* ShortName();
  char* Extension();
  char* Filename(char* name = NULL);
  bool GoToLine(int line);
  int Search(char* st,int from = 0, bool select = true , bool bell = true);
  void SetStyle();
  time_t Mtime(time_t mt = 0) { if(mt) mtime = mt; return mtime; }
  virtual int Save(char* filename);
  virtual int Load(char* filename);
  bool Realized(VDKObject*);
  bool KeyEventAfter(VDKObject* sender, GdkEvent *ev);
  bool KeyEventBefore(VDKObject* sender, GdkEvent *ev);
  bool ButtonPressEvent(VDKObject* sender, GdkEvent *ev);
  bool ButtonReleaseEvent(VDKObject* sender, GdkEvent *ev);
  bool MappedEvent(VDKObject* sender, GdkEvent *ev);
  DECLARE_SIGNAL_LIST(VDKBText);
  DECLARE_EVENT_LIST(VDKBText);
  //
};
#endif
