/***************************************************************************
                          dcfiletool.h  -  description
                             -------------------
    begin                : Die Mr 26 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILETOOL_H
#define DCFILETOOL_H

/**
  *@author Mathias Kster
  */

#include <qwidget.h>

#include <dclib/dcobject.h>

typedef enum eRepairType {
	ertNONE=0,
	ertBYTES,
	ertSECTORS
} eRepairType;

class CString;

class DCFileTool : public QWidget {
Q_OBJECT

public: 
	/** construtor */
	DCFileTool();
	/** destructor */
	virtual ~DCFileTool();

	/** reset internal values */
	void Init();

	/** */
	bool SelectFileSource( ulonglong size, QString & file, QString & localrootpath, QString & localpath );
	/** */
	bool AddFileSource( CString nick, CString hubname, CString hubhost,
				CString remotename, CString localname,
				CString localpath, CString localrootpath,
				eltMedium medium, ulonglong size );
	/** */
	bool CheckFile( CString nick, CString hubname, CString hubhost,
				CString remotename, CString localname,
				CString localpath, CString localrootpath,
				eltMedium medium, ulonglong size,
				CString hash,
				bool usermulti = FALSE,
				eRepairType repair = ertNONE );

private:
	/** */
	int m_nLastDownloadCase;
	/** */
	bool m_bCaseAllFiles;
};

#endif
