/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "panelAxes.h"

#include <string.h>

#include <visu_object.h>
#include <openGLFunctions/view.h>
#include <coreTools/toolColor.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <extraGtkFunctions/gtk_lineObjectWidget.h>
#include <extensions/axes.h>
#include <extensions/scale.h>

/* Sensitive widget in this subpanel. */
static GtkWidget *panelAxes;
static GtkWidget *lineAxes;
static GtkWidget *lineScales;
static GtkWidget *spinScaleLength;
static GtkWidget *entryScale;
static GtkWidget *originespin[3];
static GtkWidget *orientationspin[3];

static gboolean disableCallbacks;

/* Private functions. */
static GtkWidget *createInteriorAxes();

/* Local callbacks. */
static void onAxesChecked(LineObject *line, gboolean used, gpointer data);
static void onAxesWidthChanged(LineObject *line, gint width, gpointer user_data);
static void onAxesRGBChanged(LineObject *line, float *rgb, gpointer data);
static void onAxesStippleChanged(LineObject *line, gint stipple, gpointer data);
static void onAxesEnter(ToolPanel *toolPanel, gpointer data);
static void onScalesChecked(LineObject *line, gboolean used, gpointer data);
static void onScalesWidthChanged(LineObject *line, gint width, gpointer user_data);
static void onScalesRGBChanged(LineObject *line, float *rgb, gpointer data);
static void onScalesStippleChanged(LineObject *line, gint stipple, gpointer data);
static void scaleDistanceChanged(GtkSpinButton *spin,gpointer data);
static void scaleOriginChanged(GtkSpinButton *spin,gpointer data);
static void scaleOrientationChanged(GtkSpinButton *spin,gpointer data);
static void onLegendChanged(GtkEntry *entry, gpointer data);

ToolPanel* panelAxes_init()
{
  panelAxes = toolPanelNew_withIconFromPath("Panel_axes", _("Axes and labels"),
					    _("Axes & labels"), "stock-axes_20.png");
  if (!panelAxes)
    return (ToolPanel*)0;
  gtk_container_add(GTK_CONTAINER(panelAxes), createInteriorAxes());
  toolPanelSet_dockable(TOOL_PANEL(panelAxes), TRUE);

  /* Create the callbacks of all the sensitive widgets. */
  g_signal_connect(G_OBJECT(panelAxes), "page-entered",
		   G_CALLBACK(onAxesEnter), (gpointer)0);

  /* Private parameters. */
  disableCallbacks = FALSE;

  return TOOL_PANEL(panelAxes);
}

static GtkWidget *createInteriorAxes()
{
  GtkWidget *vbox, *hbox;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *align;
  GtkObject *aju;
  GtkTooltips *tooltips;
  float *xyz, *orientation;
  Scale *scale;
  gchar *lblXYZ[3] = {"X", "Y", "Z"};
  float xyzDefault[3] = {0.f, 0.f, 0.f};
  float orientationDefault[3] = {1.f, 0.f, 0.f};
  int i;

  tooltips = gtk_tooltips_new ();

  vbox = gtk_vbox_new(FALSE, 0);

  /*************/
  /* The Axes. */
  /*************/
  lineAxes = lineObjectNew(_("Basis set"));
  align = gtk_alignment_new(0.5, 0., 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 25, 0, 0);
  gtk_container_add(GTK_CONTAINER(align), lineAxes);
  gtk_box_pack_start(GTK_BOX(vbox), align, FALSE, FALSE, 0);
  g_signal_connect(G_OBJECT(lineAxes), "use-changed",
		   G_CALLBACK(onAxesChecked), (gpointer)0);
  g_signal_connect(G_OBJECT(lineAxes), "width-changed",
		   G_CALLBACK(onAxesWidthChanged), (gpointer)0);
  g_signal_connect(G_OBJECT(lineAxes), "color-changed",
		   G_CALLBACK(onAxesRGBChanged), (gpointer)0);
  g_signal_connect(G_OBJECT(lineAxes), "stipple-changed",
		   G_CALLBACK(onAxesStippleChanged), (gpointer)0);

  /*************************/
  /* Adding scale widgets. */
  /*************************/
  lineScales = lineObjectNew(_("Label"));
  align = gtk_alignment_new(0.5, 0., 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 15, 0, 0);
  gtk_container_add(GTK_CONTAINER(align), lineScales);
  gtk_box_pack_start(GTK_BOX(vbox), align, FALSE, FALSE, 0);
  g_signal_connect(G_OBJECT(lineScales), "use-changed",
		   G_CALLBACK(onScalesChecked), (gpointer)0);
  g_signal_connect(G_OBJECT(lineScales), "width-changed",
		   G_CALLBACK(onScalesWidthChanged), (gpointer)0);
  g_signal_connect(G_OBJECT(lineScales), "color-changed",
		   G_CALLBACK(onScalesRGBChanged), (gpointer)0);
  g_signal_connect(G_OBJECT(lineScales), "stipple-changed",
		   G_CALLBACK(onScalesStippleChanged), (gpointer)0);

  /* To be removed. */
  if (scalesGet_scales())
    {
      scale = SCALE(scalesGet_scales()->data);
      aju = gtk_adjustment_new(scaleGet_length(scale), 1., 1000., 1., 5., 5.);
      xyz = scaleGet_origin(scale);
      orientation = scaleGet_orientation(scale);
    }
  else
    {
      aju = gtk_adjustment_new(5., 1., 1000., 1., 5., 5.);
      xyz = xyzDefault;
      orientation = orientationDefault;
    }

  /* code yoann*/
  hbox = gtk_hbox_new(FALSE,0);
  align = gtk_alignment_new(1., 0.5, 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(align), 0, 0, 15, 5);
  gtk_box_pack_start(GTK_BOX(hbox), align, FALSE, FALSE, 3);
  label = gtk_label_new(_("Legend:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_container_add(GTK_CONTAINER(align), label);
  entryScale = gtk_entry_new();
  gtk_tooltips_set_tip(tooltips, entryScale,
		       _("Use blank legend to print the default"
			 " value with the distance."), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), entryScale, TRUE, TRUE, 0);
  g_signal_connect(G_OBJECT(entryScale), "activate",
		   G_CALLBACK(onLegendChanged), (gpointer)0);
  
  label = gtk_label_new(_("Length:"));/*je conçois sont label*/
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 5);
 
  spinScaleLength = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 0);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(spinScaleLength), 2);
  g_signal_connect((gpointer)spinScaleLength, "value-changed",
                   G_CALLBACK(scaleDistanceChanged), (gpointer)0);
  gtk_box_pack_start(GTK_BOX(hbox),spinScaleLength, FALSE, FALSE, 0); 
  gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,5);

  table = gtk_table_new(3, 4, FALSE); /* je declare une nouvelle table*/
  gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 5); 

  label = gtk_label_new(_("Origin")); /* je cree le premier labelle*/
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);/*fonction pour placer le labelle a droite*/
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, /*je positionne le label */
                   GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 5, 0);/*j'indique qu il peut prendre toute la place qu'il a besoins*/
  label = gtk_label_new(_("Orientation")); /* je crée le second label*/
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,/* je le positionne*/
                   GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 5, 0);/* j'indique qui peut s etendre */

  for (i = 0; i < 3; i++)
    {
      gtk_table_attach(GTK_TABLE(table), gtk_label_new(lblXYZ[i]), 1 + i, 2 + i, 0, 1,
		       (GtkAttachOptions)0, (GtkAttachOptions)0, 0, 0);

      aju = gtk_adjustment_new(xyz[i], -10., 999.,1.,5.,5.);
      originespin[i] = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
      g_signal_connect(G_OBJECT(originespin[i]), "value-changed",
		       G_CALLBACK(scaleOriginChanged), GINT_TO_POINTER(i));
      gtk_table_attach(GTK_TABLE(table), originespin[i], 1 + i, 2 + i, 1, 2,
		       (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
      aju = gtk_adjustment_new(orientation[i], -10., 999.,1.,5.,5.);
      orientationspin[i] = gtk_spin_button_new(GTK_ADJUSTMENT(aju), 0, 2);
      g_signal_connect(G_OBJECT(orientationspin[i]), "value-changed",
		       G_CALLBACK(scaleOrientationChanged), GINT_TO_POINTER(i));
      gtk_table_attach(GTK_TABLE(table), orientationspin[i], 1 + i, 2 + i, 2, 3,
		       (GtkAttachOptions)0, (GtkAttachOptions)0, 2, 0);
    }

  gtk_widget_show_all(vbox); /* fonctions qui permet de tous dessiner */

  return vbox;
}


/*************/
/* Callbacks */
/*************/
static void axesRedraw()
{
  VisuData *dataObj;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelAxes));
  if (!dataObj) 
    return;
  axesDraw(dataObj);
  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onAxesChecked(LineObject *line _U_, gboolean used, gpointer data _U_)
{
  if (disableCallbacks)
    return;

  axesSet_areOn(used);
  axesRedraw();
}
static void onAxesWidthChanged(LineObject *line _U_, gint width, gpointer data _U_)
{
  if (disableCallbacks)
    return;

  if (axesSet_lineWidth((float)width))
    axesRedraw();
}
static void onAxesRGBChanged(LineObject *line _U_, float *rgb, gpointer data _U_)
{
  if (disableCallbacks)
    return;

  if (axesSet_RGBValues(rgb, MASK_RGB_ALL))
    axesRedraw();
}
static void onAxesStippleChanged(LineObject *line _U_, gint stipple, gpointer data _U_)
{
  if (disableCallbacks)
    return;

  if (axesSet_lineStipple(stipple))
    axesRedraw();
}
static void onAxesEnter(ToolPanel *toolPanel _U_, gpointer data _U_)
{
  float *xyz, *orientation;
  Scale *scale;
  float xyzDefault[3] = {0.f, 0.f, 0.f};
  float orientationDefault[3] = {1.f, 0.f, 0.f};
  gchar *legend;

  disableCallbacks = TRUE;

  /* Set the axes values. */
  lineObjectSet_use(LINE_OBJECT(lineAxes), axesGet_areOn());
  lineObjectSet_width(LINE_OBJECT(lineAxes), axesGet_lineWidth());
  lineObjectSet_color(LINE_OBJECT(lineAxes), axesGet_RGBvalues());
  lineObjectSet_stipple(LINE_OBJECT(lineAxes), axesGet_lineStipple());

  /* Set the scale class values. */
  lineObjectSet_use(LINE_OBJECT(lineScales), scalesGet_areOn());
  lineObjectSet_width(LINE_OBJECT(lineScales), scalesGet_defaultLineWidth());
  lineObjectSet_color(LINE_OBJECT(lineScales), scalesGet_defaultRGBColor());
  lineObjectSet_stipple(LINE_OBJECT(lineScales), scalesGet_defaultStipple());

  /* To be removed. */
  if (scalesGet_scales())
    {
      scale = SCALE(scalesGet_scales()->data);
      DBG_fprintf(stderr, "Panel Axes: set scales values from %p.\n",
		  (gpointer)scale);
      xyz = scaleGet_origin(scale);
      orientation = scaleGet_orientation(scale);
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinScaleLength),
				scaleGet_length(scale));
      legend = (gchar*)scaleGet_legend(scale);
      if (!legend)
	legend = "";
    }
  else
    {
      xyz = xyzDefault;
      orientation = orientationDefault;
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinScaleLength), 5.);
      legend = "";
    }
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespin[0]), xyz[0]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespin[1]), xyz[1]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(originespin[2]), xyz[2]);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspin[0]), orientation[0]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspin[1]), orientation[1]);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(orientationspin[2]), orientation[2]);

  gtk_entry_set_text(GTK_ENTRY(entryScale), legend);
      
  disableCallbacks = FALSE;
}


static void scaleRedraw()
{
  VisuData *dataObj;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelAxes));
  if (!dataObj) 
    return;
  scalesDraw(dataObj);
  g_idle_add(visuObjectRedraw, (gpointer)0);
}
static void onScalesChecked(LineObject *line _U_, gboolean used, gpointer data _U_)
{
  scalesSet_areOn(used);
  scaleRedraw();
}
static void scaleDistanceChanged(GtkSpinButton *spin, gpointer data _U_)
{
  gboolean res;
  Scale *scale;
  float xyz[3], orientation[3], len;

  if (disableCallbacks)
    return;

  /* To be removed. */
  if (scalesGet_scales())
    scale = SCALE(scalesGet_scales()->data);
  else
    {
      xyz[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[0]));
      xyz[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[1]));
      xyz[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[2]));
      orientation[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[0]));
      orientation[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[1]));
      orientation[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[2]));
      len = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin)) / 2.f;
      scale = scaleNew(xyz, orientation, len, (const gchar*)0);
    }

  DBG_fprintf(stderr, "Panel Box&axes: scale distance changed.\n");
  res = scaleSet_length(scale, (float)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin)));
  scaleSet_legend(scale, (const gchar*)0);

  if (res)
    scaleRedraw();
}

static void scaleOriginChanged(GtkSpinButton *spin, gpointer data)
{
  gboolean res;
  int xyzMask[3] = {MASK_XYZ_X, MASK_XYZ_Y, MASK_XYZ_Z};
  int val;
  Scale *scale;
  float xyz[3], orientation[3];

  val = GPOINTER_TO_INT(data);
  g_return_if_fail(val >= 0 && val < 3);

  if (disableCallbacks)
    return;

  /* To be removed. */
  if (scalesGet_scales())
    scale = SCALE(scalesGet_scales()->data);
  else
    {
      xyz[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[0]));
      xyz[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[1]));
      xyz[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[2]));
      orientation[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[0]));
      orientation[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[1]));
      orientation[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[2]));
      xyz[val] += 1.f;
      scale = scaleNew(xyz, orientation,
		       gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinScaleLength)),
		       (const gchar*)0);
    }

  DBG_fprintf(stderr, "Panel Box&axes: scale origine %d change.\n", val);
  xyz[val] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin));
  res = scaleSet_origin(scale, xyz, xyzMask[val]);

  if (res)
    scaleRedraw();
}

static void scaleOrientationChanged(GtkSpinButton *spin, gpointer data)
{
  gboolean res;
  int xyzMask[3] = {MASK_XYZ_X, MASK_XYZ_Y, MASK_XYZ_Z};
  int val;
  Scale *scale;
  float xyz[3], orientation[3];

  val = GPOINTER_TO_INT(data);
  g_return_if_fail(val >= 0 && val < 3);

  if (disableCallbacks)
    return;

  /* To be removed. */
  if (scalesGet_scales())
    scale = SCALE(scalesGet_scales()->data);
  else
    {
      xyz[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[0]));
      xyz[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[1]));
      xyz[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[2]));
      orientation[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[0]));
      orientation[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[1]));
      orientation[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[2]));
      orientation[val] += 999.f;
      scale = scaleNew(xyz, orientation,
		       gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinScaleLength)),
		       (const gchar*)0);
    }

  DBG_fprintf(stderr, "Panel Box&axes: scale orientation %d changed.\n", val);
  xyz[val] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(spin));
  res = scaleSet_orientation(scale, xyz, xyzMask[val]);

  if (res)
    scaleRedraw();
}
static void onScalesWidthChanged(LineObject *line _U_, gint width, gpointer data _U_)
{
  if (scalesSet_defaultLineWidth(width))
    scaleRedraw();
}
static void onScalesRGBChanged(LineObject *line _U_, float *rgb, gpointer data _U_)
{
  float rgba[4];

  memcpy(rgba, rgb, sizeof(float) * 3);
  rgba[3] = 1.f;
  if (scalesSet_defaultRGBValues(rgba, MASK_RGB_ALL))
    scaleRedraw();
}
static void onScalesStippleChanged(LineObject *line _U_, gint stipple, gpointer data _U_)
{
  if (scalesSet_defaultStipple(stipple))
    scaleRedraw();
}
static void onLegendChanged(GtkEntry *entry, gpointer data _U_)
{
  gboolean res;
  Scale *scale;
  float xyz[3], orientation[3];

  if (disableCallbacks)
    return;

  /* To be removed. */
  if (scalesGet_scales())
    scale = SCALE(scalesGet_scales()->data);
  else
    {
      xyz[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[0]));
      xyz[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[1]));
      xyz[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(originespin[2]));
      orientation[0] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[0]));
      orientation[1] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[1]));
      orientation[2] = gtk_spin_button_get_value(GTK_SPIN_BUTTON(orientationspin[2]));
      scale = scaleNew(xyz, orientation,
		       gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinScaleLength)),
		       (const gchar*)0);
    }

  DBG_fprintf(stderr, "Panel Box&axes: scale legend changed.\n");
  res = scaleSet_legend(scale, gtk_entry_get_text(entry));

  if (res)
    scaleRedraw();
}
