/* ========================================================================== */
/* === UMFPACK_symbolic ===================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/*
    User-callable.  Performs a symbolic factorization.
    See umfpack_symbolic.h for details.
    Dynamic memory usage of UMFPACK_symbolic is identical to UMFPACK_qsymbolic.
*/

#include "umf_internal.h"

GLOBAL Int UMFPACK_symbolic
(
    Int n,
    const Int Ap [ ],
    const Int Ai [ ],
    void **SymbolicHandle,
    const double Control [UMFPACK_CONTROL],
    double Info [UMFPACK_INFO]
)
{
    Int *Qinit = (Int *) NULL ;
    return (UMFPACK_qsymbolic (n, Ap, Ai, Qinit, SymbolicHandle, Control,
	Info)) ;
}

