function umfpack_make
%UMFPACK_MAKE
%
%   Compiles the UMFPACK Version 3.2 mexFunction and then runs a simple demo.
%
%   UMFPACK Version 3.2, Jan. 1, 2002.  Copyright (c) 2002 by Timothy A.
%   Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.
%   Type "help umfpack_details" for License.
%
%   See also umfpack, umfpack_details, umfpack_report,
%   umfpack_demo, and umfpack_simple.

fprintf ('\nNow compiling the umfpack mexFunction.\n') ;

help umfpack

fprintf ('\nPlease select one of the following options: \n') ;
fprintf ('   1:  you are running Windows 95/98/NT/ME/2000 (default)\n') ;
fprintf ('   2:  you are running any version of Unix\n') ;
os = input ('or type control-C if you do not wish to proceed: ') ;

if (isempty (os))
    os = 1 ;
end

if (os == 1)
    % Windows requires no underscore to call the BLAS
    config = '-DBLAS_NO_UNDERSCORE' ;
else
    config = ' ' ;
end

fprintf ('\nUsing the BLAS is faster, but might not compile correctly.\n') ;
fprintf ('\nPlease select one of the following options: \n') ;
fprintf ('   1:  attempt to compile with the BLAS (default)\n') ;
fprintf ('   2:  do not use the BLAS\n') ;
blas = input ('or type control-C if you do not wish to proceed: ') ;

if (isempty (blas))
    blas = 1 ;
end

if (blas == 1)
    % try to link to Matlab's built-in BLAS
    blas = '-DNCBLAS' ;
else
    blas = '-DNBLAS' ;
end

s = sprintf ( ...
[ 'mex -v -O %s -DNDEBUG %s -output umfpack umfpackmex.c ', ...
'umf_analyze.c umf_apply_order.c umf_assemble.c umf_blas3_update.c ', ...
'umf_build_tuples.c umf_build_tuples_usage.c umf_colamd.c ', ...
'umf_create_element.c umf_dump.c umf_extend_front.c ', ...
'umf_free.c umf_garbage_collection.c umf_get_memory.c umf_init_front.c ', ...
'umf_is_permutation.c umf_kernel.c umf_kernel_init.c ', ...
'umf_kernel_init_usage.c umf_kernel_wrapup.c umf_local_search.c ', ...
'umf_lsolve.c umf_ltsolve.c umf_malloc.c umf_mem_alloc_element.c ', ...
'umf_mem_alloc_head_block.c umf_mem_alloc_tail_block.c ', ...
'umf_mem_free_tail_block.c umf_mem_init_memoryspace.c ', ...
'umf_order_front_tree.c umf_report_perm.c umf_realloc.c ', ...
'umf_report_vector.c umf_row_search.c umf_scale_column.c ', ...
'umf_set_stats.c umf_solve.c umf_symbolic_usage.c umfpack_timer.c ', ...
'umf_transpose.c umf_tuple_lengths.c umf_usolve.c umf_utsolve.c ', ...
'umf_valid_numeric.c umf_valid_symbolic.c umfpack_col_to_triplet.c ', ...
'umfpack_defaults.c umfpack_free_numeric.c umfpack_free_symbolic.c ', ...
'umfpack_get_numeric.c umfpack_get_lunz.c umfpack_get_symbolic.c ', ...
'umfpack_numeric.c umfpack_qsymbolic.c umfpack_report_control.c ', ...
'umfpack_report_info.c umfpack_report_matrix.c umfpack_report_numeric.c ', ...
'umfpack_report_perm.c umfpack_report_symbolic.c umfpack_report_status.c ', ...
'umfpack_report_triplet.c umfpack_report_vector.c umfpack_solve.c ', ...
'umfpack_symbolic.c umfpack_transpose.c umfpack_triplet_to_col.c ', ...
'umfpack_wsolve.c '], blas, config) ;

fprintf ('\n\n%s\n\n', s) ;

eval (s) ;

fprintf ('\nCompilation has completed.  Now trying the umfpack_simple demo.\n');

umfpack_simple

