/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: check_plots.c,v 1.2.1.2 1999/02/27 04:21:59 lance Exp $ */
#include <stdio.h>
#include <string.h>

#include "data.h"

/* make sure that x (in x VS. y) is increasing or const */
/* and check other stuff */
void check_plots(Plot *plot)
{
  int i;
  unsigned long num;
  struct Data *d1, *d2;

  if(plot->num_plots == 1)
    plot->flag |= SAME_SCALE; /** the plots will be on the same scale
			       ** if there is just one plot
			       **/

  for(i=0;i<plot->num_plots;i++)
    {
      /* put the globel flags that can go to local flags */
      if(plot->flag & NO_LINES)
	plot->plot_opt[i] |= NO_LINES;
      if(plot->flag & NO_POINTS)
	plot->plot_opt[i] |= NO_POINTS;

      if((plot->plot_opt[i] & NO_LINES) && (plot->plot_opt[i] & NO_POINTS))
	{
	  fprintf(stderr,"quickplot ERROR: You can't see a plot (field %d VS field %d) if there are no points or lines displayed\n",plot->list[i][Y],plot->list[i][X]);
	  exit(1);
	}
      if(plot->dim <= plot->list[i][X] || plot->dim <= plot->list[i][Y])
	{
	  fprintf(stderr,"quickplot ERROR: You you only loaded %d data fields so you can't plot data field %d VS field %d\n",plot->dim,plot->list[i][Y],plot->list[i][X]);
	  fprintf(stderr,"Note: counting starts at 0\n");
	  exit(1);
	}
      if(plot->num_points[plot->list[i][X]] != plot->num_points[plot->list[i][Y]])
	{
	  fprintf(stderr,"quickplot ERROR: I can't plot %s (%ld points) VS %s (%ld points)\n",
		plot->label[plot->list[i][Y]],plot->num_points[plot->list[i][Y]],
		plot->label[plot->list[i][X]],plot->num_points[plot->list[i][X]]);
	  exit(1);
	}
      if(plot->num_points[plot->list[i][X]] < 2)
	{
	  fprintf(stderr,"quickplot ERROR: Can't plot one point the in field %d. More than one point is needed to plot.\n",
		  plot->list[i][X]);
	  exit(1);
	}


      if(!(plot->plot_opt[i] & PHASE_PLOT)) /* it's a function plot */
	{
	  num = 1;
	  for(d1 = plot->data[plot->list[i][X]];d1->next != NULL;d1 = d2)
	    { 
	      d2 = d1->next;
	      if(d2->val <= d1->val)
		{
		  fprintf(stderr,
			  "quickplot ERROR: The data in field %s , plot number %d, value number %ld did not increase for the previous value.\n",
			  plot->label[plot->list[i][X]],i+1,num);
		  fprintf(stderr,
			  "So you can't use function plot.\nTry a phase plot, option -p to see what ya got.\n");
		  exit(0);
		}
	      num++;
	    }
	}
    }
}
