// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "rate.h"
#include <stdexcept>

namespace visual {

rate_timer::rate_timer() 
{
	origin = sclock();
}

void
rate_timer::delay( const double& delay) 
{
	double t = delay - (sclock() - origin);
	if (t > 0.010) {
		threaded_sleep(t);
	}
	else
		while (delay - (sclock() - origin) > 0);

	origin = sclock();
};

void
rate_timer::py_rate( const double& freq)
{
	static rate_timer* rt;
	if (!rt) rt = new rate_timer();
	
	if (freq <= 0.0)
		throw std::invalid_argument( "Rate must be positive and nonzero.");
	rt->delay( 1.0/freq );
}

} // !namespace visual
