version = (3, 2, 9)

# Copyright David Scherer and others, see license.txt

import sys, time

# Aliases for True and False in current versions of Python, booleans for older versions.
true = 1
false = 0

# Prerequisite standard libraries
from math import *

# Don't try this at home!
import array_backend
# The following is intended to be equivalent to:
# >>> from array_backend.backend[0] import *
vars = __import__(array_backend.backend[0], globals(), locals(), [])
for i,j in vars.__dict__.iteritems():
    if i not in ['__builtin__', '__name__', '__main__', 'visual', '__doc__']:
        locals()[i] = j

# import all of the public modules into the global namespace
import crayola
color = crayola
import cvisual
from cvisual import vector, mag, mag2, norm, cross, rotate, comp, proj, diff_angle, rate
from visual.primitives import arrow, cylinder, cone, sphere, box, ring, label
from visual.primitives import frame, curve, pyramid, ellipsoid, convex, faces, helix
from visual.ui import display
from cvisual import vector_array, scalar_array

def __waitclose():
    while not cvisual.allclosed(): time.sleep(0.05)

# The following ensures that __waitclose will be run
# when we reach the end of the program,
# to permit viewing and navigating the scene.
import atexit
atexit.register(__waitclose)

# The following tells idle_VPython to not close down until/unless
# the scene is closed down by the user. It is left here for
# compatibility with old versions of idle_VPython but will no longer
# needed with the new Idle distributed with Python 2.3.
sys.ready_to_exit = cvisual.allclosed

# Construct the default display object.
scene = display()
