#!/usr/bin/python
'''Ratanie neistot
'''

# author: Tomas Stanys <stanys@fmph.uniba.sk>
# Contributed by Radovan Garabik he..he..
# version 0.001
from types import *
import math

def exp(x): return math.e**x

def ToUncertain(x):
    if isinstance(x, Uncertain):
            return x
    else:
        return Uncertain(x)

class Uncertain:
    '''This class implements numbers with uncertainity.'''

    def __init__(self, value, error=0.):
            self.value, self.error = value, error

    def __repr__(self):
        return 'Uncertain(%s,%s)' % (self.value, self.error)

    def __str__(self):
        return str(self.value)+" +- "+str(self.error)

    def tomas(self):
        return "%.2f +- %.2f" % (self.value, self.error)        

    # a + b
    def __add__(self, other):
        other = ToUncertain(other)
        nvalue = self.value+other.value
        nerr = math.sqrt(self.error*self.error + other.error*other.error)
        return Uncertain(nvalue, nerr)

    def __radd__(self, other):
        return Uncertain(other) + self

    # a - b
    def __sub__(self, other):
        other = ToUncertain(other)
        nvalue = self.value-other.value
        nerr = math.sqrt(self.error*self.error + other.error*other.error)
        return Uncertain(nvalue, nerr)

    def __rsub__(self, other):
        return Uncertain(other) - self

    # a * b
    def __mul__(a, b):
        b = ToUncertain(b)
        nvalue = a.value*b.value
        nerr = math.sqrt(a.value*a.value*b.error*b.error + 
                b.value*b.value*a.error*a.error)
        return Uncertain(nvalue, nerr)

    def __rmul__(b, a):
        return Uncertain(a) * b

    # a / b
    def __div__(a, b):
        b = ToUncertain(b)
        nvalue = a.value/b.value
        nerr = math.sqrt(a.error*a.error/(b.value*b.value) + 
                a.value*a.value*b.error*b.error/(b.value*b.value*b.value*b.value))
        return Uncertain(nvalue, nerr)
        
    def __rdiv__(b, a):
        return Uncertain(a) / b

    # a % b
    #def __mod__(a, b):
    #    div = a / b
    #    try:
    #        div = int(div)
    #    except OverflowError:
    #        div = long(div)
    #    return a - b * div

    def __rmod__(b, a):
        return Uncertain(a) % b

    # a ** b
    def __pow__(a, b):
	b = ToUncertain(b)
        nvalue = a.value**b.value
        nerr = math.sqrt((b.value*a.value**(b.value-1))**2*a.error**2 + 
                (math.log(a.value)*a.value**b.value)**2*b.error**2)
        return Uncertain(nvalue, nerr)

    def __rpow__(b, a):
        return Uncertain(a) ** b

    # -a
    def __neg__(a):
        return Uncertain(-a.value, a.error)

    # abs(a)
    def __abs__(a):
        return Uncertain(abs(a.value), a.error)

    # int(a)
    def __int__(a):
        return int(a.value)

    # long(a)
    #def __long__(a):
    #    return long(a.value)

    # float(a)
    #def __float__(a):
    #    return float(a.value)

    def __eq__(self, other):
        other=ToUncertain(other)
    	return (abs(self.value-other.value)<min(self.error,other.error))
    

    # cmp(a,b)
    def __cmp__(a, b):
        return cmp(a.value,b.value)

    def __rcmp__(b, a):
           return cmp(Uncertain(a), b)

    # a != 0
    def __nonzero__(a):
        return not(a.value==0 and a.error==0)

    # coercion
    #def __coerce__(a, b):
    #    return a, Uncertain(b.value)

def test():
     a = Uncertain(5., 1.)
     b = Uncertain(2., 0.5)
     c = 20
 #   c = Uncertain(10., 5.)
     print c*a/b, int(a/b)

if __name__ == '__main__':
    test()
