#!/usr/bin/env python
""" bank04: Simulate a single customer. random time in system"""
from __future__ import generators
from SimPy.Simulation  import *
from random import Random, expovariate

class Customer(Process):
    """ Customer arrives in the bank, looks around for
    a random time and then leaves
    """
    def __init__(self,name):
        Process.__init__(self)
        self.name = name
        
    def visit(self,rv,timeInBank=0):       
        print "%7.4f %s: Here I am"%(now(),self.name)
        t = rv.expovariate(1.0/timeInBank)
        yield hold,self,t
        print "%7.4f %s: I must leave"%(now(),self.name)

def model():
    rv = Random(1133)
    initialize()
    c=Customer(name="Klaus")
    activate(c,c.visit(rv,timeInBank=10.0),delay=5.0)
    simulate(until=100.0)

model()
