# KInterbasDB Python Package - Type Conv : Fixed/fixedpoint Module (3rd-party)
#
# Version 3.1
#
# The following contributors hold Copyright (C) over their respective
# portions of code (see license.txt for details):
#
# [Original Author (maintained through version 2.0-0.3.1):]
#   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
# [Maintainers (after version 2.0-0.3.1):]
#   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
#   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
# [Contributors:]
#   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
#   2001-2002 [janez] Janez Jere            <janez.jere@void.si>

__all__ = (
    # kinterbasdb-native fixed point converters (old, precison_mode style):
    'fixed_conv_in_imprecise', 'fixed_conv_in_precise',
    'fixed_conv_out_imprecise', 'fixed_conv_out_precise',
  )

import sys, types
from kinterbasdb.k_exceptions import *

if sys.version_info < (2,2):
    from kinterbasdb.typeconv_util_isinstance import isinstance

# The fixedpoint module resides at:  http://fixedpoint.sourceforge.net/
from fixedpoint import FixedPoint

# With versions of Python that have int/long unification (2.2 and later), use
# ints where possible:
if sys.version_info >= (2,2):
    _tenTo = [10**x for x in range(20)]
else:
    _tenTo = [10L**x for x in range(20)]
del x # Created in the global namespace by the list comprehension.


################################################################################
## FIXED POINT
################################################################################

def fixed_conv_in_precise((val, scale)):
    # Allow implicit param conv:
    if val is None or isinstance(val, types.StringType):
        return val

    valCopy = val.copy()
    valCopy.set_precision(abs(scale))
    # We've taken care of the rounding via valCopy, so we can simply pass a
    # string representation of the rounded valCopy to the database engine.
    return str(valCopy)

fixed_conv_in_imprecise = fixed_conv_in_precise


def fixed_conv_out_precise(x):
    if x is None:
        return None
    absScale = abs(x[1])
    return FixedPoint(x[0], absScale) / _tenTo[absScale]

fixed_conv_out_imprecise = fixed_conv_out_precise
