/* KInterbasDB Python Package - Implementation of DB API Constant -> Py Transfer
**
** Version 3.1
**
** The following contributors hold Copyright (C) over their respective
** portions of code (see license.txt for details):
**
** [Original Author (maintained through version 2.0-0.3.1):]
**   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
** [Maintainers (after version 2.0-0.3.1):]
**   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
**   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
** [Contributors:]
**   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
**   2001-2002 [janez] Janez Jere            <janez.jere@void.si>
*/

/* This file is designed to be included directly into _kinterbasdb.c without
** the involvement of a header file. */


static int init_kidb_ibase_header_constants(PyObject *d) {
  /* Define transaction parameter buffer constants. */
  _init_kidb_ibase_header_constants_transaction_parameters(d);

  /* Define database information constants. */
  _init_kidb_ibase_header_constants_database_info(d);

  return 0;
} /* init_kidb_ibase_header_constants */


static void _init_kidb_ibase_header_constants_transaction_parameters(PyObject *d) {
  char convArray[1];

/* SET_TPB_CONST is just a shortcut for defining transaction parameter buffer
** constants, which were previously defined in kinterbasdb.py as strings
** containing octal escape codes.
**
** For example, if the definition of isc_some_dumb_const is:
** #define isc_some_dumb_const 16
** then the brittle version of kinterbasdb.py would feature this line:
** isc_some_dumb_const = '\020'
**
** The point of SET_TPB_CONST is to enter into dict d the equivalent of the
** Python string '\020', when passed the name and value of isc_some_dumb_const.
 */
#define SET_TPB_CONST(name, value) \
  convArray[0] = (char) value; \
  PyDict_SetItemString(d, name, PyString_FromStringAndSize(convArray, 1));

  /* 2003.02.20: added isc_tpb_version3: */
  SET_TPB_CONST("isc_tpb_version3",           isc_tpb_version3);

  SET_TPB_CONST("isc_tpb_consistency",        isc_tpb_consistency);
  SET_TPB_CONST("isc_tpb_concurrency",        isc_tpb_concurrency);
  SET_TPB_CONST("isc_tpb_shared",             isc_tpb_shared);
  SET_TPB_CONST("isc_tpb_protected",          isc_tpb_protected);
  SET_TPB_CONST("isc_tpb_exclusive",          isc_tpb_exclusive);
  SET_TPB_CONST("isc_tpb_wait",               isc_tpb_wait);
  SET_TPB_CONST("isc_tpb_nowait",             isc_tpb_nowait);
  SET_TPB_CONST("isc_tpb_read",               isc_tpb_read);
  SET_TPB_CONST("isc_tpb_write",              isc_tpb_write);
  SET_TPB_CONST("isc_tpb_lock_read",          isc_tpb_lock_read);
  SET_TPB_CONST("isc_tpb_lock_write",         isc_tpb_lock_write);
  SET_TPB_CONST("isc_tpb_verb_time",          isc_tpb_verb_time);
  SET_TPB_CONST("isc_tpb_commit_time",        isc_tpb_commit_time);
  SET_TPB_CONST("isc_tpb_ignore_limbo",       isc_tpb_ignore_limbo);
  SET_TPB_CONST("isc_tpb_read_committed",     isc_tpb_read_committed);
  SET_TPB_CONST("isc_tpb_autocommit",         isc_tpb_autocommit);
  SET_TPB_CONST("isc_tpb_rec_version",        isc_tpb_rec_version);
  SET_TPB_CONST("isc_tpb_no_rec_version",     isc_tpb_no_rec_version);
  SET_TPB_CONST("isc_tpb_restart_requests",   isc_tpb_restart_requests);
  SET_TPB_CONST("isc_tpb_no_auto_undo",       isc_tpb_no_auto_undo);

  /* 2003.02.19: kinterbasdb.connect()-related parameters: */
  SET_TPB_CONST("isc_dpb_version1",           isc_dpb_version1);
  SET_TPB_CONST("isc_dpb_user_name",          isc_dpb_user_name);
  SET_TPB_CONST("isc_dpb_password",           isc_dpb_password);
  SET_TPB_CONST("isc_dpb_sql_role_name",      isc_dpb_sql_role_name);
  SET_TPB_CONST("isc_dpb_lc_ctype",           isc_dpb_lc_ctype);
} /* _init_kidb_ibase_header_constants_transaction_parameters */


static void _init_kidb_ibase_header_constants_database_info(PyObject *d) {
/* SET_INT_CONST is just a shortcut for entering database info constants into
** dict d. */
#define SET_INT_CONST(name, value) \
  PyDict_SetItemString(d, name, PyInt_FromLong(value));

  SET_INT_CONST("isc_info_db_id",                   isc_info_db_id);
  SET_INT_CONST("isc_info_reads",                   isc_info_reads);
  SET_INT_CONST("isc_info_writes",                  isc_info_writes);
  SET_INT_CONST("isc_info_fetches",                 isc_info_fetches);
  SET_INT_CONST("isc_info_marks",                   isc_info_marks);
  SET_INT_CONST("isc_info_implementation",          isc_info_implementation);

#ifdef FIREBIRD_1_0_OR_LATER
  SET_INT_CONST("isc_info_isc_version",             isc_info_isc_version);
#endif
  /* isc_info_version is apparently a deprecated form of isc_info_isc_version. */
  SET_INT_CONST("isc_info_version",                 isc_info_version);

  SET_INT_CONST("isc_info_base_level",              isc_info_base_level);
  SET_INT_CONST("isc_info_page_size",               isc_info_page_size);
  SET_INT_CONST("isc_info_num_buffers",             isc_info_num_buffers);
  SET_INT_CONST("isc_info_limbo",                   isc_info_limbo);
  SET_INT_CONST("isc_info_current_memory",          isc_info_current_memory);
  SET_INT_CONST("isc_info_max_memory",              isc_info_max_memory);
  SET_INT_CONST("isc_info_window_turns",            isc_info_window_turns);
  SET_INT_CONST("isc_info_license",                 isc_info_license);
  SET_INT_CONST("isc_info_allocation",              isc_info_allocation);
  SET_INT_CONST("isc_info_attachment_id",           isc_info_attachment_id);
  SET_INT_CONST("isc_info_read_seq_count",          isc_info_read_seq_count);
  SET_INT_CONST("isc_info_read_idx_count",          isc_info_read_idx_count);
  SET_INT_CONST("isc_info_insert_count",            isc_info_insert_count);
  SET_INT_CONST("isc_info_update_count",            isc_info_update_count);
  SET_INT_CONST("isc_info_delete_count",            isc_info_delete_count);
  SET_INT_CONST("isc_info_backout_count",           isc_info_backout_count);
  SET_INT_CONST("isc_info_purge_count",             isc_info_purge_count);
  SET_INT_CONST("isc_info_expunge_count",           isc_info_expunge_count);
  SET_INT_CONST("isc_info_sweep_interval",          isc_info_sweep_interval);
  SET_INT_CONST("isc_info_ods_version",             isc_info_ods_version);
  SET_INT_CONST("isc_info_ods_minor_version",       isc_info_ods_minor_version);
  SET_INT_CONST("isc_info_no_reserve",              isc_info_no_reserve);
  SET_INT_CONST("isc_info_logfile",                 isc_info_logfile);
  SET_INT_CONST("isc_info_cur_logfile_name",        isc_info_cur_logfile_name);
  SET_INT_CONST("isc_info_cur_log_part_offset",     isc_info_cur_log_part_offset);
  SET_INT_CONST("isc_info_num_wal_buffers",         isc_info_num_wal_buffers);
  SET_INT_CONST("isc_info_wal_buffer_size",         isc_info_wal_buffer_size);
  SET_INT_CONST("isc_info_wal_ckpt_length",         isc_info_wal_ckpt_length);
  SET_INT_CONST("isc_info_wal_cur_ckpt_interval",   isc_info_wal_cur_ckpt_interval);
  SET_INT_CONST("isc_info_wal_prv_ckpt_fname",      isc_info_wal_prv_ckpt_fname);
  SET_INT_CONST("isc_info_wal_prv_ckpt_poffset",    isc_info_wal_prv_ckpt_poffset);
  SET_INT_CONST("isc_info_wal_recv_ckpt_fname",     isc_info_wal_recv_ckpt_fname);
  SET_INT_CONST("isc_info_wal_recv_ckpt_poffset",   isc_info_wal_recv_ckpt_poffset);
  SET_INT_CONST("isc_info_wal_grpc_wait_usecs",     isc_info_wal_grpc_wait_usecs);
  SET_INT_CONST("isc_info_wal_num_io",              isc_info_wal_num_io);
  SET_INT_CONST("isc_info_wal_avg_io_size",         isc_info_wal_avg_io_size);
  SET_INT_CONST("isc_info_wal_num_commits",         isc_info_wal_num_commits);
  SET_INT_CONST("isc_info_wal_avg_grpc_size",       isc_info_wal_avg_grpc_size);
  SET_INT_CONST("isc_info_forced_writes",           isc_info_forced_writes);
  SET_INT_CONST("isc_info_user_names",              isc_info_user_names);
  SET_INT_CONST("isc_info_page_errors",             isc_info_page_errors);
  SET_INT_CONST("isc_info_record_errors",           isc_info_record_errors);
  SET_INT_CONST("isc_info_bpage_errors",            isc_info_bpage_errors);
  SET_INT_CONST("isc_info_dpage_errors",            isc_info_dpage_errors);
  SET_INT_CONST("isc_info_ipage_errors",            isc_info_ipage_errors);
  SET_INT_CONST("isc_info_ppage_errors",            isc_info_ppage_errors);
  SET_INT_CONST("isc_info_tpage_errors",            isc_info_tpage_errors);
  SET_INT_CONST("isc_info_set_page_buffers",        isc_info_set_page_buffers);

#ifdef INTERBASE6_OR_LATER
  SET_INT_CONST("isc_info_db_sql_dialect",          isc_info_db_sql_dialect);
  /* Mis-cased version of the above has now been deprecated and is maintained
  ** only for compatibility: */
  SET_INT_CONST("isc_info_db_SQL_dialect",          isc_info_db_SQL_dialect);

  SET_INT_CONST("isc_info_db_read_only",            isc_info_db_read_only);
  SET_INT_CONST("isc_info_db_size_in_pages",        isc_info_db_size_in_pages);
#endif /* INTERBASE6_OR_LATER */

#ifdef FIREBIRD_1_0_OR_LATER
  SET_INT_CONST("frb_info_att_charset",             frb_info_att_charset);
  SET_INT_CONST("isc_info_db_class",                isc_info_db_class);
  SET_INT_CONST("isc_info_firebird_version",        isc_info_firebird_version);
  SET_INT_CONST("isc_info_oldest_transaction",      isc_info_oldest_transaction);
  SET_INT_CONST("isc_info_oldest_active",           isc_info_oldest_active);
  SET_INT_CONST("isc_info_oldest_snapshot",         isc_info_oldest_snapshot);
  SET_INT_CONST("isc_info_next_transaction",        isc_info_next_transaction);
  SET_INT_CONST("isc_info_db_provider",             isc_info_db_provider);
#endif /* FIREBIRD_1_0_OR_LATER */

#ifdef FIREBIRD_1_5_OR_LATER
  SET_INT_CONST("isc_info_active_transactions",     isc_info_active_transactions);
#endif /* FIREBIRD_1_5_OR_LATER */


  /* 2003.01.02: */
  #ifdef MAX_EVENT_NAMES
    SET_INT_CONST("MAX_EVENT_NAMES",                MAX_EVENT_NAMES);
  #endif

  /* 2003.04.27: */
  SET_INT_CONST("DIST_TRANS_MAX_DATABASES",        DIST_TRANS_MAX_DATABASES);

} /* _init_kidb_ibase_header_constants_database_info */
