# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """The check availability request body.

    :param name: The name of the resource for which availability needs to be checked.
    :type name: str
    :param type: The resource type.
    :type type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get("name", None)
        self.type = kwargs.get("type", None)


class CheckNameAvailabilityResponse(msrest.serialization.Model):
    """The check availability result.

    :param name_available: Indicates if the resource name is available.
    :type name_available: bool
    :param reason: The reason why the given name is not available. Possible values include:
     "Invalid", "AlreadyExists".
    :type reason: str or ~azure.mgmt.agrifood.models.CheckNameAvailabilityReason
    :param message: Detailed reason why the given name is available.
    :type message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.name_available = kwargs.get("name_available", None)
        self.reason = kwargs.get("reason", None)
        self.message = kwargs.get("message", None)


class DetailedInformation(msrest.serialization.Model):
    """Model to capture detailed information for farmBeatsExtensions.

    :param api_name: ApiName available for the farmBeatsExtension.
    :type api_name: str
    :param custom_parameters: List of customParameters.
    :type custom_parameters: list[str]
    :param platform_parameters: List of platformParameters.
    :type platform_parameters: list[str]
    :param units_supported: Unit systems info for the data provider.
    :type units_supported: ~azure.mgmt.agrifood.models.UnitSystemsInfo
    :param api_input_parameters: List of apiInputParameters.
    :type api_input_parameters: list[str]
    """

    _attribute_map = {
        "api_name": {"key": "apiName", "type": "str"},
        "custom_parameters": {"key": "customParameters", "type": "[str]"},
        "platform_parameters": {"key": "platformParameters", "type": "[str]"},
        "units_supported": {"key": "unitsSupported", "type": "UnitSystemsInfo"},
        "api_input_parameters": {"key": "apiInputParameters", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        super(DetailedInformation, self).__init__(**kwargs)
        self.api_name = kwargs.get("api_name", None)
        self.custom_parameters = kwargs.get("custom_parameters", None)
        self.platform_parameters = kwargs.get("platform_parameters", None)
        self.units_supported = kwargs.get("units_supported", None)
        self.api_input_parameters = kwargs.get("api_input_parameters", None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.agrifood.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.agrifood.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.agrifood.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get("error", None)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class Extension(ProxyResource):
    """Extension resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar e_tag: The ETag value to implement optimistic concurrency.
    :vartype e_tag: str
    :ivar extension_id: Extension Id.
    :vartype extension_id: str
    :ivar extension_category: Extension category. e.g. weather/sensor/satellite.
    :vartype extension_category: str
    :ivar installed_extension_version: Installed extension version.
    :vartype installed_extension_version: str
    :ivar extension_auth_link: Extension auth link.
    :vartype extension_auth_link: str
    :ivar extension_api_docs_link: Extension api docs link.
    :vartype extension_api_docs_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "e_tag": {"readonly": True},
        "extension_id": {"readonly": True, "pattern": r"^[A-za-z]{3,50}[.][A-za-z]{3,100}$"},
        "extension_category": {"readonly": True},
        "installed_extension_version": {"readonly": True, "pattern": r"^([1-9]|10).\d$"},
        "extension_auth_link": {"readonly": True},
        "extension_api_docs_link": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "e_tag": {"key": "eTag", "type": "str"},
        "extension_id": {"key": "properties.extensionId", "type": "str"},
        "extension_category": {"key": "properties.extensionCategory", "type": "str"},
        "installed_extension_version": {"key": "properties.installedExtensionVersion", "type": "str"},
        "extension_auth_link": {"key": "properties.extensionAuthLink", "type": "str"},
        "extension_api_docs_link": {"key": "properties.extensionApiDocsLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(Extension, self).__init__(**kwargs)
        self.system_data = None
        self.e_tag = None
        self.extension_id = None
        self.extension_category = None
        self.installed_extension_version = None
        self.extension_auth_link = None
        self.extension_api_docs_link = None


class ExtensionListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of requested objects.
    :type value: list[~azure.mgmt.agrifood.models.Extension]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Extension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(ExtensionListResponse, self).__init__(**kwargs)
        self.value = kwargs.get("value", None)
        self.next_link = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get("tags", None)
        self.location = kwargs["location"]


class FarmBeats(TrackedResource):
    """FarmBeats ARM Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar instance_uri: Uri of the FarmBeats instance.
    :vartype instance_uri: str
    :ivar provisioning_state: FarmBeats instance provisioning state. Possible values include:
     "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.agrifood.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "instance_uri": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "instance_uri": {"key": "properties.instanceUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(FarmBeats, self).__init__(**kwargs)
        self.system_data = None
        self.instance_uri = None
        self.provisioning_state = None


class FarmBeatsExtension(ProxyResource):
    """FarmBeats extension resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.agrifood.models.SystemData
    :ivar target_resource_type: Target ResourceType of the farmBeatsExtension.
    :vartype target_resource_type: str
    :ivar farm_beats_extension_id: FarmBeatsExtension ID.
    :vartype farm_beats_extension_id: str
    :ivar farm_beats_extension_name: FarmBeatsExtension name.
    :vartype farm_beats_extension_name: str
    :ivar farm_beats_extension_version: FarmBeatsExtension version.
    :vartype farm_beats_extension_version: str
    :ivar publisher_id: Publisher ID.
    :vartype publisher_id: str
    :ivar description: Textual description.
    :vartype description: str
    :ivar extension_category: Category of the extension. e.g. weather/sensor/satellite.
    :vartype extension_category: str
    :ivar extension_auth_link: FarmBeatsExtension auth link.
    :vartype extension_auth_link: str
    :ivar extension_api_docs_link: FarmBeatsExtension api docs link.
    :vartype extension_api_docs_link: str
    :ivar detailed_information: Detailed information which shows summary of requested data.
     Used in descriptive get extension metadata call.
     Information for weather category per api included are apisSupported,
     customParameters, PlatformParameters and Units supported.
    :vartype detailed_information: list[~azure.mgmt.agrifood.models.DetailedInformation]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "target_resource_type": {"readonly": True},
        "farm_beats_extension_id": {
            "readonly": True,
            "max_length": 100,
            "min_length": 2,
            "pattern": r"^[A-za-z]{3,50}[.][A-za-z]{3,100}$",
        },
        "farm_beats_extension_name": {"readonly": True, "max_length": 100, "min_length": 2},
        "farm_beats_extension_version": {
            "readonly": True,
            "max_length": 100,
            "min_length": 2,
            "pattern": r"^([1-9]|10).\d$",
        },
        "publisher_id": {"readonly": True, "max_length": 100, "min_length": 2},
        "description": {"readonly": True, "max_length": 500, "min_length": 2},
        "extension_category": {"readonly": True, "max_length": 100, "min_length": 2},
        "extension_auth_link": {"readonly": True},
        "extension_api_docs_link": {"readonly": True},
        "detailed_information": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "farm_beats_extension_id": {"key": "properties.farmBeatsExtensionId", "type": "str"},
        "farm_beats_extension_name": {"key": "properties.farmBeatsExtensionName", "type": "str"},
        "farm_beats_extension_version": {"key": "properties.farmBeatsExtensionVersion", "type": "str"},
        "publisher_id": {"key": "properties.publisherId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "extension_category": {"key": "properties.extensionCategory", "type": "str"},
        "extension_auth_link": {"key": "properties.extensionAuthLink", "type": "str"},
        "extension_api_docs_link": {"key": "properties.extensionApiDocsLink", "type": "str"},
        "detailed_information": {"key": "properties.detailedInformation", "type": "[DetailedInformation]"},
    }

    def __init__(self, **kwargs):
        super(FarmBeatsExtension, self).__init__(**kwargs)
        self.system_data = None
        self.target_resource_type = None
        self.farm_beats_extension_id = None
        self.farm_beats_extension_name = None
        self.farm_beats_extension_version = None
        self.publisher_id = None
        self.description = None
        self.extension_category = None
        self.extension_auth_link = None
        self.extension_api_docs_link = None
        self.detailed_information = None


class FarmBeatsExtensionListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of requested objects.
    :type value: list[~azure.mgmt.agrifood.models.FarmBeatsExtension]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FarmBeatsExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(FarmBeatsExtensionListResponse, self).__init__(**kwargs)
        self.value = kwargs.get("value", None)
        self.next_link = None


class FarmBeatsListResponse(msrest.serialization.Model):
    """Paged response contains list of requested objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of requested objects.
    :type value: list[~azure.mgmt.agrifood.models.FarmBeats]
    :ivar next_link: Continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FarmBeats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(FarmBeatsListResponse, self).__init__(**kwargs)
        self.value = kwargs.get("value", None)
        self.next_link = None


class FarmBeatsUpdateRequestModel(msrest.serialization.Model):
    """FarmBeats update request.

    :param location: Geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        super(FarmBeatsUpdateRequestModel, self).__init__(**kwargs)
        self.location = kwargs.get("location", None)
        self.tags = kwargs.get("tags", None)


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :param display: Localized display information for this particular operation.
    :type display: ~azure.mgmt.agrifood.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.agrifood.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.agrifood.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = kwargs.get("display", None)
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.agrifood.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.agrifood.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get("created_by", None)
        self.created_by_type = kwargs.get("created_by_type", None)
        self.created_at = kwargs.get("created_at", None)
        self.last_modified_by = kwargs.get("last_modified_by", None)
        self.last_modified_by_type = kwargs.get("last_modified_by_type", None)
        self.last_modified_at = kwargs.get("last_modified_at", None)


class UnitSystemsInfo(msrest.serialization.Model):
    """Unit systems info for the data provider.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. UnitSystem key sent as part of ProviderInput.
    :type key: str
    :param values: Required. List of unit systems supported by this data provider.
    :type values: list[str]
    """

    _validation = {
        "key": {"required": True, "max_length": 100, "min_length": 2},
        "values": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        super(UnitSystemsInfo, self).__init__(**kwargs)
        self.key = kwargs["key"]
        self.values = kwargs["values"]
