# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResolvedServicePartition(Model):
    """Information about a service partition and its associated endpoints.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The full name of the service with 'fabric:' URI
     scheme.
    :type name: str
    :param partition_information: Required. A representation of the resolved
     partition.
    :type partition_information:
     ~azure.servicefabric.models.PartitionInformation
    :param endpoints: Required. List of resolved service endpoints of a
     service partition.
    :type endpoints: list[~azure.servicefabric.models.ResolvedServiceEndpoint]
    :param version: Required. The version of this resolved service partition
     result. This version should be passed in the next time the ResolveService
     call is made via the PreviousRspVersion query parameter.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'partition_information': {'required': True},
        'endpoints': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'partition_information': {'key': 'PartitionInformation', 'type': 'PartitionInformation'},
        'endpoints': {'key': 'Endpoints', 'type': '[ResolvedServiceEndpoint]'},
        'version': {'key': 'Version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResolvedServicePartition, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.partition_information = kwargs.get('partition_information', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.version = kwargs.get('version', None)
