# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SearchServiceProperties(Model):
    """Defines properties of an Azure Search service that can be modified.

    :param sku: The SKU of the Search Service, which determines price tier
     and capacity limits.
    :type sku: :class:`Sku <azure.mgmt.search.models.Sku>`
    :param replica_count: The number of replicas in the Search service. If
     specified, it must be a value between 1 and 6 inclusive.
    :type replica_count: int
    :param partition_count: The number of partitions in the Search service;
     if specified, it can be 1, 2, 3, 4, 6, or 12.
    :type partition_count: int
    """ 

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
    }

    def __init__(self, sku=None, replica_count=None, partition_count=None):
        self.sku = sku
        self.replica_count = replica_count
        self.partition_count = partition_count
