// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "string_list_impl.hh"

PspellStringEmulation * PspellStringListEmulation::clone() const
{
  return new PspellStringListEmulation(*this);
}

void PspellStringListEmulation::assign(const PspellStringEmulation * other)
{
  *this = *(const PspellStringListEmulation *)other;
}


PspellStringList * PspellStringListImpl::clone() const
{
  return new PspellStringListImpl(*this);
}

void PspellStringListImpl::assign(const PspellStringList * other)
{
  *this = *(const PspellStringListImpl *)other;
}

bool PspellStringListImpl::add(const char * str)
{
  PspellStringListNode * * cur = & first;
  while (*cur != 0 && strcmp((*cur)->data.c_str(), str) != 0)
    cur = &(*cur)->next;
  if (*cur == 0) {
    *cur = new PspellStringListNode(str);
    return true;
  } else {
    return false;
  }
}

bool PspellStringListImpl::remove(const char * str)
{
  PspellStringListNode * * prev = 0;
  PspellStringListNode * * cur  = & first;
  while (*cur != 0 && strcmp((*cur)->data.c_str(), str)!=0 )  {
    prev = cur;
    cur = &(*cur)->next;
  }
  if (*cur == 0) {
    return false;
  } else {
    *prev = (*cur)->next;
    delete *cur;
    return true;
  }
}

void PspellStringListImpl::clear()
{
  PspellStringListNode * temp;
  while (first != 0) {
    temp = first;
    first = temp->next;
    delete temp;
  }
  first = 0;
}

PspellStringEmulation * PspellStringListImpl::elements() const
{
  return new PspellStringListEmulation(first);
}
