/* 
rutinas_db.c
*/

#include "rutinas_db.h"   

struct passwd *sm_getpwnam (char *dbfile, char *user)
{
        DB *dbusus;
        DBT dkey, od;
        int status, i;
        static char dato[MAXDATUM];
        static struct passwd usupw;
        static char nomusu[MAXUSUNOM],*vacio="";
        char *p, *pcam[MAXCAM];
        
        if (isdebug) syslog(XLOGPRIORITY, "dbusu_note: %s",user); 

        dbusus = dbopen (dbfile, O_RDONLY, 0444, DB_HASH, NULL);
        if (dbusus == NULL) 
          {
          if (isdebug) syslog(XLOGPRIORITY, "dbusu_open: %s",strerror(errno)); 
          goto normalusu;
          }
            
        dkey.data=user; dkey.size=strlen(user);
        status = dbusus->get (dbusus, &dkey, &od, 0);
        if ( status<0 ) {
          if (isdebug) 
            syslog(XLOGPRIORITY, "dbusu_get, can't read: %s",strerror(errno)); 
          } 
        else 
          if ( status==1 ) {
            if (isdebug) 
              syslog(XLOGPRIORITY, "dbusu_get, not such user: %s",user); 
            }
        else {
        
          if ( od.size>=MAXDATUM ) od.size=MAXDATUM-1; 
          if ( od.data==NULL ) od.size=0; 
          strncpy(dato,od.data,od.size);  dato[od.size]='\0';

          if (dkey.size >=MAXUSUNOM) dkey.size=MAXUSUNOM;
          strncpy(nomusu,dkey.data,dkey.size);
          
          /* Vamos buscando los ':', apuntandonos su lugar y sustituyendolos
             por nulos para terminar los str. Inicializamos a vacio por 
             si acaso */
          for (i=0; i<MAXCAM; i++) pcam[i]=vacio;
          for (p=dato,i=0; p!=NULL; p=strchr(p,':')) {
            if (p!=dato) { *p='\0'; p++; }
            if (i<MAXCAM) { pcam[i]=p; ++i; }
            }
          usupw.pw_name=nomusu;
          usupw.pw_passwd=pcam[0]; 
          usupw.pw_uid=atoi(pcam[1]); if(usupw.pw_uid == 0) {
            if (isdebug) syslog(XLOGPRIORITY, "dbusu_uid=0");
            goto normalusu;
            }
          usupw.pw_gid=atoi(pcam[2]); if(usupw.pw_gid == 0) {
            if (isdebug) syslog(XLOGPRIORITY, "dbusu_gid=0");
            goto normalusu;
            }
          usupw.pw_gecos=pcam[3];
          usupw.pw_dir=pcam[4];
          usupw.pw_shell=pcam[5];

#if defined (HP)          
          usupw.pw_age=vacio;
          usupw.pw_comment=vacio;
          usupw.pw_audid=1000;  
          usupw.pw_audflg=1;    
#endif 
 
          /* ##### AQUI VIENE EL CAMBIO DE PRIMER DIRECTORIO #### */
          {
            static char directorio_www[MAXDATUM], *usuhom;
            strncpy(directorio_www, "/tela", 6); 
            usuhom=usupw.pw_dir; 
            /* Busca la segunda "/" */
            if (*usuhom=='/') 
              for (usuhom++ ;*usuhom!='\0' && *usuhom!='/';++usuhom);
            strncat (directorio_www, usuhom, MAXDATUM - 1 - strlen(directorio_www));
            strncat (directorio_www, "\n", MAXDATUM - 1 - strlen(directorio_www)); /*NECESARIO para ESTE programa*/
            usupw.pw_dir=directorio_www;
          }
          /* ##### FIN DEL CAMBIO DE DIRECTORIO /gente -> /tela #### */

          
          }
        if ( dbusus->close(dbusus) != 0) if (isdebug) syslog(XLOGPRIORITY, "dbusu_close: %d",errno);
        if (status==0) return &usupw;
        return NULL;
normalusu:        
        if (isdebug) syslog(XLOGPRIORITY, "dbusu_normalusu: %s",user); 
        return getpwnam(user);
}           

int verify_user_POST (char *user, char *pass)
  {
  char *cp, p2[3];
#if defined (HP)
  struct pr_passwd *pwd;
  pwd = getprpwnam (user);
  if (pwd == NULL) return (0);
  cp = crypt (pass, pwd->ufld.fd_encrypt);
  if (strcmp(cp, pwd->ufld.fd_encrypt) == 0) 
    {
    /*PW CORRECTA*/
    return (1);
    }
  else 
    {
    /*MALA PW*/
    return (0);
    }
#elif defined (LINUX) || defined (SUN)
  struct passwd *pwd;
  pwd = getpwnam (user);
  if (pwd == NULL) return (0);
  p2[0] = pwd->pw_passwd[0]; p2[1] = pwd->pw_passwd[1]; p2[2] = '\0';
  cp = crypt (pass, p2);
  if (strcmp(cp, pwd->pw_passwd) == 0) 
    {
    /*PW CORRECTA*/
    return (1);
    }
  else 
    {
    /*MALA PW*/
    return (0);
    }
#endif
  }

int verify_user_POSTAL (char *dbfile, char *user, char *pass)
  {
  struct passwd *pw;
  char *cp, p2[3];
  pw = sm_getpwnam(dbfile, user);
  if (pw == NULL) return (0); 
  else
    {
    p2[0] = pw->pw_passwd[0]; p2[1] = pw->pw_passwd[1]; p2[2] = '\0'; 
    cp = crypt(pass, p2);
    if (strcmp (cp, pw->pw_passwd) == 0) return (1);   /*PW CORRECTA*/
    else return (0);                                   /*MALA PW*/
    }
  }

int exist_user_POSTAL (char *dbfile, char *user)
  {
  struct passwd *pw;
  pw = sm_getpwnam (dbfile, user);
  if (pw == NULL) return (0); else return (1);
  }
  
//0 no existe el usuario, 1 si.
int exist_user (char *dbfile, char *user)
  {
  DB *dbusus;
  DBT dkey, od;
  int status;
  
  dbusus = dbopen (dbfile, O_RDONLY, 0444, DB_HASH, NULL);
  if ( dbusus == NULL ) 
    {
    return 0;
    }
  dkey.data= user; dkey.size= strlen(user);
  status = dbusus->get (dbusus, &dkey, &od, 0);
  if ( status<0 ) 
    {
    return 0;
    } 
  else
    { 
    if (status==1) 
      {
      return 0;
      }
    else 
      {
      return 1;
      }
    }
  }

void db_get_data_from_user (char *dbfile, char *user, char *imapserver, int *imapport, char *smtpserver, char *maildomain, char *trueemail)
  {
  DB *dbusus;
  DBT dkey, od;
  int status,i;
  static char dato[MAXDATUM];
  static char nomusu[MAXUSUNOM], *vacio="";
  char *p, *pcam[MAXCAM];
  
  imapserver[0] = '\0'; smtpserver[0] = '\0'; maildomain[0] = '\0'; trueemail[0] = '\0';
  dbusus = dbopen (dbfile, O_RDONLY, 0444, DB_HASH, NULL);
  if ( dbusus == NULL ) 
    {
    imapserver[0] = '\0';
    return;
    }
  dkey.data= user; dkey.size= strlen(user);
  status = dbusus->get (dbusus, &dkey, &od, 0);
  if ( status<0 ) 
    {
    if (isdebug) syslog(XLOGPRIORITY, "dbusu_get, can't read: %s",strerror(errno)); 
    imapserver[0] = '\0';
    return;
    } 
  else
    { 
    if (status==1) 
      {
      imapserver[0] = '\0';
      return;
      }
    else 
      {
      if ( od.size>=MAXDATUM ) od.size=MAXDATUM-1; 
      if ( od.data==NULL ) od.size=0; 
      strncpy(dato,od.data,od.size);  dato[od.size]='\0';

      if (dkey.size >=MAXUSUNOM) dkey.size=MAXUSUNOM;
      strncpy (nomusu, dkey.data, dkey.size);
      /* Vamos buscando los ':', apuntandonos su lugar y sustituyendolos por nulos para terminar los str. Inicializamos a vacio por si acaso */
      for (i=0; i<MAXCAM; i++) pcam[i]=vacio;
      for (p=dato,i=0; p!=NULL; p=strchr(p,':')) 
        {
        if (p!=dato) { *p='\0'; p++; }
        if (i<MAXCAM) { pcam[i]=p; ++i; }
        }
      if (pcam[0] != NULL) {strncpy (imapserver, pcam[0], 49);}
      if (pcam[1] != NULL) {*imapport = atoi (pcam[1]);}
      if (pcam[2] != NULL) {strncpy (smtpserver, pcam[2], 49);}
      if (pcam[3] != NULL) {strncpy (maildomain, pcam[3], 49);}
      if (pcam[4] != NULL) {strncpy (trueemail, pcam[4], 100);}      
      }
    if ( dbusus->close(dbusus) != 0) if (isdebug) syslog(XLOGPRIORITY, "dbusu_close: %d",errno);
    }
  }  
  
  
