/*                               
Service_UserAccounts.cc
*/

#include "Service_UserAccounts.h"
#include "ClientHTTP.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

bool Service_UserAccounts_Initialized = false;
TBuffer USERACCOUNTS_URL2Get;

#define USERACCOUNTS_HOST       "cuentas.uv.es"
#define USERACCOUNTS_URL_BEGIN  "/cgi-bin/p/user/Usuario"
#define USERACCOUNTS_PORT 80
//In seconds
#define USERACCOUNTS_TIMEOUT 240
#define USERACCOUNTS_NEED_BASICAUTH 1

bool first_page = true;

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    void PrintUserAccountsDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, StringList *SLHead, StringList *SLBody);
  };

//retrieve the url for the Service icon
const char *GetService_UserAccounts_ICO_URL (void)
  {
  return skin->getI(L_USERACCOUNTS);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_UserAccounts_ICO_ALT (void)
  {
  return L->get(L_USERACCOUNTS);
  }

//Retrieve the Service name
const char *GetService_UserAccounts_NAME (void)
  {
  return L->get(L_USERACCOUNTS);
  }

//Retrieve the Service Description
const char *GetService_UserAccounts_DESCRIPTION (void)
  {
  return L->get(L_USERACCOUNTS_DESCRIPTION);
  }

//Entry point to service init
bool DoService_UserAccounts_BEGIN (TProgData *pd)
  {
  TBuffer file2show;

  if (Service_UserAccounts_Initialized == true) {return true;}
  Service_UserAccounts_Initialized = false;
  LOG ("Initializating Service UserAccounts for user=%s", pd->username);

  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}
  xstrncpy (USERACCOUNTS_URL2Get, CMAXBUFFER, USERACCOUNTS_URL_BEGIN);    

  Service_UserAccounts_Initialized = true;
  return true;
  }

//Entry point to service end
bool DoService_UserAccounts_END (TProgData *pd)
  {
  Service_UserAccounts_Initialized = false;  
  return true;
  }

//Entry point to execute a service command
bool DoService_UserAccounts_CMD (TProgData *pd)
  {
  ClientHTTP *CliHTTP;
  HTMLPages *html;
  int cmd, httpcode;
  StringList *SLHTTPHead, *SLHTTPBody;
  bool b;
  XString XS;
  TBuffer postdata2send,
          PATH_INFO, QUERY_STRING, REQUEST_METHOD, SERVER_PROTOCOL, header2send, HTTP_ACCEPT,
          CONTENT_TYPE, CONTENT_LENGTH, SERVER_SOFTWARE, HTTP_HOST, REMOTE_HOST, SERVER_NAME,
          HTTP_COOKIE, REMOTE_USER, SERVER_PORT;

  html = (HTMLPages *)pd->html;
  cmd = pd->cmd;

  TBuffer file2show, abuf;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {html->dumpFile (file2show, "TEXT/HTML"); return false;}

  SLHTTPHead = new StringList;    
  SLHTTPBody = new StringList;
  
  cgienv_GetSimpleVarDef (pd->envfile, "PATH_INFO",       PATH_INFO, "");
  cgienv_GetSimpleVarDef (pd->envfile, "QUERY_STRING",    QUERY_STRING, "");
  cgienv_GetSimpleVarDef (pd->envfile, "CONTENT_LENGTH",  CONTENT_LENGTH, "");
  cgienv_GetSimpleVarDef (pd->envfile, "REQUEST_METHOD",  REQUEST_METHOD, "GET");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_PROTOCOL", SERVER_PROTOCOL, "HTTP/1.0");
  cgienv_GetSimpleVarDef (pd->envfile, "HTTP_ACCEPT",     HTTP_ACCEPT, "");
  cgienv_GetSimpleVarDef (pd->envfile, "CONTENT_TYPE",    CONTENT_TYPE, "");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_SOFTWARE", SERVER_SOFTWARE, "");
  cgienv_GetSimpleVarDef (pd->envfile, "HTTP_HOST",       HTTP_HOST, "");     
  cgienv_GetSimpleVarDef (pd->envfile, "REMOTE_HOST",     REMOTE_HOST, "");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_NAME",     SERVER_NAME, "");
  cgienv_GetSimpleVarDef (pd->envfile, "HTTP_COOKIE",     HTTP_COOKIE, "");
  cgienv_GetSimpleVarDef (pd->envfile, "REMOTE_USER",     REMOTE_USER, "");
    if (IsEmpty(REMOTE_USER)) {xstrncpy (REMOTE_USER, CMAXBUFFER, pd->username);}
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_PORT",     SERVER_PORT, "");

  xstrncpy (USERACCOUNTS_URL2Get, CMAXBUFFER, USERACCOUNTS_URL_BEGIN);

  if ((IsEmpty(QUERY_STRING) == true) && (first_page == true))
    {    
    first_page = false;
    xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "?principal:");
    if      (L->getLang() == LANG_SPANISH) xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "sp");   //Castellano
    else if (L->getLang() == LANG_CATALA)  xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "va");   //Valenciano
    else if (L->getLang() == LANG_ENGLISH) xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "en");   //Ingles
    else xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "sp");                                     //Castellano    
    } 
  else 
    {
    if (IsEmpty(QUERY_STRING) == false) 
      {
      strcat (USERACCOUNTS_URL2Get, "?");
      strcat (USERACCOUNTS_URL2Get, QUERY_STRING);
      }
    } 

  if ((strcmp (USERACCOUNTS_URL2Get, USERACCOUNTS_URL_BEGIN) == 0) && (IsEmpty(CONTENT_LENGTH)))
    {
    xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "?principal:");
    if      (L->getLang() == LANG_SPANISH) xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "sp");   //Castellano
    else if (L->getLang() == LANG_CATALA)  xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "va");   //Valenciano
    else if (L->getLang() == LANG_ENGLISH) xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "en");   //Ingles
    else xstrncat (USERACCOUNTS_URL2Get, CMAXBUFFER, "sp");                                     //Castellano    
    }

  //LOG ("USERACCOUNTS_URL2Get='%s'", USERACCOUNTS_URL2Get);

  //sprintf (header2send, "%s %s %s\n", REQUEST_METHOD, USERACCOUNTS_URL2Get, SERVER_PROTOCOL);
  //Con SERVER_PROTOCOL HTTP/1.1 da algun problema el Explorer
  sprintf (header2send, "%s %s HTTP/1.0\n", REQUEST_METHOD, USERACCOUNTS_URL2Get);
  
  if (!IsEmpty(HTTP_ACCEPT))    {xstrncat(header2send, CMAXBUFFER, "Accept: ");         xstrncat (header2send, CMAXBUFFER, HTTP_ACCEPT);     xstrncat(header2send, CMAXBUFFER, "\n");}
  if (!IsEmpty(CONTENT_TYPE))   {xstrncat(header2send, CMAXBUFFER, "Content-type: ");   xstrncat (header2send, CMAXBUFFER, CONTENT_TYPE);    xstrncat(header2send, CMAXBUFFER, "\n");}
  if (!IsEmpty(CONTENT_LENGTH)) 
    {
    xstrncat(header2send, CMAXBUFFER, CONTENT_LINE_STRING);
    xstrncat (header2send, CMAXBUFFER, CONTENT_LENGTH);  
    xstrncat(header2send, CMAXBUFFER, "\n");
    }  
  if (!IsEmpty(SERVER_SOFTWARE))  {xstrncat(header2send, CMAXBUFFER, "Server: ");         xstrncat (header2send, CMAXBUFFER, SERVER_SOFTWARE); xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (!IsEmpty(REMOTE_HOST))      {xstrncat(header2send, CMAXBUFFER, "Host: ");           xstrncat (header2send, CMAXBUFFER, REMOTE_HOST);     xstrncat(header2send, CMAXBUFFER, "\n");}  
  else if (!IsEmpty(SERVER_NAME)) {xstrncat(header2send, CMAXBUFFER, "Host: ");           xstrncat (header2send, CMAXBUFFER, SERVER_NAME);     xstrncat(header2send, CMAXBUFFER, "\n");}
  else if (!IsEmpty(HTTP_HOST))   {xstrncat(header2send, CMAXBUFFER, "Host: ");           xstrncat (header2send, CMAXBUFFER, HTTP_HOST);       xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (!IsEmpty(REMOTE_USER))      {xstrncat(header2send, CMAXBUFFER, "Remote-user: ");    xstrncat (header2send, CMAXBUFFER, REMOTE_USER);     xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (USERACCOUNTS_NEED_BASICAUTH == true)
    {
    TBuffer tmp;
    xstrncat(header2send, CMAXBUFFER, "Authorization: Basic "); 
    xstrncat (header2send, CMAXBUFFER, AuthBasic (pd->username, pd->password, tmp)); 
    xstrncat(header2send, CMAXBUFFER, "\n");
    }
  
  //Send the url to back to postman to http server.
  TBuffer url2back;
  xsnprintf (url2back, CMAXBUFFER, "%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/", 
                                   PATH_CGI, SERVICE_MAIN, pd->stlang, pd->username, pd->connid,
                                   pd->uo->getValidator(), pd->uo->getPageId(), pd->uo->getLastCmd(), pd->uo->getCurrentPosition());
  //LOG ("url2back=--%s--", url2back);

  //DEBUG ("HTTP_COOKIE=%s", HTTP_COOKIE);
  if (!IsEmpty(HTTP_COOKIE))
    {
    xstrncat(header2send, CMAXBUFFER, "Cookie: "); xstrncat (header2send, CMAXBUFFER, HTTP_COOKIE); 
    if (!IsEmpty(REMOTE_USER))    
      {xstrncat(header2send, CMAXBUFFER, "; usu="); xstrncat (header2send, CMAXBUFFER, REMOTE_USER);} 
    if (!IsEmpty(SERVER_PORT))
      {xstrncat(header2send, CMAXBUFFER, "; xport="); xstrncat (header2send, CMAXBUFFER, SERVER_PORT);}        
    xstrncat(header2send, CMAXBUFFER, "; Backurl="); xstrncat (header2send, CMAXBUFFER, url2back);
    xstrncat(header2send, CMAXBUFFER, ";\n");
    }
  else 
    {
    if (!IsEmpty(REMOTE_USER) || !IsEmpty(SERVER_PORT))
      {
      xstrncat(header2send, CMAXBUFFER, "Cookie: "); 
      if (!IsEmpty(REMOTE_USER)) {xstrncat(header2send, CMAXBUFFER, "usu="); xstrncat (header2send, CMAXBUFFER, REMOTE_USER); xstrncat(header2send, CMAXBUFFER, "; ");}
      if (!IsEmpty(SERVER_PORT)) {xstrncat(header2send, CMAXBUFFER, "xport="); xstrncat (header2send, CMAXBUFFER, SERVER_PORT); xstrncat(header2send, CMAXBUFFER, "; ");}      
      xstrncat(header2send, CMAXBUFFER, "; Backurl="); xstrncat (header2send, CMAXBUFFER, url2back);
      xstrncat(header2send, CMAXBUFFER, "\n");
      }
    }    
  //DEBUG ("HTTP_COOKIE=--%s--", HTTP_COOKIE);  
  xstrncat (header2send, CMAXBUFFER, "Connection: close\n");
  xstrncat (header2send, CMAXBUFFER, "\n");
  //DEBUG ("header2send=--%s--", header2send);
  
  switch (pd->cmd)    
    {    
    case (CMD_USERACCOUNTS_GOTO):  
      {       
      CliHTTP = new ClientHTTP (USERACCOUNTS_HOST, USERACCOUNTS_PORT, USERACCOUNTS_TIMEOUT);
      if (strcmp (CONTENT_LENGTH, "") == 0)
        {
        //DEBUG ("Haciendo un GET");
        b = CliHTTP->doGetHTTPSL (header2send, SLHTTPHead, SLHTTPBody, &httpcode);
        if (b == false)
          {
          if (httpcode == 401)
            {
            LOG ("ERROR: Service_UserAccounts: Authorization Required for user='%s'", REMOTE_USER);
            pd->html->ErrorPageServicePwInvalid (pd->stlang, pd->username, pd->connid, pd->uo);
            }
          else
            {  
            LOG ("ERROR: Service_UserAccounts: Get: %s, user='%s'", CliHTTP->getErrorMsg(), REMOTE_USER);
            pd->html->ErrorPage (CliHTTP->getErrorMsg());
            }
          }
        }
      else
        {
        cgienv_GetAllSimpleVarINPUTPC (pd->envfile, postdata2send, false);
        //escape_url (postdata2send, abuf);
        
        //QUITO A LAS VARIABLES DE CGI SENCILLAS EL RETORNO DE CARRO FINAL
        XS = postdata2send;
        XS.replace ("\n&", "&");
        xstrncpy (postdata2send, CMAXBUFFER, XS.cstr());
        
        //We will replace the old content-length with the new calculated (because we have unescape several chars and this number has changed)
        XString XS;
        TBuffer buf1, buf2, buf3;
        strcpy (buf1, CONTENT_LINE_STRING); strcat (buf1, CONTENT_LENGTH);
        strcpy (buf2, CONTENT_LINE_STRING); strcat (buf2, xitoa(strlen(postdata2send), buf3));
        XS = header2send;
        XS.replace (buf1, buf2);
        xstrncpy (abuf, CMAXBUFFER, XS.cstr());
        
        /*
        DEBUG ("Haciendo un POST");
        DEBUG ("CONTENT_LENGTH=%s", CONTENT_LENGTH);
        DEBUG ("header2send=--%s--", header2send);
        DEBUG ("abuf=--%s--", abuf);
        TBuffer kk, kk2; strcpy (kk, ""); for (int i=0; i < (signed)strlen(postdata2send); ++i) {strcat (kk, xitoa(postdata2send[i], kk2)); strcat (kk, "-");}
        DEBUG ("kk=%s", kk);
        DEBUG ("postdata2send=--%s--", postdata2send);
        */
        
        b = CliHTTP->doPostHTTPSL (abuf, postdata2send, SLHTTPHead, SLHTTPBody, &httpcode);
        if (b == false)
          {
          if (httpcode == 401)
            {
            LOG ("ERROR: Service_UserAccounts: Authorization Required for user='%s'", REMOTE_USER);
            pd->html->ErrorPageServicePwInvalid (pd->stlang, pd->username, pd->connid, pd->uo);
            }
          else
            {  
            LOG ("ERROR: Service_UserAccounts: Post: %s, user='%s'", CliHTTP->getErrorMsg(), REMOTE_USER);
            pd->html->ErrorPage (CliHTTP->getErrorMsg());
            }
          }          
        }
      delete CliHTTP;
      if (httpcode != 401) {html->PrintUserAccountsDisplayPage  (pd->stlang, pd->username, pd->connid, pd->uo, SLHTTPHead, SLHTTPBody);}
      break;
      }
    default: 
      {    
      LOG ("ERROR: Service_UserAccounts: Here we can not go! cmd=%d, stcmd=--%s--, stsubcmd=--%s--", pd->cmd, pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }                                   
    }  
  initStr (USERACCOUNTS_URL2Get);

  delete SLHTTPHead;  
  delete SLHTTPBody;
  return false;  
  }  

void HTMLPages::PrintUserAccountsDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, 
                                            StringList *SLHead, StringList *SLBody)
  { 
  TBuffer linea;
  XString XS;
  /*
  static int kk = 0;
  TBuffer abuf;
  xsnprintf (abuf, CMAXBUFFER, "/tmp/head_%d.txt", kk); SLHead->SaveToFile (abuf, true); 
  xsnprintf (abuf, CMAXBUFFER, "/tmp/body_%d.txt", kk); SLBody->SaveToFile (abuf, true); 
  ++kk; 
  */
  for (int i = 0; i < SLHead->Count(); ++i) 
    {
    xstrncpy (linea, CMAXBUFFER, SLHead->getString (i).cstr());
    if (strstr (linea, "Set-Cookie: ") != NULL)
      {
      if (strstr (linea, ";Path=") != NULL)
        {
        XS = XString (linea);
        XS.replace (";Path=/pls/uv0/", ";Path=/cgi-bin/");
        WRITE ("%s\n", XS.cstr());
        }
      else
        {
        xstrncat (linea, CMAXBUFFER, ";Path=/cgi-bin/");
        WRITE ("%s\n", linea);
        }        
      }
    else
      {
      WRITE ("%s\n", linea);
      }
    }  
  WRITE ("\n");
  for (int i = 0; i < SLBody->Count(); ++i)
    {
    WRITE ("%s\n", SLBody->getString (i).cstr());
    }
  }
