/*                               
Service_Config.cc
*/

#include "Service_Config.h"

extern Language *L;
extern CCLIENT *cclient;
extern ClientNNTP *CN;
extern Skin *skin;

bool Service_Config_Initialized = false;

class HTMLPages: public HTMLBasic
  {
  private:
    void PrintStatusLine_Config (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname);
    void BotoneraComun_Config (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
  public:
    void PrintShowMainIndexOptions (TProgData *pd);  
    void PrintShowCCLIENTOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo);
    void PrintShowNNTPOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                     ClientNNTP *cn, const char *text2search);
    void PrintShowAppearanceOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo);
  };

//retrieve the url for the Service icon
const char *GetService_Config_ICO_URL (void)
  {
  return skin->getI(L_CONFIG);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Config_ICO_ALT (void)
  {
  return L->get(L_CONFIG);
  }

//Retrieve the Service name
const char *GetService_Config_NAME (void)
  {
  return L->get(L_CONFIG);
  }

//Retrieve the Service Description
const char *GetService_Config_DESCRIPTION (void)
  {
  return L->get(L_CONFIG_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Config_BEGIN (TProgData *pd)
  {
  TBuffer file2show;

  if (Service_Config_Initialized == true) {return true;}
  Service_Config_Initialized = false;
  LOG ("Initializating Service Config for user=%s", pd->username);
      
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  
  Service_Config_Initialized = true;
  return true;
  }

//Entry point to service end
bool DoService_Config_END (TProgData *pd)
  {
  if (Service_Config_Initialized == false) {return true;}
  Service_Config_Initialized = false;
  return true;
  }

//Entry point to execute a service command
bool DoService_Config_CMD (TProgData *pd)
  {
  TBuffer tmp, abuf;
  int cmd;
  HTMLPages *html;
  
  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;

  //Some commands require some initial action
  if ((cmd == CMD_CONFIG_NNTP) && 
      (cgienv_ExistsVar (pd->envfile, "config_nntp_open") == true))
    {
    int numgroups = 1;
    cmd = CMD_CCLIENT_MB_CHANGE;
    cgienv_GetSimpleMultipleEntries (pd->envfile, "searchedgroups", " ", abuf, true);
    for (int i = 0; (unsigned int)i < strlen(abuf); ++i) 
      {
      if (abuf[i] == ' ') {abuf[i] = '\0'; ++numgroups;}
      }
    if (numgroups > 1) 
      {
      html->ErrorPage(L->get(ERR_NNTP_NUM_SEL));
      return false;
      }
    else
      {
      //Transform '#' to ':'. That is because char '#' is not passed Ok in urls      
      xsnprintf (tmp, CMAXBUFFER, "%s/%s/mb_change/noop/%s/%s/%s/%d/%d/%d/:%s/", PATH_CGI, SERVICE_CCLIENT, pd->stlang, pd->username, pd->connid, 
                       pd->uo->getValidator(), pd->uo->getPageId(), CMD_CONFIG_NNTP, abuf);
      pd->html->Redirect(tmp);
      return false;
      }
    }
  else if (cgienv_ExistsVar (pd->envfile, "config_cancel") == true) {cmd = CMD_CONFIG_CANCEL;}        
  else if (cgienv_ExistsVar (pd->envfile, "config_cclient_save") == true) {cmd = CMD_CONFIG_CCLIENT_SAVE;}
  else if (cgienv_ExistsVar (pd->envfile, "config_nntp_save") == true) {cmd = CMD_CONFIG_NNTP_SAVE;}
  else if (cgienv_ExistsVar (pd->envfile, "config_nntp_search") == true) {cmd = CMD_CONFIG_NNTP_SEARCH;}
  else if (cgienv_ExistsVar (pd->envfile, "config_nntp_addselected") == true) {cmd = CMD_CONFIG_NNTP_ADDSELECTED;}
  else if (cgienv_ExistsVar (pd->envfile, "config_appearance_save") == true) {cmd = CMD_CONFIG_APPEARANCE_SAVE;}  

  switch (cmd)
    {      
    case (CMD_CONFIG_CANCEL):
      {
      if (pd->uo->getLastCmd () == CMD_CONFIG)
        {
        xsnprintf (abuf, CMAXBUFFER, "%s/%s/config/noop/%s/%s/%s/%d/%d/%d/%ld/", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(),
                   pd->uo->getPageId(), pd->uo->getLastCmd(), pd->uo->getCurrentPosition());                   
        pd->html->Redirect (abuf);           
        }
      else 
        {
        xsnprintf (abuf, CMAXBUFFER, "%s", pd->uo->getLastStringCmd(CMD_CONFIG_CANCEL, pd->stlang, pd->connid, false));
        pd->html->Redirect (abuf);          
        }                 
      break;
      }  
    case (CMD_CONFIG):
      {
      pd->uo->setStatusLine (L->get(MSG_SHOWOPTIONS), RED);
      html->PrintShowMainIndexOptions (pd);
      break;
      }  
    case (CMD_CONFIG_CCLIENT):
      {
      pd->uo->setStatusLine (L->get(MSG_SHOWOPTIONS_CCLIENT), RED);
      html->PrintShowCCLIENTOptions (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }
    case (CMD_CONFIG_NNTP):
      {
      CN->setNNTPserver (pd->uo->getNNTPServer());
      CN->retrieveAllGroupsList ();
      CN->retrievePartialGroupsList ("");
      pd->uo->setStatusLine (L->get(MSG_SHOWOPTIONS_NNTP), RED);
      html->PrintShowNNTPOptions (pd->stlang, pd->username, pd->connid, pd->uo, CN, NULL);
      break;
      }   
    case (CMD_CONFIG_APPEARANCE):
      {
      pd->uo->setStatusLine (L->get(MSG_SHOWOPTIONS_APPEARANCE), RED);
      html->PrintShowAppearanceOptions (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }
    case (CMD_CONFIG_CCLIENT_SAVE):
      {
      TBuffer abuf;
      FILE *fw;
      char *pc = NULL;
      bool boo;
      
      MakeTmpName (pd->parm1, CMAXBUFFER);
      fw = fopen (pd->parm1, "w");
      fprintf (fw, "[main]\n");        
      fprintf (fw, "msgsperindexpage=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "msgsperindexpage", abuf, "10"));
      fprintf (fw, "insigninnewmsg=%d\n", cgienv_GetEntryBool (pd->envfile, "insigninnewmsg"));
      fprintf (fw, "personalname=%s\n", Text2HTML(cgienv_GetSimpleVarDef (pd->envfile, "personalname", abuf, ""), pc)); free (pc);
      fprintf (fw, "savemsgsentmail=%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail"));
      fprintf (fw, "replyfrom=%d\n", cgienv_GetEntryBool (pd->envfile, "replyfrom"));
      fprintf (fw, "forwattachs=%d\n", cgienv_GetEntryBool (pd->envfile, "forwattachs"));
      fprintf (fw, "heightwritearea=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "heightwritearea", abuf, "30"));
      fprintf (fw, "widthwritearea=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "widthwritearea", abuf, "70"));
      fprintf (fw, "truncatelengthreadingmsg=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "truncatelengthreadingmsg", abuf, "90"));
      fprintf (fw, "refreshtime=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "refreshtime", abuf, "0"));
      fprintf (fw, "sentmailname=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "sentmailname", abuf, DEFOPT_SENTMAILBOX));
      fprintf (fw, "confirmpurge=%d\n", cgienv_GetEntryBool (pd->envfile, "confirmpurge"));
      fprintf (fw, "\n");
      fprintf (fw, "[signature]\n");                   
      fprintf (fw, "%s",  Text2HTML(Cut (cgienv_GetComplexVar (pd->envfile, "textsignature"), MAXLENGTH_IN_SIGN, abuf), pc)); free (pc);
      fclose (fw);
      boo = pd->uo->SaveOptions(pd->parm1, CMD_CONFIG_CCLIENT);
      if (boo == true) 
        {
        pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), RED); pd->uo->LoadOptions();
        if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), -1, "nntp"))          
          {
          cclient->setNNTPServer (pd->uo->getNNTPServer());
          CN->setNNTPserver (pd->uo->getNNTPServer());
          }
        //cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false);
        }
      else pd->uo->setStatusLine (L->get(MSG_ERR_SAVEOPTIONS), RED);     
      html->PrintShowCCLIENTOptions (pd->stlang, pd->username, pd->connid, pd->uo);
      break;  
      }
    case (CMD_CONFIG_APPEARANCE_SAVE):
      {
      TBuffer abuf;
      FILE *fw;
      bool boo;
      
      MakeTmpName (pd->parm1, CMAXBUFFER);
      fw = fopen (pd->parm1, "w");
      fprintf (fw, "[main]\n");        
      fprintf (fw, "displaypersonalinfo=%d\n", cgienv_GetEntryBool (pd->envfile, "displaypersonalinfo"));
      fprintf (fw, "skin=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "skin", abuf, "DEFAULT"));
      fprintf (fw, "confirmlogout=%d\n", cgienv_GetEntryBool (pd->envfile, "confirmlogout"));
      fprintf (fw, "showclock=%d\n", cgienv_GetEntryBool (pd->envfile, "showclock"));
      fprintf (fw, "showiconslabels=%d\n", cgienv_GetEntryBool (pd->envfile, "showiconslabels"));
      fprintf (fw, "iconssize=%s\n", cgienv_GetSimpleVarDef (pd->envfile, "iconssize", abuf, "0"));
      fclose (fw);
      boo = pd->uo->SaveOptions(pd->parm1, CMD_CONFIG_APPEARANCE);
      if (boo == true) 
        {
        pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), RED); pd->uo->LoadOptions();
        }
      else pd->uo->setStatusLine (L->get(MSG_ERR_SAVEOPTIONS), RED);     
      html->PrintShowAppearanceOptions (pd->stlang, pd->username, pd->connid, pd->uo);
      break;  
      }      
    case (CMD_CONFIG_NNTP_SAVE):
      {
      FILE *fw;
      char *pc = NULL;
      MakeTmpName (pd->parm1, CMAXBUFFER);
      fw = fopen (pd->parm1, "w");
      fprintf (fw, "[subscribedgroups]\n");   
      fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetComplexVar (pd->envfile, "subscribedgroups"), MAXLENGTH_IN_SUBSCRIBEDGROUPS, abuf), pc)); free (pc);
      fclose (fw);
      if (pd->uo->SaveNNTPOptions(pd->parm1) == true) 
        {
        pd->uo->setStatusLine (L->get(MSG_SAVEOPTIONS), RED); pd->uo->LoadOptions();
        cclient->setNNTPServer (pd->uo->getNNTPServer());
        CN->setNNTPserver (pd->uo->getNNTPServer());
        //cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false);
        }
      else pd->uo->setStatusLine (L->get(MSG_ERR_SAVEOPTIONS), RED);
      html->PrintShowNNTPOptions (pd->stlang, pd->username, pd->connid, pd->uo, CN, NULL);
      break;            
      }       
    case (CMD_CONFIG_NNTP_SEARCH):
      {
      int found;         
      cgienv_GetSimpleVarDef (pd->envfile, "text2search", pd->parm1, "");
      CN->setNNTPserver (pd->uo->getNNTPServer());
      CN->retrieveAllGroupsList ();
      found = CN->retrievePartialGroupsList (pd->parm1);
      if (found < MAX_NNTP_GROUPS_FOUND)
        xsnprintf (tmp, CMAXBUFFER, L->get(MSG_NNTPGROUPS_FOUND), found);
      else
        xsnprintf (tmp, CMAXBUFFER, L->get(MSG_MAX_NNTPGROUPS_FOUND), found);
      pd->uo->setStatusLine (tmp, RED);
      html->PrintShowNNTPOptions (pd->stlang, pd->username, pd->connid, pd->uo, CN, pd->parm1);
      break;       
      }
    case (CMD_CONFIG_NNTP_ADDSELECTED):
      {
      int added;
      char *pclinea;
      StringList *SLTemp;                         
      FILE *fw;
      
      cgienv_GetSimpleMultipleEntries (pd->envfile, "searchedgroups", " ", abuf, true);
      MakeTmpName (pd->parm1, CMAXBUFFER);
      fw = fopen (pd->parm1, "w");
      fprintf (fw, "%s\n", abuf);
      fclose (fw);        
      SLTemp = new StringList ();
      pclinea = getLineFile(pd->parm1, 1, 1, tmp);
      SeparaTokensEnStringList (pclinea, SP, SLTemp);
      added = MergeStringList (pd->uo->SLSubscribedGroups, SLTemp, true);
      pd->uo->SaveSubscribedGroups();
      CN->setNNTPserver (pd->uo->getNNTPServer());
      CN->retrieveAllGroupsList ();
      xsnprintf (tmp, CMAXBUFFER, L->get(MSG_NNTPGROUPS_ADDED), added);
      pd->uo->setStatusLine (tmp, RED);
      html->PrintShowNNTPOptions (pd->stlang, pd->username, pd->connid, pd->uo, CN, NULL);
      DeleteFile (pd->parm1);
      delete SLTemp;
      break;           
      }
    case (CMD_CCLIENT_NW_LIST_DUMP):
      {
      pd->uo->InitStatusLine ();
      CN->setNNTPserver (pd->uo->getNNTPServer());
      CN->retrieveAllGroupsList ();
      html->dumpSL (CN->SLAllGroups, true);
      break;
      }                                                                                      
    default:
      {
      LOG ("ERROR: Service_Config: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }
    }

  return false;
  } 

void HTMLPages::PrintStatusLine_Config (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer(), 
              mailboxname);
    }
  else
    {
    if (cclient->getError () == false)
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }
    else
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             cclient->getErrorString(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }  
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");
  }
  
void HTMLPages::BotoneraComun_Config (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));
    
      //BUTTON BACK  
      if (cmdactual != CMD_CONFIG)
        {     
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");        
        WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));                   
        Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
        WRITE ("</A>");
        EndTD();   

        //SPACE 
        EmptyCellx2();
        }        

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_CONFIG: WRITE ("<A HREF=\"%s/%s/help/config/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CONFIG_CCLIENT: WRITE ("<A HREF=\"%s/%s/help/config_cclient/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CONFIG_NNTP: WRITE ("<A HREF=\"%s/%s/help/config_nntp/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CONFIG_APPEARANCE: WRITE ("<A HREF=\"%s/%s/help/config_appearance/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, pageid, cmdactual); break;
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      
      //SPACE 
      EmptyCellx2();     
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD(); 
    EndTR();
  EndTable ();  
  PrintStatusLine_Config (user, uo, true, cclient->getMailboxName());
  }

void HTMLPages::PrintShowMainIndexOptions (TProgData *pd)
  {
  int pageid, validator, actualcmd; 

  validator = pd->uo->getValidator();
  pageid    = pd->uo->getPageId();
  actualcmd = CMD_CONFIG;

  Head ("text/html", "", "");
  HTMLBegin ();                
  Title (L->get(TIT_SERVICES), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
                   skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  BotoneraComun_Config (CMD_CONFIG, pd->stlang, pd->username, pd->connid, pd->uo);  
  Linea();  

  BeginCenter();
  WRITE ("<TABLE cellpadding=\"2\" cellspacing=\"1\" width=\"70%%\" BORDER=\"0\">\n");

  //CCLIENT
  BeginTR();
  WRITE ("<TD WIDTH=\"50%%\" align=\"right\" valign=\"top\">\n");
  Label (GetService_Cclient_NAME());
  EndTD();
  BeginTD();
  WRITE ("<A HREF=\"%s/%s/config_cclient/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
  WRITE ("<B>%s</B>\n", L->get(L_MAIN));
  WRITE ("</A><BR><BR>\n");
  
  //SIEVE
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), -1, "sieve")) //Sieve
    {
    WRITE ("<A HREF=\"%s/%s/filters_show/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    WRITE ("<B>%s</B>\n", L->get(L_FILTERS));
    WRITE ("</A><BR><BR>\n");
    
    WRITE ("<A HREF=\"%s/%s/vacations_show/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_SIEVE, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    WRITE ("<B>%s</B>\n", L->get(L_VACATION));
    WRITE ("</A><BR><BR>\n");    
    }
  EndTD();
  EndTR();
    
  //NNTP
  if (isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), -1, "nntp"))  //News Groups  
    {           
    BeginTR();
    WRITE ("<TD align=\"right\" valign=\"top\">\n");
    Label (L->get(L_NNTP)); 
    EndTD();
    BeginTD();
    WRITE ("<A HREF=\"%s/%s/config_nntp/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
    WRITE ("<B>%s</B>\n", L->get(L_MAIN));    
    WRITE ("</A><BR><BR>\n");
    EndTD();
    EndTR();
    }

  //APPEARANCE
  BeginTR();
  WRITE ("<TD align=\"right\" valign=\"top\">\n");
  Label (L->get(L_APPEARANCE));
  EndTD();
  BeginTD();
  WRITE ("<A HREF=\"%s/%s/config_appearance/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, validator, pageid, actualcmd);
  WRITE ("<B>%s</B>\n", L->get(L_MAIN));    
  WRITE ("</A><BR><BR>\n");
  EndTD();
  EndTR();

  EndTable();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));        
  }
   
void HTMLPages::PrintShowCCLIENTOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  TNumber anum;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SHOWOPTIONS), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraComun_Config (CMD_CONFIG_CCLIENT, stlang, user, connid, uo);
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));
  BeginFormPost ("PrintShowCCLIENTOptions1", PATH_CGI);
  FormHidden ("service", SERVICE_CONFIG);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CONFIG);
  FormHidden ("cmd", "config");
  FormHidden ("validator", uo->getValidator());
  Label (L->get(L_SHOWOPTIONS)); BR();
  
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_cclient_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  EndTable();
  
  Linea();
  Text (L->get(L_PERSONALNAME)); FormEdit (200, 50, "personalname", uo->getPersonalName()); BR();  
  FormCheckbox ("savemsgsentmail", "1", uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); FormEdit (50, 20, "sentmailname", uo->getSentMailName()); BR(); 
  FormCheckbox ("replyfrom", "1", uo->getReplyFrom()); WRITE (L->get(L_REPLYFROM)); BR(); 
  FormCheckbox ("forwattachs", "1", uo->getForwAttachs()); WRITE (L->get(L_FORWATTACHS)); BR(); 
  FormCheckbox ("confirmpurge",  "1", uo->getConfirmPurge());  WRITE (L->get(L_CONFIRMPURGE));  BR();
  Linea();
  Text (L->get(L_MSGSPERINDEXPAGE)); FormEdit (5, 5, "msgsperindexpage", xltoa(uo->getMsgsPerIndexPage(), anum)); BR();
  Text (L->get(L_TRUNCATELENGTHREADINGMSG)); 
  FormEdit (5, 5, "truncatelengthreadingmsg", xltoa(uo->getTruncateLengthReadingMsg(), anum)); BR();
  Text (L->get(L_SIZEWRITEAREA)); 
  FormEdit (5, 5, "heightwritearea", xltoa(uo->getHeightWriteArea(), anum)); Text (" / ");
  FormEdit (5, 5, "widthwritearea", xltoa(uo->getWidthWriteArea(), anum)); BR();
  Text (L->get(L_REFRESHTIME)); 
  FormEdit (5, 5, "refreshtime", xltoa(uo->getRefreshTime(), anum)); BR();
  BR();
  Linea();
  FormCheckbox ("insigninnewmsg", "1", uo->getInsertSignatureInNewMsg()); WRITE (L->get(L_INSIGNINNEWMSG)); BR();    
  Text (L->get(L_SIGNATURE)); BR(); 
  EndFont();
  FormTextArea (10, 55, "textsignature", uo->getSignature(), false); BR();  
    
  BR();
  Linea();
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_cclient_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  EndTable();

  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
  
void HTMLPages::PrintShowNNTPOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo, 
                                      ClientNNTP *cn, const char *text2search) 
  {
  TBuffer abuf;
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SHOWNNTPMANAGEGROUPS), skin->getSkinAtribProp ("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraComun_Config (CMD_CONFIG_NNTP, stlang, user, connid, uo);
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));

  BeginFormPost ("PrintShowNNTPOptions1", PATH_CGI);
  FormHidden ("service", SERVICE_CONFIG);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CONFIG);
  FormHidden ("cmd", "config_nntp");
  FormHidden ("validator", uo->getValidator());
  Label (L->get(L_SHOWOPTIONS)); BR();
  
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_nntp_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  EndTable();

  BR();
  Linea();
  
  Label (L->get(L_NNTPSERVER)); WRITE (" <FONT COLOR=\"#000000\"><I>%s</I></FONT>", uo->getNNTPServer()); 
  BR();
  
  BR();
  Linea();

  Label (L->get(L_SUBSCRIBEDGROUPS)); BR();
  FormTextArea (10, 75, "subscribedgroups", uo->SLSubscribedGroups->toPChar(true), false); BR();

  if (uo->getObligatedGroups(abuf) > 0)
    {
    Small ("("); Small (L->get(L_FORCEDGROUPS)); Small (abuf); Small (")");
    }
    
  Linea();
  Label (L->get(L_GROUPSTOADD)); BR();
  FormButton ("config_nntp_search", L->get(L_NNTP_LISTSEARCH));
  FormEdit (255, 30, "text2search", text2search ? text2search : BEGIN_FILTER_NNTP_SEARCH); 
  sprintf (abuf, "%s/%s/nw_list_dump/noop/%s/%s/%s/%d/%d/%d/", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
           uo->getValidator(), uo->getPageId(), uo->getLastCmd()); 
  BR();
  if (cn->SLSearchedGroups->Count() > 0)
    {
    FormBeginMultipleSelect ("PrintShowNNTPOptions1", "searchedgroups", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < cn->SLSearchedGroups->Count(); ++i)
      {
      FormAddOptionSelect (false, cn->SLSearchedGroups->getString(i).cstr(), cn->SLSearchedGroups->getString(i).cstr());
      }
    FormEndSelect();
    BR();
    FormButton ("config_nntp_addselected", L->get(L_ADDSELECTEDGROUPS));
    FormButton ("config_nntp_open", L->get(L_GOSELECTEDGROUP));
    BR();
    }
  else
    {
    FormBeginMultipleSelect ("PrintShowNNTPOptions1", "searchedgroups", NULL, uo->get_use_javascript()); 
    FormAddOptionSelect (false, L->get(L_LIST_EMPTY), L->get(L_LIST_EMPTY));
    FormEndSelect();
    BR ();
    }  
    
  Linea();
  BR ();
  URL (L->get(L_DUMPFULLLIST), abuf); 
  Linea();
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_nntp_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  EndTable();


  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
  
void HTMLPages::PrintShowAppearanceOptions (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  bool iscurrent;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SHOWOPTIONS), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraComun_Config (CMD_CONFIG_APPEARANCE, stlang, user, connid, uo);
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));
  BeginFormPost ("PrintShowAppearanceOptions1", PATH_CGI);
  FormHidden ("service", SERVICE_CONFIG);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CONFIG);
  FormHidden ("cmd", "config");
  FormHidden ("validator", uo->getValidator());
  Label (L->get(L_SHOWOPTIONS)); BR();
  
  /*
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_appearance_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  EndTable();
  */
  
  Linea();
  
  BR();
  FormCheckbox ("displaypersonalinfo", "1", uo->getDisplayPersonalInfo()); WRITE (L->get(L_DISPLAYPERSONALINFO)); 
  BR();   
  FormCheckbox ("confirmlogout", "1", uo->getConfirmLogout()); WRITE (L->get(L_CONFIRMLOGOUT)); 
  BR();  
  FormCheckbox ("showclock", "1", uo->getShowClock()); WRITE (L->get(L_OP_SHOWCLOCK)); 
  BR();  
  FormCheckbox ("showiconslabels", "0", uo->getShowIconsLabels()); WRITE (L->get(L_OP_SHOWICONSLABELS));   
  BR(); BR(); 
  Label (L->get(L_SKIN));
  FormBeginSelect ("PrintShowAppearanceOptions1", "skin", NULL, uo->get_use_javascript());
  if (strcmp (skin->getSkin(), "DEFAULT") == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "DEFAULT", "DEFAULT");
  if (strcmp (skin->getSkin(), "CLASSIC") == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "CLASSIC", "CLASSIC");
  if (strcmp (skin->getSkin(), "OLIVE")   == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "OLIVE",   "OLIVE");
  if (strcmp (skin->getSkin(), "RED")     == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "RED",     "RED");
  if (strcmp (skin->getSkin(), "BLUE")    == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "BLUE",    "BLUE"); 
  if (strcmp (skin->getSkin(), "ORANGE")  == 0) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, "ORANGE",  "ORANGE"); 
  FormEndSelect();
  
  BR(); BR(); 
  Label (L->get(L_ICONSSIZE));
  FormBeginSelect ("PrintShowAppearanceOptions2", "iconssize", NULL, uo->get_use_javascript());
  if (uo->getIconsSize() == ICONS_SIZE_SMALL) {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, ST_ICONS_SIZE_SMALL, L->get(L_SMALL));
  if (uo->getIconsSize() == ICONS_SIZE_MEDIUM)    {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, ST_ICONS_SIZE_MEDIUM, L->get(L_MEDIUM)); 
  if (uo->getIconsSize() == ICONS_SIZE_BIG)  {iscurrent = true;} else {iscurrent = false;} FormAddOptionSelect (iscurrent, ST_ICONS_SIZE_BIG, L->get(L_BIG)); 
  FormEndSelect();  
  
  BR();
  Linea();
  BeginTable (5, 0, 0, 25);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  //BeginTD(); BeginCenter(); FormButton ("config_cancel", L->get(L_CANCEL)); EndCenter(); EndTD();
  BeginTD(); BeginCenter(); FormButton ("config_appearance_save",   L->get(L_SAVE));   EndCenter(); EndTD();
  EndTR(); 
  
  EndTable();

  EndForm ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
  
