/*                  
Postman.cc
*/

#include "Postman.h"

Language *L;
XSocket *clientsocket;
const char *stservice, *stcmd, *stsubcmd, *pw, *beginmailbox, *parm1, *parm2, *parm3, *parm4, 
           *mulmsgs, *theaction2, *attnumbers, *imapserver, *user, *connid, *stlang;
TBuffer BufW, BufR, fnsocket, tmpbuf, tmpbuf2, clientip;
int cmd, iservice, sock, validator, pageid, lastcmd, res;
long len;
CGI *cgi;
char *mulentries;
const char *tmpfn = NULL;
    
int main (void)
  {
  int CodeUpload;

  openlog (PROGNAME, XLOGOPTIONS, XLOGFACILITY);
  Randomize ();

  SetHandlers();
          
  //LOG ("Ejecutado el cgi.");
  cgi= new CGI (BASEDIR, make_random_cgi_sep ());
  CodeUpload = cgi->getCodeUpload();  
  stservice  = cgi->getService ();
  stcmd      = cgi->getCmd ();    if (IsEmpty (stcmd)) {stcmd = xstrdup("home");}
  stsubcmd   = cgi->getSubCmd (); if (IsEmpty (stsubcmd)) {stsubcmd = xstrdup("noop");}
  stlang     = cgi->getLang ();
  connid     = cgi->getConnid ();
  validator  = xatoidef (cgi->getValidator(), 0);
  pageid     = xatoidef (cgi->getPageId (), -1);
  lastcmd    = xatoidef (cgi->getLastCmd (), -1); 
  user       = cgi->getUser ();
  parm1      = cgi->getParm1 ();
  parm2      = cgi->getParm2 ();
  parm3      = cgi->getParm3 ();
  parm4      = cgi->getParm4 ();

  //LOG ("Ejecutado el cgi=%s,%s,%s", stservice, stcmd, stsubcmd);
  
  xstrncpy (clientip, CMAXBUFFER, cgi->get_REMOTE_ADDR ("-"));
  
  clientsocket = new XSocket ();
  L = new Language (stlang);

  iservice = TranslateService (stservice);
  if (iservice == iSERVICE_INVALID) {LOG ("Postman: Invalid service."); ErrorPage (L->get(ERR_INV_SERVICE)); exit (0);}
  theaction2 = cgi->GetEntryDef ("theaction2", "");
  if (!IsEmpty (theaction2)) {stcmd = cgi->GetEntryDef ("cmd2", "");}
  cmd = TranslateCmd (iservice, stcmd);  
  if (CodeUpload == -100) 
    {
    if (iservice == iSERVICE_FILEBROWSER)
      {
      xsnprintf (tmpbuf, CMAXBUFFER, L->get(ERR_MAXSIZEFILEUPLOAD), FILEBROWSER_MAXUPLOADFILE);
      }
    else
      {
      xsnprintf (tmpbuf, CMAXBUFFER, L->get(ERR_MAXSIZEATT), MAXLONGATT); 
      }
    LOG (tmpbuf); 
    ErrorPage (tmpbuf);
    fclose (stdout);     
    exit (0);
    } 
  //In all services except iSERVICE_MAIN we check for good cookie
  if (iservice != iSERVICE_MAIN) {CheckingCookie();}
  
  //Login service must be for several actions
  if ((cmd == CMD_SPECIAL_INVALIDPAGE) || (cmd == CMD_MAIN_LOGOUT) || (cmd == CMD_MAIN_HELP)) 
    {
    iservice = iSERVICE_MAIN;
    }
    
  //Special action for some Login commands
  if ((iservice == iSERVICE_MAIN) && (cmd == CMD_MAIN_HOME)) 
    {
    PrintCGILoginPage(stlang);
    }
  else if ((iservice == iSERVICE_MAIN) && (cmd == CMD_MAIN_LOGIN)) 
    {
    Init_Login();
    }
  else if ((iservice == iSERVICE_MAIN) && (cmd == CMD_MAIN_RECONNECT)) 
    {
    tmpfn = cgi->Env2File();
    Init_Reconnect(tmpfn);
    }    
  else
    {  
    tmpfn = cgi->Env2File();
    xstrncpy (fnsocket, CMAXBUFFER, make_session_socket (user, connid, tmpbuf));
    sock = clientsocket->do_client_unix (fnsocket);
    if (sock <= ERROR_SOCKET) 
      {
      if (strcmp (connid, TOKEN_JOKER) == 0)
        {      
        //Security for Reconnect actions
        if (is_CMD_ALLOWED_ACTION (ACTION_RECONNECT, iservice, TranslateCmd (iservice, stcmd)) == false)
          { 
          DeleteFile (tmpfn); 
          CGIErrorPage(stlang, MSG_RECONNECT_NOTALLOWED);
          }                                                    
        //This is for allow call Postman from URLs. We need cookies for that.
        xstrncpy (tmpbuf2, CMAXBUFFER, cgi->get_Cookie(user));
        getConnidFromCookie (tmpbuf2);
        xstrncpy (fnsocket, CMAXBUFFER, make_session_socket (user, tmpbuf2, tmpbuf));
        sock = clientsocket->do_client_unix (fnsocket);
        if (sock <= ERROR_SOCKET)
          {
          DeleteFile (tmpfn); 
          CGIErrorPageConnectionRefused(stlang);
          }
        }
      else
        {
        DeleteFile (tmpfn);
        CGIErrorPageConnectionRefused(stlang);
        }    
      }
    clientsocket->SetSock (sock);  
    xsnprintf (BufW, CMAXBUFFER, "%s %d %d %d %s %s %d %s %s %s \"%s\" \"%s\" \"%s\" \"%s\"\n", 
                     connid, pageid, validator, lastcmd, stlang, clientip, iservice, 
                     stcmd, stsubcmd, 
                     tmpfn, parm1, parm2, parm3, parm4); 
    //DEBUG ("%s", BufW);
    clientsocket->Puts (BufW);
    //For avoid problems with write defined in c-client
#ifdef write
#undef write
#endif

    int cgires;
    while ((res = clientsocket->Read (BufR, CMAXBUFFER)) > ERROR_SOCKET) 
      {
      cgires = write (fileno(stdout), BufR, res);
      }                              
    
    //Delete the cgi env file
    DeleteFile (tmpfn);
    }
  
  fclose (stdout);
  clientsocket->Close ();
  delete clientsocket;
  delete cgi;
  delete L;
  return 0;         
  }

void CheckingCookie (void)  
  {
  xstrncpy (fnsocket, CMAXBUFFER, make_session_socket (user, connid, tmpbuf));
  sock = clientsocket->do_client_unix (fnsocket);
  if (sock <= ERROR_SOCKET) 
    {
    if (strcmp (connid, TOKEN_JOKER) == 0)
      {      
      //Security for Reconnect actions
      if (is_CMD_ALLOWED_ACTION (ACTION_RECONNECT, iservice, TranslateCmd (iservice, stcmd)) == false)
        { 
        CGIErrorPage(stlang, MSG_RECONNECT_NOTALLOWED);
        }                                                    
      //This is for allow call Postman from URLs. We need cookies for that.
      xstrncpy (tmpbuf2, CMAXBUFFER, cgi->get_Cookie(user));
      getConnidFromCookie (tmpbuf2);
      xstrncpy (fnsocket, CMAXBUFFER, make_session_socket (user, tmpbuf2, tmpbuf));
      sock = clientsocket->do_client_unix (fnsocket);
      if (sock <= ERROR_SOCKET)
        {
        //to change it
        imapserver = cgi->GetEntryDef ("imapserver", "post.uv.es");
        CGIPageConnectionToService (stlang, imapserver, user, stservice, stcmd, stsubcmd, parm1, parm2, parm3, parm4);      
        }
      else
        {
        //Security for Reconnect actions
        if (is_CMD_ALLOWED_ACTION (ACTION_RECONNECT, iservice, TranslateCmd (iservice, stcmd)) == false)
          { 
          CGIErrorPage(stlang, MSG_RECONNECT_NOTALLOWED);
          }                                                    
        }  
      }
    else
      {
      CGIErrorPageConnectionRefused(stlang);
      }    
    }
  clientsocket->SetSock (sock);  
  len = xatoldef (parm1, (long)1);
  xsnprintf (BufW, CMAXBUFFER, "%s %d %d %d %s %s %d check_cookie %s %s %s\n", connid, pageid, validator, lastcmd, stlang, clientip, 
                                iSERVICE_MAIN, "noop", "noop", cgi->get_Cookie(user));
  res = clientsocket->Puts (BufW);
  bool entrada = false;
  while (clientsocket->Gets (BufR, CMAXBUFFER) == true) {entrada= true; printf ("%s\n", BufR);}      
  if (entrada == true) {exit (0);}
  }         

void Init_Login (void)
  {       
  if (LOG_BROWSER_CLIENT == 1) {LOG ("   New client. Browser: '%s'", cgi->get_USERAGENT());}
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    Redirect (SERVER_IS_DISABLED);
    exit (0);
    }
  xstrncpy (fnsocket, CMAXBUFFER, make_root_socket (tmpbuf));
  sock = clientsocket->do_client_unix (fnsocket);
  if (sock <= ERROR_SOCKET) {CGIErrorPageConnectionRefused(stlang);}
  clientsocket->SetSock (sock);        
  pw = cgi->GetEntryDef ("pw", "");
  imapserver = cgi->GetEntryDef ("imapserver", "");
  beginmailbox = cgi->GetEntryDef ("beginmailbox", "");  
  
  //I NEED A USER, A PASSWORD AND A SERVER
  if (IsEmpty (pw) || IsEmpty (user) || IsEmpty (imapserver)) {ErrorPage (L->get(ERR_INV_PARMS)); clientsocket->Close (); exit (0);}      
  xsnprintf (BufW, CMAXBUFFER, "-1 -1 -1 -1 %s %s %d login %s %s %s \"%s\" %s \"%s\"\n", 
             stlang, clientip, iservice, "noop", "noop", user, pw, imapserver, beginmailbox);

  clientsocket->Puts (BufW);
//For avoid problems with write defined in c-client
#ifdef write
#undef write
#endif
  while ((res = clientsocket->Read (BufR, CMAXBUFFER)) > ERROR_SOCKET) {write (fileno(stdout), BufR, res);}
  }    

void Init_Reconnect (const char *envfile)
  {         
  int itrueservice;
  TBuffer trueservice, truecmd;

  if (LOG_BROWSER_CLIENT == 1) {LOG ("   Reconnecting New client. Browser: '%s'", cgi->get_USERAGENT());}
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    Redirect (SERVER_IS_DISABLED);
    exit (0);
    }
  xstrncpy (fnsocket, CMAXBUFFER, make_root_socket (tmpbuf));
  sock = clientsocket->do_client_unix (fnsocket);
  if (sock <= ERROR_SOCKET) {CGIErrorPageConnectionRefused(stlang);}
  clientsocket->SetSock (sock);        
  pw = cgi->GetEntryDef ("pw", "");
  imapserver = cgi->GetEntryDef ("imapserver", "");
  beginmailbox = cgi->GetEntryDef ("beginmailbox", "");  
  
  xstrncpy (trueservice, CMAXBUFFER, cgi->GetEntry("trueservice"));
  itrueservice = TranslateService (trueservice);
  xstrncpy (truecmd, CMAXBUFFER, cgi->GetEntry("truecmd"));
  
  if (is_CMD_ALLOWED_ACTION (ACTION_RECONNECT, itrueservice, TranslateCmd (itrueservice, truecmd)) == false)
    {
    CGIErrorPage(stlang, MSG_RECONNECT_NOTALLOWED);
    }
  
  //I NEED A USER, A PASSWORD AND A SERVER
  if (IsEmpty (pw) || IsEmpty (user) || IsEmpty (imapserver)) {ErrorPage (L->get(ERR_INV_PARMS)); clientsocket->Close (); exit (0);}      
  xsnprintf (BufW, CMAXBUFFER, "-1 -1 -1 -1 %s %s %d reconnect %s %s %s \"%s\" %s \"%s\"\n", 
             stlang, clientip, iservice, "noop", envfile, user, pw, imapserver, beginmailbox);
  clientsocket->Puts (BufW);
//For avoid problems with write defined in c-client
#ifdef write
#undef write
#endif
  while ((res = clientsocket->Read (BufR, CMAXBUFFER)) > ERROR_SOCKET) {write (fileno(stdout), BufR, res);}
  }    

void SetHandlers (void)
  {
  struct sigaction act, oldact;
  sigemptyset(&act.sa_mask); act.sa_flags = 0; act.sa_handler = procsignals; sigaction(SIGTERM, &act, &oldact);   
  }  

void procsignals (int signal_type)
  {
  switch (signal_type)
    {
    case SIGTERM:
      {
      if (tmpfn != NULL) {DeleteFile (tmpfn);}
      LOG ("Received signal SIGTERM in cgi for IP=%s, user=%s", clientip, user);
      exit (1);
      break;
      }    
    }    
  }       
  
  
  
