/*                                                       
HTMLBasic.cc
*/

#include "HTMLBasic.h"

extern Language *L;
extern CCLIENT *thecclient;
extern Skin *skin;

HTMLBasic::HTMLBasic (void)
  {
  MAXMSGSFORPAGE = DEFOPT_MSGSPERINDEXPAGE;
  fout = NULL;
  iout = -1;
  OneSocket = NULL;
  XBuffer = "";
  }  

HTMLBasic::HTMLBasic (FILE *FR)
  {
  MAXMSGSFORPAGE = DEFOPT_MSGSPERINDEXPAGE;
  fout = FR;
  iout = -1;
  OneSocket = NULL;
  XBuffer = "";
  }  

HTMLBasic::HTMLBasic (int FR)
  {
  MAXMSGSFORPAGE = DEFOPT_MSGSPERINDEXPAGE;
  fout = NULL;
  iout = FR;
  OneSocket = NULL;
  XBuffer = "";  
  }
   
HTMLBasic::HTMLBasic (XSocket *aXS)
  {
  MAXMSGSFORPAGE = DEFOPT_MSGSPERINDEXPAGE;
  fout = NULL;
  iout = -1;
  OneSocket = aXS;
  XBuffer = "";
  }
 
HTMLBasic::~HTMLBasic()
  {
  }  
  
void HTMLBasic::setMAXMSGSFORPAGE (long maxmsgs)
  {
  MAXMSGSFORPAGE = maxmsgs;
  }          

int HTMLBasic::WRITE (const char *fmt, ...)
  {
  int res = -1;
  TBuffer linea;
  va_list args;
  va_start (args, fmt);
  xvsnprintf (linea, CMAXBUFFER, fmt, args);  
  if (iout != -1) {res = write (iout, linea, strlen(linea));}
  else if (OneSocket != NULL) 
    {    
    res = OneSocket->Puts (linea);
    }
  else {res = fprintf (fout, linea); fflush (fout);}
  va_end (args);
  return res;      
  }  

int HTMLBasic::pcWRITE (const char *pc)
  {
  int res = -1;
  if (iout != -1) {res = write (iout, (char *)pc, strlen(pc));}
  else if (OneSocket != NULL) 
    {
    res = OneSocket->Puts (pc);
    }
  else {res = fprintf (fout, pc); fflush (fout);}
  return res;
  }  
  
int HTMLBasic::pcWRITEBuffer (const char *pc, xulong len)
  {
  int res = -1;
  if (pc == NULL) {LOG("Null in pcWRITEBuffer"); return -1;}
  if (iout != -1) {res = write (iout, (char *)pc, (uint)len);}
  else if (OneSocket != NULL) 
    {
    res = OneSocket->Write (pc, (uint)len);    
    }
  else {res = write (fileno(fout), (char *)pc, (uint)len); fflush (fout);}
  return res;
  }    
  
void HTMLBasic::printCookie (const char *cookieline)
  {
  if ((cookieline != NULL) && (strcmp(cookieline, "") != 0)) 
    {
    WRITE ("Set-Cookie: %s\n", cookieline);
    }
  }   
  
void HTMLBasic::Head (const char *contenttype, const char *name, const char *filename)
  {
  if ((name     != NULL) && (strcmp(name, "")     != 0)) {WRITE ("Name: %s\n", name);}
  if ((filename != NULL) && (strcmp(filename, "") != 0)) {WRITE ("Filename: %s\n", filename);}
  WRITE ("Content-type: %s\n", contenttype);  
  //WRITE ("Content-type: %s; charset=%s\n", contenttype, THECHARSET);
  WRITE ("\n");
  } 
  
void HTMLBasic::HeadInline (const char *contenttype, const char *filename, xulong len)
  {        
  if ((strcmp (filename, "") != 0) && (filename != NULL) && (len > 0))
    {
    WRITE ("Content-Disposition: inline; filename=%s\n", filename);
    WRITE ("Content-Length: %ld\n", len);
    }
  WRITE ("Content-type: %s\n", contenttype);  
  WRITE ("\n");
  }   

void HTMLBasic::EmulatePageNotFound (void)
  {
  //WRITE ("HTTP/1.0 404 Not Found\n");
  WRITE ("Connection: close\n");
  WRITE ("Status: 404 Not Found\n");
  WRITE ("Content-type: text/html\n");
  WRITE ("\n");
  WRITE ("%s\n", HTML_DOCTYPE);
  WRITE ("<HTML><HEAD>\n");
  WRITE ("<TITLE>404 Not Found</TITLE>\n");
  WRITE ("</HEAD><BODY>\n"); 
  WRITE ("<H1>Not Found</H1>\n");
  WRITE ("The requested URL was not found on this server.<P>\n");
  WRITE ("</BODY></HTML>\n");  
  }
  
void HTMLBasic::HTMLBegin (void)
  {
  WRITE ("%s\n<HTML>\n", HTML_DOCTYPE);
  }  
  
void HTMLBasic::Title (const char *title, const char *bgcolor, const char *txtcolor, const char *img_bg, bool include_js, int refresh_time, const char *newurl)
  {
  WRITE ("<HEAD>\n");
  WRITE ("<LINK REL=\"stylesheet\" HREF=\"%s\" type=\"text/css\">\n", skin->getCSSPage());
  WRITE ("<TITLE>%s</TITLE>\n", title);
  if (include_js == true)
    {
    //Here we can put JavaScripts
    }
       
  if ((refresh_time > 0) && (newurl != NULL))
    {
    //Time arrives in minutes and transform to seconds
    //DEBUG WRITE ("<META HTTP-EQUIV=\"refresh\" CONTENT=\"%d;URL=%s\">\n", refresh_time, newurl);  
    WRITE ("<META HTTP-EQUIV=\"refresh\" CONTENT=\"%d;URL=%s\">\n", refresh_time * 60, newurl);
    }
  
  WRITE ("</HEAD>\n");
  if (!IsEmpty(img_bg))
    {
    WRITE ("<BODY background=\"%s\" text=\"%s\" bgcolor=\"%s\" link=\"#3333CC\" vlink=\"#3333CC\" alink=\"#3333CC\" %s>\n", 
           img_bg, txtcolor, bgcolor, skin->getSkinAtribProp("BODYMARGINS"));            
    }
  else
    {
    WRITE ("<BODY text=\"%s\" bgcolor=\"%s\" link=\"#3333CC\" vlink=\"#3333CC\" alink=\"#3333CC\" %s>\n", 
            txtcolor, bgcolor, skin->getSkinAtribProp("BODYMARGINS"));            
    }
  
  /*PRINT THE BEGIN OF DECORATION TABLE*/
  for (int n = 0; n < skin->beginDecorationTable->Count(); ++n)
    {                         
    WRITE ("%s", skin->beginDecorationTable->getString(n).cstr());
    } 

  }  
  
void HTMLBasic::HTMLEnd (const char *bgtablecopyrightcolor)
  {
  WRITE ("<BR>\n");
  BeginTable (0, 2, 1, 100);
  if (bgtablecopyrightcolor == NULL) {WRITE ("<TR bgcolor=\"%s\">", DEFCOLOR_BGTABLECOPYRIGHT);}
  else {WRITE ("<TR bgcolor=\"%s\">", bgtablecopyrightcolor);}
  WRITE ("<TD align=\"center\" colspan=\"7\">\n");
  BeginFont (skin->getSkinAtribProp("FONT_TABLECOPYRIGHT"), skin->getSkinAtribPropI("FONT_TABLECOPYRIGHT_SIZE"), skin->getSkinAtribProp("COLOR_FONT_TABLECOPYRIGHT"));
  WRITE (L->get (L_COPYRIGHT)); EndTD();
  EndFont();
  EndTR();
  EndTable();

  /*PRINT THE END OF DECORATION TABLE*/
  for (int n = 0; n < skin->endDecorationTable->Count(); ++n)
    {
    WRITE ("%s", skin->endDecorationTable->getString(n).cstr());
    } 

  if (SHOW_VALIDATE_HTML_URL == 1) {WRITE ("<BR><A HREF=\"http://www.htmlhelp.com/cgi-bin/validate.cgi?url=referer&amp;input=yes\">Validate HTML code</A>\n");}
  WRITE ("</BODY>\n");
  WRITE ("</HTML>\n"); 
  }                  
  
void HTMLBasic::BR (void)
  {
  WRITE ("<BR>\n");
  }                    

void HTMLBasic::JavaScript (const char *codigo)
  {
  WRITE ("\n<SCRIPT LANGUAGE=\"JavaScript\" TYPE=\"text/javascript\">\n");
  WRITE ("<!--\n");
  WRITE ("%s", codigo);
  WRITE ("\n// -->\n");
  WRITE ("</SCRIPT>\n");
  }

void HTMLBasic::Small (const char *linea)
  {
  WRITE ("<SMALL>%s</SMALL>\n", linea);
  }

void HTMLBasic::Rectangle (const char *linea)
  {
  WRITE ("<TABLE BORDER=1><TR><TD>\n", linea);
  WRITE ("%s\n", linea);
  WRITE ("</TD></TR></TABLE>\n");
  }

void HTMLBasic::RedRectangle (const char *linea)
  {
  WRITE ("<TABLE BORDER=1><TR><TD>\n", linea);
  WRITE ("<FONT color=\"#FF0000\"><B>%s</B></FONT>\n", linea);
  WRITE ("</TD></TR></TABLE>\n");
  }      

void HTMLBasic::H1 (const char *linea)
  {
  WRITE ("<H1>%s</H1>\n", linea);
  }
  
void HTMLBasic::H2 (const char *linea)
  {
  WRITE ("<H2>%s</H2>\n", linea);
  }

void HTMLBasic::H3 (const char *linea)
  {
  WRITE ("<H3>%s</H3>\n", linea);
  }  
  
void HTMLBasic::H4 (const char *linea)
  {
  WRITE ("<H4>%s</H4>\n", linea);
  }

void HTMLBasic::H5 (const char *linea)
  {
  WRITE ("<H5>%s</H5>\n", linea);
  }  
  
void HTMLBasic::BeginTable (int border, int cellpadding, int cellspacing, int widthpercent)
  {
  WRITE ("<TABLE cellpadding=\"%d\" cellspacing=\"%d\" width=\"%d%%\" BORDER=\"%d\">\n", cellpadding, cellspacing, widthpercent, border);
  }

void HTMLBasic::EndTable (void)
  {
  WRITE ("</TABLE>\n");
  }

void HTMLBasic::BeginTR (void)
  {
  WRITE ("<TR>\n");
  }

void HTMLBasic::BeginTR (const char *bgcolor)
  {
  WRITE ("<TR bgcolor=\"%s\">\n", bgcolor);
  }

void HTMLBasic::EndTR (void)
  {
  WRITE ("</TR>\n");
  }

void HTMLBasic::BeginTD (void)
  {
  WRITE ("<TD>\n");
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }
  
void HTMLBasic::BeginTDColSpan (int acolspan)
  {
  WRITE ("<TD colspan=\"%d\">\n", acolspan);
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }
  
void HTMLBasic::BeginTDColSpanCenter (int acolspan)
  {
  WRITE ("<TD align=\"center\" colspan=\"%d\">\n", acolspan);
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }  
  
void HTMLBasic::BeginTDCenter (void)
  {
  WRITE ("<TD align=\"center\">\n");
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }
  
void HTMLBasic::BeginTD (const char *bgcolor)
  {
  WRITE ("<TD bgcolor=\"%s\">\n", bgcolor);
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }      

void HTMLBasic::BeginTD (const char *bgcolor, const char *align)
  {
  WRITE ("<TD bgcolor=\"%s\" align=\"%s\">\n", bgcolor, align);
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }

void HTMLBasic::BeginTD (const char *bgcolor, const char *align, int colspan)
  {
  WRITE ("<TD bgcolor=\"%s\" align=\"%s\" colspan=\"%d\">\n", bgcolor, align, colspan);
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }

void HTMLBasic::BeginTD (const char *bgcolor, int widthpercent)
  {
  WRITE ("<TD bgcolor=\"%s\" width=\"%d%%\">\n", bgcolor, widthpercent);    
  WRITE ("<FONT size=\"2\" face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }

void HTMLBasic::BeginTD (int widthpercent)
  {
  WRITE ("<TD width=\"%d%%\">\n", widthpercent);    
  WRITE ("<FONT size=\"2\" face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  }
  
void HTMLBasic::BeginTD (bool nowrap, int widthpercent, int rowspan, const char *facefont, int sizefont, const char *align)
  {
  if (nowrap == true)
    {
    WRITE ("<TD nowrap width=\"%d%%\" rowspan=\"%d\" align=\"%s\">\n", widthpercent, rowspan, align);
    }
  else
    {
    WRITE ("<TD width=\"%d%%\" rowspan=\"%d\" align=\"%s\">\n", widthpercent, rowspan, align);    
    }
  WRITE ("<FONT size=\"%d\" face=\"%s\" color=\"%s\">\n", sizefont, facefont, BLACK);
  }

void HTMLBasic::BeginTD (int widthpercent, const char *facefont, int sizefont, const char *align)
  {
  WRITE ("<TD width=\"%d%%\" align=\"%s\">\n", widthpercent, align);      
  WRITE ("<FONT size=\"%d\" face=\"%s\" color=\"%s\">\n", sizefont, facefont, BLACK);
  }

void HTMLBasic::EndTD (void)
  {
  WRITE ("</FONT></TD>\n");
  }

void HTMLBasic::EmptyCellx1 (void)
  {
  BeginTD (); WRITE(HTML_HSP); EndTD();
  }
  
void HTMLBasic::EmptyCellx2 (void)
  {
  BeginTD (); WRITE(HTML_HSP); EndTD();
  BeginTD (); WRITE(HTML_HSP); EndTD();
  }                

void HTMLBasic::BeginBold (void)
  {
  WRITE ("<B>\n");
  }

void HTMLBasic::EndBold (void)
  {
  WRITE ("</B>\n");
  }

void HTMLBasic::BeginItalic (void)
  {
  WRITE ("<I>\n");
  }

void HTMLBasic::EndItalic (void)
  {
  WRITE ("</I>\n");
  }
void HTMLBasic::BeginUnderline (void)
  {
  WRITE ("<U>\n");
  }

void HTMLBasic::EndUnderline (void)
  {
  WRITE ("</U>\n");
  }

void HTMLBasic::BeginFont (const char *face, int size, const char *color)
  {
  WRITE ("<FONT size=\"%d\" face=\"%s\" color=\"%s\">\n", size, face, color);
  }
  
void HTMLBasic::EndFont (void)
  {
  WRITE ("</FONT>\n");
  }        

void HTMLBasic::Text (const char *linea)
  {
  WRITE ("%s\n", linea);
  }  

void HTMLBasic::Label (const char *linea)
  {
  WRITE ("<B>%s</B>\n", linea);
  }  

void HTMLBasic::RedLabel (const char *linea)
  {
  WRITE ("<FONT color=\"#FF0000\"><B>%s</B></FONT>\n", linea);
  }

void HTMLBasic::GreenLabel (const char *linea)
  {
  WRITE ("<FONT color=%s><B>%s</B></FONT>\n", GREEN, linea);
  }

void HTMLBasic::Image (const char *urlimage, const char *label, const char *size)
  {
  if (!IsEmpty(size))
    {
    //Size must be some like " WIDTH=32 HEIGHT=32 "
    WRITE ("<IMG BORDER=0 SRC=\"%s\" ALT=\"%s\" %s>\n", urlimage, label, size);
    }
  else
    {  
    WRITE ("<IMG BORDER=0 SRC=\"%s\" ALT=\"%s\">\n", urlimage, label);
    }
  }
  
void HTMLBasic::URL (const char *caption, const char *url)
  {
  WRITE ("<A HREF=\"%s\">%s</A>\n", url, caption);
  }  
                            
void HTMLBasic::URLIMAGE (const char *label, const char *url, const char *urlimage)
  {
  WRITE ("<A HREF=\"%s\"><IMG BORDER=0 SRC=\"%s\" ALT=\"%s\"></A>\n", url, urlimage, label);
  }    

void HTMLBasic::BeginPre ()
  {
  WRITE ("<PRE>\n");
  }
  
void HTMLBasic::EndPre ()
  {
  WRITE ("</PRE>\n");
  }
   
void HTMLBasic::BeginCenter ()
  {
  WRITE ("<CENTER>\n");
  }
 
void HTMLBasic::EndCenter ()
  {
  WRITE ("</CENTER>\n");
  } 

void HTMLBasic::PrintString (const char *linea)
  {
  WRITE ("%s<BR>\n", linea);
  }
  
void HTMLBasic::pr (const char *linea)
  {
  WRITE ("%s\n", linea);
  }
        
void HTMLBasic::Redirect (const char *newurl)
  {
  WRITE ("Status: 302 Moved\n");
  WRITE ("Location: %s\n", newurl);
  WRITE ("Content-Type: text/html\n\n");
  }  
  
void HTMLBasic::BeginNOBR (void)
  {
  WRITE ("<NOBR>\n");
  }
  
void HTMLBasic::EndNOBR(void)
  {
  WRITE ("</NOBR>\n");
  }        
  
void HTMLBasic::Linea ()
  {
  WRITE ("<HR noshade size=2>\n");
  }
  
void HTMLBasic::Error (const char *error)
  {
  WRITE ("<p><h1><FONT color=\"#FF0000\">Error:</font> %s</h1><p>\n", error);
  } 

void HTMLBasic::Msg (const char *msg)
  {
  WRITE ("<p><h1>%s</h1><p>\n", msg);
  } 
 
void HTMLBasic::ErrorPage (const char *error)
  {                    
  Head ("text/html", "", "");  
  HTMLBegin ();  
  Title (error, WHITE, BLACK, NULL, false, 0, NULL);
  WRITE ("<p><h2><FONT color=\"%s\">Error:</font> %s</h2><p>\n", RED, error);
  HTMLEnd(NULL);      
  } 

void HTMLBasic::MsgPage (const char *msg, const char *lang)
  {                       
  Head ("text/html", "", "");  
  HTMLBegin ();  
  Title (msg, WHITE, BLACK, NULL, false, 0, NULL);
  WRITE ("<p><h1><FONT color=%s>%s</font></h1><p>\n", GREEN, msg);
  WRITE ("<p><A HREF=\"%s/%s?lang=%s\">%s</A>", PATH_CGI, SERVICE_MAIN, lang, L->get(MSG_CANRECONNECTHERE));
  HTMLEnd(NULL); 
  } 

void HTMLBasic::ErrorPageServicePwInvalid (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {                    
  Head ("text/html", "", "");  
  HTMLBegin ();  
  Title (L->get(L_SERVICEPW_INCORRECT), WHITE, BLACK, NULL, false, 0, NULL);
  WRITE ("<p><h2><FONT color=\"%s\">Error:</font> %s</h2><p>\n", RED, L->get(L_SERVICEPW_INCORRECT));
  WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/\">%s</A>\n", PATH_CGI, SERVICE_MAIN, stlang, user, connid, uo->getValidator(), 
          uo->getPageId(), uo->getLastCmd(), L->get(L_ROOT));
  WRITE ("<p><A HREF=\"%s/%s?lang=%s\">%s</A>\n", PATH_CGI, SERVICE_MAIN, stlang, L->get(MSG_CANRECONNECTHERE));
  HTMLEnd(NULL);      
  }     

void HTMLBasic::Ok (const char *linea)
  {
  WRITE ("<p><h1><FONT color=%s>%s</font></h1><p>\n", GREEN, linea);
  } 
            
void HTMLBasic::BeginFormPost (const char *name, const char *action)
  {
  WRITE ("<FORM NAME=\"%s\" ACTION=\"%s\" METHOD=\"POST\">\n", name, action);
  } 
  
void HTMLBasic::BeginFormPostMultipartFormData (const char *name, const char *action)
  {
  WRITE ("<FORM NAME=\"%s\" ACTION=\"%s\" METHOD=\"POST\" ENCTYPE=\"multipart/form-data\">\n", name, action);
  }                          
                             
void HTMLBasic::BeginFormGet (const char *name, const char *action)
  {
  WRITE ("<FORM NAME=\"%s\" ACTION=\"%s\" METHOD=\"GET\">\n", name, action);
  }   
  
void HTMLBasic::EndForm ()
  {
  WRITE ("</FORM>\n");
  }   
    
void HTMLBasic::FormBeginSelect (const char *formname, const char *selectname, const char *submitbutton, bool use_javascript)
  {
  if ((submitbutton == NULL) || (use_javascript == false))
    {
    WRITE ("<SELECT SIZE=1 NAME=\"%s\">\n", selectname);
    }
  else
    {
    WRITE ("<SELECT SIZE=1 NAME=\"%s\" onChange=\"%s.%s.click()\">\n", selectname, formname, submitbutton);
    }
  }                                  
  
void HTMLBasic::FormBeginMultipleSelect (const char *formname, const char *selectname, const char *submitbutton, bool use_javascript)
  {
  if ((submitbutton == NULL) || (use_javascript == false))
    {
    WRITE ("<SELECT MULTIPLE SIZE=10 NAME=\"%s\">\n", selectname);
    }
  else
    {      
    WRITE ("<SELECT MULTIPLE SIZE=10 NAME=\"%s\" onChange=\"%s.%s.click()\">\n", selectname, formname, submitbutton);
    }
  } 

void HTMLBasic::FormAddOptionSelect (bool selected, const char *value, const char *label)
  {
  if (selected == true) 
    {
    if (strcmp (value, FORM_SELECT_SEPARATOR) == 0)
      {WRITE ("<OPTION selected DISABLED VALUE=\"%s\">%s\n", FORM_SELECT_SEPARATOR, FORM_SELECT_SEPARATOR);}
    else               
      {WRITE ("<OPTION selected VALUE=\"%s\">%s\n", value, label);}
    }
  else
    {
    if (strcmp (value, FORM_SELECT_SEPARATOR) == 0)
      {WRITE ("<OPTION DISABLED VALUE=\"%s\">%s\n", FORM_SELECT_SEPARATOR, FORM_SELECT_SEPARATOR);}
    else
      {WRITE ("<OPTION VALUE=\"%s\">%s\n", value, label);}
    }
  }

void HTMLBasic::FormEndSelect ()
  {
  WRITE ("</SELECT>\n");
  }                                       

void HTMLBasic::FormHiddenQuoted (const char *name, const char *value)
  {
  WRITE ("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s%s%s\">\n", name, HTML_DCOMILLAS, value, HTML_DCOMILLAS);
  }
   
void HTMLBasic::FormHidden (const char *name, const char *value)
  {
  WRITE ("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%s\">\n", name, value);
  } 

void HTMLBasic::FormHidden (const char *name, int value)
  {
  WRITE ("<INPUT TYPE=HIDDEN NAME=\"%s\" VALUE=\"%d\">\n", name, value);
  } 

void HTMLBasic::FormEdit (int max, int size, const char *name, const char *value)
  {
  WRITE ("<INPUT TYPE=TEXT NAME=\"%s\" MAXLENGTH=\"%d\" SIZE=\"%d\" VALUE=\"%s\">\n", 
           name, max, size, value ? value : "");
  //If value is not NULL, print value, else print ""
  }  

void HTMLBasic::FormFile (int max, int size, const char *name, const char *value, const char *accept)
  {
  WRITE ("<INPUT TYPE=FILE NAME=\"%s\" MAXLENGTH=\"%d\" SIZE=\"%d\" VALUE=\"%s\" ACCEPT=\"%s\">\n", 
           name, max, size, value, accept);
  }

void HTMLBasic::FormTextArea (int rows, int cols, const char *name, const char *value, bool readonly)
  {
  if (readonly == true)
    {
    WRITE ("<TEXTAREA READONLY NAME=\"%s\" ROWS=\"%d\" COLS=\"%d\" WRAP=\"HARD\">\n", name, rows, cols);
    }
  else
    {
    WRITE ("<TEXTAREA NAME=\"%s\" ROWS=\"%d\" COLS=\"%d\" WRAP=\"HARD\">\n", name, rows, cols);
    }  
  pcWRITEBuffer (value, strlen (value));
  WRITE ("</TEXTAREA>\n");
  }  
   
void HTMLBasic::FormPassword (int max, int size, const char *name, const char *value)
  {
  WRITE ("<INPUT TYPE=PASSWORD NAME=\"%s\" MAXLENGTH=\"%d\" SIZE=\"%d\" VALUE=\"%s\">\n", 
           name, max, size, value);
  }  
  
void HTMLBasic::FormCheckbox (const char *name, const char *value, bool checked)
  {
  if (checked == true)
    WRITE ("<INPUT TYPE=\"CHECKBOX\" NAME=\"%s\" VALUE=\"%s\" CHECKED>\n", name, value);
  else
    WRITE ("<INPUT TYPE=\"CHECKBOX\" NAME=\"%s\" VALUE=\"%s\">\n", name, value);    
  }      
  
void HTMLBasic::JSFormCheckbox (const char *name, const char *value, const char *onclick, bool checked)
  {
  if (checked == true)
    WRITE ("<INPUT TYPE=\"CHECKBOX\" NAME=\"%s\" onClick=\"%s\" VALUE=\"%s\" CHECKED>\n", name, onclick, value);
  else
    WRITE ("<INPUT TYPE=\"CHECKBOX\" NAME=\"%s\" onClick=\"%s\" VALUE=\"%s\">\n", name, onclick, value);    
  }    
  
void HTMLBasic::FormImage (const char *name, const char *src)
  {
  WRITE ("<INPUT TYPE=IMAGE NAME=\"%s\" SRC=\"%s\">\n", name, src);
  }  
  
void HTMLBasic::FormButton (const char *name, const char *value)
  {
  WRITE ("<INPUT TYPE=SUBMIT NAME=\"%s\" VALUE=\"%s\">\n", name, value);
  }  
     
void HTMLBasic::FormButton (const char *name, const char *value, const char *onclick)
  {
  WRITE ("<INPUT TYPE=SUBMIT NAME=\"%s\" VALUE=\"%s\" onClick=\"%s\">\n", name, value, onclick);
  }  
   
void HTMLBasic::FormReset (const char *value)
  {
  WRITE ("<INPUT TYPE=RESET VALUE=\"%s\">\n", value);
  }
  
void HTMLBasic::soErrorPage (const char *error)
  {                    
  fprintf (stdout, "Content-type: text/html\n\n");     
  fprintf (stdout, "<p><h1><FONT color=\"#FF0000\">Error:</font> %s</h1><p>\n", error);
  }  

void HTMLBasic::dumpSL (StringList *SL, bool PutNewLines)
  {
  Head ("text/plain", "", "");
  for (int i=0; i< SL->Count(); ++i)
    {
    if (PutNewLines == false)
      {
      WRITE (SL->getString(i).cstr());
      }
    else
      {
      WRITE ("%s\n", SL->getString(i).cstr());
      }
    }
  }

void HTMLBasic::dumpPChar (const char *pc)
  {
  Head ("text/plain", "", "");
  if (pc == NULL) pcWRITE ("NULL"); 
  else pcWRITE (pc);
  }                  

void HTMLBasic::PrintBadCookiePage (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_BADCOOKIE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  WRITE ("<CENTER>\n");
  Image (skin->getI(L_SECURITYPROBLEM), L->get(L_SECURITYPROBLEM), skin->getISize());
  WRITE ("</CENTER>\n");  
  WRITE ("<CENTER>\n");
  RedLabel (L->get(MSG_BADCOOKIE)); BR();
  WRITE ("</CENTER>\n");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }                    

void HTMLBasic::PrintInvalidCommand (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_INVALIDCOMMAND), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  RedLabel (L->get(MSG_INVALIDCOMMAND)); BR();
  WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, stlang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
  Image (skin->getI(L_BACK), L->get(L_BACK), skin->getISize());
  WRITE ("</A>");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }          
          
void HTMLBasic::PrintInvalidPage (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_INVALIDPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  RedLabel (L->get(MSG_INVALIDPAGE)); BR();
  WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, stlang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
  Image (skin->getI(L_BACK), L->get(L_BACK), skin->getISize());  
  WRITE ("</A>");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
          
void HTMLBasic::PrintConfirmPage (int service, const char *stcmd, const char *stlang, const char *tokentodelete, 
                                  const char *user, const char *connid, int validator, int pageid, UserOptions *uo)
  {
  int cmd, lastservice;
  TBuffer abuff;  
  lastservice = uo->getLastService();
  cmd = TranslateCmd (lastservice, stcmd);
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CONFIRMACTION), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  Linea ();
  BeginCenter(); 
  switch (cmd)
    {
    case CMD_CCLIENT_MB_DELETE: 
                        {
                        snprintf (abuff, CMAXBUFFER, L->get(MSG_CONF_DELETEMAILBOX), tokentodelete); 
                        RedLabel (abuff); 
                        break;
                        }
    case CMD_CCLIENT_MB_EXPUNGE: 
                        {
                        RedLabel (L->get(MSG_CONF_EXPUNGE));
                        break;
                        }
    case CMD_DATABASES_DB_EXPUNGE:
                        {
                        RedLabel (L->get(MSG_CONF_DBEXPUNGE));
                        break;
                        }                        
    case CMD_DATABASES_DB_DELETE:
                        {
                        RedLabel (L->get(MSG_CONF_DBDELETE)); 
                        break;
                        }                                                
    case CMD_SIEVE_FILTERS_DELETE:
                        {
                        RedLabel (L->get(MSG_CONF_FILTERSDELETE)); 
                        break;
                        }                                                                        
    case CMD_MAIN_LOGOUT:     
                        {
                        RedLabel (L->get(MSG_CONF_LOGOUT)); 
                        break;
                        }
    }
  EndCenter ();
  BeginCenter();
  BeginFormPost ("PrintConfirmPage1", PATH_CGI);
  if (cmd == CMD_MAIN_LOGOUT) FormHidden ("service", SERVICE_MAIN); else {FormHidden ("service", TranslateServiceR(lastservice));}
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", stcmd);
  FormHidden ("subcmd", "noop");
  FormHidden ("validator", validator);
  FormHidden ("pageid", pageid);
  FormHidden ("lastcmd", CMD_MAIN_CONF_ACT);
  if (cmd == CMD_CCLIENT_MB_DELETE) {FormHiddenQuoted ("mailboxname", tokentodelete);}  
  else if (cmd == CMD_DATABASES_DB_DELETE) {FormHiddenQuoted ("db_delete_name", tokentodelete);}
  else if (cmd == CMD_SIEVE_FILTERS_DELETE) {FormHiddenQuoted ("filters_to_delete", tokentodelete);}  
  FormButton ("theaction", L->get(L_CONFIRM));    
  EndForm ();  
  EndCenter ();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
   
void HTMLBasic::OkPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (okmsg, skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  WRITE ("<BR><FONT color=%s size=5><B>%s</B></FONT><BR><BR>\n", GREEN, okmsg);
  WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, uo->getValidator(),
         uo->getPageId(), CMD_CCLIENT_MB_INDEX, uo->getCurrentPosition());
  Image (skin->getI(L_INDEXMAILBOX), L->get(L_INDEXMAILBOX2), "");
  Label (L->get(L_PRESS_TO_INDEX));
  WRITE ("</A>");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }  
  
void HTMLBasic::OkPageTitle (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg, const char *title)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (title, skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  WRITE ("<BR><FONT color=%s size=5><B>%s</B></FONT><BR><BR>\n", GREEN, okmsg);
  WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, uo->getValidator(),
         uo->getPageId(), CMD_CCLIENT_MB_INDEX, uo->getCurrentPosition());
  Image (skin->getI(L_INDEXMAILBOX), L->get(L_INDEXMAILBOX2), "");
  Label (L->get(L_PRESS_TO_INDEX));
  WRITE ("</A>");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }    
  
void HTMLBasic::OkPage_ReturnToBack (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *okmsg)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (okmsg, skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  WRITE ("<BR><FONT color=%s size=5><B>%s</B></FONT><BR><BR>\n", GREEN, okmsg);
  WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, stlang, user, 
           connid, uo->getValidator(), uo->getPageId(), CMD_MAIN_ROOT, uo->getCurrentPosition());
  Image (skin->getI(L_INDEXMAILBOX), L->get(L_BACK), ""); 
  Label (L->get(L_PRESS_TO_ROOTPAGE));
  WRITE ("</A>");
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }  
  
void HTMLBasic::dumpFile (TBuffer fn, TBuffer ContentType)
  {
  int fd, sz, len;
  TBuffer abuf;
  
  len = FileSize (fn);
  HeadInline (ContentType, fn, len);
  fd = open (fn, O_RDONLY);
  sz = read (fd, abuf, CMAXBUFFER);
  while (sz > 0)
    {  
    pcWRITEBuffer (abuf, sz);  
    sz = read (fd, abuf, CMAXBUFFER);
    }
  close (fd);
  }        

void HTMLBasic::PrintHelpPage (int service, const char *stcmd, const char *user)
  {
  TBuffer abuf;
  //sprintf (abuf, "/"APPNAME"/help/%.10s_%.50s_%.10s.html", TranslateServiceR (service), stcmd, L->getStLang());
  //Redirect(abuf);
  
  FILE *fh;
  sprintf (abuf, "%s/help/%.10s_%.50s_%.10s.html", HTDOCDIR, TranslateServiceR (service), stcmd, L->getStLang());
  //DEBUG ("--%s--", abuf);
  if (FileExists (abuf) == false) {sprintf (abuf, "%s/help/not_yet.html", HTDOCDIR);}
  fh = fdopen(OneSocket->getSock(), "a");
  DumpHTMLPage (abuf, user, fh);
  }
  
void HTMLBasic::PrintStatusLine (const char *user, UserOptions *uo, bool displayClock)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT size=2 color=\"%s\">%s: %s@%s</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer());
    }
  else
    {
    WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s</FONT></B></TD>\n",
           uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
           L->get(L_USER), user, uo->getImapServer()); 
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");  
  }  

void HTMLBasic::BotoneraTop (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  int validator, pageid;
  
  validator = uo->getValidator();
  pageid    = uo->getPageId();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

      /*I do not put the back button: is the same that Root Button
      //BUTTON BACK       
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      //WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());  
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();   
      */

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   
      
      //SPACE 
      EmptyCellx2();
            
      /*
      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_CCLIENT_MB_SHOW: WRITE ("<A HREF=\"%s/%s/help/mb_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CM: WRITE ("<A HREF=\"%s/%s/help/cm/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_OP: WRITE ("<A HREF=\"%s/%s/help/op/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_AB: case CMD_AB_SHOWALL: case CMD_AB_SORT: case CMD_AB_FROM_CM:
        case CMD_AB_ADDFIELDS:
          WRITE ("<A HREF=\"%s/%s/help/ab/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_AB_NEWENTRY:  WRITE ("<A HREF=\"%s/%s/help/ab_newentry/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_AB_EDITENTRY: WRITE ("<A HREF=\"%s/%s/help/ab_editentry/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());        
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      */
      
      //SPACE
      EmptyCellx2();      
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); 
    EndTR();
  EndTable ();  
  PrintStatusLine (user, uo, true);
  }

void HTMLBasic::BotoneraHomePage (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  int validator, pageid;
  
  validator = uo->getValidator();
  pageid    = uo->getPageId();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

      //BUTTON HELP      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/help/root/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();   

      //SPACE
      EmptyCellx2();      
      //BUTTON ABOUT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/about/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ABOUT), L->get(ALT_ABOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ABOUT));}
      WRITE ("</A>");
      EndTD();   
      
      //SPACE
      EmptyCellx2();      
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); 
      
      if (L->getLang() != LANG_SPANISH)
        {
        //SPACE     
        EmptyCellx2();            
        //BUTTON CHANGE LANGUAGE TO SPANISH
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "right");
        WRITE ("<A HREF=\"%s/%s/root/noop/spa/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, user, connid, uo->getValidator(),
           uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
        Image (skin->getI(LANG_SPANISH), L->getDescriptionLanguage(LANG_SPANISH), "");
        WRITE ("</A>");
        EndTD();    
        }
               
      if (L->getLang() != LANG_CATALA)
        {
        //SPACE
        EmptyCellx2();            
        //BUTTON CHANGE LANGUAGE TO VALENCIA
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "right");
        WRITE ("<A HREF=\"%s/%s/root/noop/val/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, user, connid, uo->getValidator(),
          uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());      
        Image (skin->getI(LANG_CATALA), L->getDescriptionLanguage(LANG_CATALA), "");
        WRITE ("</A>");      
        EndTD();      
        }
      
      if (L->getLang() != LANG_ENGLISH)
        {
        //SPACE
        EmptyCellx2();      
        //BUTTON CHANGE LANGUAGE TO ENGLISH
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "right");
        WRITE ("<A HREF=\"%s/%s/root/noop/eng/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, user, connid, uo->getValidator(),
           uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
        Image (skin->getI(LANG_ENGLISH), L->getDescriptionLanguage(LANG_ENGLISH), "");
        WRITE ("</A>");
        EndTD();    
        }
        
    EndTR();
  EndTable ();  
  PrintStatusLine (user, uo, true);
  }
  
  
  
                                         
