/*
Codecs.cc
*/

#include "Utils.h"
#include "Codecs.h"

/* For converting 6 bits of data to an 8-bit printable character */
static xuchar encode[64] = {'A', 'B', 'C', 'D', 'E', 'F', 'G',
'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6',
'7', '8', '9', '+', '/'};

/* For converting an 8-bit printable character to 6 bits of data */
static xuchar decode[256] = {
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP,
NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP, NOP};

int EncodeBase64Buffer (TBuffer abufin, int sz_abufin, TBuffer abufout, int *sz_abufout)
  {
  xuint a, b, c;
  int leidos = 0, escritos = 0;

  while (leidos < sz_abufin)
    { 
    a = abufin[leidos];
    if (leidos < sz_abufin) //while (leidos < sz_abufin)
      {
      ++leidos;
      b = abufin[leidos];
      if (leidos < sz_abufin)
        {
        ++leidos;
        c = abufin[leidos];
        if (leidos < sz_abufin)
          {
          ++leidos;
          /* Encode three bytes */
          abufout[escritos] = encode[                  (a >> 2)]; ++escritos;
          abufout[escritos] = encode[((a & 3) << 4)  + (b >> 4)]; ++escritos;
          abufout[escritos] = encode[((b & 15) << 2) + (c >> 6)]; ++escritos;
          abufout[escritos] = encode[((c & 63))];                 ++escritos;
          }
        else
          {
          /* Encode last two bytes */
          abufout[escritos] = encode[                  (a >> 2)]; ++escritos;
          abufout[escritos] = encode[((a & 3) << 4)  + (b >> 4)]; ++escritos;
          abufout[escritos] = encode[((b & 15) << 2)           ]; ++escritos;
          abufout[escritos] = '=';                                ++escritos;          
          break;
          }
        }
      else
        {
        /* Encode last byte */
        abufout[escritos] = encode[                  (a >> 2)]; ++escritos;
        abufout[escritos] = encode[((a & 3) << 4)            ]; ++escritos;
        abufout[escritos] = '=';                                ++escritos;
        abufout[escritos] = '=';                                ++escritos;
        break;
        }         
      }
    }
  abufout[escritos] = '\0';   
  *sz_abufout = escritos;   
  return ERROR_NONE;
  }

/* rfc1421encode: Converts standard input containing arbitrary,
 * unsigned bytes into printable characters and writes them
 * to standard output.  A carriage-return/line-feed pair is
 * inserted after every 4 * LINE printed characters. */
// CODIFICA size DEL FICHERO FR Y LO VUELCA A stdout
int EncodeBase64(FILE *FR, int size)
  {
  xuint a, b, c;
  int i, leidos = 0;

  i = 0;
  while (leidos < size)
    {  
    while ((xsint)(a = getc(FR)) != EOF)
    {
      ++leidos;
      if ((xsint)(b = getc(FR)) != EOF)
      {
        ++leidos;
        if ((xsint)(c = getc(FR)) != EOF)
        {
          ++leidos;
          /* Encode three bytes */
          putchar(encode[                  (a >> 2)]);
          putchar(encode[((a & 3) << 4)  + (b >> 4)]);
          putchar(encode[((b & 15) << 2) + (c >> 6)]);
          putchar(encode[((c & 63))]);
          if (++i == LINE)
          {
            putchar('\n');
            i = 0;
          }
        }
        else
        {
          /* Encode last two bytes */
          putchar(encode[                  (a >> 2)]);
          putchar(encode[((a & 3) << 4)  + (b >> 4)]);
          putchar(encode[((b & 15) << 2)           ]);
          putchar('=');
          i++;
          break;
        }
      }
      else
      {
        /* Encode last byte */
        putchar(encode[                  (a >> 2)]);
        putchar(encode[((a & 3) << 4)            ]);
        putchar('=');
        putchar('=');
        i++;
        break;
      }
    }
    if (i != 0) {
      putchar('\n');
    }
    }
  return ERROR_NONE;
}

//IDEM PERO ESCRIBO EN FICHERO QUE YA ESTA ABIERTO PARA ESCRIBIR
int EncodeBase64File (FILE *FR, FILE *FW, int size)
  {
  xuint a, b, c;
  int i, leidos = 0;

  i = 0;
  while (leidos < size)
    {  
    while ((xsint)(a = getc(FR)) != EOF)
    {
      ++leidos;
      if ((xsint)(b = getc(FR)) != EOF)
      {
        ++leidos;
        if ((xsint)(c = getc(FR)) != EOF)
        {
          ++leidos;
          /* Encode three bytes */
          fputc(encode[                  (a >> 2)], FW);
          fputc(encode[((a & 3) << 4)  + (b >> 4)], FW);
          fputc(encode[((b & 15) << 2) + (c >> 6)], FW);
          fputc(encode[((c & 63))], FW);
          if (++i == LINE)
          {
            fputc('\r', FW); fputc('\n', FW);
            i = 0;
          }
        }
        else
        {
          /* Encode last two bytes */
          fputc(encode[                  (a >> 2)], FW);
          fputc(encode[((a & 3) << 4)  + (b >> 4)], FW);
          fputc(encode[((b & 15) << 2)           ], FW);
          fputc('=', FW);
          i++;
          break;
        }
      }
      else
      {
        /* Encode last byte */
        fputc(encode[                  (a >> 2)], FW);
        fputc(encode[((a & 3) << 4)            ], FW);
        fputc('=', FW);
        fputc('=', FW);
        i++;
        break;
      }
    }
    if (i != 0) {
      fputc('\r', FW); fputc('\n', FW);
    }
    }
  return ERROR_NONE;
}

/* rfc1421decode: Converts standard input containing printable
 * characters into arbitrary, unsigned bytes and writes it to
 * standard output.  Characters of standard input that could not
 * come from standard output of rfc1421encode are ignored. */
// DECODIFICA size DEL FICHERO FR Y LO VUELCA A stdout
int DecodeBase64 (FILE *FR, int size)
  {
  xuint input;           /* Encoded input bytes */
  xuchar a = ' ', b = ' ', c = ' ', d = ' ';     /* Decoded 6-bit input value  */
  int failure = ERROR_NONE;     /* Assume success */
  int leidos = 0;

  if (decode['A'] == NOP) {

    /* We initialize decode in this routine rather than
     * statically because C does not provide a means for
     * statically initializing array elements if the order of
     * the array elements is not known by the programmer.  If we
     * were willing to assume that we were on an ASCII system,
     * we could use static initialization since the order of the
     * characters would then be known. */

    decode['A'] = 0;  decode['B'] = 1;  decode['C'] = 2;  decode['D'] = 3;
    decode['E'] = 4;  decode['F'] = 5;  decode['G'] = 6;  decode['H'] = 7;
    decode['I'] = 8;  decode['J'] = 9;  decode['K'] = 10; decode['L'] = 11;
    decode['M'] = 12; decode['N'] = 13; decode['O'] = 14; decode['P'] = 15;
    decode['Q'] = 16; decode['R'] = 17; decode['S'] = 18; decode['T'] = 19;
    decode['U'] = 20; decode['V'] = 21; decode['W'] = 22; decode['X'] = 23;
    decode['Y'] = 24; decode['Z'] = 25; decode['a'] = 26; decode['b'] = 27;
    decode['c'] = 28; decode['d'] = 29; decode['e'] = 30; decode['f'] = 31;
    decode['g'] = 32; decode['h'] = 33; decode['i'] = 34; decode['j'] = 35;
    decode['k'] = 36; decode['l'] = 37; decode['m'] = 38; decode['n'] = 39;
    decode['o'] = 40; decode['p'] = 41; decode['q'] = 42; decode['r'] = 43;
    decode['s'] = 44; decode['t'] = 45; decode['u'] = 46; decode['v'] = 47;
    decode['w'] = 48; decode['x'] = 49; decode['y'] = 50; decode['z'] = 51;
    decode['0'] = 52; decode['1'] = 53; decode['2'] = 54; decode['3'] = 55;
    decode['4'] = 56; decode['5'] = 57; decode['6'] = 58; decode['7'] = 59;
    decode['8'] = 60; decode['9'] = 61; decode['+'] = 62; decode['/'] = 63;
    /* '=' is a valid character even though it doesn't represent bits.  We'll assign it value EQUAL arbitrarily. */
    decode['='] = EQUAL;
  }

  while (leidos < size)
  {
    while ((xsint)(input = getc(FR)) != EOF && (a = decode[input]) == NOP);
    ++leidos;
    if ((xsint)input != EOF)
    {
      while ((xsint)(input = getc(FR)) != EOF && (b = decode[input]) == NOP);
      ++leidos;
      if ((xsint)input != EOF)
      {
        while ((xsint)(input = getc(FR)) != EOF && (c = decode[input]) == NOP);
        ++leidos;
        if ((xsint)input != EOF)
        {
          while ((xsint)(input = getc(FR)) != EOF && (d = decode[input]) == NOP);
          ++leidos;
          if ((xsint)input != EOF)
          {
            /* Got four significant characters */
            if (a == EQUAL || b == EQUAL || (c == EQUAL && d != EQUAL)) {
              /* If the byte quadruplet has equal signs there
               * must be one or two and they must be the last
               * characters of the quadruplet.*/
              failure = ERROR_EQUAL;
              break;
            }
            if (d != EQUAL)
            {
              /* No '=' padding present */
              putchar((a << 2) + (b >> 4));
              putchar(((b & 15) << 4) + (c >> 2));
              putchar(((c & 3) << 6) + d);
            }
            else if (c != EQUAL)
            {
              /* One '=' padding character present */
              putchar((a << 2) + (b >> 4));
              putchar(((b & 15) << 4) + (c >> 2));
            }
            else if (b != EQUAL)
            {
              /* Two '=' padding characters present */
              putchar((a << 2) + (b >> 4));
            }
          }
          else
          {
            /* Got only three bytes of last BASE64 quadruplet */
            failure = ERROR_INCOMPLETE;
            break;
          }
        }
        else
        {
          /* Got only two bytes of last BASE64 quadruplet */
          failure = ERROR_INCOMPLETE;
          break;
        }
      }
      else
      {
        /* Got only one byte of last BASE64 quadruplet */
        failure = ERROR_INCOMPLETE;
        break;
      }
    }
    else
      {
      /* Reached end of input without error */
      break;
      }
    }
  return failure;
  }

int DecodeBase64Buffer (TBuffer abufin, int sz_abufin, TBuffer abufout, int *sz_abufout)
  {
  xuint input;           /* Encoded input bytes */
  xuchar a = ' ', b = ' ', c = ' ', d = ' ';     /* Decoded 6-bit input value  */
  int failure = ERROR_NONE;     /* Assume success */
  int leidos = 0;

  *sz_abufout = 0;
  if (decode['A'] == NOP) {

    /* We initialize decode in this routine rather than
     * statically because C does not provide a means for
     * statically initializing array elements if the order of
     * the array elements is not known by the programmer.  If we
     * were willing to assume that we were on an ASCII system,
     * we could use static initialization since the order of the
     * characters would then be known. */

    decode['A'] = 0;  decode['B'] = 1;  decode['C'] = 2;  decode['D'] = 3;
    decode['E'] = 4;  decode['F'] = 5;  decode['G'] = 6;  decode['H'] = 7;
    decode['I'] = 8;  decode['J'] = 9;  decode['K'] = 10; decode['L'] = 11;
    decode['M'] = 12; decode['N'] = 13; decode['O'] = 14; decode['P'] = 15;
    decode['Q'] = 16; decode['R'] = 17; decode['S'] = 18; decode['T'] = 19;
    decode['U'] = 20; decode['V'] = 21; decode['W'] = 22; decode['X'] = 23;
    decode['Y'] = 24; decode['Z'] = 25; decode['a'] = 26; decode['b'] = 27;
    decode['c'] = 28; decode['d'] = 29; decode['e'] = 30; decode['f'] = 31;
    decode['g'] = 32; decode['h'] = 33; decode['i'] = 34; decode['j'] = 35;
    decode['k'] = 36; decode['l'] = 37; decode['m'] = 38; decode['n'] = 39;
    decode['o'] = 40; decode['p'] = 41; decode['q'] = 42; decode['r'] = 43;
    decode['s'] = 44; decode['t'] = 45; decode['u'] = 46; decode['v'] = 47;
    decode['w'] = 48; decode['x'] = 49; decode['y'] = 50; decode['z'] = 51;
    decode['0'] = 52; decode['1'] = 53; decode['2'] = 54; decode['3'] = 55;
    decode['4'] = 56; decode['5'] = 57; decode['6'] = 58; decode['7'] = 59;
    decode['8'] = 60; decode['9'] = 61; decode['+'] = 62; decode['/'] = 63;
    /* '=' is a valid character even though it doesn't represent bits.  We'll assign it value EQUAL arbitrarily. */
    decode['='] = EQUAL;
  }
  while (leidos < sz_abufin)
    {
    input = abufin[leidos]; ++leidos; a = decode[input];
    input = abufin[leidos]; ++leidos; b = decode[input];    
    input = abufin[leidos]; ++leidos; c = decode[input];
    input = abufin[leidos]; ++leidos; d = decode[input];        
    /* Got four significant characters */
    if (a == EQUAL || b == EQUAL || (c == EQUAL && d != EQUAL)) 
      {
      failure = ERROR_EQUAL;
      break;
      }
    if (d != EQUAL)
      {
      /* No '=' padding present */
      abufout[(*sz_abufout)++] = ((a << 2) + (b >> 4));
      abufout[(*sz_abufout)++] = (((b & 15) << 4) + (c >> 2));
      abufout[(*sz_abufout)++] = (((c & 3) << 6) + d);
      }
    else if (c != EQUAL)
      {
      /* One '=' padding character present */
      abufout[(*sz_abufout)++] = ((a << 2) + (b >> 4));
      abufout[(*sz_abufout)++] = ((b & 15) << 4) + (c >> 2);
      }
    else if (b != EQUAL)
      {
      /* Two '=' padding characters present */
      abufout[(*sz_abufout)++] = (a << 2) + (b >> 4);
      }
    }  
  --(*sz_abufout);  
  return failure;
  }

int DecodeQuotedPrintable (FILE *FR, int size)
  {
  const int CNONE = 0;
  const int CIGUAL = 1;
  int i, Estado, sz2, restantes, bleidos, bbleidos, j, contador = 0, cp = 0;
  char ABufferRead[10000], st_out[10], c, stchar[2], *chk;
  
  Estado = CNONE;
  restantes = size;
  initStr (st_out);
  while (restantes > 0)
    {
    if (restantes - 10000 < 0) sz2 = restantes;
    else sz2 = 10000;
    bleidos = fread (ABufferRead, 1, sz2, FR);
    restantes = restantes - bleidos;
    bbleidos = bleidos;
    i = 0;
    while (i < bbleidos)
      { 
      c = ABufferRead[i];
      ++contador;
      /*ESTO ES PARA DEBUG
      if ((cp > 18420) && (cp < 18430)) 
        {fprintf (stderr, "Est:%d NumChRead:%d NumChSav:%d CharRead:%c OrdCharRead:%d\n", 
                  Estado, contador, cp, c, c);}
      */
      switch (Estado)
        {
        case CNONE:                      
          {
          switch (c)
            {
            case '=':  Estado = CIGUAL; initStr (st_out); break;
            case '\r': printf ("\r\n"); cp += 2; break;
            case '\n': printf ("\r\n"); cp += 2; break;
            default : printf ("%c", c); 
                      ++cp;
                      break;
            }   
          break;
          } //CNONE
        case CIGUAL:
          {            
          switch (c)
            {
            case '=':  printf ("=="); cp += 2; Estado = CNONE; break;
            case '\n': if ((restantes == 0) && (i == bbleidos - 1)) {printf ("=\n"); cp += 2;} 
                       Estado = CNONE; break;
            case '\r': if ((restantes == 0) && (i == bbleidos - 1)) {printf ("=\r"); cp += 2;} 
                       Estado = CNONE; break;            
            default: if (isxdigit (c) == false) 
                       {printf ("=%s%c", st_out, c); initStr (st_out); Estado = CNONE; break;}
                     stchar[0] = c; stchar[1] = '\0';
                     xstrncat (st_out, 10, stchar);
                     if (strlen(st_out) == 2)
                       {
                       j = (int)strtol (st_out, &chk, 16);
                       if (*chk != '\0') //BAD INTEGER
                         {
                         printf ("=%s", st_out); initStr (st_out); Estado = CNONE; break;
                         }      
                       printf ("%c", (char)j); ++cp;
                       Estado = CNONE; 
                       initStr (st_out);
                       }
                     break;
            }             
          break;            
          }
        }  
      ++i;  
      } //while  
    } //WHILE
  return 0;
  }
  
bool IsQuotedPrintable (char *texto)
  {
  int longlinea = 0;
  xuchar c;
  if (texto == NULL) {return false;}
  for (int i = 0; (xuint)i < strlen(texto); ++i)
    {
    c = texto[i];
    switch (c)
      {
      case '\r': 
      case '\n':
        if (longlinea > MAXLONGLINEAQUOTEDPRINTABLE) return true;
        longlinea = 0;
        break;
      default: 
        if (c > 126) return true;  
        if (c < 33) return true;  
        ++longlinea; 
        break;
      }
    }
  if (longlinea > MAXLONGLINEAQUOTEDPRINTABLE) return true;  
  return false;
  }  
  
//ESCRIBE EN UN FICHERO TEMPORAL EL STRING DADO (NORMALMENTE
//  EL PRIMER TEXTO DEL MENSAJE) CODIFICANDOLO EN QUOTED
//  PRINTABLE SI ES NECESARIO
//DEVUELVE EL NOMBRE DEL FICHERO TMP GENERADO  
char *ToQuotedPrintableFile (char *texto)
  {
  TBuffer fntmp;
  FILE *FW;
  MakeTmpName (fntmp, CMAXBUFFER); 
  FW = fopen (fntmp, "w"); 
  if (IsQuotedPrintable (texto) == false)
    {
    fprintf (FW, "%s", texto);
    }  
  else
    {
    xuchar *c;
    xulong len;
    c = ToQuotedPrintableString ((xuchar *)texto, strlen(texto), &len);
    fprintf (FW, "%s", c);
    }
  fclose (FW);
  return xstrdup(fntmp);  
  }
  
void xfs_resize (void **block,size_t size)
  {
  *block = realloc (*block,size ? size : (size_t) 1);
  }

void *xfs_get (size_t size)
  {
  void *block = malloc (size ? size : (size_t) 1);
  return (block);
  }
  
xuchar *ToQuotedPrintableString (xuchar *src, xulong srcl, xulong *len)
  {
  xulong lp = 0;
  xuchar *ret = (xuchar *) xfs_get ((size_t) (3*srcl + (6*srcl)/MAXLONGLINEAQUOTEDPRINTABLE + 3));
  xuchar *d = ret;
  char *hex = "0123456789ABCDEF";
  xuchar c;
  while (srcl--) {              /* for each character */
                                /* true line break? */
    if (((c = *src++) == '\015') && (*src == '\012') && srcl) {
      *d++ = '\015'; *d++ = *src++; srcl--;
      lp = 0;                   /* reset line count */
    }
    else {                      /* not a line break */
                                /* quoting required? */
      if (iscntrl (c) || (c == 0x7f) || (c & 0x80) || (c == '=') ||
          ((c == ' ') && (*src == '\015'))) {
        if ((lp += 3) > MAXLONGLINEAQUOTEDPRINTABLE) { /* yes, would line overflow? */
          *d++ = '='; *d++ = '\015'; *d++ = '\012';
          lp = 3;               /* set line count */
        }
        *d++ = '=';             /* quote character */
        *d++ = hex[c >> 4];     /* high order 4 bits */
        *d++ = hex[c & 0xf];    /* low order 4 bits */
      }
      else {                    /* ordinary character */
        if ((++lp) > MAXLONGLINEAQUOTEDPRINTABLE) {    /* would line overflow? */
          *d++ = '='; *d++ = '\015'; *d++ = '\012';
          lp = 1;               /* set line count */
        }
        *d++ = c;               /* ordinary character */
      }
    }
  }
  *d = '\0';                    /* tie off destination */
  *len = d - ret;               /* calculate true size */
                                /* try to give some space back */
  xfs_resize ((void **) &ret,(size_t) *len + 1);
  return ret;
  } 
  
bool IsThereASCII8bitsInHeaders (xuchar *lin)
  {
  xuint i;
  i = 0;
  while (i < strlen((char *)lin))
    {
    if (int(lin[i]) > 126) {return true;}
    ++i;
    }
  return false;
  }

//From: =?US-ASCII?Q?Keith_Moore?= <moore@cs.utk.edu>
//Subject: =?iso-8859-1?B?4ent8/rg6Ozy+eTre30=?=
char *DecodificaHeader (char *header)
  {
  int L, i;
  char c1, c2, code = ' ', letra[2];
  bool quoted;
  XString stresult, stquoted;
  if (strstr (header, "=?") == NULL) {return xstrdup (header);}
  L = strlen (header);
  i = 0; 
  letra[1] = '\0';
  quoted = false;
  stresult = "";
  stquoted = "";
  while (i < L)
    {
    c1 = header [i];
    if (i < L - 1) {c2 = header [i + 1];} 
    else c2 = ' ';
    switch (c1)
      {
      case '=': 
        {
        if (quoted == false)
          {
          if (c2 == '?')
            {
            quoted = true; ++i; ++i;
            while (header[i] != '?') {++i;}
            ++i; code = header[i]; ++i; ++i;
            }
          else 
            {
            letra[0] = c1;
            if (quoted) stquoted += letra; 
            else stresult += letra;
            ++i;                  
            }
          }
        else {letra[0] = c1; stquoted += letra; ++i;}
        break;
        }
      case '?': 
        {
        if (c2 == '=')
          {
          switch (code)
            {
            case 'q':
            case 'Q': {
                      XString XS = XString (stquoted);
                      xulong len;
                      stquoted = XString((char *)rfc822_qprint ((xuchar *)stquoted.cstr(),
                                                                strlen((char *)stquoted.cstr()), &len));
                      if (len <= 0) stquoted = XString (XS);
                      break;
                      }
            case 'b':
            case 'B': {
                      XString XS = XString (stquoted);
                      xulong len;
                      stquoted = XString((char *)rfc822_base64 ((xuchar *)stquoted.cstr(), 
                                                                strlen((char *)stquoted.cstr()), &len));
                      if (len <= 0) stquoted = XString (XS);
                      break;
                      }
            default: break;
            }
          stresult +=  stquoted;
          quoted = false;
          stquoted = "";
          ++i; ++i;
          }
        else
          {
          letra[0] = c1;
          if (quoted) stquoted += letra; else stresult += letra;
          ++i;
          }
        break;
        }
      default:
        {
        letra[0] = c1;
        if (quoted) stquoted += letra; 
        else stresult += letra;
        ++i;
        break;   
        }
      }
    }
  if (stresult.length() <= 0) {return xstrdup(header);}
  return xstrdup (stresult.cstr());
  }

//From: =?US-ASCII?Q?Keith_Moore?= <moore@cs.utk.edu>
//Subject: =?iso-8859-1?Q?=3F?=
xuchar *CodificaHeaderQuotedP_AllInOne (xuchar *header)
  {
  if (IsThereASCII8bitsInHeaders (header) == false) return header;
  char c;
  xuchar letra[2];
  XString XS;
  xulong len, L;
  letra[1] = '\0';
  XS = "=?US-ASCII?Q?";
  for (L = 0; L < strlen ((char *)header); ++L)
    {
    c = header [L]; 
    letra[0] = c;
    if (int(header[L]) > 126) 
      {
      XS += ((char *)rfc822_8bit(letra, 1, &len));
      }
    else
      {
      XS += (char *)letra;
      }
    }
  XS += "?=";  
  return (xuchar *)xstrdup (XS.cstr());
  }
  
//From: =?US-ASCII?Q?Keith_Moore?= <moore@cs.utk.edu>
//Subject: =?iso-8859-1?Q?=3F?=
xuchar *CodificaHeaderQuotedP_One2One (xuchar *header)
  {
  if (IsThereASCII8bitsInHeaders (header) == false) return header;
  char c;
  xuchar letra[2];
  XString XS;
  xulong len, L;
  letra[1] = '\0';
  XS = "";
  for (L = 0; L < strlen ((char *)header); ++L)
    {
    c = header [L]; 
    letra[0] = c;
    if (int(header[L]) > 126) 
      {
      XS += "=?US-ASCII?Q?";
      XS += ((char *)rfc822_8bit(letra, 1, &len));
      XS += "?=";
      }
    else
      {
      XS += (char *)letra;
      }
    }
  return (xuchar *)xstrdup (XS.cstr());
  }  
  
//Check if the body of one message is uuencoded
bool IsUuencodedPChar (const char *pc)
  {
  bool hay_begin, hay_end;
  hay_begin = false;
  hay_end   = false;  
  if ((strstr(pc, "begin ") != NULL) || (strstr(pc, "begin-base64 ") != NULL))
                                                                     {hay_begin = true;}
  if (strstr(pc, "\nend") != NULL) 
                                                                     {hay_end   = true;}
  if ((hay_begin == false) || (hay_end == false)) {return false;}
  else {return true;}
  }  
  
#define DEC(Char) (((Char) - ' ') & 077)

bool read_uudecode (FILE *fin, FILE *fout)
  {
  char buf[2 * BUFSIZ];
  while (1)
    {
    int n;
    char *p, ch;

    if (fgets (buf, sizeof(buf), fin) == NULL) {return false;}
    p = buf;

    /* N is used to avoid writing out all the characters at the end of the file.  */
    n = DEC (*p);
    if (n <= 0) break;
    for (++p; n > 0; p += 4, n -= 3)
      {
      if (n >= 3)
        {
        ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
        putc (ch, fout);
        ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
        putc (ch, fout);
        ch = DEC (p[2]) << 6 | DEC (p[3]);
        putc (ch, fout);
        }
      else
        {
        if (n >= 1)
          {
          ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
          putc (ch, fout);
          }
        if (n >= 2)
          {
          ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
          putc (ch, fout);
          }
        }
      }
    }
    
  if (fgets (buf, sizeof(buf), fin) == NULL) {return false;}
  if ((strcmp (buf, "end\n") != 0) && (strcmp (buf, "end\r\n") != 0)) {return false;}
  return true;
  }

bool read_base64 (FILE *fin, FILE *fout)
  {
  unsigned char buf[2 * BUFSIZ];
  static const char b64_tab[256] =
    {
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*000-007*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*010-017*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*020-027*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*030-037*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*040-047*/
    '\177', '\177', '\177', '\76',  '\177', '\177', '\177', '\77',  /*050-057*/
    '\64',  '\65',  '\66',  '\67',  '\70',  '\71',  '\72',  '\73',  /*060-067*/
    '\74',  '\75',  '\177', '\177', '\177', '\100', '\177', '\177', /*070-077*/
    '\177', '\0',   '\1',   '\2',   '\3',   '\4',   '\5',   '\6',   /*100-107*/
    '\7',   '\10',  '\11',  '\12',  '\13',  '\14',  '\15',  '\16',  /*110-117*/
    '\17',  '\20',  '\21',  '\22',  '\23',  '\24',  '\25',  '\26',  /*120-127*/
    '\27',  '\30',  '\31',  '\177', '\177', '\177', '\177', '\177', /*130-137*/
    '\177', '\32',  '\33',  '\34',  '\35',  '\36',  '\37',  '\40',  /*140-147*/
    '\41',  '\42',  '\43',  '\44',  '\45',  '\46',  '\47',  '\50',  /*150-157*/
    '\51',  '\52',  '\53',  '\54',  '\55',  '\56',  '\57',  '\60',  /*160-167*/
    '\61',  '\62',  '\63',  '\177', '\177', '\177', '\177', '\177', /*170-177*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*200-207*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*210-217*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*220-227*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*230-237*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*240-247*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*250-257*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*260-267*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*270-277*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*300-307*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*310-317*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*320-327*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*330-337*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*340-347*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*350-357*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*360-367*/
    '\177', '\177', '\177', '\177', '\177', '\177', '\177', '\177', /*370-377*/
    };

  while (1)
    {
    int last_data = 0;
    unsigned char *p;

    if (fgets ((char *)buf, sizeof(buf), fin) == NULL) {return false;}
    p = buf;

    if (memcmp (buf, "====", 4) == 0) break;
    if (last_data != 0) {return false;}

    /* The following implementation of the base64 decoding might look
       a bit clumsy but I only try to follow the POSIX standard:
       ``All line breaks or other characters not found in the table
       [with base64 characters] shall be ignored by decoding software.''  */
    while (*p != '\n')
      {
      char c1, c2, c3;
      while ((b64_tab[*p] & '\100') != 0)
        {
        if (*p == '\n' || *p++ == '=') break;
        }
      /* This leaves the loop.  */
      if (*p == '\n') continue;
      c1 = b64_tab[*p++];
      while ((b64_tab[*p] & '\100') != 0)
        {
        if (*p == '\n' || *p++ == '=') {return false;}
        }  
      c2 = b64_tab[*p++];

      while (b64_tab[*p] == '\177')
        {
        if (*p++ == '\n') {return false;}
        }  
      if (*p == '=')
        {
        putc (c1 << 2 | c2 >> 4, fout);
        last_data = 1;
        break;
        }
      c3 = b64_tab[*p++];
      while (b64_tab[*p] == '\177')
        {
        if (*p++ == '\n') {return false;}
        }  
      putc (c1 << 2 | c2 >> 4, fout);
      putc (c2 << 4 | c3 >> 2, fout);
      if (*p == '=')
        {
        last_data = 1;
        break;
        }
      else 
        {
        putc (c3 << 6 | b64_tab[*p++], fout);
        }
      }
    }
  return true;
  }

const char *getUuencodedFileName (const char *beginline, TBuffer TrueName)
  {
  int mode;
  initStr (TrueName);
  if (strncmp (beginline, "begin", 5) == 0)
    {
    if (sscanf (beginline, "begin-base64 %o %[^]]s", &mode, TrueName) == 2)
      {
      }
    else 
      {
      if (sscanf (beginline, "begin %o %[^]]s", &mode, TrueName) == 2) 
          {
          }
      }
    } 
  return TrueName;   
  }

bool UudecodeFiles (const char *fnin, const char *forced_outname, TBuffer TrueName, int numatt)
  {
  int mode, do_base64 = 0, ret, cont_begin = 0;
  char buf[2 * BUFSIZ], *outname;
  FILE *in, *out;

  initStr (TrueName);
  if ((in = fopen(fnin, "r")) == NULL) {return false;}

  /* Search for header line*/
  while (1)
    {
    if (fgets (buf, sizeof (buf), in) == NULL) {return false;}
    if (strncmp (buf, "begin", 5) == 0)
      {
      if (sscanf (buf, "begin-base64 %o %[^]]s", &mode, TrueName) == 2)
        {
        ++cont_begin;
        do_base64 = 1;
        if (cont_begin == numatt) break;
        }
      else 
        {
        if (sscanf (buf, "begin %o %[^]]s", &mode, TrueName) == 2) 
          {
          ++cont_begin;
          do_base64 = 0;
          if (cont_begin == numatt) break;
          }
        }
      }
    }
  Ltrim (TrueName);
  QuitaRetornoCarroDeLinea (TrueName);
  
  /* If the output file name is given on the command line this rules.  */
  if (forced_outname != NULL) outname = (char *) forced_outname;
  else outname = buf;
    
  out = fopen (outname, "w");
  if (out == NULL) {return false;}

  if (do_base64)
    {
    ret = read_base64 (in, out);
    }
  else
    { 
    ret = read_uudecode (in, out);
    }
  fclose (in); 
  fclose (out);
  return ret;  
  }

void Encrypt1 (char *password, TBuffer buffer2encrypt, int len_buffer2encrypt, TBuffer bufferencrypted, int *lenbufferencrypted)
  {
  int i, passwordLength;
  TBuffer abuf1;
  
  passwordLength = strlen (password);
  for (i = 0; i < len_buffer2encrypt; i++) 
    {
    abuf1[i] = buffer2encrypt[i] ^ password [i%passwordLength];
    }        
  i = EncodeBase64Buffer (abuf1, len_buffer2encrypt, bufferencrypted, lenbufferencrypted);    
  } 
  
void Decrypt1 (char *password, TBuffer buffer2decrypt, int len_buffer2decrypt, TBuffer bufferdecrypted, int *lenbufferdecrypted)
  {
  int i, passwordLength;
  TBuffer abuf1;
  
  i = DecodeBase64Buffer (buffer2decrypt, len_buffer2decrypt, abuf1, lenbufferdecrypted);
  passwordLength = strlen (password);
  for (i = 0; i < *lenbufferdecrypted; i++) 
    {
    bufferdecrypted[i] = abuf1[i] ^ password [i%passwordLength];
    }        
  } 

unsigned int crctab[256];
#define QUOTIENT 0x04c11db7

void crc32_init(void)
  {
  int i, j;
  unsigned int crc;
  for (i = 0; i < 256; i++)
    {
    crc = i << 24;
    for (j = 0; j < 8; j++)
      {
      if (crc & 0x80000000) crc = (crc << 1) ^ QUOTIENT; else crc = crc << 1;
      }
    crctab[i] = crc;
    }
  }

unsigned int crc32(unsigned char *data, int len)
  {
  unsigned int        result;
  int                 i;
  
  if (len < 4) {return 0;}
  crc32_init();
  result = *data++ << 24;
  result |= *data++ << 16;
  result |= *data++ << 8;
  result |= *data++;
  result = ~ result;
  len -= 4;  
  for (i=0; i<len; i++)
    {
    result = (result << 8 | *data++) ^ crctab[result >> 24];
    }  
  return ~result;
  }

void encryptcasero (TBuffer password, TBuffer buffer2encrypt, int len_buffer2encrypt, TBuffer bufferencrypted, int *lenbufferencrypted)
  {
  /*
  002:lopezj:lopezj:postman:
          |
          v
  002:lopezj:lopezj:postman:1993239182:
  */

  int i, k, ipwindex, passwordLength, lentmpbuff, len2encrypt;
  TBuffer abuf1, tmpbuff, pwindex, token_original, token2encript, pass2use;  
  char c[2];
  unsigned int ui;
  
  c[1] = '\0';
  strcpy (token_original, buffer2encrypt);
  strncpy (pwindex, token_original, 3);
  ipwindex = atoi (pwindex);
  if ((ipwindex < 0) || (ipwindex >= (signed)strlen(password) - 1)) {ipwindex=5; strcpy (pwindex, "005");}
  strcpy (pass2use, "");
  for (i = ipwindex; i <= (signed)strlen(password); ++i) {c[0] = password[i]; strcat(pass2use, c);}  
  strcpy (token2encript, "");
  for (i = 3; i < (signed)strlen(token_original); ++i) {c[0] = token_original[i]; strcat(token2encript, c);}

  crc32_init();
  ui = crc32 ((unsigned char *)token2encript, strlen(token2encript));
  sprintf (tmpbuff, "%d", ui);
  strcat (token2encript, tmpbuff);
  strcat (token2encript, ":");          
  len2encrypt = strlen (token2encript);                      
  memset (bufferencrypted, 0, CMAXBUFFER);
  passwordLength = strlen (pass2use);
  for (i = 0; i < len2encrypt; i++) 
    {
    abuf1[i] = token2encript[i] ^ pass2use [i % passwordLength];
    }        
  i = EncodeBase64Buffer (abuf1, len2encrypt, tmpbuff, &lentmpbuff); 
  strncpy (bufferencrypted, pwindex, 3);
  strcat (bufferencrypted, tmpbuff);
  *lenbufferencrypted = strlen (bufferencrypted);
  for (k=0; k < *lenbufferencrypted; ++k) {if (bufferencrypted[k] == '/') bufferencrypted[k] = '*';}
  } 
  
const char *AuthBasic (const char *user, const char *pw, TBuffer value)
  {
  TBuffer tmpbuf;
  int lenmaxbuf = CMAXBUFFER;
  xsnprintf (tmpbuf, CMAXBUFFER, "%s:%s", user, pw);
  EncodeBase64Buffer (tmpbuf, strlen(tmpbuf), value, &lenmaxbuf);
  return value;    
  }  
