/*
ClientNNTP.cc
*/

#include "ClientNNTP.h"
extern Language *L;
extern CCLIENT *thecclient;

ClientNNTP::ClientNNTP (const char *anntpserver, const char *adefaultipdomain, const char *auser, const char *apw)
  {
  xstrncpy (nntpserver, CMAXIPNAME, anntpserver);
  xstrncpy (user, CMAXBUFFER, auser);
  xstrncpy (pw, CMAXBUFFER, apw);  
  xstrncpy (defaultipdomain, CMAXIPNAME, adefaultipdomain);
  if (strchr (nntpserver, '.') == NULL) {xstrncat (nntpserver, CMAXIPNAME, defaultipdomain);}
  ReturnAllNNGroupsFileName (nntpserver, fnallnn);
  searchedgroups = "";
  SLAllGroups = new StringList;
  SLSearchedGroups = new StringList;
  }  

ClientNNTP::~ClientNNTP ()
  {
  delete SLAllGroups;
  delete SLSearchedGroups;
  }

void ClientNNTP::setNNTPserver (const char *anntpserver)
  {
  if (strcasecmp (nntpserver, anntpserver) != 0)
    {
    xstrncpy (nntpserver, CMAXIPNAME, anntpserver);
    if (strchr (nntpserver, '.') == NULL) {xstrncat (nntpserver, CMAXIPNAME, defaultipdomain);}
    ReturnAllNNGroupsFileName (nntpserver, fnallnn);
    searchedgroups = "";
    //Force get the list group
    SLAllGroups->Clear();
    SLSearchedGroups->Clear();
    SLAllGroups->Clear();
    retrieveAllGroupsList ();
    }  
  }

const char *ClientNNTP::getNNTPServer (void)
  {
  return nntpserver;
  }    

int ClientNNTP::retrieveAllGroupsList (void)
  {
  struct stat STAT;
  int res, dif;
  time_t tm, now;
  
  if (SLAllGroups->Count () > 0) 
    {
    //DEBUG ("NNTP AllGroups are already in memory.");
    return SLAllGroups->Count ();
    } 
  
  now = time (NULL);
  res = stat ((const char *)fnallnn, &STAT);  
  tm = STAT.st_mtime;      
  dif = (int)difftime(now, tm);
  //DEBUG ("res=%d,now=%ld--tm=%ld--dif=%d--MAX_TIME_NNFILE=%ld--", res, now, tm, dif, MAX_TIME_NNFILE);
  if ((dif > MAX_TIME_NNFILE) || (res != 0))
    {
    return retrieveAllGroupsListFromNet ();
    }
  else
    {
    return retrieveAllGroupsListFromFile ();
    }        
  }
  
int ClientNNTP::retrieveAllGroupsListFromNet (void)
  {
  TBuffer buffer, basura;
  int sock, cod, res, numgroups, possp;
  XSocket *nntpsocket;
  TBuffer errormsg;

  LOG ("NNTP retrieveAllGroupsListFromNet for server: %s, user: %s", nntpserver, user);
  SLAllGroups->Clear();
  nntpsocket = new XSocket ();
  nntpsocket->ignore_pipe();
  sock = nntpsocket->do_client_inet (nntpserver, NULL, DEFNNTPPORT, 240);
  if (sock == -1) {xstrncpy (errormsg, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return -1;}
  nntpsocket->SetSock (sock);
  
  /*LEO LA LINEA DE BIENVENIDA*/
  /*-1 by the possible buffer overflow resulting from the linefeed added below. */
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {return -1;}
  sscanf (buffer, "%d %200s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {xstrncpy (errormsg, CMAXBUFFER, buffer); return -1;}

  /*ENVIO LIST*/
  sprintf (buffer, "LIST\n");
  if (nntpsocket->Puts (buffer) == -1) {return -1;}

  /*LEO LO RECIBIDO*/
  numgroups = 0;
  res = nntpsocket->Gets (buffer, sizeof(buffer) - 1);
  sscanf (buffer, "%d %200s", &cod, basura);
  if (cod != 215) 
    {
    //Me pide usuario y pw
    if ((cod == 450) || (cod == 480))
      {
      snprintf (buffer, CMAXBUFFER, "AUTHINFO USER %s\n", user);
      if (nntpsocket->Puts (buffer) == -1) {return -1;}
      res = nntpsocket->Gets (buffer, sizeof(buffer) - 1);
      sscanf (buffer, "%d %200s", &cod, basura);
      if (cod != 381) {return -1;}
      
      snprintf (buffer, CMAXBUFFER, "AUTHINFO PASS %s\n", pw);
      if (nntpsocket->Puts (buffer) == -1) {return -1;}
      res = nntpsocket->Gets (buffer, sizeof(buffer) - 1);
      sscanf (buffer, "%d %200s", &cod, basura);
      if (cod != 281) {xstrncpy (errormsg, CMAXBUFFER, "User/pw invalid!"); return -1;}
      
      }
    else return -1;
    }  
  res = nntpsocket->Gets (buffer, sizeof(buffer) - 1);
  while ((res != -1) && (strcmp(buffer, ".") != 0) && (strcmp(buffer, "") != 0)) 
    {
    ++numgroups;
    possp = Cstrstr (buffer, " ");
    if (possp > 0) {buffer [possp - 1] = '\0';}
    /*DEBUG*/ //printf ("--%d--%s--\n", numgroups, buffer); fflush (stdout);
    SLAllGroups->Add (buffer);
    res = nntpsocket->Gets (buffer, sizeof(buffer) - 1);
    }  

  /*ENVIO QUIT*/
  sprintf (buffer, "QUIT\n");
  if (nntpsocket->Puts (buffer) == -1) {return -1;}

  /*LEO LA LINEA DE QUIT*/
  if (!nntpsocket->Gets (buffer, sizeof(buffer) -1)) {return -1;}
  sscanf (buffer, "%d %200s", &cod, basura);
  if ((cod < 200) || (cod > 400)) {return -1;}

  //sortAllGroupsList(); VERY SLOWLY WITH MANY GROUPS.

  SLAllGroups->SaveToFile (fnallnn, true);
  
  delete nntpsocket;
  
  //SORT THE BIG FILE FOR NNTP GROUPS
  if (SORT_NNTP_ALLGROUPS == 1)
    {
    TBuffer abuf, fnallnn_tmp;
    snprintf (fnallnn_tmp,  CMAXBUFFER, "%s.tmp", fnallnn);
    snprintf (abuf,  CMAXBUFFER, "%s -o %s %s", cmdSORT, fnallnn_tmp, fnallnn);
    if (system(abuf) == 0) {CopyFileOverWrite (fnallnn_tmp, fnallnn);}
    DeleteFile (fnallnn_tmp);
    }
    
  return numgroups;
  }

int ClientNNTP::retrieveAllGroupsListFromFile (void)
  {
  LOG ("NNTP retrieveAllGroupsListFromFile for server: %s, user: %s", nntpserver, user);
  SLAllGroups->LoadFromFile (fnallnn);
  return SLAllGroups->Count();
  }

const char *ClientNNTP::getSearchedGroups (void)
  {
  return searchedgroups.cstr();
  } 

int ClientNNTP::retrievePartialGroupsList (char *filter)
  {
  int i, res;  
  SLSearchedGroups->Clear();
  searchedgroups = "";
  if (IsEmpty (filter) == true) {return 0;}
  
  if (strstr (filter, "*") == NULL) 
    {
    for (int k = strlen(filter) - 1; k >= 0; --k) {filter[k + 1] = filter[k];}
    filter[0] = '*';
    filter[strlen(filter)] = '*';
    }
  
  res = 0;
  for (i = 0; i < SLAllGroups->Count (); ++i)
    {
    if (StringsLike (SLAllGroups->getString(i).cstr(), filter) == true) 
      {
      ++res;
      SLSearchedGroups->Add (SLAllGroups->getString(i).cstr());
      searchedgroups += SLAllGroups->getString(i).cstr(); searchedgroups += "\n";
      if (res >= MAX_NNTP_GROUPS_FOUND) {return res;}
      }
    }
  return res;
  }

void ClientNNTP::sortAllGroupsList (void)
  {
  if (SLAllGroups->Count() <= 0) {return;}
  SLAllGroups->SORT (CompareStringsNCS, FlipStrings);      
  }

