/*
CCLIENT.cc
*/

#include "CCLIENT.h"
#include "HTMLBasic.h"

CCLIENT *thecclient;
extern Language *L;
extern HTMLBasic *html;
extern TBuffer BasePath;

long *PLongListSort;
int *PListIndent = NULL;

CCLIENT::CCLIENT ()
  {
  thecclient = this;
  TheDEBUG = true;
  
  ServerProtocol = PROTOCOL_IMAP;
  MAILBOXSIZE = 0;
  TOTALMSGS = 0;
  msgsmarkeddeleted = 0;
  imapstream = NIL;
  nntpstream = NIL;
  timeout = 30;
  maxlogintrials = 0;
  TheERROR = false;
  imapport = DEFIMAPPORT;
  nntpport = DEFNNTPPORT;
  initStr (imapserver);
  initStr (nntpserver);
  initStr (username);
  initStr (password);
  initStr (mailbox);
  initStr (fullmailbox);
  initStr (ERRORSTRING);
  initStr (WARNINGSTRING);
  MAXMSGSFORPAGE = DEFOPT_MSGSPERINDEXPAGE;

  //SortType = NO_SORT; SortReversed = false;      
  if (USE_ARRIVAL_DATE == 1) {SortType = SORTARRIVAL;} else {SortType = SORTDATE;} 
  SortReversed = false;
  //One bug in CYRUS imapd for dates "Date: 21 Apr 2002 18:26:43 -0000"
  //   crash the imap server
  SortType = NO_SORT;  
  
  SLMailboxes = new StringList ();
  SLSearch = new StringList ();
  ILSort = new ULongList ();

  /*EN VEZ DE LAS LINEAS DE ABAJO SE PUEDE PONER #include "linkage.c" EN EL MAIN */
  mail_link (&mboxdriver);  /* link in the mbox driver */
  mail_link (&imapdriver);  /* link in the imap driver */  
  mail_link (&nntpdriver);  /* link in the nntp driver */
  mail_link (&pop3driver);  /* link in the pop3 driver */
  mail_link (&mhdriver);    /* link in the mh driver */
  mail_link (&mxdriver);    /* link in the mx driver */
  mail_link (&mbxdriver);   /* link in the mbx driver */
  mail_link (&tenexdriver); /* link in the tenex driver */
  mail_link (&mtxdriver);   /* link in the mtx driver */
  mail_link (&mmdfdriver);  /* link in the mmdf driver */
  mail_link (&unixdriver);  /* link in the unix driver */
  mail_link (&newsdriver);  /* link in the news driver */
  mail_link (&philedriver); /* link in the phile driver */
  mail_link (&dummydriver); /* link in the dummy driver */
  auth_link (&auth_md5);    /* link in the md5 authenticator */
#ifndef C_CLIENT_4_7
  auth_link (&auth_pla);  /* link in the pla authenticator */  
#endif
  auth_link (&auth_log);    /* link in the log authenticator */
  
  setPathToRemoteFolder ("");
  setMailboxPrefix ("");
  setDelimiter (47);
  setTimeout  (timeout);
  disableRSH();
  hideDotFiles();
  setMaxLoginTrials (maxlogintrials);
  }
  
CCLIENT::~CCLIENT() 
  {
  CloseMailbox ();
  delete SLSearch;
  delete SLMailboxes;
  delete ILSort;
  }     

void CCLIENT::setIMAPServer (const char *aIMAPServer)
  {
  xstrncpy (imapserver, CMAXIPNAME, aIMAPServer);
  }
  
char *CCLIENT::getIMAPServer (void)
  {
  return imapserver;
  }
  
void CCLIENT::setNNTPServer (const char *aNNTPServer)
  {
  xstrncpy (nntpserver, CMAXIPNAME, aNNTPServer);
  }
  
char *CCLIENT::getNNTPServer (void)
  {
  return nntpserver;
  }                  

TServerProtocol CCLIENT::getServerProtocol (void)
  {
  return ServerProtocol;
  }

void CCLIENT::setServerProtocol (TServerProtocol aServerProtocol)
  {
  ServerProtocol = aServerProtocol;
  }      

xulong CCLIENT::getNumMsgFromPosList (xulong pos)
  {
  return ILSort->elementAt((int)(pos - 1));
  }
  
xulong CCLIENT::getPosListFromNumMsg (xulong nummsg)
  {  
  return ILSort->indexOf(nummsg);
  }  

bool CCLIENT::isLastMsgFromList (xulong nummsg)
  {
  if (ILSort->indexOf(nummsg) >= ILSort->Count () - 1) return true; else return false;
  }
  
char *CCLIENT::getFullMailbox (char *amailbox, TBuffer resbuf)
  {
  //{idolo.ci.uv.es:143/imap/user="noprotes"}INBOX
  //{idolo.ci.uv.es:143/imap/user="noprotes"}~/mail/
  //{news.uv.es:119/nntp}#news.local.anuncios
  TBuffer mailbox;
  setError (false);
  xstrncpy (mailbox, CMAXFILENAME, amailbox);
  if (NCstrstr (amailbox, NNTPFOLDERPREFIX) == 1) //Mailbox from News
    {
    snprintf (resbuf, CMAXBUFFER, "{%s/nntp}%s", nntpserver, mailbox);
    }
  else if (strcmp (amailbox, "INBOX") == 0)
    {
    snprintf (resbuf, CMAXBUFFER, "{%s/imap/user=\"%s\"}%s", imapserver, username, mailbox);
    }
  else
    {
    snprintf (resbuf, CMAXBUFFER, "{%s/imap/user=\"%s\"}%s%s", imapserver, username, getPathToRemoteFolder(), mailbox);
    }
  return resbuf;
  }  

MAILSTREAM *CCLIENT::getStream (void)
  {
  if (ServerProtocol == PROTOCOL_IMAP) 
    {    
    return getIMAPStream();
    }
  else
    {
    return getNNTPStream();
    }
  }

MAILSTREAM *CCLIENT::getIMAPStream (void)
  {
  return imapstream;
  }

MAILSTREAM *CCLIENT::getNNTPStream (void)
  {
  return nntpstream;
  }

void CCLIENT::setStream (MAILSTREAM *TheStream)
  {
  if (ServerProtocol == PROTOCOL_IMAP) 
    {    
    imapstream = TheStream;
    }
  else
    {
    nntpstream = TheStream;
    }
  }

void CCLIENT::setNetNewsRC (void)
  {    
  //Netnews newsgroup reading status file (.newsrc) path name.
  ReturnRcNNGroupsFileName (BasePath, username, imapserver, NETNEWSRC);
  mail_parameters (NIL, SET_NEWSRC, (void *) NETNEWSRC);   
  }

const char *CCLIENT::getNetNewsRC(void)
  {  
  return NETNEWSRC;
  }

void CCLIENT::setDelimiter (char adelim)
  {
  delimiter = adelim;
  }  

char CCLIENT::getDelimiter (void)     
  {
  return delimiter;
  }  

void CCLIENT::setPathToRemoteFolder (const char *aPathToRemoteFolder)
  {
  xstrncpy (PathToRemoteFolder, CMAXBUFFER, aPathToRemoteFolder);
  }  

char *CCLIENT::getPathToRemoteFolder (void)
  {
  return PathToRemoteFolder;
  }

void CCLIENT::setMailboxPrefix (const char *aMailboxPrefix)
  {
  xstrncpy (MailboxPrefix, CMAXBUFFER, aMailboxPrefix);
  }
  
char *CCLIENT::getMailboxPrefix (void)
  {
  return MailboxPrefix;
  }      

void CCLIENT::setMAXMSGSFORPAGE (long maxmsgs)
  {
  MAXMSGSFORPAGE = maxmsgs;
  }
    
bool CCLIENT::getError (void)
  {
  return TheERROR;
  }
  
void CCLIENT::setError (bool value)
  {
  TheERROR = value;
  if (value == false) initStr (WARNINGSTRING);
  }
          
char *CCLIENT::getErrorString (void)
  {
  if ((strcasecmp (ERRORSTRING, "Can not authenticate to IMAP server: Authentication failure") == 0) ||
      (strcasecmp (ERRORSTRING, "Login failed: authentication failure") == 0) ||
      (strcasecmp (ERRORSTRING, "LOGOUT received") == 0) ||
      (strstr (ERRORSTRING, "IMAP4rev1 server terminating connection") != NULL) ||
      (strcasecmp (ERRORSTRING, "Too many login failures")) == 0)
    {
    xstrncpy (ERRORSTRING, CSMALLBUFFER, L->get(ERR_INV_USER_PW));
    }
  //[ALERT] Mailbox is at 99% of quota  
  else if (strstr (ERRORSTRING, "[ALERT] Mailbox is at ") != NULL)
    {
    TSBuffer c1, c2, c3, c4, c5, c6;
    sscanf (ERRORSTRING, "200%s %200s %200s %200s %200s %200s", c1, c2, c3, c4, c5, c6);
    xstrncpy (c1,  CSMALLBUFFER, L->get(ERR_QUOTA_USAGE));
    sprintf (ERRORSTRING, c1, c5);
    } 
  //[CLOSED] IMAP connection broken (server response)
  //Can not authenticate to IMAP server: [CLOSED] IMAP connection broken (authenticate)
  else if ((strstr (ERRORSTRING, "[CLOSED] IMAP connection broken (server response)") != NULL) ||
           (strstr (ERRORSTRING, "Can not authenticate to IMAP server: [CLOSED] IMAP connection broken (authenticate)") != NULL))
    {
    xstrncpy (ERRORSTRING, CSMALLBUFFER, L->get(MSG_SERVERISDOWN));
    }    
  //Do not show the next message  
  //[ALERT] Mailbox vulnerable        
  else if (strstr (ERRORSTRING, "[ALERT] Mailbox vulnerable ") != NULL)
    {
    initStr (ERRORSTRING);
    }        
  return ERRORSTRING;
  }
  
void CCLIENT::setErrorString (char *sterr)
  {
  xstrncpy (ERRORSTRING, CSMALLBUFFER, sterr);
  }  
  
const char *CCLIENT::getWarningString (void)
  {
  return WARNINGSTRING;
  }
  
void CCLIENT::setWarningString (char *stwarn)
  {
  strncpy (WARNINGSTRING, stwarn, CSMALLBUFFER);
  }      
  
char *CCLIENT::getBriefMailbox (const char *amailbox, TBuffer abuf)
  {
  //INBOX
  //~/mail/
  TBuffer mailbox;
  setError (false);
  xstrncpy (mailbox,  CMAXFILENAME, amailbox);
  if (strcmp (amailbox, "INBOX") == 0)
    snprintf (abuf, CMAXBUFFER, "%s", mailbox);
  else
    snprintf (abuf, CMAXBUFFER, "%s%s", getPathToRemoteFolder(), mailbox);
  return abuf;
  }  
  
char *CCLIENT::getUsername (void) {return (username);}
char *CCLIENT::getPassword (void) {return (password);}        
bool CCLIENT::isDebug (void) {return false;} /*{return (TheDEBUG);}*/
void CCLIENT::Expunge (void) {setError (false); if (getStream() != NIL) mail_expunge (getStream());}  

void CCLIENT::setTimeout (int atimeout)
  {
  setError (false);  
  timeout = atimeout;
  mail_parameters (NIL, SET_OPENTIMEOUT,  (void *) (long) timeout); //TCP/IP open timeout in seconds
  mail_parameters (NIL, SET_READTIMEOUT,  (void *) (long) timeout); //TCP/IP read timeout in seconds
  mail_parameters (NIL, SET_WRITETIMEOUT, (void *) (long) timeout); //TCP/IP write timeout in seconds
  mail_parameters (NIL, SET_CLOSETIMEOUT, (void *) (long) timeout); //TCP/IP close timeout in seconds
  // GET_TIMEOUT / SET_TIMEOUT
  //    If non-NIL, points to the function called when a TCP/IP timeout occurs.  This function is called with the number of
  //    seconds since the start of the TCP operation.  If it returns non-zero, the TCP/IP operation is continued; if it returns
  //    zero, the TCP/IP connection is aborted.
  mail_parameters (NIL, SET_TIMEOUT, (void *) doTCPTimeout);  
  }
  
//To avoid c-client try to connect using rsh at the beginning before IMAP validation
//   we must set the rshtimeout to 0
void CCLIENT::disableRSH(void)
  {
  setError (false);  
  mail_parameters (NIL, SET_RSHTIMEOUT, 0);  
  }
  
//To avoid c-client show files beginning with dot in mail_list results 
void CCLIENT::hideDotFiles(void)
  {
  setError (false);  
#ifndef C_CLIENT_4_7
  mail_parameters (NIL, SET_HIDEDOTFILES, (void *)T);  
#endif
  }  
  
void CCLIENT::setMaxLoginTrials (int amaxlogintrials)
  {
  setError (false);
  maxlogintrials = amaxlogintrials;
  mail_parameters (NIL, SET_MAXLOGINTRIALS, (void *) maxlogintrials);
  }

/*VALIDATE user/pw WITH IMAP. DO NOT OPEN A MAILBOX*/
bool CCLIENT::IMAPValidate (const char *ahost, int aport, const char *amailbox, const char *ausername, const char *apassword)
  {   
  TBuffer abuf;
  long flag;
  setError (false);
  flag = OP_HALFOPEN;
  if (TheDEBUG == true) {flag = flag || OP_DEBUG;}
  imapport = aport;
  xstrncpy (username, CMAXFILENAME, ausername);
  xstrncpy (password, CMAXFILENAME, apassword);      
  xstrncpy (mailbox,  CMAXFILENAME, amailbox);
  xstrncpy (imapserver, CMAXIPNAME, ahost);
  xstrncpy (fullmailbox, CMAXFILENAME, getFullMailbox (mailbox, abuf));
  if (strstr (fullmailbox, "/imap/") != NULL) ServerProtocol = PROTOCOL_IMAP; else ServerProtocol = PROTOCOL_NNTP;
  if (ServerProtocol == PROTOCOL_IMAP) 
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(imapport));
    }
  else if (ServerProtocol == PROTOCOL_NNTP)
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(nntpport));
    }
    
  if (ServerProtocol == PROTOCOL_NNTP)
    {
    //This is for convert 
    // {news.cis.dfn.de/nntp}#local.anuncios
    //   to
    // {news.cis.dfn.de/nntp}#news.local.anuncios
    XString xs;
    xs = fullmailbox;
    if (NCstrstr (fullmailbox, NNTPFOLDERPREFIX"news.") <= 0)
      {
      xs.replace (NNTPFOLDERPREFIX, NNTPFOLDERPREFIX"news.");
      }
    xstrncpy (fullmailbox, CMAXFILENAME, xs.cstr());
    }
    
  setStream (xmail_open (getStream(), fullmailbox, flag));
  if (getStream() == NIL) {return false;}
  return true;
  }
          
bool CCLIENT::Reconnect (void)
  {
  long flag;
  setError (false);
  flag = OP_HALFOPEN;
  if (TheDEBUG == true) {flag = flag || OP_DEBUG;}
  if (strstr (fullmailbox, "/imap/") != NULL) ServerProtocol = PROTOCOL_IMAP; else ServerProtocol = PROTOCOL_NNTP;
  if (ServerProtocol == PROTOCOL_IMAP) 
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(imapport));
    }
  else if (ServerProtocol == PROTOCOL_NNTP)
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(nntpport));
    }
  //DEBUG ("1 --%s--%d--", fullmailbox, flag);
  if (ServerProtocol == PROTOCOL_NNTP)
    {
    //This is for convert 
    // {news.cis.dfn.de/nntp}#local.anuncios
    //   to
    // {news.cis.dfn.de/nntp}#news.local.anuncios
    XString xs;
    xs = fullmailbox;
    if (NCstrstr (fullmailbox, NNTPFOLDERPREFIX"news.") <= 0)
      {
      xs.replace (NNTPFOLDERPREFIX, NNTPFOLDERPREFIX"news.");
      }
    xstrncpy (fullmailbox, CMAXFILENAME, xs.cstr());
    }
  CloseMailbox();
  setStream (xmail_open (getStream(), fullmailbox, flag));

  //if ((getStream() == NIL) || (getError() == true)) {return false;}
  if (getStream() == NIL) {return false;}
  
  Sort ();
  return true;                            
  }

bool CCLIENT::ChangeMailbox (char *newmailbox, bool ALLOW_NNTP)
  {
  TBuffer abuf;
  TFileName oldmailbox, oldfullmailbox;
  long flag;
  setError (false);
  if (strcmp(newmailbox, FORM_SELECT_SEPARATOR) == 0) {return false;}
  saveFlagsRCNewsFile ();
  flag = OP_HALFOPEN;
  if (TheDEBUG == true) {flag = flag || OP_DEBUG;}  
  xstrncpy (oldmailbox,  CMAXFILENAME, mailbox);
  xstrncpy (oldfullmailbox, CMAXFILENAME, fullmailbox);  
  xstrncpy (mailbox, CMAXFILENAME, newmailbox);
  xstrncpy (fullmailbox, CMAXFILENAME, getFullMailbox (mailbox, abuf));
  //LOG ("--%s--", fullmailbox);
  if (ServerProtocol == PROTOCOL_IMAP) 
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(imapport));
    }
  else if (ServerProtocol == PROTOCOL_NNTP)
    {
    mail_parameters (NIL, SET_IMAPPORT, (void *)(nntpport));
    }
  if (strstr (fullmailbox, "/imap/") != NULL) ServerProtocol = PROTOCOL_IMAP; else ServerProtocol = PROTOCOL_NNTP;

  if (ServerProtocol == PROTOCOL_NNTP)
    {
    //This is for convert 
    // {news.cis.dfn.de/nntp}#local.anuncios
    //   to
    // {news.cis.dfn.de/nntp}#news.local.anuncios
    XString xs;
    xs = fullmailbox;
    if (NCstrstr (fullmailbox, NNTPFOLDERPREFIX"news.") <= 0)
      {
      xs.replace (NNTPFOLDERPREFIX, NNTPFOLDERPREFIX"news.");
      }
    xstrncpy (fullmailbox, CMAXFILENAME, xs.cstr());
    }
                                                                                                                                                   
  CloseMailbox();
  setStream (xmail_open (getStream(), fullmailbox, flag));
                                                                  
  if ((getStream() == NIL) || ((ServerProtocol == PROTOCOL_NNTP) && (ALLOW_NNTP == 0)))
    {
    xstrncpy (mailbox,  CMAXFILENAME, oldmailbox);
    xstrncpy (fullmailbox, CMAXFILENAME, oldfullmailbox);
    return false;
    }

  Sort ();
    
  msgsmarkeddeleted = 0;
  return true;  
  }
  
void CCLIENT::CloseMailbox (void)
  {
  setError (false);
  
  //ONLY CLOSE THE NNTP FOLDER FOR FREE MEMORY
  if (nntpstream != NIL) 
    {
    mail_gc (nntpstream, GC_ENV | GC_TEXTS | GC_ELT);
    xmail_close (nntpstream); 
    nntpstream = NIL;
    }
  }  
  
MAILSTREAM *CCLIENT::xmail_open (MAILSTREAM *stream, const char *fullmailbox, long options)
  {
  stream = mail_open (stream, (char *)fullmailbox, options);  
  if ((ServerProtocol == PROTOCOL_NNTP) && (stream != NIL))
    {
    /*For statistics I do a log of the NetNews Groups open*/
    if (LOG_OPEN_NEWSGROUPS == 1) {LOG ("Open News Group '%s'", mailbox + strlen(NNTPFOLDERPREFIX));}
    /*NNTP: I read flags from local newsrc file to stream*/    
    Newsrc_read (mailbox + strlen(NNTPFOLDERPREFIX), stream);
    }  
  return stream;
  }  
  
void CCLIENT::xmail_close (MAILSTREAM *stream)
  {
  if (stream != NIL)
    {
    mail_close_full (stream, NIL);
    }
  }  
  
void CCLIENT::saveFlagsRCNewsFile (void)
  {
  if (getStream()->dtb)
    {
    if (!strcmp (getStream()->dtb->name, "nntp"))
      {
      /*NNTP: I write flags from stream to local newsrc file*/
      Newsrc_write (mailbox + strlen(NNTPFOLDERPREFIX), getStream());  
      }
    }
  } 
  
void CCLIENT::addMailbox (char *name)
  {
  SLMailboxes->Add(name);
  }  
  
char *CCLIENT::getMailboxName (void) 
  {
  if (getStream() != NIL) {return (mailbox);}
  return "";
  };          

//Return the NNTP Newsgroup without the prefix "#news."   
char *CCLIENT::getNNTPMailboxName (void) 
  {
  if (getStream() != NIL) {return (mailbox + strlen ("#news."));}
  return "";
  };  
  
char *CCLIENT::getFullMailboxName (void) 
  {
  if (getStream() != NIL) {return (getStream()->mailbox);}
  return "";
  };        

long CCLIENT::getTotalMsgs (void) 
  {
  TOTALMSGS = -1;
  if (getStream() != NIL) {TOTALMSGS = (xulong)getStream()->nmsgs;}
  return TOTALMSGS;
  };  

int CCLIENT::getMsgsMarkedDeleted (void) 
  {
  return msgsmarkeddeleted;
  };  

long CCLIENT::getRecentMsgs (void) 
  {
  if (getStream() != NIL) {return ((xulong)getStream()->recent);}
  return (long)-1;
  };  

long CCLIENT::getMsgsUnreadIMAPINBOX (void) 
  {
  TNumber anum;
  long msgno, TOT, NEWMSGS = (long)-1;
  MESSAGECACHE *cache;

  if ((strcmp (getMailboxName(), "INBOX") == 0) && (getServerProtocol() == PROTOCOL_IMAP) && (getStream() != NIL))
    {
    TOT = getStream()->nmsgs;
    NEWMSGS = 0;
    for (msgno = 1; msgno <= TOT; ++msgno)
      {
      cache = mail_elt (getStream(), msgno);
      if (cache != NIL)
        {
        mail_fetchflags (getStream(), xitoa(msgno, anum));
        if (!cache->seen) {++NEWMSGS;}
        }
      else
        {
        return -1;
        }
      }    
    }
  else
    {
    return -1;  
    }
  return NEWMSGS;
  }

bool CCLIENT::Ping (void)
  {
  setError (false);
  if (getStream() != NIL) 
    {
    long L;
    L = mail_ping (getStream());
    if (L == 0) return false; 
    else return true;
    }
  return false;
  }
     
char *CCLIENT::getAttIdFromCID (xulong nummsg, char *cid, TBuffer connid)
  {
  int i, j, p;
  TBuffer basura;
  initStr (connid);
  StringList *SLAttachs, *SLAttHeader;                                   
  SLAttachs  = new StringList ();
  SLAttHeader= new StringList ();
  SLAttachs->Clear();
  SLAttHeader->Clear();  
  getBodyStructure (nummsg, SLAttachs);
  setError (false);
  for (i = 0; i < SLAttachs->Count(); ++i)
    {
    sscanf (SLAttachs->getString(i).cstr(), "%2000s %2000[^]]s", connid, basura);
    getAttHeaderSL (nummsg, connid, SLAttHeader);
    for (j=0; j < SLAttHeader->Count(); ++j) 
      {
      p = NCstrstr ((char *)SLAttHeader->getString(j).cstr(), "Content-Id: ");
      if (p > 0) 
        {
        XString XS = XString (cid).substring (4);
        p = NCstrstr ((char *)SLAttHeader->getString(j).cstr(), (char *)XS.cstr());
        if (p > 0) 
          {
          delete SLAttachs;
          delete SLAttHeader;
          return connid;
          }
        }
      }
    }
  delete SLAttachs;
  delete SLAttHeader;
  return connid;
  }    
  
const char *CCLIENT::getTo (xulong nummsg)
  {
  const char stTO[] = "To: ";
  setError (false);
  initStr (FTo);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("To")));
      xstrncpy (FTo, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FTo);
      mail_free_stringlist (&lines);
      if (strcmp (FTo, "") == 0) return FTo;
      QuitaRetornoCarroDeLinea (FTo);
      memmove (FTo, FTo + strlen (stTO), strlen (FTo) - strlen(stTO) + 1);
      return DecodificaHeader(FTo);
      }
    }
  return FTo;    
  }    

const char *CCLIENT::getNewsGroup (xulong nummsg)
  {
  const char stNEWSGROUPS[] = "Newsgroups: ";
  setError (false);
  initStr (FNewsgroups);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Newsgroups")));
      xstrncpy (FNewsgroups, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FNewsgroups);
      mail_free_stringlist (&lines);
      if (strcmp (FNewsgroups, "") == 0) return FNewsgroups;
      QuitaRetornoCarroDeLinea (FNewsgroups);
      memmove (FNewsgroups, FNewsgroups + strlen (stNEWSGROUPS), strlen (FNewsgroups) - strlen(stNEWSGROUPS) + 1);
      return DecodificaHeader(FNewsgroups);
      }
    }
  return FNewsgroups;    
  }            
  
const char *CCLIENT::getReplyTo (xulong nummsg)
  {
  const char stREPLYTO[] = "Reply-to: ";
  setError (false);
  initStr (FReplyTo);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Reply-to")));
      xstrncpy (FReplyTo, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FReplyTo);
      mail_free_stringlist (&lines);
      if (strcmp (FReplyTo, "") == 0) return FReplyTo;
      QuitaRetornoCarroDeLinea (FReplyTo);
      memmove (FReplyTo, FReplyTo + strlen (stREPLYTO), strlen (FReplyTo) - strlen(stREPLYTO) + 1);            
      return DecodificaHeader(FReplyTo);
      }
    }
  return FReplyTo;    
  }  
  
const char *CCLIENT::getMessageId (xulong nummsg)
  {
  const char stMESSAGEID[] = "Message-id: ";
  setError (false);
  initStr (FMessageId);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Message-id")));
      xstrncpy (FMessageId, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FMessageId);
      mail_free_stringlist (&lines);
      if (strcmp (FMessageId, "") == 0) return FMessageId;
      QuitaRetornoCarroDeLinea (FMessageId);
      memmove (FMessageId, FMessageId + strlen (stMESSAGEID), strlen (FMessageId) - strlen(stMESSAGEID) + 1);            
      return DecodificaHeader(FMessageId);
      }
    }
  return FMessageId;    
  }    
  
const char *CCLIENT::getFrom (xulong nummsg)
  {
  const char stFROM[] = "From: ";
  setError (false);
  initStr (FFrom);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("From")));
      xstrncpy (FFrom, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FFrom);
      mail_free_stringlist (&lines);
      if (strcmp (FFrom, "") == 0) return FFrom;
      QuitaRetornoCarroDeLinea (FFrom);  
      memmove (FFrom, FFrom + strlen (stFROM), strlen (FFrom) - strlen(stFROM) + 1);            
      return DecodificaHeader(FFrom);
      }
    }
  return FFrom;      
  }  

const char *CCLIENT::getCC (xulong nummsg)
  {
  const char stCC[] = "Cc: ";
  setError (false);
  initStr (FCC);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Cc")));
      xstrncpy (FCC, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FCC);
      mail_free_stringlist (&lines);
      if (strcmp (FCC, "") == 0) return FCC;
      QuitaRetornoCarroDeLinea (FCC);  
      memmove (FCC, FCC + strlen (stCC), strlen (FCC) - strlen(stCC) + 1);    
      return DecodificaHeader(FCC);
      }
    }
  return FCC;      
  }  

const char *CCLIENT::getContentType (xulong nummsg)
  {
  const char stCONTENTTYPE[] = "Content-Type: ";
  int p;
  setError (false);
  initStr (FContentType);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Content-Type")));
      xstrncpy (FContentType, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FContentType);
      mail_free_stringlist (&lines);
      if (strcmp (FContentType, "") == 0) return FContentType;
      QuitaRetornoCarroDeLinea (FContentType);    
      p = NCstrstr (FContentType, ";");
      if (p > 0) {FContentType[p - 1] = '\0';}
      memmove (FContentType, FContentType + strlen (stCONTENTTYPE), strlen (FContentType) - strlen(stCONTENTTYPE) + 1);
      return FContentType;
      }
    }
  return FContentType;      
  }  

const char *CCLIENT::getSubject (xulong nummsg)
  {
  const char stSUBJECT[] = "Subject: ";
  setError (false);
  initStr (FSubject);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Subject")));
      xstrncpy (FSubject, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FSubject);
      mail_free_stringlist (&lines);
      if (strcmp (FSubject, "") == 0) return FSubject;
      QuitaRetornoCarroDeLinea (FSubject);
      memmove (FSubject, FSubject + strlen (stSUBJECT), strlen (FSubject) - strlen(stSUBJECT) + 1);
      return DecodificaHeader(FSubject);
      }
    }
  return FSubject;      
  }  

const char *CCLIENT::getContentDisposition (xulong nummsg)
  {
  const char stCONTENTDISPOSITION[] = "Content-Disposition: ";
  setError (false);
  initStr (FContentDisposition);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Content-Disposition")));
      xstrncpy (FContentDisposition, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      QuitaRetornoCarroDeLinea (FContentDisposition);
      mail_free_stringlist (&lines);
      if (strcmp (FContentDisposition, "") == 0) return FContentDisposition;
      QuitaRetornoCarroDeLinea (FContentDisposition);
      memmove (FContentDisposition, FContentDisposition + strlen (stCONTENTDISPOSITION), strlen (FContentDisposition) - strlen(stCONTENTDISPOSITION) + 1);
      return DecodificaHeader(FContentDisposition);
      }
    }
  return FContentDisposition;      
  }  

const char *CCLIENT::getDate (xulong nummsg)
  {
  const char stDATE[] = "Date: ";
  setError (false);
  initStr (FDate);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *)xstrdup ("Date")));
      xstrncpy (FDate, CMAXBUFFER, mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      Rclean (FDate);
      mail_free_stringlist (&lines);      
      if ((strcmp (FDate, "") == 0) || (FDate == NULL) || (strcmp (FDate, "\r\n") == 0)) 
        {
        xstrncpy (FDate, CMAXBUFFER, "Date: NODATE, 00 xxx 0000 00:00:00 +0000");
        }
      memmove (FDate, FDate + strlen (stDATE), strlen (FDate) - strlen(stDATE) + 1);
      return FDate;
      }
    }
  return FDate;      
  }  
  
xulong CCLIENT::getSize (xulong nummsg)
  {
  setError (false);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      MESSAGECACHE *cache;
      cache = mail_elt (getStream(), nummsg);
      return cache->rfc822_size;
      }
    }
  return 0;      
  }  
  
char *CCLIENT::getFormattedSize (xulong nummsg, TBuffer abuf)
  {
  TBuffer tmpbuf;
  initStr (abuf);
  setError (false);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      MESSAGECACHE *cache;
      cache = mail_elt (getStream(), nummsg);
      xstrncpy (abuf, CMAXBUFFER, FormatCountBytes (cache->rfc822_size, tmpbuf));
      return abuf;
      }
    }
  return abuf;      
  }    
  
void CCLIENT::dumpFullHeader (xulong nummsg, StringList *SL)
  {
  setError (false);
  SL->Clear();
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      SeparaTokensEnStringList (mail_fetchheader_full (getStream(), nummsg, NIL, NIL, NIL), '\n', SL);
      }
    }
  }

void CCLIENT::dumpFullBody (xulong nummsg, StringList *SL)
  {
  setError (false);
  SL->Clear();
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      SL->Add (mail_fetchtext (getStream(), nummsg));
      }
    }
  }

char *CCLIENT::dumpFullMsg (xulong nummsg)
  {
  setError (false);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      char *pc;
      pc = mail_fetch_message (getStream(), nummsg, NIL, NIL);
      if ((pc == NULL) || (strcmp (pc, "(null)\r\n") == 0) || (pc == NIL)) {pc = xstrdup(" ");}
      return (pc);
      }
    }
  return NULL;
  }

void CCLIENT::dumpMsg (xulong nummsg, StringList *SL)
  {
  setError (false);
  SL->Clear();
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      STRINGLIST *lines = mail_newstringlist ();
      STRINGLIST *cur = lines;
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("Date")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("From")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup (">From")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("Subject")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("To")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("cc")));
      cur = cur->next = mail_newstringlist ();
      cur->text.size = strlen ((char *) (cur->text.data = (xuchar *) xstrdup ("Newsgroups")));
      SL->Add (mail_fetchheader_full (getStream(), nummsg, lines, NIL, NIL));
      SL->Add (mail_fetchtext (getStream(), nummsg));
      mail_free_stringlist (&lines);
      }
    }
  }

char *CCLIENT::getFlags (xulong nummsg, TBuffer tmp)
  {
  setError (false);
  initStr (tmp);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      MESSAGECACHE *cache;
      cache = mail_elt (getStream(), nummsg);
      mail_fetchstructure (getStream(), nummsg, NIL);
      snprintf (tmp, CMAXBUFFER, "%c%c%c%c%c", FEMPTY, FEMPTY, FEMPTY, FEMPTY, FEMPTY);
      tmp[POS_FLAG_DELETED]   = cache->deleted                ? FDELETED  : FEMPTY; 
      tmp[POS_FLAG_ANSWERED]  = cache->answered               ? FANSWERED : FEMPTY;
      if (!cache->seen) {tmp[POS_FLAG_NEW] = FUNSEEN;}
      tmp[POS_FLAG_IMPORTANT] = cache->flagged                ? FFLAGGED  : FEMPTY;
      if (IsSearched (nummsg) == true) {tmp[POS_FLAG_SEARCHED] = FSEARCHED;} else {tmp[POS_FLAG_SEARCHED] = FEMPTY;}
      tmp[5] = '\0';    
      return tmp;
      }
    }
  return tmp;      
  }      
  
void CCLIENT::getHeaderList (xulong abeginmsg, StringList *SL, char *user, const char *maildomain, const char *tolabel, const char *TrueEmail)
  {
  xulong j, t, oldtotal, beginmsg, endmsg, aMAXMSGSFORPAGE, themsgnum;
  TBuffer tmp, xtmp; 
  TSBuffer abuf;
  TNumber anum;
  char *inter, *inter2;
  MESSAGECACHE *cache;
           
  setError (false);
  if (CALCULATEMAILBOXSIZE == 1)
    {
    if (ServerProtocol == PROTOCOL_IMAP)
      {
      //DO NOT USE WITH NNTP. WORKS BUT WASTE MANY MEMORY AND CPU
      doMailboxSize();
      }
    }
  
  SL->Clear();
  if (getStream() != NIL)
    {
    oldtotal = ILSort->Count();
    t = getTotalMsgs();
    if (t != oldtotal) {Sort();}
    
    aMAXMSGSFORPAGE = MAXMSGSFORPAGE;  
    if (aMAXMSGSFORPAGE <= 0) aMAXMSGSFORPAGE = t;
        
    beginmsg=abeginmsg; if (beginmsg <= 0) beginmsg = 1;  
    if (aMAXMSGSFORPAGE > 0)
      {
      endmsg = abeginmsg + aMAXMSGSFORPAGE - 1;
      if (endmsg > t) endmsg = t;
      }
    else endmsg = t;  

    for (j=beginmsg; j<=endmsg; ++j) 
      {
      //themsgnum = j;
      themsgnum = getNumMsgFromPosList (j);

      cache = mail_elt (getStream(), themsgnum);
      //1. POSITION
      SL->Add (xltoa(cache->msgno, anum));
      //2. FLAGS
      mail_fetchstructure (getStream(), themsgnum, NIL);
      snprintf (tmp, CMAXBUFFER, "%c%c%c%c%c", FEMPTY, FEMPTY, FEMPTY, FEMPTY, FEMPTY);
      tmp[POS_FLAG_DELETED]   = cache->deleted                ? FDELETED  : FEMPTY; 
      tmp[POS_FLAG_ANSWERED]  = cache->answered               ? FANSWERED : FEMPTY;
      if (!cache->seen) {tmp[POS_FLAG_NEW] = FUNSEEN;}
      tmp[POS_FLAG_IMPORTANT] = cache->flagged                ? FFLAGGED  : FEMPTY;
      if (IsSearched (themsgnum) == true) {tmp[POS_FLAG_SEARCHED] = FSEARCHED;} else {tmp[POS_FLAG_SEARCHED] = FEMPTY;}
      tmp[5] = '\0';       
      SL->Add (tmp);
            
      //3. DATE 
      if (USE_ARRIVAL_DATE == 1)
        {   
        mail_date (tmp, cache);
        SL->Add (ProcesaDate (tmp, xtmp));
        }
      else
        {
        MESSAGECACHE amc;
        char datebuff[101], *pc;
        xstrncpy (datebuff, 100, this->getDate(themsgnum));
        //xstrncpy (datebuff, 100, "Thu, 5 Jul 2001 18:08:16 -0700");
        pc = datebuff;
        // Debug: the offending MS Date: "        Thu, 5 Jul 2001 18:08:16 -0700";
        while (pc[0] == ' ') pc++;
        if (pc[strlen(pc) - 1] == ' ') pc[strlen(pc) - 1] = '\0';
        mail_parse_date (&amc, pc);                        
        mail_date (tmp, &amc);  
        SL->Add (ProcesaDate (tmp, xtmp));
        }
      
      //4. FROM  (If the FROM field is the same that user@maildomain then use TO field)
      if (!IsEmpty(TrueEmail))
        {
        xstrncpy (abuf, CSMALLBUFFER, TrueEmail);
        }
      else
        {  
        xstrncpy (abuf, CSMALLBUFFER, user); xstrncat (abuf, CSMALLBUFFER, "@"); xstrncat (abuf, CSMALLBUFFER, maildomain);
        }
      mail_fetchfrom_mod (tmp, getStream(), themsgnum, CMAXBUFFER - 1, 2);
      if ((strstr (tmp, abuf) == NULL) || (ServerProtocol == PROTOCOL_NNTP))
        {
        mail_fetchfrom_mod (tmp, getStream(), themsgnum, CMAXBUFFER - 1, 1);
        inter = DecodificaHeader (tmp);
        xstrncpy (xtmp, CMAXBUFFER, inter);
        delete [] inter;
        }
      else  //We use the TO field
        {
        mail_fetchto_mod (tmp, getStream(), themsgnum, CMAXBUFFER - 1, 1);
        xstrncpy (xtmp, CMAXBUFFER, tolabel); 
        inter = DecodificaHeader (tmp);
        xstrncat (xtmp, CMAXBUFFER, inter);
        delete [] inter;
        }
      SL->Add (Cut(xtmp, LONGDISPLAYFROM, tmp));    
      //5. SUBJECT
      mail_fetchsubject (tmp, getStream(), themsgnum, CMAXBUFFER - 1);
      inter2 = DecodificaHeader (tmp);
      xstrncpy (xtmp, CMAXBUFFER, inter2);
      delete [] inter2;
      Cut(xtmp, LONGDISPLAYSUBJECT, tmp);      
      int indent = getIndent (themsgnum);
      initStr (xtmp); 
      for (int i=0;i<indent;++i) 
        {xstrncat (xtmp, CMAXBUFFER, THREAD_INDENTATIONCHAR);}
      xstrncat (xtmp, CMAXBUFFER, tmp);
      SL->Add (xtmp);
      //6. SIZE
      SL->Add (FormatCountBytes (cache->rfc822_size, xtmp));
      //7. UID
      SL->Add (xltoa(cache->cclientPrivate.uid, anum));      
      }
    }  
  }

//Internal return the mailbox size. Carga???
void CCLIENT::doMailboxSize (void)
  {
  xulong j, t;
  MESSAGECACHE *cache;
  MAILBOXSIZE = 0;
  setError (false);
  if (getStream() != NIL)
    {
    t = getTotalMsgs();
    msgsmarkeddeleted = 0;
    for (j=1; j<=t; ++j) 
      {
      cache = mail_elt (getStream(), j);
      mail_fetchstructure (getStream(), j, NIL);
      MAILBOXSIZE = MAILBOXSIZE + cache->rfc822_size;
      if (cache->deleted) ++msgsmarkeddeleted;
      }
    }
  }

long CCLIENT::getMailboxSize (void)
  {
  return MAILBOXSIZE;  
  }

/* Display body
 * Accepts: BODY structure pointer
 *          prefix string
 *          index
 */
void CCLIENT::display_body (BODY *body, char *pfx, long i, StringList *SLAttach) 
  {
  char tmp[MAILTMPLEN + 1];
  char *s = tmp;
  PARAMETER *par;
  PART *part;                   /* multipart doesn't have a row to itself */
  setError (false);
  if (body->type == TYPEMULTIPART) 
    {
    /* if not first time, extend prefix */
    if (pfx) snprintf (tmp, MAILTMPLEN, "%s%ld.", pfx, ++i);
    else tmp[0] = '\0';
    for (i = 0,part = body->nested.part; part; part = part->next)
      {
      display_body (&part->body, tmp, i++, SLAttach);
      }
    }
  else 
    {
    /* non-multipart, output oneline descriptor */
    if (!pfx) pfx = "";    /* dummy prefix if top level */
    snprintf (s, MAILTMPLEN, " %s%ld %s", pfx, ++i, body_types[body->type]);
    if (body->subtype) snprintf (s += strlen (s), MAILTMPLEN, "/%s",body->subtype);
    //if (body->id) snprintf (s += strlen (s), MAILTMPLEN, ", id = %s",body->id);
    switch (body->type) 
      {   /* bytes or lines depending upon body type */
      case TYPEMESSAGE:    /* encapsulated message */
      case TYPETEXT:       /* plain text */
        snprintf (s += strlen (s), MAILTMPLEN, " %lu bytes", body->size.bytes);
        break;
      default:
        snprintf (s += strlen (s), MAILTMPLEN, " %lu bytes", body->size.bytes);
        break;
      }
    if (body->description) 
      {snprintf (s += strlen (s), MAILTMPLEN, ", \"%s\"",body->description);}
    else
      {snprintf (s += strlen (s), MAILTMPLEN, ", \"%s\"", "");}    
    
    //SEARCH FILENAME attribute IN CONTENT-DISPOSITION
    //DEBUG ("Content-Disposition=%s", body->disposition.type);
    TBuffer xFileName;
    initStr (xFileName);
    par = body->disposition.parameter;
    if (par)
      {
      do
        {
        //DEBUG ("attribute=%s,value=%s", par->attribute, par->value);
        if ((strcmp ("NAME", par->attribute) == 0) || (strcmp ("FILENAME", par->attribute) == 0))
          {          
          xstrncpy (xFileName, CMAXBUFFER, par->value);
          utils_unescape (xFileName);
          snprintf (s += strlen (s), MAILTMPLEN, ", \"%s\"", xFileName);          
          }        
        par = par->next;
        }
      while (par); 
      }
      
    //IF WE DO NOT FOUND FILENAME, WE TRY IN BODY PARMS 
    if (IsEmpty (xFileName))
      {
      par = body->parameter;
      if (par) 
        {
        do
          {
          //DEBUG ("attribute=%s,value=%s", par->attribute, par->value);        
          if ((strcmp ("NAME", par->attribute) == 0) || (strcmp ("FILENAME", par->attribute) == 0))
            {
            xstrncpy (xFileName, CMAXBUFFER, par->value);
            utils_unescape (xFileName);
            snprintf (s += strlen (s), MAILTMPLEN, ", \"%s\"", xFileName);
            }
          par = par->next;
          }
        while (par);
        }
      }
    //IF IS EMPTY YET, WE PUT DOUBLE \"
    if (IsEmpty (xFileName))
      {            
      xstrncat (s += strlen (s), MAILTMPLEN, ", \"\"");
      }
      
    SLAttach->Add(tmp);
    /* encapsulated message? */
    if ((body->type == TYPEMESSAGE) && !strcmp (body->subtype,"RFC822") &&
        (body = body->nested.msg->body)) 
      {
      if (body->type == TYPEMULTIPART) display_body (body, pfx, i-1, SLAttach);
      else 
        {/* build encapsulation prefix */
        snprintf (tmp, MAILTMPLEN, "%s%ld.", pfx, i);
        display_body (body, tmp, (long) 0, SLAttach);
        }
      }
    }
  }

void CCLIENT::getBodyStructure (xulong nummsg, StringList *SLAttachs) 
  {
  BODY *body;
  SLAttachs->Clear();
  setError (false);
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      mail_fetchstructure (getStream(), nummsg, &body);
      if (body) display_body (body, NIL, (long) 0, SLAttachs);
      }
    }
  }

void CCLIENT::getAttachInfo (BODY *body, char *oripfx, char *pfx, long i, StringList *SLAttach, StringList *SLFullHeader) 
  {
  TBuffer theprefix, name, filename;
  TNumber anum;
  char tmp[MAILTMPLEN + 1];
  char *s = tmp;
  PARAMETER *par;
  PART *part;                   /* multipart doesn't have a row to itself */
  setError (false);
  if (body->type == TYPEMULTIPART) 
    {
    /* if not first time, extend prefix */
    if (pfx) snprintf (tmp, MAILTMPLEN, "%s%ld.", pfx, ++i);
    else tmp[0] = '\0';
    for (i = 0,part = body->nested.part; part; part = part->next)
      {
      getAttachInfo (&part->body, oripfx, tmp, i++, SLAttach, SLFullHeader);
      }
    }
  else 
    {
    /* non-multipart, output oneline descriptor */
    if (!pfx) pfx = "";    /* dummy prefix if top level */
    snprintf (s, MAILTMPLEN, " %s%ld %s", pfx, ++i, body_types[body->type]);
    snprintf (theprefix, CMAXBUFFER, "%s%ld", pfx, i);
    if (body->subtype) snprintf (s += strlen (s), MAILTMPLEN, "/%s", body->subtype);
    switch (body->type) 
      { 
      case TYPEMESSAGE:    /* encapsulated message */
      case TYPETEXT:       /* plain text */
        snprintf (s += strlen (s), MAILTMPLEN, " (%lu lines)", body->size.lines);
        break;
      default:
        snprintf (s += strlen (s), MAILTMPLEN, " (%lu bytes)", body->size.bytes);
        break;
      }      
    //1 theprefix
    //2 tmp info
    //3 codec
    //4 type
    //5 subtype
    //6 description
    //7 name
    //8 filename 
    //9 size.bytes 
    if (strcmp (oripfx, theprefix) == 0)
      {
      SLAttach->Add (theprefix);  
      SLAttach->Add (tmp);
      SLAttach->Add (xltoa(body->encoding, anum));
      SLAttach->Add (body_types[body->type]);
      if (body->subtype) SLAttach->Add (body->subtype); else SLAttach->Add ("");
      if (body->description) SLAttach->Add (body->description); else SLAttach->Add ("");   
      name[0] = '\0'; filename[0] = '\0';
      par = body->parameter;
      if (par) 
        {
        do
          {
          if (strcmp ("NAME", par->attribute) == 0) xstrncpy (name, CMAXBUFFER, par->value);
          if (strcmp ("FILENAME", par->attribute) == 0) xstrncpy (filename, CMAXBUFFER, par->value);
          par = par->next;
          }
        while (par);
        }     
      if (name) SLAttach->Add (name); else SLAttach->Add ("");
      if (filename) SLAttach->Add (filename); else SLAttach->Add ("");   
      SLAttach->Add (xltoa(body->size.bytes, anum));
      }
    /* encapsulated message? */
    if ((body->type == TYPEMESSAGE) && !strcmp (body->subtype,"RFC822") &&
        (body = body->nested.msg->body)) 
      {
      if (body->type == TYPEMULTIPART) getAttachInfo (body, oripfx, pfx, i-1, SLAttach, SLFullHeader);
      else 
        {/* build encapsulation prefix */
        snprintf (tmp, MAILTMPLEN, "%s%ld.", pfx, i);
        getAttachInfo (body, oripfx, tmp, (long) 0, SLAttach, SLFullHeader);
        }
      }
    }
  }

char *CCLIENT::getAttHeaderPC (xulong nummsg, char *attid)
  {
  xulong lensource;
  char *pc = NULL;
  setError (false);
  if (getStream() != NIL) 
    {        
    pc = mail_fetch_mime (getStream(), nummsg, attid, &lensource, 0);
    }
  return pc;
  }
    
void CCLIENT::getAttHeaderSL (xulong nummsg, char *attid, StringList *SL)
  {
  xulong lensource;
  char *pc = NULL;
  setError (false);
  if (getStream() != NIL) 
    {        
    pc = mail_fetch_mime (getStream(), nummsg, attid, &lensource, 0);
    PChar2SL (pc, SL);    
    }
  }

char *CCLIENT::getAttBody (xulong nummsg, char *attid, StringList *SLAttachInfo, xulong *len, bool decodificar)
  {
  xulong lensource;
  char *pc, *pc2;
  setError (false);
  SLAttachInfo->Clear();
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      BODY *body;
      mail_fetchstructure (getStream(), nummsg, &body);
      if (body) 
        {        
        StringList *SLFullHeader;
        SLFullHeader = new StringList ();        
        getAttachInfo (body, attid, NIL, (long) 0, SLAttachInfo, SLFullHeader);
        delete SLFullHeader;
        if (SLAttachInfo->Count() <= 0) return NULL;
        int codec;
        codec = xatoidef((char *)SLAttachInfo->getString(2).cstr(), 0);
        switch (codec)
          {
          case ENCBASE64: 
            pc  = mail_fetchbody (getStream(), nummsg, attid, &lensource);
            if (decodificar == true)
              {
              pc2 = (char *) rfc822_base64 ((xuchar *)pc, lensource, len);
              return pc2;
              }
            else return pc;
            break;             
          case ENCQUOTEDPRINTABLE:
            pc  = mail_fetchbody (getStream(), nummsg, attid, &lensource);
            if (decodificar == true)
              {
              pc2 = (char *) rfc822_qprint ((xuchar *)pc, lensource, len);
              return pc2;
              }
            else return pc;
            break;
          default: 
            pc = mail_fetchbody (getStream(), nummsg, attid, len);
            if (strcmp (pc, "(null)\r\n") == 0) {return " ";}
            return pc;
            break;
          }
        }
      }
    }
  return NULL;
  }

xulong CCLIENT::getAttSize (xulong nummsg, char *attid, StringList *SLAttachInfo)
  {
  xulong lensource;
  setError (false);
  SLAttachInfo->Clear();
  lensource = 0;
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      BODY *body;
      mail_fetchstructure (getStream(), nummsg, &body);
      if (body) 
        {        
        StringList *SLFullHeader;
        SLFullHeader = new StringList ();        
        getAttachInfo (body, attid, NIL, (long) 0, SLAttachInfo, SLFullHeader);
        delete SLFullHeader;
        if (SLAttachInfo->Count() <= 0) {return 0;}
        lensource = xatoidef((char *)SLAttachInfo->getString(8).cstr(), 0);
        }
      }
    }
  return lensource;
  }

bool CCLIENT::getAttBodyToFile (xulong nummsg, char *attid, StringList *SLAttachInfo, xulong *len, char *fname, bool decodificar)
  {
  xulong lensource;
  char *pc, *pc2;
  setError (false);
  SLAttachInfo->Clear();
  if (getStream() != NIL) 
    {
    if (nummsg && (nummsg <= getStream()->nmsgs)) 
      {
      BODY *body;
      int codec;
      mail_fetchstructure (getStream(), nummsg, &body);
      if (body) 
        {
        int fd;
        StringList *SLFullHeader;
        SLFullHeader = new StringList ();        
        getAttachInfo (body, attid, NIL, (long) 0, SLAttachInfo, SLFullHeader);
        delete SLFullHeader;
        if (SLAttachInfo->Count() <= 0) return false;        
        fd = open (fname, O_WRONLY | O_CREAT, 0600);
        if (fd == -1) {return false;}
        codec = xatoidef((char *)SLAttachInfo->getString(2).cstr(), 0);
        switch (codec)
          {
          case ENCBASE64: 
            pc  = mail_fetchbody (getStream(), nummsg, attid, &lensource);
            if (decodificar == true)
              {
              pc2 = (char *) rfc822_base64 ((xuchar *)pc, lensource, len);
              write (fd, pc2, (xuint)*len);
              }
            else write (fd, pc, (xuint)lensource);
            break;             
          case ENCQUOTEDPRINTABLE:
            pc  = mail_fetchbody (getStream(), nummsg, attid, &lensource);
            if (decodificar == true)
              {
              pc2 = (char *) rfc822_qprint ((xuchar *)pc, lensource, len);
              write (fd, pc2, (xuint)*len);
              }
            else write (fd, pc, (xuint)lensource);
            break;
          default: 
            pc = mail_fetchbody (getStream(), nummsg, attid, len);
            write (fd, pc, (xuint)*len);
            break;
          }
        close (fd);
        }
      }
    return true;
    }
  else return false;
  }

int CCLIENT::setFlags (char *flags, char *pcmessages)
  {
  setError (false);
  if (getStream() != NIL) 
    {
    if (pcmessages == NULL) return 0;
    mail_setflag (getStream(), pcmessages, flags);                 
    return CountChar (pcmessages, ',') + 1;
    }
  return 0;    
  }

int CCLIENT::clearFlags (char *flags, char *pcmessages)
  {
  setError (false);
  if (getStream() != NIL) 
    {
    if (pcmessages == NULL) return 0;
    mail_clearflag (getStream(), pcmessages, flags);                 
    return CountChar (pcmessages, ',') + 1;
    }
  return 0;    
  }
  
int CCLIENT::copyMessages (const char *mailboxname, char *pcmessages)
  {
  long options;
  TBuffer abuf, abuf2;
  setError (false);
  if (getStream() != NIL) 
    {                                   
    if ((pcmessages == NULL) || (mailboxname == NULL)) return 0;
    xstrncpy (abuf, CMAXBUFFER, getBriefMailbox(mailboxname, abuf2));
    options = 0;
    if (mail_copy_full (getStream(), pcmessages, abuf, options) == NIL) return 0;
    else return CountChar (pcmessages, ',') + 1;
    } 
  else return 0;   
  }  
               
int CCLIENT::moveMessages (const char *mailboxname, char *pcmessages)
  {
  long options;
  TBuffer abuf, abuf2;
  setError (false);
  if (getStream() != NIL) 
    {                                   
    if ((pcmessages == NULL) || (mailboxname == NULL)) return 0;
    xstrncpy (abuf, CMAXBUFFER, getBriefMailbox(mailboxname, abuf2));
    options = CP_MOVE;
    if (mail_copy_full (getStream(), pcmessages, abuf, options) == NIL) return 0;
    else return CountChar (pcmessages, ',') + 1;
    }
  else return 0;    
  }  
  
void CCLIENT::getMailboxes (StringList *SL, StringList *SLSubscribedGroups, bool refreshIMAPFolders, bool ALLOW_NNTP)
  {
  char *pc, *pc1, *pc2;
  TBuffer abuf, abuf2, abuf3, mbinbox;
  setError (false);
  if (refreshIMAPFolders == true)
    {
    delete SLMailboxes;
    SLMailboxes = new StringList();
    mail_list (getIMAPStream(), "", getFullMailbox ("*", abuf3));
    }
  xstrncpy (mbinbox, CMAXBUFFER, getFullMailbox("INBOX", abuf3));  
  if (SLMailboxes->indexOf (mbinbox) < 0) {SLMailboxes->Add(mbinbox);}
    
  for (int i=0; i<SLMailboxes->Count(); ++i) 
    {
    //LOG ("mailbox %d='%s'", i, SLMailboxes->getString(i).cstr());
    pc1 = strstr (SLMailboxes->getString(i).cstr(), "}");
    if (pc1 != NULL) {xstrncpy (abuf, CMAXBUFFER, pc1 + 1);} 
    else {xstrncpy (abuf, CMAXBUFFER, SLMailboxes->getString(i).cstr());}
    
    pc = strstr (abuf, getPathToRemoteFolder());
    if (pc != NULL) 
      {
      pc2 = pc + strlen(getPathToRemoteFolder());
      xstrncpy (abuf2, CMAXBUFFER, HTML_DCOMILLAS); 
      xstrncat (abuf2, CMAXBUFFER, pc2);
      xstrncat (abuf2, CMAXBUFFER, HTML_DCOMILLAS);
      SL->Add (abuf2);
      }
    else
      {
      xstrncpy (abuf2, CMAXBUFFER, HTML_DCOMILLAS);
      xstrncat (abuf2, CMAXBUFFER, pc1 + 1);
      xstrncat (abuf2, CMAXBUFFER, HTML_DCOMILLAS);
      SL->Add (abuf2);
      }  
    }
    
  if ((ALLOW_NNTP == 1) && (SLSubscribedGroups != NULL)) //Add Subscribed News Groups
    {
    SL->Add (FORM_SELECT_SEPARATOR);
    for (int i=0; i<SLSubscribedGroups->Count(); ++i) 
      {
      if (strcmp (SLSubscribedGroups->getString(i).cstr(), "") != 0)
        {
        xstrncpy (abuf2, CMAXBUFFER, HTML_DCOMILLAS);
        xstrncat (abuf2, CMAXBUFFER, NNTPFOLDERHTMLPREFIX);
        xstrncat (abuf2, CMAXBUFFER, SLSubscribedGroups->getString(i).cstr());
        xstrncat (abuf2, CMAXBUFFER, HTML_DCOMILLAS);
        SL->Add (abuf2);
        }
      }
    }
    
  sortMailboxes (SL);    
  }

bool CCLIENT::createMailbox (char *mailboxname)
  {
  TBuffer abuf, abuf2;
  setError (false);
  xstrncpy (abuf, CMAXBUFFER, getFullMailbox(mailboxname, abuf2));
  if (mail_create (getStream(), abuf) == NIL) return false;
  else return true; 
  return false;  
  }
  
bool CCLIENT::deleteMailbox (char *mailboxname)
  {
  TBuffer abuf, abuf2;
  setError (false);
  if (strcmp (mailboxname, getMailboxName()) == 0) {return false;}
  xstrncpy (abuf, CMAXBUFFER, getFullMailbox(mailboxname, abuf2));
  if (mail_delete (getStream(), abuf) == NIL) return false; 
  else return true;
  return false;    
  }
  
bool CCLIENT::renameMailbox (char *oldmailboxname, char *newmailboxname)
  {
  TBuffer abufold, abufnew, abuf;
  setError (false);
  if (strcmp (oldmailboxname, getMailboxName()) == 0) {return false;}    
  xstrncpy (abufold, CMAXBUFFER, getFullMailbox(oldmailboxname, abuf));
  xstrncpy (abufnew, CMAXBUFFER, getFullMailbox(newmailboxname, abuf));
  if (mail_rename (getStream(), abufold, abufnew) == NIL) return false; 
  else return true;
  return false;    
  }
  
//ONLY FOR IMAP STREAM
bool CCLIENT::appendMsg (char *mailbox, STRING *msg)
  {
  TBuffer abuf;
  long L;
  setError (false);
  
  //LOG ("mailbox=%s", mailbox);
  //LOG ("getFullMailbox=%s", getFullMailbox(mailbox, abuf));
    
  L = mail_append (getIMAPStream(), getFullMailbox(mailbox, abuf), msg);
  if (L == 0) return false;
  else return true;
  }

//*****************  MODIFIED FUNCTIONS OF CCLIENT LIBRARY  ************************

//Options: 1 Only Personal Name, Address if Personal name not exists
//         2 Only Address
//         3 All
void mail_fetchfrom_mod (char *s,MAILSTREAM *stream,unsigned long msgno, long length, int option)
  {
  char *t = NULL, tmp[MAILTMPLEN + 1];
  ENVELOPE *env = mail_fetchenvelope (stream,msgno);
  ADDRESS *adr = env ? env->from : NIL;
  memset (s,' ',(size_t)length);               /* fill it with spaces */
  s[length] = '\0';                            /* tie off with null */
  while (adr && !adr->host) adr = adr->next;   /* get first from address from envelope */
  if (adr) 
    {
    switch (option)
      {
      case 1: if (!(t = adr->personal)) snprintf (t = tmp, MAILTMPLEN, "%.256s@%.256s",adr->mailbox, adr->host); 
              break;
      case 2: snprintf (t = tmp, MAILTMPLEN, "%.256s@%.256s",adr->mailbox,adr->host); 
              break;
      case 3: snprintf (t = tmp, MAILTMPLEN, "%.256s%.256s@%.256s", adr->personal, adr->mailbox, adr->host);
              break; 
      }
    memcpy (s,t,(size_t) min (length,(long) strlen (t)));      
    }
  }

//Options: 1 Only Personal Name, Address if Personal name not exists
//         2 Only Address
//         3 All
void mail_fetchto_mod (char *s,MAILSTREAM *stream,unsigned long msgno, long length, int option)
  {
  char *t = NULL, tmp[MAILTMPLEN + 1];
  ENVELOPE *env = mail_fetchenvelope (stream,msgno);
  ADDRESS *adr = env ? env->to : NIL;
  memset (s,' ',(size_t)length);               /* fill it with spaces */
  s[length] = '\0';                            /* tie off with null */
  while (adr && !adr->host) adr = adr->next;   /* get first to address from envelope */
  if (adr) 
    {
    switch (option)
      {
      case 1: if (!(t = adr->personal)) snprintf (t = tmp, MAILTMPLEN, "%.256s@%.256s",adr->mailbox, adr->host); 
              break;
      case 2: snprintf (t = tmp, MAILTMPLEN, "%.256s@%.256s",adr->mailbox,adr->host); 
              break;
      case 3: snprintf (t = tmp, MAILTMPLEN, "%.256s%.256s@%.256s", adr->personal, adr->mailbox, adr->host);
              break; 
      }
    memcpy (s,t,(size_t) min (length,(long) strlen (t)));      
    }
  }
  
//BUSCA EN EL BUZON ABIERTO CON CRITERIO IMAP2  
//Return the number of hints in the search
//Examples of criterion:
//               ALL     SUBJECT "pepe is here"
//               DELETED FROM    "SMITH"        SINCE 1-OCT-87
//
// range:     ALL, ANSWERED, DELETED, FLAGGED, NEW, OLD, RECENT, SEEN, UNANSWERED, UNDELETED, UNFLAGGED, UNSEEN
// imaptoken: BCC, BODY, CC, KEYWORD, SUBJECT, TEXT, TO, UNKEYWORD
// from:      BEFORE, FROM, ON, SINCE
int CCLIENT::searchFolder2 (char *range, int token, char *whatsearch, char *from, char *fecha)
  {
  TBuffer criterion;
  setError (false);
  SLSearch->Clear();
  XSearch = " ";
  if (getStream() != NIL) 
    {
    initStr(criterion);
    if (range == NULL) {xstrncpy (criterion, CMAXBUFFER, "ALL");} else {xstrncpy(criterion, 50, range);}
    xstrncat (criterion, CMAXBUFFER, " ");
    switch (token)
      {
      case 1:
        xstrncat (criterion, CMAXBUFFER, "SUBJECT");
        break;
      case 2:
        xstrncat (criterion, CMAXBUFFER, "FROM");
        break;
      case 3:
        xstrncat (criterion, CMAXBUFFER, "BODY");
        break;
      default:
        xstrncat (criterion, CMAXBUFFER, "TEXT");
        break;
      }      
    xstrncat (criterion, CMAXBUFFER, " ");
    if (whatsearch == NULL) 
      {
      xstrncat (criterion, CMAXBUFFER, "\"NOTHING TO SEARCH\"");
      } 
    else 
      {
      xstrncat (criterion, CMAXBUFFER, "\""); 
      xstrncat (criterion, 500, whatsearch); 
      xstrncat (criterion, CMAXBUFFER, "\"");
      }
    if (from != NULL)
      {
      xstrncat (criterion, CMAXBUFFER, " "); 
      xstrncat (criterion, 100, from); 
      if (fecha != NULL)
        {
        xstrncat (criterion, CMAXBUFFER, " "); 
        xstrncat (criterion, 100, fecha);
        }
      }
    mail_search (getStream(), criterion);                 
    
    /***** DEBUG *****/
    /*        
    DEBUG ("--%d--", imaptoken);
    DEBUG ("--%s--", criterion);
    DEBUG ("--%s--", (char *)XSearch.cstr());
    DEBUG ("--%ld--", SLSearch->Count());
    for (int i = 0; i < SLSearch->Count(); ++i) {DEBUG ("-%s--", (char *)SLSearch->getString(i).cstr());}
    */
    return SLSearch->Count();
    }
  return 0;    
  }    

void CCLIENT::addResultToSearch (xulong msgnum)
  {
  TNumber anum;
  SLSearch->Add(xltoa(msgnum, anum));
  XSearch += xltoa((int)msgnum, anum); XSearch += " ";  
  }

bool CCLIENT::delMsgInSearchList (xulong msgnum)
  {
  xulong au;
  for (int i=0; i < SLSearch->Count(); ++i)
    {
    au = atoi((char *)SLSearch->elementAt(i).cstr());
    if (au == msgnum) 
      {
      SLSearch->removeElementAt (i); 
      XSearch = " ";
      for (int j=0; j < SLSearch->Count(); ++j)
        {
        XSearch += (char *)SLSearch->elementAt(j).cstr(); XSearch += " ";
        }
      return true;
      }
    }
  return false;
  }
  
void CCLIENT::addMsgInSearchList (xulong msgnum)
  {  
  TNumber anum;
  SLSearch->Add(xltoa(msgnum, anum));
  XSearch = " ";
  for (int i=0; i < SLSearch->Count(); ++i)
    {
    XSearch += (char *)SLSearch->elementAt(i).cstr(); XSearch += " ";
    }
  }  
  
xulong CCLIENT::getNumFirstMsgInSearch (void)
  {
  if (SLSearch->Count() <= 0) return 0;
  return xatoidef ((char *)SLSearch->getString(0).cstr(), 1);
  }
  
bool CCLIENT::IsSearched (xulong nummsg)
  {
  TSBuffer stnum;
  TNumber anum;
  xstrncpy (stnum, CSMALLBUFFER, " "); 
  xstrncat (stnum, CSMALLBUFFER, xltoa (nummsg, anum));
  xstrncat (stnum, CSMALLBUFFER, " ");
  if (strstr ((char *)XSearch.cstr(), stnum) != NULL) {return true;} else {return false;}
  }  

void CCLIENT::getMsgIndex (ULongList *IL)
  {
  IL->Clear();
  for (int i = 0; i < ILSort->Count(); ++i) {IL->Add (ILSort->elementAt(i));}
  }

void CCLIENT::setSortType (int aSortType)
  {
  if (aSortType == SortType) 
    {
    if (SortReversed == true) SortReversed = false; else SortReversed = true;
    } 
  SortType = aSortType;
  }

int CompareMailboxes (const void *e1, const void *e2)
  {
  XString *xs1, *xs2;
  int res;
  char c1;
  
  xs1 = (XString *)e1;
  xs2 = (XString *)e2;
  
  if (((char *)(xs1->cstr()) == NULL) || ((char *)(xs2->cstr()) == NULL)) {return 1;}
  
  c1 = ((char *)(xs1->cstr())) [0];
  if (isalpha(c1) == 0) {return 1;}
  
  res = strcasecmp ((char *)(xs1->cstr()), (char *)(xs2->cstr()));
  return res;
  }

void FlipMailboxes (const void *e1, const void *e2)
  {
  XString *xs1, *xs2, *temp;
  xs1 = (XString *)e1;
  xs2 = (XString *)e2;
  temp = new XString (*xs1);
  *xs1  = *xs2;
  *xs2  = *temp;    
  }

//SORT and Put INBOX in the first position of the StringList
void CCLIENT::sortMailboxes (StringList *SL)
  {
  int p;
  XString XS;
  if (SL->Count() <= 0) {return;}
  SL->SORT (CompareMailboxes, FlipMailboxes);
  p = SL->indexOf (HTML_DCOMILLAS"INBOX"HTML_DCOMILLAS);
  if (p > 0)
    {
    XS = SL->getString(0);
    SL->setElementAt(XString(HTML_DCOMILLAS"INBOX"HTML_DCOMILLAS), 0); 
    SL->setElementAt(XS, p);
    }
  else
    {
    return;
    }
  }

void CCLIENT::PathTool (const char *mailbox, int *numseps, int *poslastsep)
  {
  char c;
  *numseps = 0;
  *poslastsep = -1;
  for (unsigned int i=0; i < strlen(mailbox); ++i)
    {
    c = (unsigned char)mailbox[i];
    if (c == getDelimiter ()) {++(*numseps); *poslastsep = i;}
    }  
  }

char *CCLIENT::expandMailboxName (const char *mailbox, TBuffer SentMailBox)
  {
  initStr (SentMailBox);
  if (mailbox[0] == '/')
    {
    xstrncat (SentMailBox, CMAXBUFFER, (char *)mailbox[1]);
    }
  else if (NCstrstr (mailbox, NNTPFOLDERPREFIX) == 1) //Mailbox from News
    {
    xstrncpy (SentMailBox, CMAXBUFFER, mailbox);
    }
  else if (strcasecmp (mailbox, "INBOX") == 0) 
    {
    xstrncpy (SentMailBox, CMAXBUFFER, mailbox);
    }    
  else
    { 
    xstrncat (SentMailBox, CMAXBUFFER, getMailboxPrefix());
    xstrncat (SentMailBox, CMAXBUFFER, mailbox);
    }  
  return SentMailBox;
  }

//For get indentation for threaded messages
int CCLIENT::getIndent (xulong nummsg)
  {
  if (PListIndent != NULL)
    {
    int indent;
    indent = PListIndent[nummsg - 1];
    if (indent > THREAD_MAXINDENTATION) {indent = THREAD_MAXINDENTATION;}
    indent = indent * THREAD_LENGTHINDENTATION;
    return indent;
    }
  return 0;  
  }

//SORT
int CCLIENT::Sort (void)
  {
  if (getStream() != NIL) 
    {     
    if (PListIndent != NULL) {free (PListIndent); PListIndent = NULL;}
    if (SortType == NO_SORT)
      {
      ILSort->Clear();
      if (SortReversed == false) {for (long i = 1; i <= (long)getTotalMsgs(); ++i) {ILSort->Add (i);}}
      else {for (long i = (long)getTotalMsgs(); i >= 1; --i) {ILSort->Add (i);}}
      return 0;
      } 
    SEARCHPGM *spg = NULL;
    SORTPGM *pgm = NULL, *pgm2 = NULL;
    spg = mail_newsearchpgm ();  
    pgm = mail_newsortpgm ();
    pgm2 = mail_newsortpgm (); 
    if (SortReversed == true) {pgm->reverse = 1; pgm2->reverse = 1;} else {pgm->reverse = 0; pgm2->reverse = 0;}
    pgm->function = SortType; pgm->next = pgm2;
    if (SortType == SORTSUBJECT) SortType2 = SORTARRIVAL; else SortType2 = SORTSUBJECT;
    pgm2->function = SortType2; pgm2->next = NIL;

    if (SortType != SORTTHREAD)
      {      
      PLongListSort = (long *)mail_sort (getStream(), THECHARSET, spg, pgm, NIL);
      if (PLongListSort != NULL)
        {
        ILSort->Clear();
        long *sl;
        for (sl = PLongListSort; *sl; sl++) {if (*sl) {ILSort->Add ((long)*sl);}}
        free (PLongListSort);
        }
      }
    else
      {
      //SORTING BY THREADS
      THREADNODE *thread;
      mail_parameters (NIL, SET_THREADRESULTS, (void *) sort_thread_callback);
      //thread = mail_thread (getStream(), (char *)"ORDEREDSUBJECT", THECHARSET, spg, 0L);
      thread = mail_thread (getStream(), (char *)"REFERENCES", THECHARSET, spg, 0L); 
      mail_parameters (NIL, SET_THREADRESULTS, (void *) NULL);
      if (thread) 
        {
        mail_free_threadnode (&thread);      
        if (PLongListSort != NULL)
          {
          ILSort->Clear();
          for (long LL=0; LL < getTotalMsgs(); ++LL) 
            {
            xulong xu = (xulong)PLongListSort[LL];
            ILSort->Add (xu);
            }
          free (PLongListSort);
          } 
        }
      else
        {
        DEBUG ("Sort by thread is NULL");
        ILSort->Clear();
        if (SortReversed == false) {for (long i = 1; i <= (long)getTotalMsgs(); ++i) {ILSort->Add (i);}}
        else {for (long i = (long)getTotalMsgs(); i >= 1; --i) {ILSort->Add (i);}}
        }        
      }
    if (pgm != NULL)  {mail_free_sortpgm (&pgm);}
    if (spg != NULL)  {mail_free_searchpgm (&spg);}    
    }

  return 0;    
  }    

void sort_thread_callback (MAILSTREAM *stream, THREADNODE *tree)
  {
  long sz, depth = 0;
  sz = thecclient->getTotalMsgs() * sizeof(long);
  PLongListSort = (long *) malloc (sz); memset (PLongListSort, 0, sz);
  sz = thecclient->getTotalMsgs() * sizeof(int);
  PListIndent = (int *) malloc (sz); memset (PListIndent, 0, sz);  
  (void) sort_thread (tree, PLongListSort, depth);
  }

//Recursive function
long *sort_thread (THREADNODE *node, long *entry, long depth)
  {
  bool LastIsNodeNum;
  if(node)
    {
    if(node->num)
      {  
      LastIsNodeNum = true; 
      long n = (long) (entry - PLongListSort);
      for (; n > 0; n--)
        {
        if(PLongListSort[n] == (long)node->num) break; 
        }
      if (!n) //n==0 
        {
        //DEBUG ("msgnum=%d,depth=%d", node->num, depth);
        PListIndent[node->num - 1] = depth;
        *entry = node->num; 
        ++entry;
        }
      }
    else
      {
      LastIsNodeNum = false;
      }  
    if (node->next)   
      {
      if (LastIsNodeNum == true) {++depth;}
      //++depth;
      entry = sort_thread (node->next, entry, depth);
      if (LastIsNodeNum == true) {--depth;}
      }
    if (node->branch) 
      {
      entry = sort_thread (node->branch, entry, depth); 
      }
    }
  return(entry);
  }

//********************************************************
//*****************  CALLBACKS   *************************
//********************************************************


void mm_login (NETMBX *mb, char *user, char *pwd, long trial)
  {
  xstrncpy (user, 50, thecclient->getUsername());
  xstrncpy (pwd,  50, thecclient->getPassword());
  //DEBUG ("mm_login--%s--%s--%ld--", user, pwd, trial);
  }

void mm_log (char *string, long errflg)
  {
  //NIL=0,WARN=1,ERROR=2
  //DEBUG ("mm_log--%ld--%s--", errflg, string);   
  //Avoid a msg without many interes or worked in other place
  if (strstr (string, "No state for newsgroup ") != NULL) {return;}
#ifdef AVOID_IMAP_MSG_MAILBOXVULNERABLE 
  if (strstr (string, "Mailbox vulnerable") != NULL) {return;}
#endif
  //CYRUS mm_log--1--Login failed: authentication failure
  //WASH  mm_log--2--Can not authenticate to IMAP server: Authentication failure
  if ((errflg == ERROR) || 
      ((errflg == WARN) && (strcmp (string, "Login failed: authentication failure") == 0)))
    {thecclient->setError (true); thecclient->setErrorString (string);}
  else if (errflg == WARN) 
    {thecclient->setWarningString (string);}
  if (thecclient->isDebug() == true) {printf ("mm_log=%ld %s\n", errflg, string); fflush(stdout);}
  }

void mm_dlog (char *string)
  {
  //DEBUG ("mm_dlog--%s--", string);  
  if (thecclient->isDebug() == true) {printf ("mm_dlog=%s\n", string); fflush(stdout);}
  }

void mm_fatal (char *string)
  {
  thecclient->setError (true);
  thecclient->setErrorString (string);  
  if (thecclient->isDebug() == true) {printf ("mm_fatal=%s\n", string); fflush(stdout);}
  }

void mm_status (MAILSTREAM *TheStream, char *mailbox, MAILSTATUS *status)
  {
  if (thecclient->isDebug() == true) 
    {
    printf ("Mailbox %s",mailbox);
    if (status->flags & SA_MESSAGES) printf (", %lu messages",status->messages);
    if (status->flags & SA_RECENT) printf (", %lu recent",status->recent);
    if (status->flags & SA_UNSEEN) printf (", %lu unseen",status->unseen);
    if (status->flags & SA_UIDVALIDITY) printf (", %lu UID validity", status->uidvalidity);
    if (status->flags & SA_UIDNEXT) printf (", %lu next UID",status->uidnext);
    printf ("\n");  
    }
  }

void mm_list (MAILSTREAM *TheStream, int delim, char *name, long attrib)
  {
  //LOG ("mm_list name=%s,delim=%d,attrib=%ld", name, delim, attrib);
  if (delim > 0) {thecclient->setDelimiter(delim);}
  if (thecclient->isDebug() == true)
    {
    printf ("MAILBOX=%d %s %ld\n", delim, name, attrib);
    if (attrib & LATT_NOSELECT)    printf ("   no select\n"); 
    if (attrib & LATT_NOINFERIORS) printf ("   no inferiors\n");
    if (attrib & LATT_MARKED)      printf ("   marked\n");
    if (attrib & LATT_UNMARKED)    printf ("   unmarked\n");
    }
  if (attrib & LATT_NOSELECT) {} else 
    {
    if (name != NULL) 
      {
      thecclient->addMailbox (name);
      }
    }
  }

void mm_notify (MAILSTREAM *TheStream, char *string, long errflg)
  {
  //LOG ("notify='%s',errflg=%ld", string, errflg);
#ifdef AVOID_IMAP_MSG_MAILBOXVULNERABLE 
  if (strstr (string, "Mailbox vulnerable") != NULL) {return;}
#endif
  if (errflg == ERROR)
  //if ((errflg == (long)2) || (errflg == (long)1) || (errflg == (long)4))
    {thecclient->setError (true); thecclient->setErrorString (string);}
  mm_log (string, errflg);
  }

long mm_diskerror (MAILSTREAM *TheStream, long errcode, long serious)
  {
  thecclient->setError (true);  
  thecclient->setErrorString ("Disk Error");
  kill (getpid (), SIGSTOP);
  return NIL;
  }

void mm_searched (MAILSTREAM *TheStream, xulong number)
  {
  thecclient->addResultToSearch (number);
  }

//doTCPTimeout - C-client callback to handle tcp-related timeouts.
long doTCPTimeout (long elapsed, long sincelast)
  {
  LOG ("TCPTimeout: %ld seconds", elapsed);
  ErrorPage (L->getStLang());
  fflush (stdout); 
  //1L wait the connection, 0L for break.
  exit (0);
  return (0L);
  }

//NO USED CALLBACKS
void mm_critical (MAILSTREAM *TheStream) {}
void mm_nocritical (MAILSTREAM *TheStream) {}
void mm_exists (MAILSTREAM *TheStream, xulong number) {}
void mm_expunged (MAILSTREAM *TheStream, xulong number) {}
void mm_lsub (MAILSTREAM *TheStream, int delim, char *name, long attrib) {}
void mm_flags (MAILSTREAM *TheStream, xulong number) {}





