/*
 * PaperKind.cs - Implementation of the
 *			"System.Drawing.Printing.PaperKind" class.
 *
 * Copyright (C) 2003  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace System.Drawing.Printing
{

public enum PaperKind
{
	Custom								= 0,
	Letter								= 1,
	LetterSmall							= 2,
	Tabloid								= 3,
	Ledger								= 4,
	Legal								= 5,
	Statement							= 6,
	Executive							= 7,
	A3									= 8,
	A4									= 9,
	A4Small								= 10,
	A5									= 11,
	B4									= 12,
	B5									= 13,
	Folio								= 14,
	Quarto								= 15,
	Standard10x14						= 16,
	Standard11x17						= 17,
	Note								= 18,
	Number9Envelope						= 19,
	Number10Envelope					= 20,
	Number11Envelope					= 21,
	Number12Envelope					= 22,
	Number14Envelope					= 23,
	CSheet								= 24,
	DSheet								= 25,
	ESheet								= 26,
	DLEnvelope							= 27,
	C5Envelope							= 28,
	C3Envelope							= 29,
	C4Envelope							= 30,
	C6Envelope							= 31,
	C65Envelope							= 32,
	B4Envelope							= 33,
	B5Envelope							= 34,
	B6Envelope							= 35,
	ItalyEnvelope						= 36,
	MonarchEnvelope						= 37,
	PersonalEnvelope					= 38,
	USStandardFanfold					= 39,
	GermanStandardFanfold				= 40,
	GermanLegalFanfold					= 41,
	IsoB4								= 42,
	JapanesePostcard					= 43,
	Standard9x11						= 44,
	Standard10x11						= 45,
	Standard15x11						= 46,
	InviteEnvelope						= 47,
	LetterExtra							= 50,
	LegalExtra							= 51,
	TabloidExtra						= 52,
	A4Extra								= 53,
	LetterTransverse					= 54,
	A4Transverse						= 55,
	LetterExtraTransverse				= 56,
	APlus								= 57,
	BPlus								= 58,
	LetterPlus							= 59,
	A4Plus								= 60,
	A5Transverse						= 61,
	B5Transverse						= 62,
	A3Extra								= 63,
	A5Extra								= 64,
	B5Extra								= 65,
	A2									= 66,
	A3Transverse						= 67,
	A3ExtraTransverse					= 68,
	JapaneseDoublePostcard				= 69,
	A6									= 70,
	JapaneseEnvelopeKakuNumber2			= 71,
	JapaneseEnvelopeKakuNumber3			= 72,
	JapaneseEnvelopeChouNumber3			= 73,
	JapaneseEnvelopeChouNumber4			= 74,
	LetterRotated						= 75,
	A3Rotated							= 76,
	A4Rotated							= 77,
	A5Rotated							= 78,
	B4JisRotated						= 79,
	B5JisRotated						= 80,
	JapanesePostcardRotated				= 81,
	JapaneseDoublePostcardRotated		= 82,
	A6Rotated							= 83,
	JapaneseEnvelopeKakuNumber2Rotated	= 84,
	JapaneseEnvelopeKakuNumber3Rotated	= 85,
	JapaneseEnvelopeChouNumber3Rotated	= 86,
	JapaneseEnvelopeChouNumber4Rotated	= 87,
	B6Jis								= 88,
	B6JisRotated						= 89,
	Standard12x11						= 90,
	JapaneseEnvelopeYouNumber4			= 91,
	JapaneseEnvelopeYouNumber4Rotated	= 92,
	Prc16K								= 93,
	Prc32K								= 94,
	Prc32KBig							= 95,
	PrcEnvelopeNumber1					= 96,
	PrcEnvelopeNumber2					= 97,
	PrcEnvelopeNumber3					= 98,
	PrcEnvelopeNumber4					= 99,
	PrcEnvelopeNumber5					= 100,
	PrcEnvelopeNumber6					= 101,
	PrcEnvelopeNumber7					= 102,
	PrcEnvelopeNumber8					= 103,
	PrcEnvelopeNumber9					= 104,
	PrcEnvelopeNumber10					= 105,
	Prc16KRotated						= 106,
	Prc32KRotated						= 107,
	Prc32KBigRotated					= 108,
	PrcEnvelopeNumber1Rotated			= 109,
	PrcEnvelopeNumber10Rotated			= 118,
	PrcEnvelopeNumber2Rotated			= 110,
	PrcEnvelopeNumber3Rotated			= 111,
	PrcEnvelopeNumber4Rotated			= 112,
	PrcEnvelopeNumber5Rotated			= 113,
	PrcEnvelopeNumber6Rotated			= 114,
	PrcEnvelopeNumber7Rotated			= 115,
	PrcEnvelopeNumber8Rotated			= 116,
	PrcEnvelopeNumber9Rotated			= 117

}; // enum PaperKind

}; // namespace System.Drawing.Printing
