Summary: Connectivity for psion series 5.
Name: plptools
%define version 0.10
Version: %{version}
Release: 1
Vendor: The plptools project
Packager: Fritz Elfert <fritz.elfert@to.com>
URL: http://plptools.sourceforge.net/
Source0: http://download.sourceforge.net/plptools/plptools-%{version}.tar.gz
Copyright: GPL
Group: Networking/Utilities
Requires: chkconfig >= 0.9
Buildrequires: readline-devel kdelibs-devel >= 2.1 qt-devel >= 2.2.4
BuildRoot: /tmp/plputils-buildroot

%package devel
Summary: Static library and includes for psion series 5 communication.
Group: Development/Libraries
Requires: %{name} = %{version}

%package kde
Summary: Psion support for KDE 2.1.
Group: User Interface/Desktops
Requires: %{name} = %{version} kdelibs >= 2.1 qt >= 2.2.4

%description
This package contains the programs (client and server), necessary to
communicate with a psion series 5. The psion's file-system will
be automatically mounted under /mnt/psion at the time it is
connected to your computer. If the psion is shut down or
disconnected, the contents of /mnt/psion will automatically
disappear. A second program (plpftp) allows you to transfer
files in a ftp-like manner, view and modifiy processes on your
psion and some other useful stuff.

%description devel
This package contains the static library and include files for building
programs which can communicate with a psion series 5.

%description kde
This package provides support for a new protocol prefix "psion:/" for
KDE 2.1. Any KDE application which uses KDE-conforming URLs, can access
files on the Psion. Furthermore, a plugin for Konqueror's file-properties
dialog provides access to Psions proprietary file attributes and information
about the Psion's drives as well as generic machine information.

%description -l de
Dieses Packet enthlt Programme zur Kommunikation mit einem Psion 5.
Das Dateisystem des Psion wird beim Anschlieen automatisch unter
/mnt/psion eingehngt. Wird der Psion ausgeschaltet oder das Kabel
gezogen, so verschwindet der Inhalt dieses Verzeichnisses automatisch
und erscheint erneuten Anschlieen wieder. Ein weiteres Programm ist
plpftp, welches eine FTP-hnliche Oberflche fr Dateitransfer
bietet.

%description -l de devel
Dieses Packet enthlt die statische Bibliothek und include-Dateien
zur Programm-Entwicklung von Kommunikations-software fr den Psion 5.

%description -l de kde
Dieses Packet stellt Untersttzung fr eine neues Protokoll-Prfix "psion:/"
fr KDE 2.1 bereit. Jede KDE Anwendung, die KDE-konforme URLs benutzt, kann
damit auf die Dateien eines Psion zugreifen. Weiterhin, liefert ein Plugin
fr Konqueror's Datei-Eigenschaften-Dialog Informationen ber proprietre
Psion-Dateiattribute und stellt Informationen zum Gert sowie seiner
Laufwerke zur Verfgung.

%package -n kpsion
Summary: Psion utility for KDE 2.1.
Group: User Interface/Desktops
Requires: %{name} = %{version} kdelibs >= 2.1 qt >= 2.2.4

%description -n kpsion
This package contains a KDE utility program for backup, restore and formatting
Psion drives.

%description -l de -n kpsion
Dieses Packet enthlt ein KDE werkzeug zum Backup, Restore und Formatieren
von Psion Laufwerken.

%package -n klipsi
Summary: Psion remote clipboard utility for KDE 2.1.
Group: User Interface/Desktops
Requires: %{name} = %{version} kdelibs >= 2.1 qt >= 2.2.4

%description -n klipsi
This package contains a KDE utility for using the Psion's remote clipboard
function.

%description -l de -n klipsi
Dieses Packet enthlt ein KDE Werkzeug zum Transfer der Zwischenablage
zwischen Psion und Rechner.

%changelog
* Fri May 25 2001 Fritz Elfert <fritz.elfert@to.com>
- Added klipsi subpackage

* Thu May 17 2001 Fritz Elfert <fritz.elfert@to.com>
- Official release of version 0.8

* Thu Mar  1 2001 Fritz Elfert <fritz.elfert@to.com>
- Added KDE sub-packages

* Sat Jan 20 2001 Fritz Elfert <fritz.elfert@to.com>
- Updated to latest version
- Using RPM 4 (RH 7.0)

* Mon Jan 17 2000 Fritz Elfert <fritz.elfert@to.com>
- New version 0.5 with lots of bugfixes and additions.

* Sat Aug  7 1999 Fritz Elfert <fritz.elfert@to.com>
- fixed violation of const parameters in rfsv32.cc.
- corrected BLOCKSIZE in mp.h to fix behaviour of "du" program.

%prep
%setup -q

%build
%configure --enable-kde
make

%install
mkdir -p $RPM_BUILD_ROOT/usr $RPM_BUILD_ROOT/etc/rc.d/init.d
# rpm's makeinstall doesn't work here!
make DESTDIR=$RPM_BUILD_ROOT install
install -m755 etc/psion $RPM_BUILD_ROOT/etc/rc.d/init.d

%clean
rm -rf $RPM_BUILD_ROOT

%post
ldconfig
test ! -d /mnt/psion && mkdir -p /mnt/psion
/sbin/chkconfig --add psion
/etc/rc.d/init.d/psion condrestart

%preun
if [ "$1" = 0 ]
then
	/etc/rc.d/init.d/psion stop >&2
	/sbin/chkconfig --del psion
fi

%files
%doc COPYING INSTALL CHANGES README* TODO etc/*magic patches
%{_bindir}/plpftp
%{_bindir}/plpbackup
%{_sbindir}/*
%{_mandir}/*/*
%{_libdir}/libplp.so*
%{_libdir}/libplp.la
%{_datadir}/locale/*/LC_MESSAGES/plptools.mo
%config /etc/rc.d/init.d/psion

%files devel
%doc doc/api etc/*.spec
%{_libdir}/libplp.a
%{_includedir}/%{name}/*

%files kde
%{_libdir}/kio_plp.so*
%{_libdir}/kio_plp.la
%{_libdir}/libplpprops.so*
%{_libdir}/libplpprops.la
%{_datadir}/services/*
%{_datadir}/icons/*/*/mimetypes/*
%{_datadir}/icons/*/*/devices/*
%{_datadir}/locale/*/LC_MESSAGES/libplpprops.mo
%{_datadir}/mimelnk/*/*

%files -n kpsion
%{_bindir}/kpsion
%{_libdir}/libkpsion.*
%{_datadir}/applnk/*/kpsion*
%{_datadir}/apps/kpsion/*
%{_datadir}/apps/konqueror/*
%{_datadir}/icons/*/*/apps/kpsion*
%{_datadir}/icons/*/*/actions/psion*
%{_datadir}/locale/*/LC_MESSAGES/kpsion.mo
%{_datadir}/doc/HTML/*/kpsion

%files -n klipsi
%{_bindir}/klipsi
%{_libdir}/klipsi.*
%{_datadir}/apps/klipsi/*
%{_datadir}/icons/*/*/apps/klipsi*
%{_datadir}/icons/*/*/actions/klipsi*
%{_datadir}/locale/*/LC_MESSAGES/klipsi.mo
