/*  Copyright (C) 2000-2001  MandrakeSoft S.A.
 *
 *    MandrakeSoft S.A.
 *    43, rue d'Aboukir
 *    75002 Paris - France
 *    http://www.linux-mandrake.com/
 *    http://www.mandrakesoft.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_NEXUS_SPACE
#include "monitor.h"






#if 0
// NOTES ON THE 8253/8254 PIT MODES

// MODE 0: Interrupt on Terminal Count
// ===================================
// Writing new count action:
//   loaded upon next CLK pulse.  counting doesn't start until GATE=1
// GATE 0..1 transition:
//   ???
// GATE 1..0 transition:
// counter expiration action:
//   wraps to FFFF
// * OUT rises until new count val or new control word for mode 0 written

// MODE 1: Programmable Monoflop
// =============================
// Writing new count action:
//   not effective for current process
// GATE 0..1 transition:
//   loads counter
// counter expiration action:
//   wraps to FFFF
// NOTES:
//   OUT rises until new count val or new control word for mode 0 written

// MODE 2: Rate Generator
// ======================
// Writing new count action:
//   ???
// GATE 0..1 transition:
//   loads initial count val and starts counting
// counter expiration action:
//   reloads after count expires
// NOTES:
// * after control word & initial count val N loaded, PIT starts
//   counting upon next CLK pulse.
// * when counter reaches 1, OUT drops to a low level, for one
//   CLK cycle. (short peak pulse generated)
// * afterwards, the initial count val is automatically reloaded
//   and the PIT restarts the same counting operation again.
// * distance of two OUT pulses is N CLK cycles long.
// * GATE=1 enables, GATE=0 disables counter.
// * if GATE drops to low level during counting operation and rises
//     to high level later, PIT loads initial count value at the
//     rise and starts counting.
// * PIT starts counting after last data byte written if GATE=1
// * if the output is low when the gate goes low, the output is
//   immediately set high.

// MODE 3: Square Wave Generator
// =============================
// Writing new count action:
//   ???
// GATE 0..1 transition:
//   ???
// counter expiration action:
//   reloads after count expires
// NOTES:
// * initially OUT at a high level
// * drop of GATE to a low level while OUT low, raises OUT to a high level
// * a rise from a low to a high level at GATE (trigger pulse),
//   loads the counter with the initial count value and starts
//   counting operation
// * a new count value supplied during the course of an active
//   counting operation doesn't affect the current process.
//   At the end of the current half cycle, the PIT loads the new value
// * if the GATE line goes low, count is temporarily halted until GATE
//   returns high
// * if the OUT line is high when GATE goes low, OUT is forced low.
// ??? different for odd/even counts

// MODE 4: Software Triggered Pulse
// ================================
// Writing new count action:
//   ???
// GATE 0..1 transition:
//   ???
// counter expiration action:
//   wraps to FFFF
// NOTES:

// MODE 5: Hardware Triggered Pulse
// ================================
// Writing new count action:
//   ???
// GATE 0..1 transition:
//   ???
// counter expiration action:
//   wraps to FFFF
// NOTES:
#endif






#ifdef OUT
#  undef OUT
#endif


  void
pitInit(vm_t *vm)
{
  timerRegister_t timer;

  mon_memzero(&vm->pit, sizeof(vm->pit));

  timer.thisPtr = 0; /* Unused for monitor space. */
  timer.callback = (void *) pitTimerCallback;
  timer.useconds = PitPeriodicDelta;
  timer.continuous = 1;
  timer.active = 1;
  registerTimer(vm, MonitorSpace, &timer);

//devices->register_irq(0, "8254 PIT"); // xxx Fix this
  registerIORHandler(vm, MonitorSpace, 0, pitIORead, 0x0040, 1, "8254 PIT");
  registerIORHandler(vm, MonitorSpace, 0, pitIORead, 0x0041, 1, "8254 PIT");
  registerIORHandler(vm, MonitorSpace, 0, pitIORead, 0x0042, 1, "8254 PIT");
  registerIORHandler(vm, MonitorSpace, 0, pitIORead, 0x0043, 1, "8254 PIT");
  registerIORHandler(vm, MonitorSpace, 0, pitIORead, 0x0061, 1, "8254 PIT");

  registerIOWHandler(vm, MonitorSpace, 0, pitIOWrite, 0x0040, 1, "8254 PIT");
  registerIOWHandler(vm, MonitorSpace, 0, pitIOWrite, 0x0041, 1, "8254 PIT");
  registerIOWHandler(vm, MonitorSpace, 0, pitIOWrite, 0x0042, 1, "8254 PIT");
  registerIOWHandler(vm, MonitorSpace, 0, pitIOWrite, 0x0043, 1, "8254 PIT");
  registerIOWHandler(vm, MonitorSpace, 0, pitIOWrite, 0x0061, 1, "8254 PIT");


  vm->pit.s.speaker_data_on = 0;
  vm->pit.s.refresh_clock_div2 = 0;

  vm->pit.s.timer[0].mode        = 3;  /* periodic rate generator */
  vm->pit.s.timer[0].latch_mode  = BX_PIT_LATCH_MODE_16BIT;
  vm->pit.s.timer[0].input_latch_value = 0;
  vm->pit.s.timer[0].input_latch_toggle = 0;
  vm->pit.s.timer[0].output_latch_value = 0;
  vm->pit.s.timer[0].output_latch_toggle = 0;
  vm->pit.s.timer[0].output_latch_full = 0;
  vm->pit.s.timer[0].counter_max = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[0].counter     = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[0].bcd_mode    = 0;  /* binary counting mode */
  vm->pit.s.timer[0].GATE        = 1;  /* GATE tied to + logic */
  vm->pit.s.timer[0].OUT         = 1;
  vm->pit.s.timer[0].active      = 0;

  vm->pit.s.timer[1].mode        = 3;  /* periodic rate generator */
  vm->pit.s.timer[1].latch_mode  = BX_PIT_LATCH_MODE_16BIT;
  vm->pit.s.timer[1].input_latch_value = 0;
  vm->pit.s.timer[1].input_latch_toggle = 0;
  vm->pit.s.timer[1].output_latch_value = 0;
  vm->pit.s.timer[1].output_latch_toggle = 0;
  vm->pit.s.timer[1].output_latch_full = 0;
  vm->pit.s.timer[1].counter_max = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[1].counter     = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[1].bcd_mode    = 0;  /* binary counting mode */
  vm->pit.s.timer[1].GATE        = 1;  /* GATE tied to + logic */
  vm->pit.s.timer[1].OUT         = 1;
  vm->pit.s.timer[1].active      = 0;

  vm->pit.s.timer[2].mode        = 3;  /* periodic rate generator */
  vm->pit.s.timer[2].latch_mode  = BX_PIT_LATCH_MODE_16BIT;
  vm->pit.s.timer[2].input_latch_value = 0;
  vm->pit.s.timer[2].input_latch_toggle = 0;
  vm->pit.s.timer[2].output_latch_value = 0;
  vm->pit.s.timer[2].output_latch_toggle = 0;
  vm->pit.s.timer[2].output_latch_full = 0;
  vm->pit.s.timer[2].counter_max = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[2].counter     = 0;  /* 0xFFFF + 1 : (1193182 / 65535 = 18.2Hz) */
  vm->pit.s.timer[2].bcd_mode    = 0;  /* binary counting mode */
  vm->pit.s.timer[2].GATE        = 0;  /* timer2 gate controlled by port 61h bit 0 */
  vm->pit.s.timer[2].OUT         = 1;
  vm->pit.s.timer[2].active      = 0;
}
