/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  regs.c:  access guest registers (convience functions)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"



  Bit32u 
ReadReg32(vm_t *vm, unsigned reg)
{
  Bit32u *reg_p;

  if (reg == RegESP)
    reg_p = &vm->guest.addr.guest_context->esp;
  else
    reg_p = &vm->guest.addr.guest_context->eax - reg;
  return(*reg_p);
}

  Bit16u
ReadReg16(vm_t *vm, unsigned reg)
{
  Bit16u *reg_p;

  if (reg == RegESP) {
    reg_p = (Bit16u *) &vm->guest.addr.guest_context->esp;
    }
  else {
    reg_p = (Bit16u *) (&vm->guest.addr.guest_context->eax - reg);
    }
  return(*reg_p);
}

  Bit8u
ReadReg8(vm_t *vm, unsigned reg)
{
  Bit8u *reg_p;

  if (reg < 4) {
    /* AL,CL,DL,BL */
    reg_p = (Bit8u *) (&vm->guest.addr.guest_context->eax - reg);
    return(*reg_p);
    }
  else {
    /* AH,CH,DH,BH */
    reg_p = (Bit8u *) (&vm->guest.addr.guest_context->eax - (reg-4));
    reg_p++;
    return(*reg_p);
    }
}

  void
WriteReg32(vm_t *vm, unsigned reg, Bit32u val)
{
  if (reg == RegESP)
    G_ESP(vm) = val;
  else {
    Bit32u *reg_p;
    reg_p = &vm->guest.addr.guest_context->eax - reg;
    *reg_p = val;
    }
}

  void
WriteReg16(vm_t *vm, unsigned reg, Bit16u val)
{
  if (reg == RegESP) {
    G_SP(vm) = val;
    }
  else {
    Bit16u *reg_p;
    reg_p = (Bit16u *) (&vm->guest.addr.guest_context->eax - reg);
    *reg_p = val;
    }
}

  void
WriteReg8(vm_t *vm, unsigned reg, Bit8u val)
{
  Bit8u *reg_p;

  if (reg < 4) {
    /* AL,CL,DL,BL */
    reg_p = (Bit8u *) (&vm->guest.addr.guest_context->eax - reg);
    *reg_p = val;
    }
  else {
    /* AH,CH,DH,BH */
    reg_p = (Bit8u *) (&vm->guest.addr.guest_context->eax - (reg-4));
    reg_p++;
    *reg_p = val;
    }
}
