/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */



#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <signal.h>

#include "codegen.h"


Bit8u *
dtGenJzJd(Bit8u * tcodePtr, Bit32u targetOffset32)
{
  Bit8u *tcodeBranchAddr;
  Bit32u *r3hBranchPtr;
#if DT_UseBackpatch
  Bit8u *idCheckOffsetPtr, *idPtr;
  Bit32u *directTcodeOffsetPtr;
#endif

  /* Emit code */
  *tcodePtr++ = 0x0f;   /* Negate branch: JNZ Jd */
  *tcodePtr++ = 0x85;
  tcodeBranchAddr = tcodePtr;   /* for patching branch offset */
  tcodePtr += 4;

#if DT_UseR3hStack
  tcodePtr = dtEmitUseR3hESP(tcodePtr);
#endif
#if DT_UseBackpatch
  tcodePtr = dtEmitPushf(tcodePtr);
  tcodePtr = dtEmitIDCheck(tcodePtr, &idCheckOffsetPtr, &idPtr);
  tcodePtr = dtEmitPopf(tcodePtr);
#if DT_UseR3hStack
  tcodePtr = dtEmitUseGuestESP(tcodePtr);
#endif
  tcodePtr = dtEmitJmp(tcodePtr, &directTcodeOffsetPtr);
  *directTcodeOffsetPtr = 0;

  /* Patch the 8-bit jump in the ID check fail case here */
  *idCheckOffsetPtr = (tcodePtr - (idCheckOffsetPtr + 1));
#endif /* DT_UseBackpatch */

  /* Emit code for when branch handler must be used */
  tcodePtr = dtEmitPushImm32(tcodePtr, targetOffset32);
  tcodePtr = dtEmitCall(tcodePtr, &r3hBranchPtr);

  /* Emit relocation record */
  reloc[relocN].tcodePtr = r3hBranchPtr;
  reloc[relocN].tcodeOff = (Bit32u) __r3h_branch_static;
  relocN++;

#if DT_UseBackpatch
  /* Calculate backpatch offsets of ID and direct branch address */
  idPatchDispl = tcodePtr - idPtr;
  jmpPatchDispl = tcodePtr - (Bit8u *) directTcodeOffsetPtr;
#endif

  /* Patch offset from negated branch here */
  *(Bit32u *) tcodeBranchAddr = tcodePtr - (tcodeBranchAddr + 4);

  return tcodePtr;
}


Bit8u *
dtGenJnzJd(Bit8u * tcodePtr, Bit32u targetOffset32)
{
  Bit8u *tcodeBranchAddr;
  Bit32u *r3hBranchPtr;
#if DT_UseBackpatch
  Bit8u *idCheckOffsetPtr, *idPtr;
  Bit32u *directTcodeOffsetPtr;
#endif

  /* Emit code */
  *tcodePtr++ = 0x0f;   /* Negate branch: JZ Jd */
  *tcodePtr++ = 0x84;
  tcodeBranchAddr = tcodePtr;   /* for patching branch offset */
  tcodePtr += 4;

#if DT_UseR3hStack
  tcodePtr = dtEmitUseR3hESP(tcodePtr);
#endif
#if DT_UseBackpatch
  tcodePtr = dtEmitPushf(tcodePtr);
  tcodePtr = dtEmitIDCheck(tcodePtr, &idCheckOffsetPtr, &idPtr);
  tcodePtr = dtEmitPopf(tcodePtr);
#if DT_UseR3hStack
  tcodePtr = dtEmitUseGuestESP(tcodePtr);
#endif
  tcodePtr = dtEmitJmp(tcodePtr, &directTcodeOffsetPtr);
  *directTcodeOffsetPtr = 0;

  /* Patch the 8-bit jump in the ID check fail case here */
  *idCheckOffsetPtr = (tcodePtr - (idCheckOffsetPtr + 1));
#endif /* DT_UseBackpatch */

  /* Emit code for when branch handler must be used */
  tcodePtr = dtEmitPushImm32(tcodePtr, targetOffset32);
  tcodePtr = dtEmitCall(tcodePtr, &r3hBranchPtr);

  /* Emit relocation record */
  reloc[relocN].tcodePtr = r3hBranchPtr;
  reloc[relocN].tcodeOff = (Bit32u) __r3h_branch_static;
  relocN++;

#if DT_UseBackpatch
  /* Calculate backpatch offsets of ID and direct branch address */
  idPatchDispl = tcodePtr - idPtr;
  jmpPatchDispl = tcodePtr - (Bit8u *) directTcodeOffsetPtr;
#endif

  /* Patch offset from negated branch here */
  *(Bit32u *) tcodeBranchAddr = tcodePtr - (tcodeBranchAddr + 4);

  return tcodePtr;
}


Bit8u *
dtGenLoopJb(Bit8u * tcodePtr, Bit8s displ8)
{
  /* +++ hack specific to cascade loop */
  if (displ8 != -12) {
    printf("LOOP: Jb not -12\n");
    exit(1);
    }

  /* Emit code */
  *tcodePtr++ = 0xe2;
  *tcodePtr++ = (Bit8u) displ8;

  return tcodePtr;
}


Bit8u *
dtGenJmpJd(Bit8u * tcodePtr, Bit32u targetOffset32)
{
  Bit32u *r3hBranchPtr;
#if DT_UseBackpatch
  Bit8u *idCheckOffsetPtr, *idPtr;
  Bit32u *directTcodeOffsetPtr;
#endif

  /* Emit code */
#if DT_UseR3hStack
  tcodePtr = dtEmitUseR3hESP(tcodePtr);
#endif
#if DT_UseBackpatch
  tcodePtr = dtEmitPushf(tcodePtr);
  tcodePtr = dtEmitIDCheck(tcodePtr, &idCheckOffsetPtr, &idPtr);
  tcodePtr = dtEmitPopf(tcodePtr);
#if DT_UseR3hStack
  tcodePtr = dtEmitUseGuestESP(tcodePtr);
#endif
  tcodePtr = dtEmitJmp(tcodePtr, &directTcodeOffsetPtr);
  *directTcodeOffsetPtr = 0;

  /* Patch the 8-bit jump in the ID check fail case here */
  *idCheckOffsetPtr = (tcodePtr - (idCheckOffsetPtr + 1));
#endif /* DT_UseBackpatch */

  /* Emit code for when branch handler must be used */
  tcodePtr = dtEmitPushImm32(tcodePtr, targetOffset32);
  tcodePtr = dtEmitCall(tcodePtr, &r3hBranchPtr);

  /* Emit relocation record */
  reloc[relocN].tcodePtr = r3hBranchPtr;
  reloc[relocN].tcodeOff = (Bit32u) __r3h_branch_static;
  relocN++;

#if DT_UseBackpatch
  /* Calculate backpatch offsets of ID and direct branch address */
  idPatchDispl = tcodePtr - idPtr;
  jmpPatchDispl = tcodePtr - (Bit8u *) directTcodeOffsetPtr;
#endif

  return tcodePtr;
}
