<?php

##########################################################################################
#    New Page Functions:                                                                 #
#       Create and edit data on new web pages. These pages are added to the main menu    #
#       by the user's request.                                                           #
#    Written by:                                                                         #
#       Adam Morton, am26882@appstate.edu; Brian W. Brown, brownb@appstate.edu           #
##########################################################################################
function get_page_data()
{
	include ("header.php");
	global $phpgw;
	GraphicAdmin(0);

	echo "
<form action=\"admin.php\" method=\"post\" enctype=\"multipart/form-data\">
<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
<tr>
	<td class=\"type0\">
<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
<tr>
	<td class=\"type4\">".lang("Create Page")."</td>
</tr>
<tr>
	<td class=\"type5\">
<table align=\"center\" cellspacing=\"10\">
<tr>
	<td class=\"type5\" colspan=\"2\">".lang("Title:")."<br />
        <input type=\"text\" name=\"title\" maxlength=\"60\" size=\"45\" />
	</td>
</tr>
	";
	
	for($i=0; $i < $default_num_sections; $i++)
	{
		$j = $i+1;
		echo "
<tr>
	<td>
	<input type=\"checkbox\" name=\"sub_array[$i]\" value=\"$j\" />
	".lang("Subtitle")." $j:<br />
	<input type=\"text\" name=\"subtitle$j\" maxlength=\"60\" size=\"50\" />
	<br />
	<input type=\"checkbox\" name=\"text_array[$i]\" value=\"$j\" />
	".lang("Text")." $j:<br />
	<textarea name=\"text$j\" cols=\"50\" rows=\"20\" wrap=\"virtual\"></textarea>
	<br />
	<input type=\"checkbox\" name=\"image_array[$i]\" value=\"$j\" />
	".lang("Image")." $j:<br />
	<input type=\"file\" name=\"image$j\" maxlength=\"60\" size=\"40\" />
        <br />
        ".lang("Short Image Description:")." <br />
	<input type=\"text\" name=\"alt$j\" maxlength=\"60\" size=\"50\" />
	</td>
</tr>
<tr>
        <td class=\"type5\"><hr /></td>
</tr>
		";
	}
	
	echo "
<tr>
	<td class=\"type5\" colspan=\"2\" align=\"center\">
	<input type=\"hidden\" name=\"op\" value=\"select_layout\" />
	<input type=\"hidden\" name=\"new_page\" value=\"1\" />
	<input type=\"submit\" value=\"".lang("Submit Page")."\" />
	</td>
</tr>
</table>
</td></tr></table>
</td></tr></table>
</form><br />
	";
	
	include ('footer.php');
}

function store_user_page($title, $num_sections)
{
	global $phpgw;

//	$phpgw->db->query("lock table user_pages write");
	$phpgw->db->query("insert into wcm_user_pages (title, num_sections) values ('$title', '$num_sections')");
        $phpgw->db->query("select max(page_id) AS MAXIMUM from wcm_user_pages");
	$phpgw->db->next_record();
//	$phpgw->db->query("unlock table");

	$page_id=$phpgw->db->f('MAXIMUM');
	return $page_id;
}

function store_page_content($page_id, $subtitle, $text, $image, $image_name, $image_type, $image_size, $alt, $level)
{
	include("config.php");
	global $phpgw;

	if($image != "none")
	{
		if($image_size > $max_user_file_size)
		page_error("$image_name / $level : ".lang("The image in the section is too large.")." <br />
	                   ".lang("The largest allowable size is:")." $max_user_file_size b.<br />
		           ".lang("Your file is:")." $image_size b.");
	  
		if(substr_count($user_file_types, $image_type) > 0)
		{
			copy($image, $user_directory.$image_name);
			$phpgw->db->query("insert into wcm_page_content (page_id, subtitle, text, image, level, alt, sub_active, text_active, image_active)
	                             values ('$page_id', '$subtitle', '$text', '$image_name', '$level', '$alt', '0', '0', '0')");
		}
		else
		page_error("$image_name / $level : ".lang("The image in the section has a wrong file type.")."<br />
	                   ".lang("The allowed types are:")." $user_file_types<br />
		           ".lang("You file is of type:")." $image_type");
	}
	else
	{
		$phpgw->db->query("insert into wcm_page_content (page_id, subtitle, text, image, level, sub_active, text_active, image_active)
	                     values ('$page_id', '$subtitle', '$text', 'none', '$level', '0', '0', '0')");
	}
}

function save_changes($page_id, $subtitle, $text, $image, $image_name, $image_type, $image_size, $level, $alt, $flag)
{
	include("config.php");
	global $phpgw;

	$phpgw->db->query("select MAX(level) AS MAXIMUM from wcm_page_content where page_id='$page_id'");
	$phpgw->db->next_record();
	$max_level=$phpgw->db->f('MAXIMUM');

	if($image != "none")
	{
		if($image_size > $max_user_file_size)
		page_error("$image_name / $level : ".lang("The image in the section is too large.")." <br />
	                   ".lang("The largest allowable size is:")." $max_user_file_size b.<br />
		           ".lang("Your file is:")." $image_size b.");

		if(substr_count($user_file_types, $image_type)>0)
		{
			copy($image, $user_directory.$image_name);
			if($level <= $max_level)
			$phpgw->db->query("update wcm_page_content set subtitle='$subtitle', text='$text', image='$image_name', alt='$alt',
                                     sub_active='0', text_active='0', image_active='0' where page_id='$page_id' and level='$level'");
			else
			$phpgw->db->query("insert into wcm_page_content (page_id, subtitle, text, image, level, alt, sub_active, text_active, image_active)
	                             values ('$page_id', '$subtitle', '$text', '$image_name', '$level', '$alt', '0', '0', '0')");
		}
		else
		page_error("$image_name / $lever : ".lang("The image in the section has a wrong file type.")."<br />
	                   ".lang("The allowed types are:")." $user_file_types<br />
			   ".lang("You file is of type:")." $image_type");
	}
	else if($flag)
	{
		$phpgw->db->query("update wcm_page_content set subtitle='$subtitle', text='$text', alt='$alt',
                	     sub_active='0', text_active='0', image_active='0' where page_id='$page_id' and level='$level'");
	}
	else
	{
		if($level <= $max_level)
		$phpgw->db->query("update wcm_page_content set subtitle='$subtitle', text='$text', image='none', alt='$alt',
                    	 sub_active='0', text_active='0', image_active='0' where page_id='$page_id' and level='$level'");
		else
		$phpgw->db->query("insert into wcm_page_content (page_id, subtitle, text, image, level, sub_active, text_active, image_active)
	                     values ('$page_id', '$subtitle', '$text', 'none', '$level', '0', '0', '0')");
	}
}

function set_display_flags($page_id, $sub_array, $text_array, $image_array)
{
	include("config.php");
	global $phpgw;
	
	if($sub_array)
        for($i=0; $i < $default_num_sections; $i++)
	$phpgw->db->query("update wcm_page_content set sub_active = '1' where page_id = '$page_id' and level = '$sub_array[$i]'");

	if($text_array)
        for($i=0; $i < $default_num_sections; $i++)
	$phpgw->db->query("update wcm_page_content set text_active = '1' where page_id = '$page_id' and level = '$text_array[$i]'");

	if($image_array)
        for($i=0; $i < $default_num_sections; $i++)
	$phpgw->db->query("update wcm_page_content set image_active = '1' where page_id = '$page_id' and level = '$image_array[$i]'");
}


function select_layout($page_id, $new_page)
{
	include ("header.php");
	global $phpgw;
	GraphicAdmin(0);
	
	echo "
<form action=\"admin.php\" method=\"post\">

<table border=\"0\" width=\"100%\" cellpadding=\"8\" cellspacing=\"0\">
<tr>
<td  class=\"type3\">
<font size=\"4\">".lang("Select Layout")."</font>
<p>".lang("Please choose a layout for your page. Once you have selected a layout, you will be shown a preview of your page and be given the opportunity to change your layout choice before saving.")."</p>
<p>".lang("If you want to change your layout or page content at a later date, you can always edit your page from the Admin Home Page!")."</p>
</td>
</tr>

<tr>
<td>
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>
	<td class=\"type0\">
		<table border=\"0\" width=\"100%\" cellpadding=\"4\" cellspacing=\"1\">
		<tr>
        	<td class=\"type4\">".lang("Select Layout")."</td>
		</tr>

		<tr>
		<td class=\"type5\">
			<table align=\"center\" cellspacing=\"10\">
			";

	//Selecting the current layout of the page. If it is a new page then the default layout is 1.
	$phpgw->db->query("select layout from wcm_user_pages where page_id='$page_id'");
	$phpgw->db->next_record();
	$current_layout=$phpgw->db->f('layout');

	if($current_layout == NULL)
	$current_layout = 1;

	for($i=1; $i <= $num_layouts; $i++)
	{
		$phpgw->db->query("select msg_text from wcm_messages where msg_name=\"layout_msg$i\"");
		$phpgw->db->next_record();
		$msg_text=$phpgw->db->f('msg_text');

	echo "
			<tr>
        		<td class=\"type5\" colspan=\"3\"><hr /></td>
			</tr>

			<tr>
			<td class=\"type5\">
			";
	
	if($current_layout == $i)
	echo "
	<input type=\"radio\" name=\"layout\" value=\"$i\" checked=\"checked\" />
	";
	else
	echo "
	<input type=\"radio\" name=\"layout\" value=\"$i\" />
	";

	echo "
        		</td>

        		<td class=\"type5\">
			<img src=\"./images/layout/layout$i.gif\" alt=\"".lang("Layout")." $i\" />
			</td>
        		<td class=\"type5\">Layout $i<br /><hr /><p>$msg_text</p></td>
			</tr>
			";
	}
	
	echo "
			</table>
		</td>

		<tr>
		<td class=\"type5\">
		<input type=\"hidden\" name=\"op\" value=\"preview_page\" />
        	<input type=\"hidden\" name=\"page_id\" value=\"$page_id\" />
		<input type=\"hidden\" name=\"new_page\" value=\"$new_page\" />
		<center>
		";

	if(!$new_page)
	echo "
        <input type=\"submit\" name=\"submit_layout\" value=\"".lang("Submit Layout and Preview Page")."\" /><br />
	<input type=\"submit\" name=\"menu\" value=\"".lang("Submit Layout and Select Menu Placement")."\" /><br />
	<input type=\"submit\" name=\"save\" value=\"".lang("Submit Layout and Save Page")."\" /><br />
	";
        else
	echo "
        <input type=\"submit\" name=\"submit_layout\" value=\"".lang("Submit Layout and Preview Page")."\" /><br />
        ";

	echo "
		</center>
		</td>
		</tr>
		</table>
	</td>
	</tr>
	</table><br />
</td></tr>
</table>
</form>
	";

	include ('footer.php');
}

function choose_menu($page_id) 
{
  include ("header.php");
  global $phpgw;
  $db2 = $phpgw->db;
  $db3 = $phpgw->db;
 
  GraphicAdmin(0);  
  
  echo "<center>
	<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width = \"100%\">
	<tr>
	<td class=\"type0\">
	<table border=\"0\" cellpadding=\"8\" cellspacing=\"1\" width = \"100%\">
	<tr>
	<td class = \"type4\">".lang("Select Menu Placement")."</td>
	</tr>
	<tr>
	<td class = \"type5\">".lang("Please select where you would like this page to appear on the main menu by clicking the appropriate link.")."</td>
	</tr>
  ";

  $phpgw->db->query("select menu_id, menu_text, menu_url, menu_active, menu_order from wcm_menu where menu_level = 1 order by menu_order");

  echo "
	<tr>
	<td class=\"type5\">[<a href=\"admin.php?op=page_menu_post&amp;page_id=$page_id\">".lang("Add Page to Top Level")."</a>]</td>
	</tr>
  ";

  while($phpgw->db->next_record())
  {
     $menu_id=$phpgw->db->f('menu_id');
     $menu_text=$phpgw->db->f('menu_text');
     $menu_url=$phpgw->db->f('menu_url');
     $menu_active=$phpgw->db->f('menu_active');
     $menu_order=$phpgw->db->f('menu_order');

     $low_sub = $menu_id * 100;  
     $high_sub = $low_sub + 99;

     echo "
<tr>
      <td class=\"type5\"><b>$menu_text</b><br />
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      [<a href=\"admin.php?op=sub_page_menu_post&amp;low_sub=$low_sub&amp;page_id=$page_id\">".lang("Add Page Under")." $menu_text</a>]
      </td>
</tr>
     ";

     $db2->query("select menu_id, menu_text, menu_url, menu_active, menu_order from wcm_menu where menu_level = 2 and menu_id >=  $low_sub and menu_id <=  $high_sub order by menu_order");

     while($db2->next_record())
     {
	$menu_id=$db2->f('menu_id');
	$menu_text=$db2->f('menu_text');
	$menu_url=$db2->f('menu_url');
	$menu_active=$db2->f('menu_active');
	$menu_order=$db2->f('menu_order');

       $low_sub2 = $menu_id * 100; 
       $high_sub2 = $low_sub2 + 99;

       echo"
	<tr>
	<td class=\"type5\"><span class=\"onebiggerred\">&gt;&gt;</span>
	<b>$menu_text</b><br />
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
	[<a href=\"admin.php?op=sub_page_menu_post&amp;low_sub=$low_sub2&amp;page_id=$page_id\">".lang("Add Page Under")." $menu_text</a>]
	</td>
	</tr>
       ";

     $db3->query("select menu_id, menu_text, menu_url, menu_active, menu_order from wcm_menu where menu_level = 3 and menu_id >=  $low_sub2 and menu_id <=  $high_sub2 order by menu_order");

     while($db3->next_record())
     {
	$menu_id=$db3->f('menu_id');
	$menu_text=$db3->f('menu_text');
	$menu_url=$db3->f('menu_url');
	$menu_active=$db3->f('menu_active');
	$menu_order=$db3->f('menu_order');

       echo"
	<tr>
	<td class=\"type5\"><span class=\"onebiggerred\">&gt;&gt;&gt;&gt;</span>
	<b>$menu_text</b>
	</td>
	</tr>
       ";
     }
   }    
 }

  echo "
</table>
</td></tr></table>
</center>
  ";

  include ('footer.php'); 
}

function get_menu_text($menu_id)
{
        include ("header.php");
	global $phpgw;
	GraphicAdmin(1);
	
	$phpgw->db->query("select menu_text from wcm_menu where menu_id='$menu_id'");
	$phpgw->db->next_record();
	$link=$phpgw->db->f('menu_text');

	echo "
	<table border=\"0\" bgcolor=\"#000000\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>
	<td>
	<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
	<tr>
	<td class=\"type4\">".lang("Menu Text:")."</td>
	</tr>
	<tr>
	<td class=\"type5\"><object><form method=\"post\" action=\"admin.php\">".lang("Please name this link:")."
        <input type=\"text\" name=\"link\" maxlength=\"60\" size=\"33\" value=\"$link\" />
        <input type=\"hidden\" name=\"op\" value=\"update_link_text\" />
        <input type=\"hidden\" name=\"menu_id\" value=\"$menu_id\" />
        <br /><input type=\"submit\" value=\"".lang("Submit Link Text")."\" />
        </form></object>
	</td>
	</tr>
	</table>
        </td>
	</tr>
	</table>
        ";
	include("footer.php");
}

function update_link_text($menu_id, $link)
{
	global $phpgw;
        $phpgw->db->query("update wcm_menu set menu_text='$link' where menu_id='$menu_id'");
}

function preview_page($layout, $page_id, $new_page)
{
	include ("header.php");
	global $phpgw;
	GraphicAdmin(0);
	
	$phpgw->db->query("update wcm_user_pages set layout='$layout' where page_id='$page_id'");
        $phpgw->db->query("select title from wcm_user_pages where page_id='$page_id'");
	$phpgw->db->next_record();
	$title=$phpgw->db->f('title');

	echo "Previewing page...<br /><br />
	";

	include ("layout.php");

	echo "
	<br />
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"1\">
	<tr>
	<td class=\"type3\" align=\"left\"><form action=\"admin.php\" method=\"post\">
        <input type=\"hidden\" name=\"op\" value=\"choose_menu\" />
        <input type=\"hidden\" name=\"page_id\" value=\"$page_id\" />
        <input type=\"hidden\" name=\"title\" value=\"$title\" />
        <input type=\"hidden\" name=\"new_page\" value=\"$new_page\" />
        ".lang("If you would like to edit the content on this page, choose").":<br />
        <input type=\"submit\" name=\"edit_content\" value=\"".lang("Edit Content")."\" /><br /><br />
        ".lang("If you would like to choose a different Layout, choose").":<br />
        <input type=\"submit\" name=\"layout\" value=\"".lang("Select New Layout")."\" /><br /><br />
        ".lang("If you would like to put this page on the Main Menu and save the page choose").":<br />
        <input type=\"submit\" name=\"menu\" value=\"".lang("Select Menu Placement")."\" /><br /><br />";

	if(!$new_page)
	  echo lang("If this page is already listed on the Main Menu and you only want to save this edit choose").":<br />
               <input type=\"submit\" name=\"save\" value=\"".lang("Save Page")."\" /><br /><br />
        ";

	echo "
        </form>
        </td>
	</tr>
	</table>
        ";

	include ("footer.php");
}


function save_new_page()
{
	include ("header.php");
	GraphicAdmin(0);
	
	echo "
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>
	<td class=\"type0\">
	<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
	<tr>
	<td class=\"type4\">".lang("PAGE SAVED!")."</td>
	</tr>
	<tr>
	<td class=\"type5\" align=\"center\">
	<font size=\"4\"><b>".lang("Your page has been saved!")."</b></font>
	</td>
	</tr>
	</table>
        </td>
	</tr>
	</table>
        ";
	include("footer.php");
}

function list_user_pages()
{
        include("header.php");
	global $phpgw;
	GraphicAdmin(0);
	
	$phpgw->db->query("select page_id, title, active from wcm_user_pages order by title asc");

	echo "
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>
	<td class=\"type0\">
	<table border=\"0\" width=\"100%\" cellpadding=\"4\" cellspacing=\"1\">
	<tr>
        <td class=\"type4\">".lang("Edit Page")."
        </td>

        <td class=\"type4\" align=\"center\">".lang("Page ID")."
        </td>

        <td class=\"type4\" align=\"center\">".lang("Delete?")."
        </td>

        <td class=\"type4\" align=\"center\">".lang("Active?")."
        </td>
	</tr>
        ";

//	if ($page_result)
	while($phpgw->db->next_record())
	{
	    $page_id=$phpgw->db->f('page_id');
	    $title=$phpgw->db->f('title');
	    $active=$phpgw->db->f('active');

	    $db2->query("select subtitle, text from wcm_page_content where page_id='$page_id' and level='1'");
	    $db2->next_record();
	    $subtitle=$db2->f('subtitle');
	    $text=$db2->f('text');

	    echo "
	<tr>
        <td class=\"type5\"><a href=\"./admin.php?op=edit_page&amp;page_id=$page_id\">$title</a>
        <br /><dl>
        <dd>$subtitle</dd>
        <dd>
            ";

	    echo (htmlspecialchars(substr($text, 0, 99)));

	    echo "...</dd></dl>
        </td>

        <td class=\"type5bigger\" align=\"center\"><font size=\"4\">$page_id</font></td>

        <td class=\"type5\" align=\"center\">
        <a href=\"./admin.php?op=double_check&amp;page_id=$page_id\">".lang("Delete")."</a></td>
            ";

            if($active)
	    {
	        echo "
         <td class=\"active\" align=\"center\">
         <a href=\"./admin.php?op=toggle_active&amp;page_id=$page_id&amp;active=$active\">".lang("ON")."</a>
         </td>
                ";
	    }
	    else
	    {
	        echo "
         <td class=\"inactive\" align=\"center\">
         <a href=\"./admin.php?op=toggle_active&amp;page_id=$page_id&amp;active=$active\">".lang("OFF")."</a>
         </td>
                ";
            }

	    echo "
</tr>
            ";
	}
	
	echo "

</table>
</td></tr></table>
	";

        include("footer.php");
	
}

function edit_page($page_id, $new_page)
{
        include ("header.php");
	global $phpgw;
	GraphicAdmin(0);
	
	echo "
	<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
	<tr>
	<td class=\"type0\">
		<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
		<tr>
        	<td class=\"type4\">".lang("Current Page Data")."</td>
		</tr>

		<tr>
		<td class=\"type5\">
		<form action=\"admin.php\" method=\"post\" enctype=\"multipart/form-data\">
			<table align=\"center\" cellspacing=\"0\" cellpadding=\"5\">
			";

			$phpgw->db->query("select title from wcm_user_pages where page_id='$page_id'");
			$phpgw->db->next_record();
			$main_title=$phpgw->db->f('title');

			echo "
			<tr>
			<td class=\"type5\"><span class=\"boldtext\">".lang("Title:")." </span><br />
        		<input type=\"text\" name=\"title\" maxlength=\"60\" size=\"45\" value=\"$main_title\" />
			</td>
			</tr>
			";

        $phpgw->db->query("select level, subtitle, text, image, sub_active, text_active, image_active, alt from wcm_page_content where page_id='$page_id' order by level asc");
	$j=1;
	while(($phpgw->db->next_record()) || ($j <= $default_num_sections))
	{
			$level=$phpgw->db->f('level');
			$subtitle=$phpgw->db->f('subtitle');
			$text=$phpgw->db->f('text');
			$image=$phpgw->db->f('image');
			$sub_active=$phpgw->db->f('sub_active');
			$text_active=$phpgw->db->f('text_active');
			$image_active=$phpgw->db->f('image_active');
			$alt=$phpgw->db->f('alt');

			echo "
			<tr>
			<td class=\"type5\"><hr />
                	";
		
		//BEGIN BIG IF-ELSE STRUCTURE: sets up check boxes and populates data from database. -Adam
		if($sub_active)
		echo "<input type=\"checkbox\" name=\"sub_array[$i]\" value=\"$j\" checked=\"checked\" />
                ";  
		else
		echo "<input type=\"checkbox\" name=\"sub_array[$i]\" value=\"$j\" />
                ";
		
		echo lang("Subtitle")." $j: <br />
                <input type=\"text\" name=\"subtitle$j\" maxlength=\"60\" size=\"45\" value=\"" . htmlspecialchars($subtitle) . "\" />
                <br />";
		
		if($text_active)
		echo "<input type=\"checkbox\" name=\"text_array[$i]\" value=\"$j\" checked=\"checked\" />
                ";
		else
		echo "<input type=\"checkbox\" name=\"text_array[$i]\" value=\"$j\" />
                ";
		
		echo lang("Text")." $j: <br />
                <textarea name=\"text$j\" cols=\"45\" rows=\"20\" wrap=\"virtual\">$text</textarea>
                <br />";
		
		if($image_active)
		echo "<input type=\"checkbox\" name=\"image_array[$i]\" value=\"$j\" checked=\"checked\" />
                ";
		else
		echo "<input type=\"checkbox\" name=\"image_array[$i]\" value=\"$j\" />
                ";
		
		echo lang("Image")." $j: <br />";
		
		if($image != 'none' && $level)
		echo "<img src=\"$user_images_webdir$image\" alt=\"$alt\" /><br />
                <input type=\"hidden\" name=\"old_image$j\" value=\"$image\" />
                <input type=\"file\" name=\"image$j\" maxlength=\"60\" size=\"35\" />
                <br />
                ".lang("Short Image Description:")."<br />
                <input type=\"text\" name=\"alt$j\" maxlength=\"60\" size=\"45\" value=\"$alt\" />
                ";
		else
		echo "<input type=\"file\" name=\"image$j\" maxlength=\"60\" size=\"35\" />
                <br />
                ".lang("Short Image Description:")."<br />
                <input type=\"text\" name=\"alt$j\" maxlength=\"60\" size=\"45\" value=\"$alt\" />
                ";
		//END BIG IF-ELSE STRUCTURE -Adam

		echo "</td></tr>
		";

		$j++;
	}

	echo "
	<tr>
	<td class=\"type5\" align=\"center\">
	<input type=\"hidden\" name=\"op\" value=\"save_changes\" />
        <input type=\"hidden\" name=\"page_id\" value=\"$page_id\" />
	<input type=\"hidden\" name=\"new_page\" value=\"$new_page\" />
        <input type=\"hidden\" name=\"num_sections\" value=\"$num_sections\" />
	<input type=\"submit\" name=\"layout\" value=\"".lang("Submit Changes and Proceed to Layout Selection")."\" /><br />
	<input type=\"submit\" name=\"menu\" value=\"".lang("Submit Changes and Proceed to Menu Placement")."\" /><br />
        ";

        if(!$new_page)
	echo "
	<input type=\"submit\" name=\"save\" value=\"".lang("Submit Changes Only")."\" /><br />
        ";

        echo "
	</td></tr></table>
	</td></tr></table>
	</td></tr></table></form><br />
	";
	
	include ('footer.php');
}

function toggle_active($page_id, $active)
{
	global $phpgw;

  if($active) {
    $phpgw->db->query("update wcm_user_pages set active='0' where page_id='$page_id'");
    $phpgw->db->query("update wcm_menu set menu_active='0' where page_id='$page_id'");
  }
  
  else {
    $phpgw->db->query("update wcm_user_pages set active='1' where page_id='$page_id'");	
    $phpgw->db->query("update wcm_menu set menu_active='1' where page_id='$page_id'");
  }
  
}

function double_check($page_id)
{
        include("header.php");

	echo "
	<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"0\">
	<tr>
	<td class=\"type3bigger\" align=\"center\"><font color=\"red\"><b>".lang("Attention!")."</b></font><br />
	".lang("Are you sure you want to completely delete this page and all associated images?")."<br />
	<a href=\"./admin.php?op=drop_page&page_id=$page_id&answer=1\">".lang("YES")."</a>&nbsp;&nbsp;
        <a href=\"./admin.php?op=drop_page&page_id=$page_id&answer=0\">".lang("NO")."</a>
        </td>
	</tr>
	<tr>
        <td class=\"type3\">
        ";

        include("layout.php");

	echo "
	</td></tr></table>
        ";

	include("footer.php");
}

function drop_page($page_id, $answer)
{
	global $phpgw;

	if($answer)
	{
	    $phpgw->db->query("delete from wcm_user_pages where page_id='$page_id'");
	    $phpgw->db->query("delete from wcm_page_content where page_id='$page_id'");
	    $phpgw->db->query("delete from wcm_menu where page_id='$page_id'");
	}
}

##########################################################################
#    Error Handling:                                                     #
#       These functions check for errors in forms and uploaded files.    #
##########################################################################

//Tests fields from main_page_data() for correctness.
function test_data($main_flag, $title, $text, $image, $alt)
{
        if(!$title && $main_flag)
	  $type = lang("No title submitted!");
	else if(!$text && $main_flag)
	  $type = lang("No main text submitted! You must fill in the first TEXT field.");
	else if(($image != "none") && !$alt)
	  $type = lang("You must supply a small description for images (around 15-20 characters).");
        else
          $type = "none";

	if($type != "none")
	page_error($type);
}

//Produces an appropriate page error.
function page_error($type)
{
        include ("header.php");
	GraphicAdmin(0);

	echo "
<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
<tr>
	<td class=\"type0\">
<table border=\"0\" width=\"100%\" cellpadding=\"5\" cellspacing=\"1\">
<tr>
	<td class=\"type4\"><font color=\"red\">".lang("Data Error!!")."</font></td>
</tr>
<tr>
        <td class=\"type5\" align=\"center\"><b>".lang("The following error has occured:")."</b>
	<br /><br />
	$type
	<br /><br />
        ".lang("Please hit the back button on your browser and re-submit your data.")."
        </td>
</tr>
</table>
</td></tr></table>
        ";

	include("footer.php");
	exit();
}


function page_menu_post ($page_id)
{

  include("header.php");
  global $phpgw;

//  $phpgw->db->query("lock table menu write");
  $phpgw->db->query ("select max(menu_id) AS MAXIMUM from wcm_menu where menu_id >= '0' and menu_id < '100'");
  $phpgw->db->next_record();
  $menu_id=$phpgw->db->f('MAXIMUM');

  $phpgw->db->query ("select max(menu_order) AS MAXIMUM from wcm_menu where menu_level='1'");
  $phpgw->db->next_record();
  $menu_order=$phpgw->db->f('MAXIMUM');

  $menu_text = lang("Type Link Name Here");

    $menu_id = $menu_id + 1;
  $menu_order = $menu_order + 1;

  $phpgw->db->query("insert into wcm_menu (menu_id, menu_text, menu_url, menu_level, menu_active, menu_order, page_id) values ('$menu_id', '$menu_text', 'content.php', '1', '1', '$menu_order', '$page_id')");

//  $phpgw->db->query("unlock table");

  echo "
      <center>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width = \"100%\"><tr>
      <td class=\"type0\">
      <table border=\"0\" cellpadding=\"8\" cellspacing=\"1\" width = \"100%\">
      <tr><td class = \"type4\">".lang("Edit Menu Item")."</td></tr>
      <tr><td class = \"type5\">

	".lang("Please give this page a link name for the menu:")."
        <form action=\"admin.php\">
	".lang("Menu Text:")." <br /><input type=\"text\" name=\"menu_text\" maxlength=\"60\" size=\"33\" value=\"$menu_text\" />
        <br />

        <input type=\"hidden\" name=\"menu_id\" value=\"$menu_id\" />
        <input type=\"hidden\" name=\"op\" value=\"update_page_menu\" />
        <input type=\"submit\" value=\"Submit\" />
        </td></tr></table></td></tr></table>";

  include("footer.php");

}

function sub_page_menu_post ($low_sub, $page_id)
{

  include ("header.php");
  global $phpgw;
  $high_sub = $low_sub + 99;

//  $phpgw->db->query("lock table menu write");
  $phpgw->db->query ("select max(menu_id) AS MAXIMUM from wcm_menu where menu_id >= '$low_sub' and menu_id <= '$high_sub'");
  $phpgw->db->next_record();
  $menu_id=$phpgw->db->f('MAXIMUM');

  $phpgw->db->query ("select max(menu_order) AS MAXIMUM from wcm_menu where menu_id >= '$low_sub' and menu_id <= '$high_sub'");
  $phpgw->db->next_record();
  $menu_order=$phpgw->db->f('MAXIMUM');

  if ($menu_id == ""){
    $menu_id = $low_sub;
    $menu_order = 0;

  }

  else{
    $menu_id = $menu_id + 1;
    $menu_order = $menu_order + 1;
  }

  if ($menu_id < 10000){
    $phpgw->db->query("insert into wcm_menu (menu_id, menu_text, menu_url, menu_level, menu_active, menu_order, page_id) values ('$menu_id', '$menu_text', 'content.php', '2', '1', '$menu_order', '$page_id')");
  }
  else {
    $phpgw->db->query("insert into wcm_menu (menu_id, menu_text, menu_url, menu_level, menu_active, menu_order, page_id) values ('$menu_id', '$menu_text', 'content.php', '3', '1', '$menu_order', '$page_id')");
  }

//  $phpgw->db->query("unlock table");

  echo "
      <center>
      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width = \"100%\"><tr>
      <td class=\"type0\">
      <table border=\"0\" cellpadding=\"8\" cellspacing=\"1\" width = \"100%\">
      <tr><td class = \"type4\">".lang("Edit Menu Item")."</td></tr>
      <tr><td class = \"type5\">

	".lang("Please give this page a link name for the menu:")."
        <form action=\"admin.php\">
	".lang("Menu Text:")." <br /><input type=\"text\" name=\"menu_text\" maxlength=\"60\" size=\"33\" value=\"$menu_text\" />
        <br />

        <input type=\"hidden\" name=\"menu_id\" value=\"$menu_id\" />
        <input type=\"hidden\" name=\"op\" value=\"update_page_menu\" />
        <input type=\"submit\" value=\"".lang("Submit")."\" />
        </td></tr></table></td></tr></table>";
  
  include ("footer.php");
  

}


function update_page_menu($menu_id, $menu_text)
{
   global $phpgw;
   $phpgw->db->query("update wcm_menu set menu_text='$menu_text'  where menu_id='$menu_id'");
}

?>
