<?php
  /**************************************************************************\
  * phpgwtimetrack - Setup                                                   *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: mysql_oldtables.inc.php,v 1.1 2001/05/08 16:00:22 camden Exp $ */
  
  // This script is mainly so I can setup the old tables for testing
  // upgradability, etc.
  $sql = "CREATE TABLE employee_profiles (
    con int(11) DEFAULT '0' NOT NULL,
    lid varchar(20),
    title varchar(255),
    phone_number varchar(255),
    comments text,
    mobilephn varchar(24),
    pager varchar(20),
    hire_date date,
    yearly_vacation_hours smallint(5) unsigned,
    vacation_hours_used_todate smallint(5) unsigned,
    location_id int(10) unsigned,
    inout enum('IN','Out') DEFAULT 'IN' NOT NULL,
    PRIMARY KEY (id)
  )";
  $phpgw_setup->db->query($sql);


  $sql = "CREATE TABLE job_details (
    detail_id int(10) unsigned NOT NULL auto_increment,
    job_id int(10) unsigned DEFAULT '0' NOT NULL,
    account_id int(10) unsigned DEFAULT '0' NOT NULL,
    work_catagory_id int(10) unsigned DEFAULT '0' NOT NULL,
    work_date date,
    start_time time,
    end_time time,
    num_hours float(10,2) unsigned,
    detail_billable enum('Y','N'),
    comments text,
    PRIMARY KEY (detail_id)
  )";
  $phpgw_setup->db->query($sql);

  $sql = "CREATE TABLE job_status (
    status_id int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
    status_name varchar(20),
    PRIMARY KEY (status_id)
  )";
  $phpgw_setup->db->query($sql);

  $sql = "CREATE TABLE jobs (
    job_id int(10) unsigned NOT NULL auto_increment,
    company_id int(10) unsigned DEFAULT '0' NOT NULL,
    contact_id int(10) unsigned,
    account_id int(10) unsigned DEFAULT '0' NOT NULL,
    job_number int(10) unsigned DEFAULT '100' NOT NULL,
    job_revision varchar(5),
    description text,
    quote_date date,
    quoted_hours int(11),
    opened_date date,
    deadline date,
    approved_by int(10) unsigned,
    status_id int(10) unsigned DEFAULT '0' NOT NULL,
    billable enum('Y','N'),
    summary varchar(60),
    completed_date date,
    paid_date date,
    cancelled_date date,
    PRIMARY KEY (job_id)
  )";
  $phpgw_setup->db->query($sql);

  $sql = "CREATE TABLE locations (
    location_id int(10) unsigned NOT NULL auto_increment,
    location_name varchar(50) DEFAULT '0' NOT NULL,
    PRIMARY KEY (location_id)
  )";
  $phpgw_setup->db->query($sql);

  $sql = "CREATE TABLE work_catagories (
    work_catagory_id int(10) unsigned NOT NULL auto_increment,
    catagory_desc varchar(50),
    PRIMARY KEY (work_catagory_id)
  )";
  $phpgw_setup->db->query($sql);


// Additional steps for setup:
// 1. Have option Automatically create groups for Manager and Payroll ACL's, or just do it, after
// testing that they don't exist. Use groupnames of "TTrack_Managers" and "TTrackPayroll"
// 2. Automatically generate Profiles for all current accounts.

?>
