<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  // HTTP_GET_VARS
  $order=$HTTP_GET_VARS['order'];
  $selected=$HTTP_GET_VARS['selected'];
  $entry_id=$HTTP_GET_VARS['entry_id'];

  // HTTP_POST_VARS
  $submit=$HTTP_POST_VARS['submit'];
  $account_id=$HTTP_POST_VARS['account_id'];
  $income_expense=$HTTP_POST_VARS['income_expense'];
  $year=$HTTP_POST_VARS['year'];
  $month=$HTTP_POST_VARS['month'];
  $day=$HTTP_POST_VARS['day'];
  $amount=$HTTP_POST_VARS['amount'];
  $category_id=$HTTP_POST_VARS['category_id'];
  $description=$HTTP_POST_VARS['description'];

  if (!$submit=='')
  {
    $phpgw_info["flags"]["noheader"] = True;
    $phpgw_info["flags"]["nonavbar"] = True;
  }
  $phpgw_info["flags"]["currentapp"]="bookkeeping";
  include("../header.inc.php");
  include("inc/bookkeeping_header.inc.php");

  $db2=$phpgw->db;

  if(!$submit=='')
  {
    if(!checkdate($month,$day,$year))
    {
      header("Location: ".$phpgw->link("/bookkeeping/message.php","entry_id=$entry_id&selected=$selected&order=$order&error_id=1&script=entry_edit.php"));
      exit;
    }
    elseif($amount=='')
    {
      header("Location: ".$phpgw->link("/bookkeeping/message.php","entry_id=$entry_id&selected=$selected&order=$order&error_id=2&script=entry_edit.php"));
      exit;
    }
    else
    {
      $date_entry=mktime('1','0','0',$month,$day,$year);
      $sql="update phpgw_bk_entries set account_id=$account_id,income_expense='$income_expense',date_entry='$date_entry',category_id=$category_id,description='$description',amount='$amount' where entry_id=$entry_id";
      $phpgw->db->query($sql);
      header("Location: ".$phpgw->link("/bookkeeping/index.php","selected=$selected&order=$order"));
    }
  }
  else
  {
    $phpgw->template->set_file(array( "entry_edit" => "entry_edit.tpl"));

    $phpgw->template->set_var("header",$header);
    $phpgw->template->set_var("lang_app_title",lang("bookkeeping"));
    $phpgw->template->set_var("lang_title",lang("entries"));
    $phpgw->template->set_var("head_color","D3DCE3");

    $hidden_vars="<input type=\"hidden\" name=\"account_id\" value=\"".$phpgw_info["user"]["account_id"]."\">";

    if($selected=="expenses")
    {
      $hidden_vars.="<input type=\"hidden\" name=\"income_expense\" value=\"E\">";
      $lang_selected=lang("edit_expense");
      $income_expense='E';
    }
    else
    {
      $hidden_vars.="<input type=\"hidden\" name=\"income_expense\" value=\"I\">";
      $lang_selected=lang("edit_income");
      $income_expense='I';
    }

    $phpgw->template->set_var(hidden_vars,$hidden_vars);
    $phpgw->template->set_var("lang_selected",lang("$lang_selected"));
    $phpgw->template->set_var("lang_go_back",'<a href="'.$phpgw->link("/bookkeeping/index.php","selected=$selected&order=$order").'">'.lang("go_back").'</a>');

    $phpgw->db->query("select date_entry,category_id,amount,description from phpgw_bk_entries WHERE entry_id='$entry_id'");
    $phpgw->db->next_record();

    $lang_date_entry=lang("date");
    $_date_entry=getdate($phpgw->db->f("date_entry"));
    $year=$_date_entry["year"];
    $month=$_date_entry["mon"];
    $day=$_date_entry["mday"];
    $date_entry="<select name=\"year\">";
    for($i=($year-2);$i<=($year+1);$i++)
    {
      if($i==$year)
      {
        $date_entry.="<option value=\"".$i."\" selected>$i";
      }
      else
      {
        $date_entry.="<option value=\"".$i."\">$i";
      }
    }
    $date_entry.="</select>";
    $date_entry.="<select name=\"month\">";
    for($i=1;$i<=12;$i++)
    {
      if($i==$month)
      {
        $date_entry.="<option value=\"".$i."\" selected>$i";
      }
      else
      {
        $date_entry.="<option value=\"".$i."\">$i";
      }
    }
    $date_entry.="</select>";
    $date_entry.="<select name=\"day\">";
    for($i=1;$i<=31;$i++)
    {
      if($i==$day)
      {
        $date_entry.="<option value=\"".$i."\" selected>$i";
      }
      else
      {
        $date_entry.="<option value=\"".$i."\">$i";
      }
    }
    $date_entry.="</select>";

    $lang_category=lang("category");
    $sql2="select category_id,description from phpgw_bk_categories where income_expense='$income_expense' order by description asc";
    $db2->query($sql2);
    $category="<select name=\"category_id\">";
    while( $db2->next_record() )
    {
      if($db2->f("category_id")==$phpgw->db->f("category_id"))
      {
        $category.="<option value=\"".$db2->f("category_id")."\" selected>".$db2->f("description");
      }
      else
      {
        $category.="<option value=\"".$db2->f("category_id")."\">".$db2->f("description");
      }
    }
    $category.="</select>";

    $lang_amount=lang("amount");
    $amount="<input type=\"text\" name=\"amount\" value=\"".$phpgw->db->f("amount")."\">";

    $lang_description=lang("description");
    $description="<textarea name=\"description\" rows=\"4\" cols=\"50\" wrap=\"virtual\">".$phpgw->db->f("description")."</textarea>";

    $phpgw->template->set_var("lang_date_entry",$lang_date_entry);
    $phpgw->template->set_var("date_entry",$date_entry);
    $phpgw->template->set_var("lang_amount",$lang_amount);
    $phpgw->template->set_var("amount",$amount);
    $phpgw->template->set_var("lang_category",$lang_category);
    $phpgw->template->set_var("category",$category);
    $phpgw->template->set_var("lang_description",$lang_description);
    $phpgw->template->set_var("description",$description);
    $phpgw->template->set_var("actionurl",$phpgw->link("/bookkeeping/entry_edit.php","selected=$selected&order=$order&entry_id=$entry_id"));
    $phpgw->template->set_var("lang_edit",lang("edit"));
    $phpgw->template->parse("out", "entry_edit", true);
    $phpgw->template->p("out");

    $phpgw->common->phpgw_footer();
  }
?>
