<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  // HTTP_GET_VARS
  $order=$HTTP_GET_VARS['order'];
  $selected=$HTTP_GET_VARS['selected'];

  $phpgw_info["flags"]["currentapp"]="bookkeeping";
  include('../header.inc.php');
  include('inc/bookkeeping_header.inc.php');

  $phpgw->template->set_file(array( "categories" => "categories.tpl"));
  $phpgw->template->set_block("categories", "categories_list", "list");

  $phpgw->template->set_var("header",$header);
  $phpgw->template->set_var("lang_app_title",lang("bookkeeping"));
  $phpgw->template->set_var("lang_title",lang("categories"));
  $phpgw->template->set_var("head_color","D3DCE3");
  
  if ($order=="") {
     $order = "description";
  }
  if($selected==""){
    $selected="expenses";
  }
  $_switch=lang("switch to");
  if($selected=='expenses'){
    $lang_selected=lang("expenses");
    $_switch.=': <a href="'.$phpgw->link("/bookkeeping/categories.php","selected=income&order=$order").'">'.lang("income")."</a>";
    $income_expense='E';
  }else{
    $lang_selected=lang("income");
    $income_expense='I';
    $_switch.=': <a href="'.$phpgw->link("/bookkeeping/categories.php","selected=expenses&order=$order").'">'.lang("expenses")."</a>";
  }

  $phpgw->template->set_var("lang_selected",$lang_selected);
  $phpgw->template->set_var("lang_switch",$_switch);

  $phpgw->template->set_var("lang_description",'<a href="'.$phpgw->link("/bookkeeping/categories.php","selected=$selected&order=description").'">'.lang("description").'</a>');
  $phpgw->template->set_var("lang_edit",lang("edit"));
  $phpgw->template->set_var("lang_delete",lang("delete"));

  $phpgw->db->query("SELECT * FROM phpgw_bk_categories WHERE income_expense='$income_expense' order by $order");
  while(  $phpgw->db->next_record() ){
    $color=row_color($color);
    $phpgw->template->set_var("color",$color);
    $category_id = $phpgw->db->f("category_id");
    $description = $phpgw->db->f("description");
    $phpgw->template->set_var(array("description" => $description,
                          "edit" => '<a href="'.$phpgw->link("/bookkeeping/category_edit.php","category_id=".$category_id."&selected=$selected&order=$order").'">'.lang("edit")."</a>",
                          "delete" => '<a href="'.$phpgw->link("/bookkeeping/category_delete.php","category_id=".$category_id."&selected=$selected&order=$order").'">'.lang("delete")."</a>"));
    $phpgw->template->parse("list", "categories_list", true);
  }

  $phpgw->template->set_var("actionurl",$phpgw->link("/bookkeeping/category_add.php","selected=$selected&order=$order"));
  $phpgw->template->set_var("lang_add",lang("add"));
  $phpgw->template->parse("out", "categories", true);
  $phpgw->template->p("out");

  $phpgw->common->phpgw_footer();

?>
