<?php

/*************************************************************************\
* Bookkeeping (phpGroupWare app)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: index.php,v 1.3 2001/06/18 22:13:57 darw1n Exp $ */

//
//
//
$phpgw_info['flags']['currentapp'] = 'bookkeeping';
include('../../header.inc.php');

//
$bookkeeping_info['bookkeeping_account_id'] = $phpgw->session->appsession('id', 'bookkeeping');

//
$bookkeeping             = CreateObject('bookkeeping.bookkeeping');
$bookkeeping_bookkeeping = CreateObject('bookkeeping.bookkeeping_bookkeeping');
$template_header         = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template_modules        = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template                = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
$template_footer         = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);

//
$bookkeeping_info['bookkeeping_account_id'] = $phpgw->session->appsession('id', 'bookkeeping');
if ($bookkeeping_info['bookkeeping_account_id'] != '')
{
	$access = $bookkeeping->access_to_bookkeeping_account($bookkeeping_info['bookkeeping_account_id'], $phpgw_info['user']['account_id']);
	if ($access == 1)
	{
		$modules = $bookkeeping->show_all_modules($bookkeeping_info['bookkeeping_account_id']);
		$proceed = 'yes';
	}
	elseif ($access == '2')
	{
		$modules = $bookkeeping->show_modules($bookkeeping_info['bookkeeping_id'], $phpgw_info['user']['account_id']);
		$proceed = 'yes';
	}
	else
	{
		$modules = '&nbsp;';
		$proceed = 'no';
	}
}
else
{
	$proceed = 'no';
}

if ($proceed == 'yes')
{
	$template_sub = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$template_sub->set_file(array('index_sub1' => 'bookkeeping/index_sub2.tpl'));

	$bookkeeping_info['rights'] = $bookkeeping->bookkeeping_rights($bookkeeping_info['bookkeeping_account_id'], $phpgw_info['user']['account_id']);
	$is_admin = $bookkeeping->is_admin($bookkeeping_info['bookkeeping_account_id'], $phpgw_info['user']['account_id']);
	$is_bookkeeping_admin = $bookkeeping->is_admin(1, $phpgw_info['user']['account_id']);

	//
	// user section
	//
	if ((!isset($bookkeeping_info['rights']['change_bookkeeping_account'][0])) || $is_admin || $is_bookkeeping_admin)
	{
		if (isset($bookkeeping_info['rights']['change_bookkeeping_account'][1]) || $is_admin || $is_bookkeeping_admin)
		{
			$options = '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/change_bookkeeping_account.php') . '">' . lang('change_bookkeeping_account') . '</a>';
		}
	}

	//
	// admin section
	//
	$options .= '<p>';
	if (isset($bookkeeping_info['rights']['bookkeeping_schema'][1]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/view_bookkeeping_schema.php') . '">' . lang('view_bookkeeping_schema') . '</a>'; 
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_schema'][2]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/add_bookkeeping_schema.php') . '">' . lang('add_bookkeeping_schema') . '</a>'; 
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_schema'][4]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/edit_bookkeeping_schema.php') . '">' . lang('edit_bookkeeping_schema') . '</a>'; 
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_schema'][8]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/delete_bookkeeping_schema.php') . '">' . lang('delete_bookkeeping_schema') . '</a>';
		$options .= '<br>';
	}
	$options .= '<p>';
	if (isset($bookkeeping_info['rights']['group'][1]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/view_group.php') . '">' . lang('view_group') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['group'][2]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/add_group.php') . '">' . lang('add_group') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['group'][4]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/edit_group.php') . '">' . lang('edit_group') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['group'][8]) || $is_admin || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/delete_group.php') . '">' . lang('delete_group') . '</a>';
		$options .= '<br>';
	}

	//
	// bookkeeping admin section
	//
	$options .= '<p>';
	if (isset($bookkeeping_info['rights']['bookkeeping_account'][1]) || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/view_bookkeeping_account.php') . '">' . lang('view_bookkeeping_account') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_account'][2]) || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/add_bookkeeping_account_1.php') . '">' . lang('add_bookkeeping_account') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_account'][4]) || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/edit_bookkeeping_account.php') . '">' . lang('edit_bookkeeping_account') . '</a>';
		$options .= '<br>';
	}
	if (isset($bookkeeping_info['rights']['bookkeeping_account'][8]) || $is_bookkeeping_admin)
	{
		$options .= '&nbsp;&#8226;&nbsp;<a href="' . $phpgw->link('/bookkeeping/bookkeeping/delete_bookkeeping_account.php') . '">' . lang('delete_bookkeeping_account') . '</a>';
		$options .= '<br>';
	}





	$template_sub->set_var('options', $options);
	$index_sub = $template_sub->parse('index_sub', 'index_sub1', true);
}
else
{
	$template_sub->set_file(array('index_sub1' => 'bookkeeping/index_sub1.tpl'));
	$template_sub->set_var('message', lang('no_access_this_bookkeeping_account'));
	$index_sub = $template_sub->parse('index_sub', 'index_sub1', true);
}


$template_header->set_file(array('bookkeeping_header' => 'bookkeeping_header.tpl'));
$template_header->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template_header->set_var('lang_app_title', lang('bookkeeping'));
$template_header->set_var('lang_module', lang('module'));
$template_header->set_var('module', 'Bookkeeping');
$template_header->set_var('lang_bookkeeping_account', lang('bookkeeping_account'));
$phpgw->db->query("SELECT bookkeeping_account FROM phpgw_bk_ba WHERE bookkeeping_account_id='" . $bookkeeping_info['bookkeeping_account_id'] . "'");
$phpgw->db->next_record();
$bookkeeping_account = $phpgw->db->f('bookkeeping_account');
$template_header->set_var('bookkeeping_account', $bookkeeping_account);
$template_header->parse('out', 'bookkeeping_header', true);
$template_header->p('out');

//
//
//
$template_modules->set_file(array('bookkeeping_modules' => 'bookkeeping_modules.tpl'));
$template_modules->set_var('modules', $modules);
$template_modules->parse('out', 'bookkeeping_modules', true);
$template_modules->p('out');

//
//
//
$template->set_file(array('index' => 'bookkeeping/index.tpl'));
$template->set_var('index_sub', $index_sub);
$template->parse('out', 'index', true);
$template->p('out');

//
//
//
$template_footer->set_file(array('bookkeeping_footer' => 'bookkeeping_footer.tpl'));
$template_footer->set_var('head_color', $phpgw_info['theme']['th_bg']);
$template_footer->parse('out', 'bookkeeping_footer', true);
$template_footer->p('out');

//
//
//
$phpgw->common->phpgw_footer();

?>
