#!/bin/sh
#
# $Progeny: modtofile.sh,v 1.4 2002/01/18 06:19:54 dsp Exp $
#

if [ "$#" -lt "2" ] ; then
    echo "Usage: $0 kernel_version module [module ...]" 1>&2
    exit 1
fi

version=$1 ; shift

[ ! -f /lib/modules/$version/modules.dep ] && depmod -F /boot/System.map-$version -a $version

for module in $* ; do
    awk '! /\\$/ { print $0 } \
           /\\$/ { printf("%s", substr($0, 1, length($0) - 1)) }' \
           /lib/modules/$version/modules.dep \
        | grep "^/lib/modules/$version/.*/$module.o" \
        | awk '{ print substr($1, 1, length($1) - 1) ; \
            for (i = 2; i <= NF; i++) print $i }'
done
