;; $Id: theme.jl,v 1.16 2000/08/14 14:23:08 john Exp $
;; $Progeny: theme.jl,v 1.7 2002/01/31 22:01:08 epg Exp $

;; Copyright (C) 1999 John Harper <john@dcs.warwick.ac.uk>
;; Copyright (C) 2001 Progeny Linux Systems, Inc.

;; This is based on the Simple theme distributed with Sawfish
;; (nee Sawmill) and modified for Progeny by Eric Gillespie, Jr.
;; <epg@progeny.com>.

;; sawmill is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; sawmill is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with sawmill; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

(defgroup installer "Installer Theme"
  :group appearance)

(defcustom installer:normal-color "#5e5e5e"
  "Color of inactive frames in `installer' frame style."
  :type color
  :group (appearance installer)
  :user-level novice
  :after-set after-setting-frame-option)

(defcustom installer:active-color "#006699"
  "Color of active frames in `installer' frame style."
  :type color
  :group (appearance installer)
  :user-level novice
  :after-set after-setting-frame-option)

(let*
    ((frame-colors (lambda (w)
		     (list (or (window-get w 'frame-inactive-color)
			       installer:normal-color)
			   (or (window-get w 'frame-active-color)
			       installer:active-color))))

     (frame `(((background . ,frame-colors)
	       (foreground . "white")
	       (text . ,window-name)
	       (x-justify . 30)
	       (y-justify . center)
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -21)
	       (height . 21)
	       (class . title))

	      ((background . "black")
	       (left-edge . 0)
	       (right-edge . 0)
	       (top-edge . -22)
	       (height . 1))

	      ((background . "black")
	       (left-edge . -1)
	       (width . 1)
	       (top-edge . -22)
	       (bottom-edge . -5))

	      ((background . "black")
	       (right-edge . -1)
	       (width . 1)
	       (top-edge . -22)
	       (bottom-edge . -5))

	      ((background . ,frame-colors)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -4)
	       (height . 4)
	       (class . bottom-border))

	      ((background . "black")
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -5)
	       (height . 1))))

     (shaped-frame `(((background . ,frame-colors)
		      (foreground . "black")
		      (text . ,window-name)
		      (x-justify . 30)
		      (y-justify . center)
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . -21)
		      (height . 21)
		      (class . title))

		     ((background . "black")
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . -22)
		      (height . 1))

		     ((background . "black")
		      (left-edge . -1)
		      (width . 1)
		      (top-edge . -22)
		      (height . 23))

		     ((background . "black")
		      (right-edge . -1)
		      (width . 1)
		      (top-edge . -22)
		      (height . 23))

		     ((background . "black")
		      (left-edge . 0)
		      (right-edge . 0)
		      (top-edge . 0)
		      (height . 1))))

     (transient-frame `(((background . ,frame-colors)
			 (left-edge . 0)
			 (right-edge . 0)
			 (top-edge . -4)
			 (height . 4)
			 (class . title))

			((background . "black")
			 (left-edge . 0)
			 (right-edge . 0)
			 (top-edge . -5)
			 (height . 1))

			((background . "black")
			 (left-edge . -1)
			 (width . 1)
			 (top-edge . -5)
			 (bottom-edge . -5))

			((background . "black")
			 (right-edge . -1)
			 (width . 1)
			 (top-edge . -5)
			 (bottom-edge . -5))

			((background . ,frame-colors)
			 (left-edge . 0)
			 (right-edge . 0)
			 (bottom-edge . -4)
			 (height . 4)
			 (class . bottom-border))

			((background . "black")
			 (left-edge . 0)
			 (right-edge . 0)
			 (bottom-edge . -5)
			 (height . 1))))

     (shaped-transient-frame `(((background . ,frame-colors)
				(left-edge . 0)
				(right-edge . 0)
				(top-edge . -5)
				(height . 4)
				(class . title))

			       ((background . "black")
				(left-edge . 0)
				(right-edge . 0)
				(top-edge . -6)
				(height . 1))

			       ((background . "black")
				(left-edge . -1)
				(width . 1)
				(top-edge . -6)
				(height . 6))

			       ((background . "black")
				(right-edge . -1)
				(width . 1)
				(top-edge . -6)
				(height . 6))

			       ((background . "black")
				(left-edge . 0)
				(right-edge . 0)
				(top-edge . -1)
				(height . 1)))))

  (add-frame-style 'installer
		   (lambda (w type)
		     (case type
		       ((default) frame)
		       ((transient) transient-frame)
		       ((shaped) shaped-frame)
		       ((shaped-transient) shaped-transient-frame)))))
