#! /usr/bin/python

# $Progeny: setup-bootloader-text.py,v 1.5 2002/02/01 22:54:22 epg Exp $

import sys

import pgi.bootloader
import pgi.common

from getopt import getopt, GetoptError
from pgi.common import TRUE, FALSE, EX_USAGE, _, warn

###############################################################################
# getopt

device = None
root = None
target = "/target"

try:
    (opts, args) = getopt(sys.argv[1:], "",
                          ["root=", "target="])
except GetoptError:
    sys.exit(EX_USAGE)

for (o, a) in opts:
    if o == "--root":
        root = a
    elif o == "--target":
        target = a

if not root:
    sys.exit(EX_USAGE)

if len(args) == 0:
    sys.exit(EX_USAGE)

device = args[0]

###############################################################################
# Main

pgi.bootloader.install(device, root, target)
