# $Progeny: base.py,v 1.61 2002/04/23 21:47:14 branden Exp $

import os
import string
import sys

import pgi.common

from pgi.common import TRUE, FALSE

LIVE = pgi.common.get_live()
LOGFILE = pgi.common.get_logfile()
MESSAGES = LIVE + "/share/installer/messages"

def _run_command(command, tries=1, callback=None, cbdata=None):
    result = "bogus"

    while tries and result != None:
        pipe = os.popen(command, "r")

        line = pipe.readline()
        while line:
            pgi.common.msg(line)
            if callback:
                callback(line, cbdata)
            else:
                sys.stdout.write(line)
            line = pipe.readline()

        result = pipe.close()

        tries = tries - 1

    return (result == None)

def _write_fstab_line(fstab, device, mntpnt, fstype, options, dumpno,
                           passno):
    fstab.write("%s\t%s\t%s\t%s\t%d\t%d\n" % (device, mntpnt, fstype,
                                              options, dumpno, passno))

def get_messages(type):
    retval = None

    if os.path.exists(MESSAGES):
        druidtext = open(MESSAGES)
        state = "none"
        druid_texts = {}
        for line in druidtext.readlines():
            if line[0] == "<":
                if line[1] == "/":
                    state = "none"
                else:
                    state = line[1:string.find(">", line) - 1]
                continue

            if not druid_texts.has_key(state):
                druid_texts[state] = ""
            druid_texts[state] = druid_texts[state] + line

        druidtext.close()

        if druid_texts.has_key(type):
            retval = druid_texts[type]

    return retval

def mount(mounts, target):
    mntpnts = mounts.keys()
    mntpnts.sort()

    for mntpnt in mntpnts:
        (device, fstype) = mounts[mntpnt]
        if mntpnt == "/":
            # Write this to the initrd's fstab so stage0.sh will have
            # no problems remounting /target read-only.
            fstab = open("/etc/fstab", "a")
            fstab.write("%s %s %s defaults 0 0\n" % (device, target, fstype))
            fstab.close()

            os.system("mkdir -p " + target)
            os.system("mount -t %s %s %s" % (fstype, device, target))
        else:
            os.system("mkdir -p " + target + mntpnt)
            os.system("mount -t %s %s %s" % (fstype, device, target + mntpnt))

    return TRUE

def unmount(mounts, target):
    mntpnts = mounts.keys()
    mntpnts.sort()

    for mntpnt in mntpnts:
        (device, fstype) = mounts[mntpnt]
        if mntpnt != target:
            command = "umount %s" % (mntpnt,)
        else:
            continue

        pgi.common.msg("Running %s\n" % (command,))
        os.system(command)

    return TRUE

def install_packages(suite, mirror, target, extra_pkg_fn = None, \
                     callback = None, cbdata = None):
    if os.path.exists("%s/debian" % (LIVE,)):
        mirror = "file://%s/debian" % (LIVE,) # LIVE already has a prefixed /
    pgi.common.msg("Using %s mirror.\n" % (mirror,))

    if extra_pkg_fn:
        extra_pkg_file = open(extra_pkg_fn)
        extra_pkg_data = extra_pkg_file.read()
        extra_pkg_file.close()

        extra_pkgs = string.split(extra_pkg_data)
        extra_pkg_arg = "--include=%s" % (string.join(extra_pkgs, ","),)
        pgi.common.msg("Including: %s\n" % (extra_pkg_arg,))
    else:
        extra_pkg_arg = ""
        pgi.common.msg("Not including extra packages.\n")

    del os.environ["PYTHONHOME"]

    if os.environ["PGIDEBUG"] == "noisy":
        debug_option = "-x"
    else:
        debug_option = ""

    command = "%s/sbin/bash %s %s/sbin/debootstrap --exclude=lilo %s %s %s %s" \
              % (LIVE, debug_option, LIVE, extra_pkg_arg, suite, target, mirror)
    pgi.common.msg("Running command %s\n" % (command,))
    if not _run_command(command, 1, callback, cbdata):
        return FALSE

    #if (mirror[:5] == "file:"):
    #    sources_list = open("%s/etc/apt/sources.list" % (target,), "w")
    #    sources_list.write("deb %s %s main\n" % (mirror, suite))
    #    sources_list.close()

    return TRUE

def mkfstab(mounts, swaps, target):
    mntpnts = mounts.keys()
    mntpnts.sort()

    fstab = open("%s/etc/fstab" % (target,), "w")
    fstab.write("""
# /etc/fstab: static file system information.
#
# <file system> <mount point> <type> <options> <dump> <pass>
""")

    for mntpnt in mntpnts:
        (device, fstype) = mounts[mntpnt]
        if mntpnt == "/":
            _write_fstab_line(fstab, device, mntpnt, fstype,
                              "defaults,errors=remount-ro", 0, 1)
        else:
            _write_fstab_line(fstab, device, mntpnt, fstype,
                              "defaults", 0, 2)
    for swap in swaps:
        _write_fstab_line(fstab, swap, "none", "swap", "sw", 0, 0)

    _write_fstab_line(fstab, "proc", "/proc", "proc", "defaults", 0, 0)
    _write_fstab_line(fstab, "/dev/fd0", "/floppy", "auto",
                      "defaults,user,noauto", 0, 0)
    _write_fstab_line(fstab, "/dev/cdrom", "/cdrom", "iso9660",
                      "defaults,ro,user,noauto", 0, 0)
    fstab.close()

    return TRUE

def install_kernel(target):
    os.system("cp -a %s/kernel/* %s" % (LIVE, target))

    return TRUE

# vim:ai:et:sts=4:sw=4:tw=0:
