# Instruction to build PLplot from internal package source
SET(EXTRA "")
IF(APPLE)
   SET(EXTRA  -DCMAKE_INSTALL_NAME_DIR=${CMAKE_INSTALL_PREFIX}/lib)
ELSE(APPLE)
   SET(EXTRA -DCMAKE_INSTALL_RPATH=${CMAKE_INSTALL_PREFIX}/lib)
ENDIF(APPLE)

INCLUDE(ExternalProject)
IF(STANDALONE)
	SET(SHARED_LIBS OFF)
ELSE(STANDALONE)
	SET(SHARED_LIBS ON)
ENDIF(STANDALONE)

IF(NOT BUILD_GD)
	EXTERNALPROJECT_ADD(PLplot
			URL file://${PROJECT_SOURCE_DIR}/extern/plplot-5.11.0.zip
			PREFIX ${CMAKE_CURRENT_BINARY_DIR}/PLplot
			CMAKE_ARGS 	-DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_CURRENT_BINARY_DIR}/PLplot
			-DBUILD_DOC=OFF
			-DBUILD_TEST=OFF
			-DBUILD_DOX_DOC=OFF
			-DBUILD_SHARED_LIBS=${SHARED_LIBS}
			-DDEFAULT_NO_CAIRO_DEVICES=ON
			-DDEFAULT_NO_QT_DEVICES=ON
			-DDEFAULT_NO_BINDINGS=ON
			-DDEFAULT_NO_DEVICES=ON
			-DENABLE_DYNDRIVERS=OFF
			-DPLD_jpeg=ON
			-DPLD_png=ON
			${EXTRA}
	)
ELSE(NOT BUILD_GD)
	EXTERNALPROJECT_ADD(PLplot
			DEPENDS libGD
			URL file://${PROJECT_SOURCE_DIR}/extern/plplot-5.11.0.zip
			PREFIX ${CMAKE_CURRENT_BINARY_DIR}/PLplot
			CMAKE_ARGS 	-DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_CURRENT_BINARY_DIR}/PLplot
			-DBUILD_DOC=OFF
			-DBUILD_TEST=OFF
			-DBUILD_DOX_DOC=OFF
			-DBUILD_SHARED_LIBS=${SHARED_LIBS}
			-DDEFAULT_NO_CAIRO_DEVICES=ON
			-DDEFAULT_NO_QT_DEVICES=ON
			-DDEFAULT_NO_BINDINGS=ON
			-DDEFAULT_NO_DEVICES=ON
			-DENABLE_DYNDRIVERS=OFF
			-DPLD_jpeg=ON
			-DPLD_png=ON
			-DGD_INCLUDE_DIR:PATH=${CMAKE_CURRENT_BINARY_DIR}/libGD/include
			-DGD_LIBRARY:PATH=${GD_LIBRARIES}
			-DUSE_RPATH=ON
			${EXTRA}
	)
ENDIF(NOT BUILD_GD)

ExternalProject_Get_Property(PLplot install_dir)
include_directories(${CMAKE_CURRENT_BINARY_DIR}/PLplot/include)
MESSAGE(STATUS "PLplot will be built in ${install_dir}")

SET( PLplot_LIBRARY_DIR ${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib PATH)
# Set uncached variables as per standard.
# 	  set(hpdf_FOUND ON)
SET(PLplot_INCLUDE_DIR ${CMAKE_CURRENT_BINARY_DIR}/PLplot/include CACHE PATH "" FORCE)

IF(STANDALONE)
	SET(PLplot_LIBRARIES 
				${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libplplot${CMAKE_STATIC_LIBRARY_SUFFIX};
				${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libcsirocsa${CMAKE_STATIC_LIBRARY_SUFFIX};
				${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libqsastime${CMAKE_STATIC_LIBRARY_SUFFIX};
				${GD_LIBRARIES}
				CACHE STRING "" FORCE
	)
ELSE(STANDALONE)
	IF(NOT BUILD_GD)
		SET(PLplot_LIBRARIES 
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libplplot${CMAKE_SHARED_LIBRARY_SUFFIX};
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libcsirocsa${CMAKE_SHARED_LIBRARY_SUFFIX};
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libqsastime${CMAKE_SHARED_LIBRARY_SUFFIX}
					CACHE STRING "" FORCE
		)
	ELSE(NOT BUILD_GD)
		SET(PLplot_LIBRARIES 
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libplplot${CMAKE_SHARED_LIBRARY_SUFFIX};
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libcsirocsa${CMAKE_SHARED_LIBRARY_SUFFIX};
					${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib/libqsastime${CMAKE_SHARED_LIBRARY_SUFFIX};
					${CMAKE_CURRENT_BINARY_DIR}/libGD/lib/libgd${CMAKE_SHARED_LIBRARY_SUFFIX}
					CACHE STRING "" FORCE 
		)
	ENDIF(NOT BUILD_GD)
	INSTALL(DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/PLplot/lib
					DESTINATION ./
					USE_SOURCE_PERMISSIONS
					FILES_MATCHING PATTERN "*${CMAKE_SHARED_LIBRARY_SUFFIX}*"
				 )
ENDIF(STANDALONE)
