#include <unistd.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>

#include "npsummary.h"

void tree_widget_callback( GtkWidget *widget, gpointer data )
{
   void *selection = GTK_TREE( widget )->selection;
   if ( selection == NULL )
      return;

   selection = GTK_TREE_SELECTION( widget )->data;
   if ( selection == NULL )
      return;

   NP_Summary *summary = ( NP_Summary *)data;
   if ( summary->text_line < 0 && selection == summary->selected_item )
      return;

   tree_item_callback( ( GtkWidget *)selection, data );

   return;
}

void tree_item_callback( GtkWidget *widget, gpointer data )
{
   static int running = 0;
   if ( running )
      return;
   else
      running = 1;

   NP_Summary *summary =
      ( NP_Summary *)gtk_object_get_data( GTK_OBJECT( widget ), "object" );
   if ( summary == NULL )
   {
      fprintf( stderr, "NULL summary pointer in tree_item_callback()\n" );
      return;
   }

   summary->selected_item = widget;
   if ( summary->selected_item == NULL )
   {
      running = 0;
      return;
   }

   summary->current_node =
      ( np_thread_node_t *)gtk_object_get_data( GTK_OBJECT( widget ), "node" );

   if ( summary->current_node == NULL ||
        summary->current_node->is_article < 0 )
   {
      running = 0;
      return;
   }
   
   if ( summary->list_onscreen )
   {
      for( int i = 0; i < summary->total; ++i )
      {
         if ( summary->items[ i ] == summary->selected_item )
         {
            for( int j = 0; j < summary->total; ++j )
            {
               if ( summary->positions[ j ] == i )
               {
                  gtk_clist_select_row( GTK_CLIST( summary->list ), j, 0 );
                  break;
               }
            }

            break;
         }
      }
   }

   if ( summary->button )
   {
      GtkWidget *pointer = ( GtkWidget *)summary->selected_item;

      float pos = pointer->allocation.y;
      int height = pointer->requisition.height;

      while( pos < 0 && gtk_events_pending() )
      {
         gtk_main_iteration();
         pos = pointer->allocation.y;
         height = pointer->allocation.height;
      }

      np_thread_node_t *node = summary->current_node;

      while( node->parent != NULL )
      {
         node = node->parent;
         pointer = pointer->parent;
         pos += pointer->allocation.y;
      }

      static int old_chunk = 0;
      GtkAdjustment *adjustment = summary->adjustment;
      int chunk = int(( pos + height ) / adjustment->page_size );

      if ( chunk != old_chunk )
      {
         float value = chunk * adjustment->page_size;
         if ( value >= adjustment->upper - adjustment->page_size )
            value = adjustment->upper - adjustment->page_size;

         gtk_adjustment_set_value( adjustment, value - height );
      }

      old_chunk = chunk;
   }

   if ( !summary->text_pid )
   {
      if ( pipe( summary->text_pipe ))
      {
         perror( "pipe" );
         running = 0;
         return;
      }

      summary->SIGPIPE_received = 0;
   
      switch( summary->text_pid = fork() )
      {
      case -1:
         perror( "fork" );
         running = 0;
         return;
         break;

      case 0:
         close( ConnectionNumber( gdk_display ));
         close( summary->text_pipe[ 1 ] );

         if ( dup2( summary->text_pipe[ 0 ], STDIN_FILENO ) < 0 )
         {
            perror( "dup2" );
            exit( 1 );
         }

         execlp( "nptext", "nptext", NULL );
         perror( "execlp" );
         _exit( 1 );
         break;

      default:
         close( summary->text_pipe[ 0 ] );

         char buffer[ 128 ];
         snprintf( buffer, sizeof buffer, "%d", summary->text_pid );
         if ( summary->children.add_item( buffer ))
            summary->children.print_error();

         break;
      }

      if (( summary->output = fdopen( summary->text_pipe[ 1 ] , "w" ))
          == NULL )
      {
         perror( "fdopen" );
         running = 0;
         return;
      }
   }

   if ( !summary->SIGPIPE_received &&
        summary->text_pid &&
        summary->output != NULL )
   {
      fprintf( summary->output, "%s\n%s\n%ld\n%ld\n%d\n%d\n%d\n",
               summary->server, summary->group,
               summary->current_node->offset, summary->current_node->size,
               summary->current_node->is_article,
               summary->current_node->is_requested,
               summary->text_line );

      fflush( summary->output );

      summary->text_line = 0;
   }

   if ( summary->current_node->is_unseen )
   {
      if ( !summary->is_stdout_a_tty )
      {
         printf( "%s\n%s\ns\n.", summary->server, summary->group );
         fflush( stdout );
      }
      
      summary->current_node->is_unseen = 0;

      np_thread_node_t *pointer = summary->current_node;
      char *line = summary->create_tree_entry( pointer );
      gtk_label_set( GTK_LABEL( pointer->label ), line );

      GtkStyle *style;
      if ( !pointer->is_article )
      {
         if ( pointer->is_requested )
            style = ( pointer->is_unseen ? summary->unread_request_style :
                  summary->request_style );
         else
            style = ( pointer->is_unseen ?  summary->unread_header_style : 
                                            summary->header_style );
      }
      else if ( pointer->is_article < 0 )
         style = ( pointer->unseen_descendents ?  summary->unread_dummy_style :
                                                  summary->dummy_style );
      else
         style = ( pointer->is_unseen ? summary->unread_style : 
                                        summary->read_style );

      gtk_widget_set_style( GTK_WIDGET( pointer->label ), style );

      if ( pointer->is_child )
      {
         while( pointer->is_child == 1 )
            pointer = pointer->parent;

         --pointer->unseen_descendents;

         line = summary->create_tree_entry( pointer );
         gtk_label_set( GTK_LABEL( pointer->label ), line );
         GtkStyle *style;
         if ( !pointer->is_article )
         {
            if ( pointer->is_requested )
               style = ( pointer->is_unseen ? summary->unread_request_style :
                                              summary->request_style );
            else
               style = ( pointer->is_unseen ?  summary->unread_header_style : 
                                               summary->header_style );
         }
         else if ( pointer->is_article < 0 )
         {
            if ( pointer->unseen_descendents )
               style = summary->unread_dummy_style;
            else
               style = summary->dummy_style;
         }
         else
            style = ( pointer->is_unseen ? summary->unread_style : 
                                           summary->read_style );

         gtk_widget_set_style( GTK_WIDGET( pointer->label ), style );
      }      
   }

   running = 0;
   
   return;
}
