#include "npsummary.h"

void left_green_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Summary *summary = ( NP_Summary *)data;

   if ( !summary->total || summary->tree == NULL )
      return;

   if ( summary->current_node == NULL || summary->selected_item == NULL )
   {
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( summary->tree->item ));
   }

   np_thread_node_t *pointer, *old = summary->current_node;

   while(( pointer = left_button_callback( NULL, data )) != NULL )
   {
      if ( pointer->is_requested == 1 && pointer->item != NULL )
         break;

      summary->current_node = pointer;
   }
                                        
   if ( pointer != NULL && pointer->is_requested == 1 && pointer->item != NULL )
   {
      old = pointer;
      while( old->is_child == 1 )
      {
         old = old->parent;
         gtk_tree_item_expand( GTK_TREE_ITEM( old->item ));
      }
      
      summary->button = 1;
      gtk_tree_select_child( GTK_TREE( summary->tree_widget ),
                             GTK_WIDGET( pointer->item ));
      summary->button = 0;
   }
   else
      summary->current_node = old;

   return;
}
