#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"

int NP_Pex::expire_group( char *server, char *group )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Pex: expire_group(): "
              "NULL server address passed as argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Pex: expire_group(): "
              "NULL group name passed as argument." );
      return 1;
   }

   char path[ 1024 ];
   snprintf( path, sizeof path, "%s/.peruser_spool/%s-%s", home,
             server, group );
   if ( spool.openr( path ))
   {
      if ( errno == ENOENT )
         return 0;
      
      snprintf( error_message, sizeof error_message, "NP_Pex: expire_group(): "
                " %s", spool.get_error());
      return 1;
   }

   char read_path[ 1024 ];
   snprintf( read_path, sizeof read_path, "%s:read", path );
   if ( read.openr( read_path ))
   {
      if ( errno != ENOENT )
      {
         spool.close();
         snprintf( error_message, sizeof error_message,
                   "NP_Pex: expire_group(): %s", read.get_error());
         return 1;
      }
   }

   char temp_path[ 1024 ];
   snprintf( temp_path, sizeof temp_path, "%s:tmp", path );
   if ( temp.openw( temp_path ))
   {
      spool.close();
      temp.close();
      snprintf( error_message, sizeof error_message, "NP_Pex: expire_group(): "
                " %s", temp.get_error());
      return 1;
   }

   char temp_read_path[ 1024 ];
   snprintf( temp_read_path, sizeof temp_read_path, "%s:tmp", read_path );

   if ( read.is_open )
   {
      if ( temp_read.openw( temp_read_path ))
      {
         spool.close();
         temp.close();
         read.close();
         remove( temp_path );
         snprintf( error_message, sizeof error_message,
                   "NP_Pex: expire_group(): %s", temp_read.get_error());
         return 1;
      }
   }
   
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", home );
   if ( config.openr( buffer ))
   {
      spool.close();
      temp.close();
      read.close();
      temp_read.close();
      remove( temp_path );
      remove( temp_read_path );
      snprintf( error_message, sizeof error_message, "NP_Pex: expire_group(): "
                "%s", config.get_error());
      return 1;
   }

   char *line;
   for( int i = 0; i < 4; ++i )
   {
      if (( line = config.get_string()) == NULL )
      {
         spool.close();
         temp.close();
         read.close();
         temp_read.close();
         config.close();
         remove( temp_path );
         remove( temp_read_path );
         snprintf( error_message, sizeof error_message, "NP_Pex: "
                   "expire_group(): %s", config.get_error());
         return 1;
      }
   }
   
   char elapsed[ 16 ];
   snprintf( elapsed, sizeof elapsed,
            "000000%02d000000", atoi( line ));
   config.close();
   
   time_t t;
   time( &t );
   struct tm *bt = localtime( &t );

   buffer[ 0 ] = elapsed[ 0 ];
   buffer[ 1 ] = elapsed[ 1 ];
   buffer[ 2 ] = elapsed[ 2 ];
   buffer[ 3 ] = elapsed[ 3 ];
   buffer[ 4 ] = '\0';

   int year = atoi( buffer );

   buffer[ 0 ] = elapsed[ 4 ];
   buffer[ 1 ] = elapsed[ 5 ];
   buffer[ 2 ] = '\0';

   int month = atoi( buffer );

   buffer[ 0 ] = elapsed[ 6 ];
   buffer[ 1 ] = elapsed[ 7 ];

   int day = atoi( buffer );

   buffer[ 0 ] = elapsed[ 8 ];
   buffer[ 1 ] = elapsed[ 9 ];

   int hours = atoi( buffer );

   buffer[ 0 ] = elapsed[ 10 ];
   buffer[ 1 ] = elapsed[ 11 ];

   int minutes = atoi( buffer );

   buffer[ 0 ] = elapsed[ 12 ];
   buffer[ 1 ] = elapsed[ 13 ];

   int seconds = atoi( buffer );

   bt->tm_year += 1900;
   bt->tm_year -= year;
   bt->tm_mon -= month;
   bt->tm_mon++;  
   bt->tm_mday -= day;
   bt->tm_hour -= hours;
   bt->tm_min -= minutes;
   bt->tm_sec -= seconds;

   adjust_time( &bt->tm_hour, &bt->tm_min, &bt->tm_sec, 
                &bt->tm_mday, &bt->tm_mon, &bt->tm_year );

   char test[ 32 ];
   snprintf( test, sizeof test, "%4d%02d%02d%02d%02d%02d", bt->tm_year,
             bt->tm_mon, bt->tm_mday, bt->tm_hour, bt->tm_min, bt->tm_sec );

   int total = 0;
   while(( line = spool.get_string()) != NULL )
      if ( !strncmp( line, ".\r\n", 3 ))
         ++total;

   char **localtimes = ( char **)calloc( total, sizeof localtimes );
   if ( localtimes == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   if ( spool.seek( 0, SEEK_SET ))
   {
      spool.close();
      read.close();
      temp.close();
      temp_read.close();
      remove( temp_path );
      remove( temp_read_path );
      free( localtimes );
      snprintf( error_message, sizeof error_message, "NP_Pex: expire_group(): "
                " %s", spool.get_error());
      return 1;
   }

   int found = 0;
   char **pointer = localtimes;

   while(( line = spool.get_string()) != NULL )
   {
      if ( !strncmp( line, ".\r\n", 3 ))
         continue;

      if ( found || !strncmp( line, "\r\n", 2 ))
      {
         if ( !found )
            if (( *localtimes++ = strdup( "" )) == NULL )
            {
               perror( "strdup" );
               exit( 1 );
            }

         do
            if (( line = spool.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message,
                         "NP_Pex: expire_group(): premature"
                         " end of spool: %s", path );
               return 1;
            }
         while( strncmp( line, ".\r\n", 3 ));

         found = 0;
         continue;
      }
               
      if ( !strncasecmp( line, "Date:", 5 ))
      {
         found = 1;
            
         strtok( line, "\r\n" );
         int result;
         if (( result = convert_date( line + 5 + strspn( line, " \t" ),
                                      pointer++ )))
         {
            if ( result == 2 )
               print_error();
            else
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               remove( temp_path );
               remove( temp_read_path );
               free( localtimes );
               return 1;
            }
         }
      }
   }

   if ( spool.seek( 0, SEEK_SET ))
   {
      spool.close();
      read.close();
      temp.close();
      temp_read.close();
      free( localtimes );
      remove( temp_path );
      remove( temp_read_path );
      snprintf( error_message, sizeof error_message, "NP_Pex: expire_group(): "
                " %s", spool.get_error());
      return 1;
   }

   pointer = localtimes;
   for( int i = 0; i < total; ++i )
   {
      if ( *pointer == NULL )
         continue;

      if ( strcmp( *pointer++, test ) > 0 )
      {
         do
         {
            if (( line = spool.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "expire_spool(): %s", spool.get_error());
               return 1;
            }

            if ( temp.put_string( line ))
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "expire_spool(): %s", temp.get_error());
               return 1;
            }
         }
         while( strncmp( line, ".\r\n", 3 ));
         
         if ( read.is_open )
         {
            if (( line = read.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "expire_spool(): %s", read.get_error());
               return 1;
            }

            if ( temp_read.put_string( line ))
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "expire_spool(): %s", temp_read.get_error());
               return 1;
            }
         }
      }
      else
      {
         if ( read.is_open )
            if (( line = read.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message,
                         "NP_Pex: expire_group(): premature"
                         " end of readfile: %s", read_path );
               return 1;
            }

         do
            if (( line = spool.get_string()) == NULL )
            {
               spool.close();
               read.close();
               temp.close();
               temp_read.close();
               free( localtimes );
               remove( temp_path );
               remove( temp_read_path );
               snprintf( error_message, sizeof error_message, "NP_Pex: "
                         "expire_spool(): %s", spool.get_error());
               return 1;
            }
         while( strncmp( line, ".\r\n", 3 ));
      }
   }
   
   free( localtimes );

   spool.close();
   read.close();
   temp.close();
   temp_read.close();

   rename( temp_path, path );
   rename( temp_read_path, read_path );

   return 0;
}
