#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void execute_search_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( *collections->search_text == '\0' ||
        *collections->search_text == '\n' )
      return;
   
   gtk_object_set_data( GTK_OBJECT( collections->window ),
                        "regexp", collections->search_text );

   pack_button_callback( ( GtkWidget *)1, data );

   gtk_object_remove_data( GTK_OBJECT( collections->window ), "regexp" );

   int total = collections->search_results.get_total();
   if ( total < 0 )
   {
      collections->search_results.print_error();
      return;
   }

   gtk_clist_clear( GTK_CLIST( collections->search_clist ));

   char buffer[ 128 ];
   snprintf( buffer, sizeof buffer, "Matches: %d", total );
   gtk_label_set( GTK_LABEL( collections->search_label ), buffer );

   if ( !total )
      return;

   gtk_clist_freeze( GTK_CLIST( collections->search_clist ));

   for( int i = 0; i < total; ++i )
   {
      char *text[ 5 ];
      char *pointer = ( char *)collections->search_results[ i ];
      if ( pointer == NULL )
      {
         collections->search_results.print_error();
         break;
      }

      text[ 0 ] = strtok( pointer, ":" );
      text[ 1 ] = strtok( NULL, ":" );
      text[ 2 ] = strtok( NULL, ":" );
      text[ 3 ] = strtok( NULL, ":" );
      text[ 4 ] = strtok( NULL, "\n" );

      gtk_clist_append( GTK_CLIST( collections->search_clist ), text );
   }

   gtk_clist_thaw( GTK_CLIST( collections->search_clist ));

   return;
}
