//
// C++ Implementation: taglistviewitem.cpp
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:55:55

#include <algorithm>

#if 0
#include <tagcoll/OpSet.h>
#endif

#include <helpers.h>

#include "taglistviewitem.h"
#include "tagselectionview.h"


TagListViewItem::TagListViewItem(Q3ListViewItem* pParent, const string& fullTagname, 
	const string& description)
	: Q3ListViewItem(pParent)
{
	_fullTagname = fullTagname;
	_description = description;
	string shortname = TagItem::getShortname(_fullTagname);
// 	cout << "Shortname:  "<< shortname<<endl;
// 	cout << "Description:  "<< description<<endl;

	setText(0, toQString(shortname));
	setText(1, toQString(description));
}

TagListViewItem::TagListViewItem(Q3ListView* pParent, const string& fullTagname, 
	const string& description)
	: Q3ListViewItem(
			pParent,
			"test"
	  )
{
	_fullTagname = fullTagname;
	_description = description;
	string shortname = TagItem::getShortname(_fullTagname);
	setText(0, toQString(shortname));
	setText(1, toQString(description));
}

bool TagListViewItem::filterByName(const string& pattern)
{
	bool found = false;
	TagListViewItem* pChild = static_cast<TagListViewItem*>(firstChild());

	// if we did found the object in a facet, all its children will be visible
	if ( text(0).contains(QString(pattern.c_str())))	// if we did not already find the 
		// object (for performance reasons) check if the current object contains it 
	{
		setVisible(true);
		return true;
	}
	// search in the children
	while (pChild)
	{
		if (pChild->filterByName(pattern))
			found = true;
		pChild = static_cast<TagListViewItem*>(pChild->nextSibling());
	}
	if (found)	// if one of the children contained the filter
		setOpen(true);
	/** @todo BUG in QT? After backspace a wrong list is shown, even though the item was made invisible.
	  * I fixed this with a proceeding make all visible, but it it kinda ugly...
	if (text(0)=="boot")
	{
		if (text(0).contains(filter) && !found)
			std::cerr << "Making boot visible"<<endl;
		else
			std::cerr << "Making boot invisible"<<endl;

	}*/
	setVisible(found);
	return found;
}

bool TagListViewItem::filterByTagset(const std::set<string>& shownTags)
{
	bool found = false;
	TagListViewItem* pChild = static_cast<TagListViewItem*>(firstChild());

	if ( find(shownTags.begin(), shownTags.end(), fullTagname()) != shownTags.end() )
		found = true;
	// search in the children
	while (pChild)
	{
		if (pChild->filterByTagset(shownTags))
			found = true;
		pChild = static_cast<TagListViewItem*>(pChild->nextSibling());
	}
	if (!found)
		setVisible(false);
	return found;
	
}

