//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <map>
#include <iostream>

#include <qregexp.h>
#include <qstringlist.h>
//Added by qt3to4:
#include <Q3CString>


#include "package.h"

namespace NApt
{

/** Function object. */
class Squeeze
{
public:
	void operator()(QString& s)	
	{
		s.squeeze();
	}
};

QString Package::_emptyString("");

Package::Package()
{
	_installedState = NOT_INSTALLED;
};
	
Package::Package(const QString& name)
{
	_name = name;
	_installedState = NOT_INSTALLED;
};

Package::Package(const IPackage& package)
{
	_name = package.name();
	_essential = package.essential();
	_priority = package.priority();
	_section = package.section();
	_installedSize = package.installedSize();
	_maintainer = package.maintainer();
	_architecture = package.architecture();
	_source = package.source();
	_version = package.version();
	_replaces = package.replaces();
	_provides = package.provides();
	_preDepends = package.preDepends();
	_depends = package.depends();
	_recommends = package.recommends();
	_suggests = package.suggests();
	_conflicts = package.conflicts();
	_filename = package.filename();
	_size = package.size();
	_md5sum = package.md5sum();
	_conffiles = package.conffiles();
	_description = package.description();
	_installedVersion = package.installedVersion();
	_installedState = package.installedState();
	_shortDescription = package.shortDescription();
}



Package::Package(const QStringList& lines)
{
	_installedState = NOT_INSTALLED;
	parseInformation(lines);
	
	// trim the strings to current length
/*	Squeeze squeeze;
	processEntries(squeeze);*/
}


void Package::parseInformation(const QStringList& lines)
{
	static map<QString, int> sectionToString;
	static bool sectionToStringInitialized=false;
	if (!sectionToStringInitialized)
	{	// init the map
		sectionToStringInitialized=true;
		sectionToString["Package"]= 0;
		sectionToString["Essential"]= &_essential - &_name;
		sectionToString["Priority"]=&_priority - &_name;
		sectionToString["Section"]=&_section - &_name;
		sectionToString["Installed-Size"]=&_installedSize - &_name;
		sectionToString["Maintainer"]=&_maintainer - &_name;
		sectionToString["Architecture"]=&_architecture - &_name;
		sectionToString["Source"]=&_source - &_name;
		sectionToString["Version"]=&_version - &_name;
		sectionToString["Replaces"]=&_replaces - &_name;
		sectionToString["Provides"]=&_provides - &_name;
		sectionToString["Pre-Depends"]=&_preDepends - &_name;
		sectionToString["Depends"]=&_depends - &_name;
		sectionToString["Recommends"]=&_recommends - &_name;
		sectionToString["Suggests"]=&_suggests - &_name;
		sectionToString["Conflicts"]=&_conflicts - &_name;
		sectionToString["Filename"]=&_filename - &_name;
		sectionToString["Size"]=&_size - &_name;
		sectionToString["MD5sum"]=&_md5sum - &_name;
		sectionToString["Conffiles"]=&_conffiles - &_name;
		sectionToString["Description"]=&_description - &_name;
	
// 		sectionToString["InstalledVersion"]=&installedVersion - &package;

	}

	// search all lines for the keywords
	QString dummy;
	// this is only for the case of an error, dummy should not be used in regular work
	QString* pCurrentSection = &dummy;
	for (QStringList::const_iterator it=lines.begin(); it!=lines.end(); ++it)
	{
		QString line = (*it);
		int col = line.find(':');
		QString key = line.left(col);
		if (key[0] == ' ') 	// if this is simply a line in another section (the description)
			col = -1;
		QString value = line.mid(col+2);
		if (col != -1)	// we have probably found a new section
		{
			map<QString, int>::iterator jt = sectionToString.find(key);
			// if it really is a new section i.e. its key is known
			if ( jt != sectionToString.end() )
			{
				pCurrentSection = &_name + jt->second;	// point to the new section 
				if (pCurrentSection == &_description)
					_shortDescription = value;
				(*pCurrentSection) = value;
			}
			else	// attach to the current section
			{
// 				qDebug("Unknown Section: " + key);
				(*pCurrentSection) += "\n" + line;
			}
		}
		else	// attach to the current section
		{
			(*pCurrentSection) += "\n" + line;
		}
	}
	// trim the strings to current length
/*	Squeeze squeeze;
	processEntries(squeeze);*/
}


} // namespace NApt
