#
# extconf.rb
#
# $Id: extconf.rb,v 1.13 2002/03/12 08:10:13 katsu Exp $

require 'mkmf'
require 'rbconfig'
include Config

def msg_check(s)
  print s, "... "
  STDOUT.flush
end

def have_ruby_func(s)
  oldlibs = $libs
  oldlibpath = $LIBPATH
  lib = 'ruby'
  lib = 'libruby' if /mswin32/ =~ RUBY_PLATFORM
  $libs = append_library($libs, lib)
  archdir = CONFIG['archdir']
  archdir ||= "$(libdir)/ruby/$(ruby_version)/$(arch)"      # for ruby-1.4
  $LIBPATH = [ archdir, CONFIG['compile_dir'] ] + $LIBPATH
  begin
    have_func s, 'ruby.h'
  rescue ArgumentError   # for ruby-1.4
    have_func s
  ensure
    $libs = oldlibs
    $LIBPATH = oldlibpath
  end
end


dir_config "zlib"

if have_library('z', 'deflateReset') and
   have_header('zlib.h') then

  defines = []

  msg_check "checking for block_given?"   # for ruby-1.4
  if Kernel.respond_to? :block_given? then
    print "yes\n"
    defines << "HAVE_BLOCK_GIVEN_P"
  else
    print "no\n"
  end

  have_ruby_func 'rb_str_buf_new'         # for ruby-1.6
  have_ruby_func 'rb_io_print'            # for ruby-1.6
  have_ruby_func 'rb_io_printf'           # for ruby-1.6
  have_ruby_func 'rb_io_puts'             # for ruby-1.6
  have_ruby_func 'rb_io_addstr'           # for ruby-1.6

  msg_check "checking for new NORETURN"   # for ruby-1.6
  if egrep_cpp("^NORETURN", "#include \"config.h\"\nNORETURN(exit);\n") then
    print "no\n"
  else
    print "yes\n"
    defines << "HAVE_NEW_NORETURN"
  end

  msg_check "checking for new allocation framework"   # for ruby-1.6
  if Object.respond_to? :allocate then
    print "yes\n"
    defines << "HAVE_OBJECT_ALLOCATE"
  else
    print "no\n"
  end

  msg_check 'guessing OS_CODE'

  # I don't know whether or not this code works correctly on your platform...
  case RUBY_PLATFORM.split('-',2)[1]
  when 'os2_emx' then
    print "OS/2\n"
    defines << 'OS_CODE=OS_OS2'
  when 'amigaos' then
    print "Amiga\n"
    defines << 'OS_CODE=OS_AMIGA'
  when 'mswin32', 'mingw32' then
    print "Win32\n"
    defines << 'OS_CODE=OS_WIN32'
  else
    print "Unix\n"
  end

  puts("** Attention:",
       "**  If you find auto-detected OS_CODE is seem to be different",
       "**  from your platform, please report it as a bug.")

  defines = defines.collect {|d| " -D"+d}.join
  if $CPPFLAGS then
    $CPPFLAGS += defines
  else
    $CFLAGS += defines
  end

  create_makefile('zlib')
end
