/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.DelegateExprContext;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.PathPatternBase;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;

class FilterPattern
extends PathPatternBase {
    private PathPatternBase pattern;
    private BooleanExpr predicate;

    FilterPattern(PathPatternBase pattern, BooleanExpr predicate) {
        this.pattern = pattern;
        this.predicate = predicate;
    }

    public boolean matches(Node node, ExprContext context) throws XSLException {
        if (!this.pattern.matches(node, context)) {
            return false;
        }
        return this.predicate.eval(node, new Context(node, context));
    }

    public int getDefaultPriority() {
        return 1;
    }

    Name getMatchName() {
        return this.pattern.getMatchName();
    }

    byte getMatchNodeType() {
        return this.pattern.getMatchNodeType();
    }

    class Context
    extends DelegateExprContext {
        Node node;
        int position = 0;
        int lastPosition = 0;

        Context(Node node, ExprContext context) {
            super(context);
            this.node = node;
        }

        public int getPosition() throws XSLException {
            Node tem;
            SafeNodeIterator iter;
            if (this.position != 0) {
                return this.position;
            }
            switch (this.node.getType()) {
                case 3: {
                    this.position = 1;
                    return 1;
                }
                case 2: {
                    iter = this.node.getParent().getAttributes();
                    break;
                }
                default: {
                    iter = this.node.getParent().getChildren();
                }
            }
            this.position = 1;
            while (!(tem = iter.next()).equals(this.node)) {
                if (!FilterPattern.this.pattern.matches(tem, this.origContext)) continue;
                ++this.position;
            }
            return this.position;
        }

        public int getLastPosition() throws XSLException {
            Node tem;
            SafeNodeIterator iter;
            if (this.lastPosition != 0) {
                return this.lastPosition;
            }
            switch (this.node.getType()) {
                case 3: {
                    this.lastPosition = 1;
                    return 1;
                }
                case 2: {
                    iter = this.node.getParent().getAttributes();
                    this.lastPosition = 0;
                    break;
                }
                default: {
                    iter = this.node.getFollowingSiblings();
                    this.lastPosition = this.position;
                }
            }
            while ((tem = iter.next()) != null) {
                if (!FilterPattern.this.pattern.matches(tem, this.origContext)) continue;
                ++this.lastPosition;
            }
            return this.lastPosition;
        }
    }
}

