/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PipelineReader
implements ContentHandler {
    private List result = new ArrayList();
    private boolean hasConRef = false;
    private boolean hasHref = false;
    private XMLReader reader = null;
    private String filePath = null;

    public void initXMLReader() throws SAXException, ParserConfigurationException {
        if (System.getProperty("org.xml.sax.driver") == null) {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        }
        this.reader = XMLReaderFactory.createXMLReader();
        this.reader.setContentHandler(this);
    }

    public void parse(String file) throws IOException, SAXException {
        int index = file.indexOf(124);
        File xmlRelativeFile = index != -1 ? new File(file.substring(index + 1)) : new File(file);
        this.filePath = xmlRelativeFile.getParent();
        this.hasConRef = false;
        this.hasHref = false;
        if (index != -1) {
            this.reader.parse(new InputSource(file.replace('|', File.separatorChar)));
        } else {
            this.reader.parse(file);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.parseAttribute(atts, "conref");
        this.parseAttribute(atts, "href");
        this.parseAttribute(atts, "copy-to");
        this.parseAttribute(atts, "img");
    }

    private void parseAttribute(Attributes atts, String attrName) {
        String attrValue = atts.getValue(attrName);
        if (attrValue != null && attrValue.indexOf("://") == -1) {
            if ("conref".equals(attrName)) {
                this.hasConRef = true;
            } else if ("href".equals(attrName)) {
                this.hasHref = true;
            }
            if (attrValue.startsWith("#")) {
                return;
            }
            String filename = StringUtils.resolveDirectory(this.filePath, attrValue);
            String lcasefn = filename.toLowerCase();
            if (lcasefn.endsWith(".dita") || lcasefn.endsWith(".ditamap") || lcasefn.endsWith(".xml") || lcasefn.endsWith(".jpg") || lcasefn.endsWith(".gif") || lcasefn.endsWith(".eps")) {
                this.result.add(filename);
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public boolean hasConRef() {
        return this.hasConRef;
    }

    public boolean hasHref() {
        return this.hasHref;
    }

    public List getResult() {
        return this.result;
    }
}

