/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/param.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "finestre.h"

int files_sel_dir(),files_sel_file();

char path[128];
char pathname[256];
char name[128];
char filtro[28];
char tmp[128];
CmdInfo *mio;
CmdInfo *a0,*a2,*a3,*a4,*a5,*a6;
ListCmdInfo *Directories, *Files;
ListCmdInfo *ListaFiltri;

char * PathEsecuzione (char *eseguibile)
{
    static char PathEsecuzione[128];
    int x;

    if (eseguibile)
    {
        strcpy (PathEsecuzione,eseguibile);
        x=strlen(eseguibile);
        while (--x && PathEsecuzione[x]!='/');
        PathEsecuzione[x+1]='\0';
    }
    return (PathEsecuzione);
}
char * FullPath (char *file)
{
    static char pathname[128];
    strcpy (pathname,PathEsecuzione(NULL));
    strcat (pathname,file);
    return (pathname);
}

char *RTrim (char *stringa)
{
	static char buff[256];
	char *p=buff;
	int x;
	
	if (stringa)
	{
		x=strlen(stringa)-1;
		strcpy (buff,stringa);
		while (x>=0 && buff[x]==' ') x--;
		buff[x+1]='\0';
	}
	else
		p=NULL;

	return (p);	
}

char *Instr (char *s1,char *s2)
{
    char *ptr1=s1;
    char *ptr2=s2;
    char *ptr3;
    int len=strlen(s2);
    int pos=-1;

    do
    {
        ptr3=index(ptr1,ptr2[0]);
        if (ptr3)
        {
            pos=strncmp (ptr3,ptr2,len);
            if (pos)
            {
                ptr1=ptr3+1;
                pos=-1;
            }
        }
			
    } while (pos==-1 && ptr3);

    return (ptr3);
}


struct dirent **ScanDir (char *path,int *TotaleFiles)
{
    // Legge e carica la directory
    // 
    struct dirent **files;
    int file_select();

    *TotaleFiles=scandir(path,&files,file_select,alphasort);

    return (files);
}

int file_select(struct direct *entry)
{
	//
	// Nota che questa funzione deve stare dopo la 
	// chiamata di scandir altrimenti genera un warning
	//
	struct  stat    sbuf;
	char *ptr;
	int ret_code;

	if (!strcmp(RTrim(filtro),"*.*"))
		return (1);

	strcpy (tmp,entry->d_name);
	strcpy (pathname,path);
	strcat (pathname,tmp);
	stat (pathname,&sbuf);

	if((sbuf.st_mode & S_IFMT) == S_IFDIR)
		return (1);

	ptr=rindex(tmp,'.');
	
	if (ptr && Instr(RTrim(filtro),ptr))
		ret_code=1;
	else
		ret_code=0;

	return (ret_code);
}

void CaricaDirectory ()
{
	
    int TotaleFiles=0,k;
    struct dirent **files;
    struct  stat    sbuf;

    files=ScanDir (path,&TotaleFiles);

    for (k=0;k<TotaleFiles;k++)
    {
        strcpy (tmp,files[k]->d_name);

        strcpy (pathname,path);
        strcat (pathname,tmp);
        stat (pathname,&sbuf);

        if((sbuf.st_mode & S_IFMT) == S_IFDIR)
            WX11_ListCmdItemAdd (Directories, LIST_BOX, tmp);
        else
            WX11_ListCmdItemAdd (Files, LIST_BOX, tmp);

        free(files[k]);
    }
    free (files);

    strcpy(pathname,""); //$$max
		
}

void updir ()
{
    int x=strlen(path)-2;
    while (x >= 0)
    {
        if (path[x]=='/')
        {
            path[x+1]='\0';
            return;
        }
        x--;
    }	
}

int file_dir (char *dir)
{
    if (strcmp(dir,".")==0)
    {
        // Stessa dir
    }
    else if (strcmp(dir,"..")==0)
    {
        // Sale
        updir();
    }
    else
    {
        strcat (path,dir);
        strcat (path,"/");
    }
    CambiaLabel ("PATH",path);

    // TODO
    // This is necessary inside the RealCloseCmd
    UltimoComandoSelezionato (1,NULL);

    xClearAllListBoxItem (Directories);
    xClearAllListBoxItem (Files);

    CaricaDirectory ();

    WX11_ListBoxRefresh (Directories);
    WX11_ListBoxRefresh (Files);

    return (0);
}


int files_sel_dir()
{

    CmdInfo *comando=UltimoComandoSelezionato(0,NULL);
    char *dir;

    if (!comando)
        return (1);

    dir=comando->Label;
	
    file_dir (dir);

    return (0);

}
 
int files_sel_file()
{
    CmdInfo *comando=UltimoComandoSelezionato(0,NULL);

    if (!comando)
        return (1);

    //printf ("comando label=%s\n",comando->Label);
    CambiaLabel ("FILENAME",comando->Label);
    //strcpy (name,comando->Label);

    return (0);

}

int file_ok (CmdInfo *cmd, int EventType)
{
    Window focusWin;
    int reverToReturn;
    CmdInfo *cmdinput;
    //
    //
    cmdinput=CercaNomeComando ("FILENAME");
    if (cmdinput)
        strcpy (name,cmdinput->Label);

    //
    if (strlen(RTrim(name))==0)
    {
        WX11_Alert ("Seleziona il file","Ok",NULL);
        return (0);
    }
    if (strcmp(RTrim(name),"..")==0)
    {
        file_dir (RTrim(name));
	return (0);
    }
    sprintf (pathname,"%s%s",path,name);
    //strcpy (pathname,path); strcat (pathname,name);
    //
    // Prende la finestra attiva	
    XGetInputFocus(WX11_GetDisplay(), &focusWin, &reverToReturn);
    //
    // Esegue la Funzione Utente
    //Funzione(RTrim(pathname)); 
    //
    // Chiude QUESTA Finestra
    ChiudeFinestra (focusWin);
    //
    //WX11_ListCmdFree (Directories);
    //WX11_ListCmdFree (Files);
    //WX11_ListCmdFree (ListaFiltri);
    //
    return (1);
}

int file_ko (CmdInfo *cmd, int EventType)
{
    Window focusWin;
    int reverToReturn;

    // Prende la finestra attiva	
    XGetInputFocus(WX11_GetDisplay(), &focusWin, &reverToReturn);

    strcpy(pathname,"");

    ChiudeFinestra (focusWin);
    WX11_ListCmdFreeUnused ();

    return (-1); //1
}

int file_combo_selectfilter (CmdInfo *cmd,int Type)
{
    //CmdInfo *comando=UltimoComandoSelezionato(0,NULL);
    strcpy (filtro,cmd->Label);
    printf ("filter changed\n");
	
    file_dir ("."); // Refresh same dir
    return (0);
}

char *WX11_Files (char *Label,char *CurDir,...)
{
    int LlWin=580;
    int HhWin=350;
    int exitcode=0;

    va_list args;
    char *va_filtro;

    CmdInfo *ok,*ko;
    CmdInfo *PrevMain;

    // Percorso di default
    strcpy (path,CurDir); strcat (path,"/");
    strcpy (name,  " ");
    strcpy (filtro,"*.*");
    //
    PrevMain=GetPrevTopLevelWindow();
    if (PrevMain)
    {
        WX11_DisableTopLevelWindow(PrevMain);

        mio=ApreFinestra (
            Label,
            PrevMain->x+(((PrevMain->Width)-(LlWin))/2),
            PrevMain->y+(((PrevMain->Height)-(HhWin))/2),
            LlWin,HhWin);

        XSetTransientForHint(
            WX11_GetDisplay(), 
            mio->win,
            PrevMain->win);
    }
    else
    {
        mio=ApreFinestraCentrale ("Files",LlWin,HhWin);
    }
    // area path
    a0=ApreArea(mio,25,5,530,40,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);

    // area dirs + files
    a2=ApreArea(mio, 25,50,250,200,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);
    a3=ApreArea(mio,300,50,250,200,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);

    // area labels
    a4=ApreArea(mio,25,260,100,70,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);

    // area input + combo
    a5=ApreArea(mio,130,260,300,70,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);

    // area buttons
    a6=ApreArea (mio,445,260,110,70,WX11_ColorGet(WINBG),WX11_ColorGet(WINFG),0);

    CmdInfo *s;
    s=WX11_Say (a0,path);
    //s->Width=100;
    AddNomeComando (s,"PATH");

    ListaFiltri=WX11_ListCmdAdd ("Filtri");
    WX11_SetSignalCallBack (ListaFiltri,Button1Release,file_combo_selectfilter,NULL);
    //
    va_start(args, CurDir);
    va_filtro=va_arg(args,char *);
    while (va_filtro)
    {
        WX11_ListCmdItemAdd (ListaFiltri, COMBO_BOX,va_filtro);
        va_filtro=va_arg(args,char *);
    }
    WX11_ListCmdItemAdd (ListaFiltri, COMBO_BOX, "*.*");
    va_end(args);
    //
    s=WX11_Say (a4,"Filter:\n");
    WX11_ComboBox (a5,ListaFiltri,200, 40, NULL ,filtro,sizeof(filtro));

    ListaFiltri->CmdInput->Attivo=0; // Disabilita edit

    s=WX11_Say (a4,"File:\n");
    AddNomeComando (WX11_Ask (a5, NULL, name, sizeof(name), 200),"FILENAME");

    ko=ApreBottone(a6,1,5,100,15,"Cancel");
    WX11_SetSignalCallBack (ko,Button1Release,file_ko, NULL);

    ok=ApreBottone(a6,1,25,100,15,"ok");
    WX11_SetSignalCallBack (ok,Button1Release,file_ok, NULL);

    Directories=WX11_ListCmdAdd ("Directories");
    WX11_SetSignalCallBack (Directories,Button1Release,files_sel_dir,NULL);

    Files=WX11_ListCmdAdd ("Files");
    WX11_SetSignalCallBack (Files,Button1Release,files_sel_file,NULL);
	
    CaricaDirectory ();

    WX11_ListBox (a2,Directories, 240, 185,NULL);
    WX11_ListBox (a3,Files,       240, 185,NULL);

    exitcode=WX11_Events (mio);

    if (PrevMain)
        WX11_EnableTopLevelWindow (PrevMain);

    if (exitcode==-1)
        return (NULL);

    if (strlen(RTrim(pathname)))
        return (RTrim(pathname));
    else
        return (NULL);

}


